/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.graph;

import edu.cmu.tetrad.util.Parameters;
import java.io.IOException;
import java.io.ObjectInputStream;

public class LagGraphParams {
    static final long serialVersionUID = 23L;
    public static final int CONSTANT = 0;
    public static final int MAX = 1;
    public static final int MEAN = 2;
    private int indegreeType;
    private int varsPerInd = 5;
    private int mlag = 1;
    private int indegree = 2;
    private double percentUnregulated = 10.0;
    private final Parameters parameters;

    public LagGraphParams(Parameters parameters) {
        this.parameters = parameters;
    }

    public static LagGraphParams serializableInstance() {
        return new LagGraphParams(new Parameters());
    }

    public int getVarsPerInd() {
        return this.parameters.getInt("lagGraphVarsPerInd", this.varsPerInd);
    }

    public void setVarsPerInd(int varsPerInd) {
        if (varsPerInd > 0) {
            this.parameters.set("lagGraphVarsPerInd", (Object)varsPerInd);
            this.varsPerInd = varsPerInd;
        }
    }

    public int getMlag() {
        return this.parameters.getInt("lagGraphMlag", this.mlag);
    }

    public void setMlag(int mlag) {
        if (mlag > 0) {
            this.parameters.set("lagGraphMLag", (Object)mlag);
            this.mlag = mlag;
        }
    }

    public int getIndegree() {
        return this.parameters.getInt("lagGraphIndegree", this.indegree);
    }

    public void setIndegree(int indegree) {
        if (indegree > 1) {
            this.indegree = indegree;
            this.parameters.set("lagGraphIndegree", (Object)indegree);
        }
    }

    public int getIndegreeType() {
        return this.indegreeType;
    }

    public void setIndegreeType(int indegreeType) {
        switch (indegreeType) {
            case 0: 
            case 1: 
            case 2: {
                this.indegreeType = indegreeType;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public double getPercentUnregulated() {
        return this.percentUnregulated;
    }

    public void setPercentUnregulated(double percentUnregulated) {
        if (!(percentUnregulated >= 0.0) || !(percentUnregulated <= 100.0)) {
            throw new IllegalArgumentException();
        }
        this.percentUnregulated = percentUnregulated;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        switch (this.indegreeType) {
            case 0: 
            case 1: 
            case 2: {
                if (this.varsPerInd < 1) {
                    throw new IllegalStateException("VarsPerInd out of range: " + this.varsPerInd);
                }
                if (this.mlag <= 0) {
                    throw new IllegalStateException("Mlag out of range: " + this.mlag);
                }
                if (this.varsPerInd <= 1) {
                    throw new IllegalStateException("VarsPerInd out of range: " + this.varsPerInd);
                }
                if (this.percentUnregulated > 0.0 && this.percentUnregulated < 100.0) {
                    return;
                }
                throw new IllegalStateException("PercentUnregulated out of range: " + this.percentUnregulated);
            }
        }
        throw new IllegalStateException("Illegal indegree type: " + this.indegreeType);
    }
}

