/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.history;

import edu.cmu.tetrad.gene.tetrad.gene.history.LagGraph;
import edu.cmu.tetrad.gene.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetrad.util.PointXy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class BasicLagGraph
implements LagGraph {
    static final long serialVersionUID = 23L;
    private final SortedMap<String, SortedSet<LaggedFactor>> connectivity;
    private int maxLagAllowable = Integer.MAX_VALUE;
    private Map<String, PointXy> locations;

    public BasicLagGraph() {
        this.connectivity = new TreeMap<String, SortedSet<LaggedFactor>>();
    }

    public BasicLagGraph(LagGraph lagGraph) {
        this.connectivity = lagGraph.getConnectivity();
        this.maxLagAllowable = lagGraph.getMaxLagAllowable();
    }

    public static BasicLagGraph serializableInstance() {
        BasicLagGraph lagGraph = new BasicLagGraph();
        lagGraph.addFactor("X");
        lagGraph.setMaxLagAllowable(2);
        return lagGraph;
    }

    @Override
    public void addEdge(String factor, LaggedFactor laggedFactor) throws IllegalArgumentException {
        int lag = laggedFactor.getLag();
        if (lag < 1 || lag > this.maxLagAllowable) {
            throw new IllegalArgumentException("Illegal lag specified: " + laggedFactor);
        }
        TreeSet list = (TreeSet)this.connectivity.get(factor);
        if (list == null) {
            throw new IllegalArgumentException("Either factor not in graph (" + factor + ") or lagged factor not in graph or not into factor (" + laggedFactor + ").");
        }
        list.add(laggedFactor);
    }

    @Override
    public void clearEdges() {
        for (String s : this.connectivity.keySet()) {
            SortedSet set = (SortedSet)this.connectivity.get(s);
            set.clear();
        }
    }

    @Override
    public void addFactor(String factor) {
        if (!NamingProtocol.isLegalName(factor)) {
            throw new IllegalArgumentException(NamingProtocol.getProtocolDescription());
        }
        if (!this.connectivity.containsKey(factor)) {
            TreeSet laggedFactors = new TreeSet();
            this.connectivity.put(factor, laggedFactors);
        }
    }

    @Override
    public boolean existsFactor(String factor) {
        return this.connectivity.containsKey(factor);
    }

    @Override
    public boolean existsEdge(String factor, LaggedFactor laggedFactor) {
        if (laggedFactor.getLag() < 1) {
            throw new IllegalArgumentException("Illegal lag specified: " + laggedFactor);
        }
        TreeSet list = (TreeSet)this.connectivity.get(factor);
        if (list != null) {
            return list.contains(laggedFactor);
        }
        return false;
    }

    @Override
    public SortedSet<LaggedFactor> getParents(String factor) {
        return (SortedSet)this.connectivity.get(factor);
    }

    @Override
    public void removeEdge(String factor, LaggedFactor laggedFactor) {
        TreeSet list = (TreeSet)this.connectivity.get(factor);
        if (list == null) {
            throw new IllegalArgumentException("Either factor not in graph (" + factor + ") or lagged factor not in graph or not into factor (" + laggedFactor + ").");
        }
        list.remove(laggedFactor);
    }

    @Override
    public int getMaxLagAllowable() {
        return this.maxLagAllowable;
    }

    @Override
    public void setMaxLagAllowable(int maxLagAllowable) {
        if (maxLagAllowable >= this.getMaxLag()) {
            this.maxLagAllowable = maxLagAllowable;
        }
    }

    @Override
    public int getMaxLag() {
        int max = 0;
        for (String factor : this.connectivity.keySet()) {
            for (LaggedFactor laggedFactor : (SortedSet)this.connectivity.get(factor)) {
                int lag = laggedFactor.getLag();
                if (lag <= max) continue;
                max = lag;
            }
        }
        return max;
    }

    @Override
    public void removeFactor(String factor) {
        Object o = this.connectivity.remove(factor);
        if (o == null) {
            throw new IllegalArgumentException("Factor not in graph: " + factor);
        }
    }

    @Override
    public SortedMap<String, SortedSet<LaggedFactor>> getConnectivity() {
        return new TreeMap<String, SortedSet<LaggedFactor>>(this.connectivity);
    }

    @Override
    public void renameFactor(String oldName, String newName) {
        if (this.existsFactor(newName)) {
            throw new IllegalArgumentException("A factor named " + newName + " already exists in graph");
        }
        SortedSet transfer = (SortedSet)this.connectivity.remove(oldName);
        this.connectivity.put(newName, transfer);
        for (SortedSet<LaggedFactor> parents : this.connectivity.values()) {
            for (LaggedFactor itm : parents) {
                if (!itm.getFactor().equals(oldName)) continue;
                itm.setFactor(newName);
            }
        }
    }

    @Override
    public int getNumFactors() {
        return this.connectivity.size();
    }

    @Override
    public SortedSet<String> getFactors() {
        return new TreeSet<String>(this.connectivity.keySet());
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nUpdate graph:\n");
        Set<String> factors = this.connectivity.keySet();
        for (String factor : factors) {
            buf.append("\n");
            buf.append(factor);
            buf.append("\t<-- ");
            Collection edges = (Collection)this.connectivity.get(factor);
            for (LaggedFactor edge : edges) {
                buf.append("\t");
                buf.append(edge);
            }
        }
        buf.append("\n");
        return buf.toString();
    }

    @Override
    public void addFactors(String base, int numFactors) {
        NumberFormat nf = NumberFormat.getInstance();
        int numDigits = 0;
        int m = numFactors;
        while (m > 0) {
            m /= 10;
            ++numDigits;
        }
        nf.setMinimumIntegerDigits(numDigits);
        nf.setGroupingUsed(false);
        for (int i = 0; i < numFactors; ++i) {
            String factor = base + nf.format(i + 1);
            this.addFactor(factor);
        }
    }

    @Override
    public void setLocation(String factor, PointXy point) {
        this.getLocations().put(factor, point);
    }

    @Override
    public PointXy getLocation(String factor) {
        return this.getLocations().get(factor);
    }

    @Override
    public Map<String, PointXy> getLocations() {
        if (this.locations == null) {
            this.locations = new HashMap<String, PointXy>();
        }
        return this.locations;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.connectivity == null) {
            throw new NullPointerException();
        }
        if (this.maxLagAllowable < 1) {
            throw new IllegalStateException();
        }
    }
}

