/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.history;

import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;

public class PolynomialTerm
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private double coefficient;
    private final int[] variables;

    public PolynomialTerm(double coefficient, int[] variables) {
        if (variables == null) {
            throw new NullPointerException("Variables cannot be null.");
        }
        this.variables = new int[variables.length];
        System.arraycopy(variables, 0, this.variables, 0, variables.length);
        this.coefficient = coefficient;
    }

    public static PolynomialTerm serializableInstance() {
        return new PolynomialTerm(0.0, new int[0]);
    }

    public double getCoefficient() {
        return this.coefficient;
    }

    public void setCoefficient(double coefficient) {
        this.coefficient = coefficient;
    }

    public int getNumVariables() {
        return this.variables.length;
    }

    public int getVariable(int index) {
        return this.variables[index];
    }

    public boolean isVariableListEqual(int[] variables) {
        return Arrays.equals(variables, this.variables);
    }

    public int getMaxIndex() {
        int max = 0;
        for (int variable : this.variables) {
            if (variable <= max) continue;
            max = variable;
        }
        return max;
    }

    public double evaluate(double[] values) {
        double product = this.coefficient;
        for (int variable : this.variables) {
            product *= values[variable];
        }
        return product;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.coefficient);
        if (this.variables.length > 0) {
            buf.append("*");
        }
        for (int variable : this.variables) {
            buf.append("(V");
            buf.append(variable);
            buf.append(")");
        }
        return buf.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.variables == null) {
            throw new NullPointerException();
        }
    }
}

