/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.history;

import edu.cmu.tetrad.gene.tetrad.gene.history.BooleanFunction;
import edu.cmu.tetrad.gene.tetrad.gene.history.IndexedParent;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBooleanFunction
extends TestCase {
    public TestBooleanFunction(String name) {
        super(name);
    }

    public void testNullConstruction() {
        ArrayList<IndexedParent> parents = new ArrayList<IndexedParent>();
        for (int i = 0; i < 5; ++i) {
            parents.add(new IndexedParent(1, 2));
        }
        parents.set(RandomUtil.getInstance().nextInt(5), null);
        try {
            new BooleanFunction(parents.toArray(new IndexedParent[0]));
        }
        catch (NullPointerException e) {
            return;
        }
        TestCase.fail("Should have thrown an NullPointerException.");
    }

    public void testTableSize() {
        int numParents = RandomUtil.getInstance().nextInt(5);
        ArrayList<IndexedParent> parents = new ArrayList<IndexedParent>();
        for (int i = 0; i < numParents; ++i) {
            parents.add(new IndexedParent(1, 2));
        }
        BooleanFunction function = new BooleanFunction(parents.toArray(new IndexedParent[0]));
        int size = 1;
        for (int i = 0; i < numParents; ++i) {
            size *= 2;
        }
        TestCase.assertEquals(size, function.getNumRows());
    }

    public void testRowOrder() {
        boolean[] values = new boolean[2];
        int row = 0;
        IndexedParent x = new IndexedParent(1, 2);
        IndexedParent y = new IndexedParent(2, 1);
        IndexedParent[] twoParents = new IndexedParent[]{x, y};
        BooleanFunction function = new BooleanFunction(twoParents);
        values[0] = true;
        values[1] = true;
        row = function.getRow(values);
        function.setValue(row, true);
        values[0] = true;
        values[1] = false;
        row = function.getRow(values);
        function.setValue(row, false);
        values[0] = false;
        values[1] = true;
        row = function.getRow(values);
        function.setValue(row, false);
        values[0] = false;
        values[1] = false;
        row = function.getRow(values);
        function.setValue(row, false);
        TestCase.assertEquals(true, function.getValue(0));
        TestCase.assertEquals(false, function.getValue(1));
        TestCase.assertEquals(false, function.getValue(2));
        TestCase.assertEquals(false, function.getValue(3));
    }

    public void testIsEffective() {
        IndexedParent x = new IndexedParent(0, 2);
        IndexedParent y = new IndexedParent(1, 2);
        IndexedParent z = new IndexedParent(2, 3);
        IndexedParent[] threeParents = new IndexedParent[]{x, y, z};
        BooleanFunction function = null;
        function = new BooleanFunction(threeParents);
        function.setValue(0, true);
        function.setValue(1, false);
        function.setValue(2, false);
        function.setValue(3, true);
        function.setValue(4, false);
        function.setValue(5, false);
        function.setValue(6, false);
        function.setValue(7, false);
        TestCase.assertTrue(function.isEffective());
        function = new BooleanFunction(threeParents);
        function.setValue(0, true);
        function.setValue(1, false);
        function.setValue(2, false);
        function.setValue(3, true);
        function.setValue(4, true);
        function.setValue(5, false);
        function.setValue(6, false);
        function.setValue(7, true);
        TestCase.assertTrue(!function.isEffective());
    }

    public void testIsCanalyzing() {
        IndexedParent x = new IndexedParent(0, 1);
        IndexedParent y = new IndexedParent(1, 2);
        IndexedParent z = new IndexedParent(2, 3);
        IndexedParent[] twoParents = new IndexedParent[]{x, y};
        IndexedParent[] threeParents = new IndexedParent[]{x, y, z};
        BooleanFunction function = null;
        function = new BooleanFunction(twoParents);
        function.setValue(0, true);
        function.setValue(1, false);
        function.setValue(2, false);
        function.setValue(3, false);
        TestCase.assertTrue(function.isCanalyzing());
        function = new BooleanFunction(twoParents);
        function.setValue(0, true);
        function.setValue(1, true);
        function.setValue(2, true);
        function.setValue(3, false);
        TestCase.assertTrue(function.isCanalyzing());
        function = new BooleanFunction(twoParents);
        function.setValue(0, false);
        function.setValue(1, true);
        function.setValue(2, true);
        function.setValue(3, false);
        TestCase.assertTrue(!function.isCanalyzing());
        function = new BooleanFunction(threeParents);
        function.setValue(0, true);
        function.setValue(1, false);
        function.setValue(2, false);
        function.setValue(3, true);
        function.setValue(4, false);
        function.setValue(5, false);
        function.setValue(6, false);
        function.setValue(7, false);
        TestCase.assertTrue(function.isCanalyzing());
        function = new BooleanFunction(threeParents);
        function.setValue(0, true);
        function.setValue(1, false);
        function.setValue(2, false);
        function.setValue(3, true);
        function.setValue(4, false);
        function.setValue(5, false);
        function.setValue(6, false);
        function.setValue(7, true);
        TestCase.assertTrue(!function.isCanalyzing());
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestBooleanFunction.class);
    }
}

