/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.history;

import edu.cmu.tetrad.gene.tetrad.gene.history.BasicLagGraph;
import edu.cmu.tetrad.gene.tetrad.gene.history.IndexedConnectivity;
import edu.cmu.tetrad.gene.tetrad.gene.history.LaggedFactor;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestIndexedConnectivity
extends TestCase {
    public TestIndexedConnectivity(String name) {
        super(name);
    }

    public void testConstruction() {
        BasicLagGraph lagGraph = new BasicLagGraph();
        lagGraph.addFactor("G1");
        lagGraph.addFactor("G2");
        lagGraph.addFactor("G3");
        lagGraph.addEdge("G1", new LaggedFactor("G3", 1));
        lagGraph.addEdge("G2", new LaggedFactor("G1", 2));
        lagGraph.addEdge("G3", new LaggedFactor("G2", 3));
        lagGraph.addEdge("G3", new LaggedFactor("G3", 4));
        System.out.println(lagGraph);
        IndexedConnectivity indexedConnectivity = new IndexedConnectivity(lagGraph);
        System.out.println(indexedConnectivity);
        TestCase.assertEquals("G1", indexedConnectivity.getFactor(0));
        TestCase.assertEquals("G2", indexedConnectivity.getFactor(1));
        TestCase.assertEquals("G3", indexedConnectivity.getFactor(2));
        TestCase.assertEquals(2, indexedConnectivity.getParent(0, 0).getIndex());
        TestCase.assertEquals(0, indexedConnectivity.getParent(1, 0).getIndex());
        TestCase.assertEquals(1, indexedConnectivity.getParent(2, 0).getIndex());
        TestCase.assertEquals(2, indexedConnectivity.getParent(2, 1).getIndex());
        TestCase.assertEquals(1, indexedConnectivity.getParent(0, 0).getLag());
        TestCase.assertEquals(2, indexedConnectivity.getParent(1, 0).getLag());
        TestCase.assertEquals(3, indexedConnectivity.getParent(2, 0).getLag());
        TestCase.assertEquals(4, indexedConnectivity.getParent(2, 1).getLag());
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestIndexedConnectivity.class);
    }
}

