/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.history;

import edu.cmu.tetrad.gene.tetrad.gene.history.BasicLagGraph;
import edu.cmu.tetrad.gene.tetrad.gene.history.LagGraph;
import edu.cmu.tetrad.gene.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.gene.tetrad.gene.history.SimpleRandomizer;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.SortedSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSimpleRandomizer
extends TestCase {
    LagGraph lagGraph = new BasicLagGraph();

    public TestSimpleRandomizer(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        int numVars = 100;
        for (int i = 0; i < 100; ++i) {
            this.lagGraph.addFactor("G" + i);
        }
    }

    public void testConstantIndegree() {
        int indegree = RandomUtil.getInstance().nextInt(8) + 2;
        int mlag = RandomUtil.getInstance().nextInt(9) + 1;
        double percentHousekeeping = RandomUtil.getInstance().nextDouble() * 20.0;
        SimpleRandomizer simpleRandomizer = new SimpleRandomizer(indegree, 0, mlag, percentHousekeeping);
        simpleRandomizer.initialize(this.lagGraph);
        SortedSet<String> factors = this.lagGraph.getFactors();
        for (Object e : factors) {
            String factor = (String)e;
            SortedSet<LaggedFactor> parents = this.lagGraph.getParents(factor);
            if (1 == parents.size()) continue;
            TestCase.assertEquals(indegree, parents.size());
        }
    }

    public void testMeanIndegree() {
        int indegree = RandomUtil.getInstance().nextInt(8) + 2;
        int mlag = RandomUtil.getInstance().nextInt(9) + 1;
        double percentHousekeeping = RandomUtil.getInstance().nextDouble() * 20.0;
        SimpleRandomizer simpleRandomizer = new SimpleRandomizer(indegree, 2, mlag, percentHousekeeping);
        simpleRandomizer.initialize(this.lagGraph);
        int sum = 0;
        int numNonHousekeeping = 0;
        SortedSet<String> factors = this.lagGraph.getFactors();
        for (Object e : factors) {
            String factor = (String)e;
            SortedSet<LaggedFactor> parents = this.lagGraph.getParents(factor);
            if (parents.size() <= 1) continue;
            System.out.println("# Nonhousekeeping = " + ++numNonHousekeeping + " This num parents = " + parents.size() + " sum = " + (sum += parents.size()));
        }
        if (numNonHousekeeping > 0) {
            double mean = (double)sum / (double)numNonHousekeeping;
            TestCase.assertEquals((double)indegree, mean, 1.2);
        }
    }

    public void testMaxIndegree() {
        int indegree = RandomUtil.getInstance().nextInt(8) + 2;
        int mlag = RandomUtil.getInstance().nextInt(9) + 1;
        double percentHousekeeping = RandomUtil.getInstance().nextDouble() * 20.0;
        SimpleRandomizer simpleRandomizer = new SimpleRandomizer(indegree, 1, mlag, percentHousekeeping);
        simpleRandomizer.initialize(this.lagGraph);
        int max = 0;
        SortedSet<String> factors = this.lagGraph.getFactors();
        for (Object e : factors) {
            String factor = (String)e;
            SortedSet<LaggedFactor> parents = this.lagGraph.getParents(factor);
            if (parents.size() <= max) continue;
            max = parents.size();
        }
        TestCase.assertTrue(indegree <= max);
    }

    @Override
    public void tearDown() {
        this.lagGraph = null;
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestSimpleRandomizer.class);
    }
}

