/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.simexp;

import edu.cmu.tetrad.gene.tetrad.gene.history.BasalInitializer;
import edu.cmu.tetrad.gene.tetrad.gene.history.BasicLagGraph;
import edu.cmu.tetrad.gene.tetrad.gene.history.GeneHistory;
import edu.cmu.tetrad.gene.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.gene.tetrad.gene.history.LinearFunction;
import edu.cmu.tetrad.gene.tetrad.gene.history.UpdateFunction;
import edu.cmu.tetrad.gene.tetrad.gene.simulation.MeasurementSimulator;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.NumberFormat;

public class LinearSimExp1 {
    private final MeasurementSimulator simulator = new MeasurementSimulator(new Parameters());

    public LinearSimExp1(String stub) {
        UpdateFunction function = this.createFunction();
        GeneHistory history = this.createHistory(function);
        this.simulator.setRawDataSaved(true);
        this.simulator.setNumDishes(8);
        this.simulator.simulate(history);
        try {
            PrintStream out = new PrintStream(new FileOutputStream(stub + "meas.dat"));
            this.printMeasuredData(out);
            out.close();
            PrintStream out2 = new PrintStream(new FileOutputStream(stub + "raw.dat"));
            this.printRawData(out2);
            out2.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new LinearSimExp1(args[0]);
    }

    private UpdateFunction createFunction() {
        String[] factors = new String[]{"G1", "G2", "G3"};
        BasicLagGraph lagGraph = new BasicLagGraph();
        lagGraph.addFactor(factors[0]);
        lagGraph.addFactor(factors[1]);
        lagGraph.addFactor(factors[2]);
        lagGraph.addEdge(factors[0], new LaggedFactor(factors[0], 1));
        lagGraph.addEdge(factors[1], new LaggedFactor(factors[0], 1));
        lagGraph.addEdge(factors[1], new LaggedFactor(factors[1], 1));
        lagGraph.addEdge(factors[1], new LaggedFactor(factors[2], 1));
        lagGraph.addEdge(factors[2], new LaggedFactor(factors[2], 1));
        LinearFunction function = new LinearFunction(lagGraph);
        function.setIntercept("G1", 0.05);
        function.setCoefficient("G1", new LaggedFactor("G1", 1), 0.5);
        function.setIntercept("G2", 0.1);
        function.setCoefficient("G2", new LaggedFactor("G1", 1), 0.6);
        function.setIntercept("G3", 0.2);
        function.setCoefficient("G2", new LaggedFactor("G2", 1), 0.7);
        function.setIntercept("G3", 0.3);
        function.setCoefficient("G2", new LaggedFactor("G3", 1), 0.8);
        function.setIntercept("G3", 0.4);
        function.setCoefficient("G3", new LaggedFactor("G3", 1), 0.9);
        System.out.println(function);
        return function;
    }

    private GeneHistory createHistory(UpdateFunction function) {
        BasalInitializer initializer = new BasalInitializer(function, 0.0, 1.0);
        return new GeneHistory(initializer, function);
    }

    private void printRawData(PrintStream out) {
        double[][][] data = this.simulator.getRawData();
        GeneHistory history = this.simulator.getHistory();
        UpdateFunction updateFunction = history.getUpdateFunction();
        int[] timeSteps = this.simulator.getTimeSteps();
        out.print("Dish\tInd\t");
        for (int timeStep : timeSteps) {
            for (int j = 0; j < updateFunction.getNumFactors(); ++j) {
                out.print("G" + j + ":t" + timeStep + "\t");
            }
        }
        out.println();
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        int cellsPerDish = this.simulator.getNumCellsPerDish();
        for (int i = 0; i < data[0][0].length; ++i) {
            out.print(i / cellsPerDish + 1 + "\t");
            out.print(i + 1 + "\t");
            for (int j = 0; j < data[0].length; ++j) {
                for (double[][] datum : data) {
                    out.print(nf.format(datum[j][i]) + "\t");
                }
            }
            out.println();
        }
    }

    private void printMeasuredData(PrintStream out) {
        double[][][] data = this.simulator.getMeasuredData();
        GeneHistory history = this.simulator.getHistory();
        UpdateFunction updateFunction = history.getUpdateFunction();
        int[] timeSteps = this.simulator.getTimeSteps();
        out.print("Dish\tChip\t");
        for (int timeStep : timeSteps) {
            for (int j = 0; j < updateFunction.getNumFactors(); ++j) {
                out.print("G" + j + ":t" + timeStep + "\t");
            }
        }
        out.println();
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        int samplesPerDish = this.simulator.getNumSamplesPerDish();
        for (int i = 0; i < data[0][0].length; ++i) {
            out.print(i / samplesPerDish + 1 + "\t");
            out.print(i + 1 + "\t");
            for (int j = 0; j < data[0].length; ++j) {
                for (double[][] datum : data) {
                    out.print(nf.format(datum[j][i]) + "\t");
                }
            }
            out.println();
        }
    }
}

