/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetradapp.model;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.TimeSeriesData;
import edu.cmu.tetrad.gene.tetrad.gene.graph.DisplayNameHandler;
import edu.cmu.tetrad.gene.tetrad.gene.history.BasalInitializer;
import edu.cmu.tetrad.gene.tetrad.gene.history.BooleanGlassFunction;
import edu.cmu.tetrad.gene.tetrad.gene.history.GeneHistory;
import edu.cmu.tetrad.gene.tetrad.gene.history.IndexedLagGraph;
import edu.cmu.tetrad.gene.tetrad.gene.history.IndexedParent;
import edu.cmu.tetrad.gene.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.gene.tetradapp.model.BooleanGlassGenePm;
import edu.cmu.tetrad.gene.tetradapp.model.MeasurementSimulatorParams;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.dist.Distribution;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class BooleanGlassGeneIm
implements SessionModel {
    static final long serialVersionUID = 23L;
    private String name;
    private BooleanGlassGenePm genePm;
    private BooleanGlassFunction glassFunction;
    private BasalInitializer initializer;
    private GeneHistory history;
    private MeasurementSimulatorParams simulator;

    public BooleanGlassGeneIm(BooleanGlassGenePm genePm, Parameters parameters) {
        try {
            this.genePm = genePm;
            this.glassFunction = new BooleanGlassFunction(genePm.getLagGraph());
            this.initializer = new BasalInitializer(this.glassFunction, 0.0, 1.0);
            this.history = new GeneHistory(this.initializer, this.glassFunction);
            this.simulator = new MeasurementSimulatorParams(parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BooleanGlassGeneIm serializableInstance() {
        return new BooleanGlassGeneIm(BooleanGlassGenePm.serializableInstance(), new Parameters());
    }

    public List<String> getFactors() {
        ArrayList<String> factors = new ArrayList<String>();
        IndexedLagGraph connectivity = this.glassFunction.getIndexedLagGraph();
        for (int i = 0; i < connectivity.getNumFactors(); ++i) {
            factors.add(connectivity.getFactor(i));
        }
        return factors;
    }

    public List<String> getParents(int factor) {
        IndexedLagGraph connectivity = this.getBooleanGlassFunction().getIndexedLagGraph();
        ArrayList<String> displayParents = new ArrayList<String>();
        for (int i = 0; i < connectivity.getNumParents(factor); ++i) {
            IndexedParent parent = connectivity.getParent(factor, i);
            String name = connectivity.getFactor(parent.getIndex());
            LaggedFactor laggedFactor = new LaggedFactor(name, parent.getLag());
            String displayString = DisplayNameHandler.getDisplayString(laggedFactor);
            displayParents.add(displayString);
        }
        return displayParents;
    }

    public Object getSimulationParams() {
        return this.simulator;
    }

    public int getNumParents(int factor) {
        IndexedLagGraph connectivity = this.getBooleanGlassFunction().getIndexedLagGraph();
        return connectivity.getNumParents(factor);
    }

    public boolean getRowValueAt(int factor, int row) {
        return this.getBooleanGlassFunction().getSubFunction(factor).getValue(row);
    }

    public void setRowValueAt(int factor, int row, boolean value) {
        this.getBooleanGlassFunction().getSubFunction(factor).setValue(row, value);
    }

    public void setSimulator(MeasurementSimulatorParams simulator) {
        simulator.setHistory(this.getHistory());
        this.simulator = simulator;
    }

    public DataModelList simulateData() {
        int i;
        this.simulator.simulate(this.history);
        DataModelList dataModelList = new DataModelList();
        LinkedList<Node> variables = new LinkedList<Node>();
        if (this.simulator.isIncludeDishAndChipVariables()) {
            DiscreteVariable dishVar = new DiscreteVariable("Dish");
            DiscreteVariable chipVar = new DiscreteVariable("Chip");
            variables.add(dishVar);
            variables.add(chipVar);
        }
        double[][][] measuredData = this.simulator.getMeasuredData();
        int[] timeSteps = this.simulator.getTimeSteps();
        ArrayList<String> factors = new ArrayList<String>(this.genePm.getLagGraph().getFactors());
        for (int i2 = 0; i2 < measuredData[0].length; ++i2) {
            for (int j = 0; j < measuredData.length; ++j) {
                String name = (String)factors.get(j) + ":t" + timeSteps[i2];
                ContinuousVariable var = new ContinuousVariable(name);
                variables.add(var);
            }
        }
        BoxDataSet measuredDataSet = new BoxDataSet(new DoubleDataBox(measuredData[0][0].length, variables.size()), variables);
        for (i = 0; i < measuredData[0].length; ++i) {
            for (int j = 0; j < measuredData.length; ++j) {
                double[] _data = measuredData[j][i];
                String name = (String)factors.get(j) + ":t" + timeSteps[i];
                ContinuousVariable var = (ContinuousVariable)measuredDataSet.getVariable(name);
                int col = measuredDataSet.getVariables().indexOf(var);
                for (int i1 = 0; i1 < _data.length; ++i1) {
                    measuredDataSet.setDouble(i1, col, _data[i1]);
                }
            }
        }
        measuredDataSet.setName("Measurement Data");
        dataModelList.add(measuredDataSet);
        if (this.simulator.isIncludeDishAndChipVariables()) {
            for (i = 0; i < measuredData[0][0].length; ++i) {
                int samplesPerDish = this.simulator.getNumSamplesPerDish();
                measuredDataSet.setInt(i, 0, i / samplesPerDish + 1);
                measuredDataSet.setInt(i, 1, i + 1);
            }
        }
        if (this.simulator.isRawDataSaved()) {
            double[][][] rawData = this.simulator.getRawData();
            LinkedList<ContinuousVariable> _variables = new LinkedList<ContinuousVariable>();
            for (int i3 = 0; i3 < rawData[0].length; ++i3) {
                for (int j = 0; j < rawData.length; ++j) {
                    String name = "G" + (j + 1) + ":t" + timeSteps[i3];
                    _variables.add(new ContinuousVariable(name));
                }
            }
            BoxDataSet rawDataSet = new BoxDataSet(new DoubleDataBox(rawData[0][0].length, _variables.size()), variables);
            for (int i4 = 0; i4 < rawData[0].length; ++i4) {
                for (int j = 0; j < rawData.length; ++j) {
                    double[] _data = rawData[j][i4];
                    String name = "G" + (j + 1) + ":t" + timeSteps[i4];
                    Node var = rawDataSet.getVariable(name);
                    int col = rawDataSet.getVariables().indexOf(var);
                    for (int i1 = 0; i1 < _data.length; ++i1) {
                        rawDataSet.setDouble(i1, col, _data[i1]);
                    }
                }
            }
            int n = rawData[0][0].length;
            int cellsPerDish = this.simulator.getNumCellsPerDish();
            if (this.simulator.isIncludeDishAndChipVariables()) {
                DiscreteVariable dishVar2 = new DiscreteVariable("Dish", n / cellsPerDish + 1);
                rawDataSet.addVariable(0, dishVar2);
            }
            rawDataSet.setName("Raw Data");
            if (this.simulator.isIncludeDishAndChipVariables()) {
                for (int i5 = 0; i5 < n; ++i5) {
                    rawDataSet.setInt(i5, 0, i5 / cellsPerDish + 1);
                }
            }
            dataModelList.add(rawDataSet);
        }
        if (measuredData[0][0].length == 1) {
            dataModelList.add(0, this.asTimeSeriesData(measuredData, factors));
        }
        return dataModelList;
    }

    private TimeSeriesData asTimeSeriesData(double[][][] cube, List<String> factors) {
        int numTimeSteps = cube[0].length;
        int numFactors = cube.length;
        double[][] square = new double[numTimeSteps][numFactors];
        for (int timeStep = 0; timeStep < numTimeSteps; ++timeStep) {
            for (int factor = 0; factor < numFactors; ++factor) {
                square[timeStep][factor] = cube[factor][timeStep][0];
            }
        }
        ArrayList<String> varNames = new ArrayList<String>();
        for (int i = 0; i < numFactors; ++i) {
            varNames.add(factors.get(i));
        }
        return new TimeSeriesData(new Matrix(square), varNames);
    }

    public BooleanGlassFunction getBooleanGlassFunction() {
        return this.glassFunction;
    }

    public GeneHistory getHistory() {
        return this.history;
    }

    public void setErrorDistribution(int factor, Distribution distribution) {
        this.getBooleanGlassFunction().setErrorDistribution(factor, distribution);
    }

    public Distribution getErrorDistribution(int factor) {
        return this.getBooleanGlassFunction().getErrorDistribution(factor);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.genePm == null) {
            throw new NullPointerException();
        }
        if (this.glassFunction == null) {
            throw new NullPointerException();
        }
        if (this.initializer == null) {
            throw new NullPointerException();
        }
        if (this.history == null) {
            throw new NullPointerException();
        }
        if (this.simulator == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

