/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.graph.Underlines;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Dag
implements Graph {
    static final long serialVersionUID = 23L;
    private final Graph graph;

    public Dag() {
        this.graph = new EdgeListGraph();
    }

    public Dag(List<Node> nodes) {
        this.graph = new EdgeListGraph(nodes);
    }

    public Dag(Graph graph) throws IllegalArgumentException {
        if (graph.paths().existsDirectedCycle()) {
            throw new IllegalArgumentException("That graph was not acyclic.");
        }
        this.graph = new EdgeListGraph();
        this.transferNodesAndEdges(graph);
        for (Node node : this.graph.getNodes()) {
            node.getAllAttributes().clear();
        }
    }

    public static Dag serializableInstance() {
        Dag dag = new Dag();
        GraphNode node1 = new GraphNode("X");
        dag.addNode(node1);
        return dag;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public boolean addBidirectedEdge(Node node1, Node node2) {
        return this.graph.addBidirectedEdge(node1, node2);
    }

    @Override
    public boolean addDirectedEdge(Node node1, Node node2) {
        return this.addEdge(Edges.directedEdge(node1, node2));
    }

    @Override
    public boolean addUndirectedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException("Disallowed for a DAG.");
    }

    @Override
    public boolean addNondirectedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException("Disallowed for a DAG.");
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException("Disallowed for a DAG.");
    }

    @Override
    public boolean addEdge(Edge edge) {
        if (!Edges.isDirectedEdge(edge)) {
            throw new IllegalArgumentException("Only directed edges may be added to a DAG.");
        }
        Node x = Edges.getDirectedEdgeTail(edge);
        Node y = Edges.getDirectedEdgeHead(edge);
        if (this.paths().isAncestorOf(y, x)) {
            throw new IllegalArgumentException("Adding that edge would create a cycle: " + edge);
        }
        return this.graph.addEdge(edge);
    }

    @Override
    public boolean addNode(Node node) {
        return this.graph.addNode(node);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener e) {
        this.graph.addPropertyChangeListener(e);
    }

    @Override
    public void clear() {
        this.graph.clear();
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.graph.containsEdge(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.graph.containsNode(node);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Graph)) {
            return false;
        }
        return this.graph.equals(o);
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        throw new UnsupportedOperationException("Cannot fully connect a DAG with a single endpoint type.");
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        throw new UnsupportedOperationException("Cannot reorient all edges in a DAG with a single endpoint type.");
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        return this.graph.getAdjacentNodes(node);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return this.graph.getChildren(node);
    }

    @Override
    public int getDegree() {
        return this.graph.getDegree();
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        return this.graph.getEdge(node1, node2);
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        return this.graph.getDirectedEdge(node1, node2);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        return this.graph.getEdges(node);
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        return this.graph.getEdges(node1, node2);
    }

    @Override
    public Set<Edge> getEdges() {
        return this.graph.getEdges();
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        return this.graph.getEndpoint(node1, node2);
    }

    @Override
    public int getIndegree(Node node) {
        return this.graph.getIndegree(node);
    }

    @Override
    public int getDegree(Node node) {
        return this.graph.getDegree(node);
    }

    @Override
    public Node getNode(String name) {
        return this.graph.getNode(name);
    }

    @Override
    public List<Node> getNodes() {
        return this.graph.getNodes();
    }

    @Override
    public List<String> getNodeNames() {
        return this.graph.getNodeNames();
    }

    @Override
    public int getNumEdges() {
        return this.graph.getNumEdges();
    }

    @Override
    public int getNumEdges(Node node) {
        return this.graph.getNumEdges(node);
    }

    @Override
    public int getNumNodes() {
        return this.graph.getNumNodes();
    }

    @Override
    public int getOutdegree(Node node) {
        return this.graph.getOutdegree(node);
    }

    @Override
    public List<Node> getParents(Node node) {
        return this.graph.getParents(node);
    }

    @Override
    public boolean isAdjacentTo(Node node1, Node node2) {
        return this.graph.isAdjacentTo(node1, node2);
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        return this.graph.isChildOf(node1, node2);
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        return this.graph.isParentOf(node1, node2);
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        return this.graph.isDefNoncollider(node1, node2, node3);
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        return this.graph.isDefCollider(node1, node2, node3);
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.graph.isExogenous(node);
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint n) {
        return this.graph.getNodesInTo(node, n);
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint n) {
        return this.graph.getNodesOutTo(node, n);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        return this.graph.removeEdge(edge);
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        return this.graph.removeEdge(node1, node2);
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        return this.graph.removeEdges(node1, node2);
    }

    @Override
    public boolean removeEdges(Collection<Edge> edges) {
        return this.graph.removeEdges(edges);
    }

    @Override
    public boolean removeNode(Node node) {
        return this.graph.removeNode(node);
    }

    @Override
    public boolean removeNodes(List<Node> nodes) {
        return this.graph.removeNodes(nodes);
    }

    @Override
    public boolean setEndpoint(Node from, Node to, Endpoint endPoint) {
        throw new UnsupportedOperationException("Setting a single endpoint for a DAG is disallowed.");
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        return this.graph.subgraph(nodes);
    }

    @Override
    public String toString() {
        return this.graph.toString();
    }

    @Override
    public void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new NullPointerException("No graph was provided.");
        }
        for (Node node : graph.getNodes()) {
            if (this.addNode(node)) continue;
            throw new IllegalArgumentException();
        }
        for (Edge edge : graph.getEdges()) {
            if (this.addEdge(edge)) continue;
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void transferAttributes(Graph graph) throws IllegalArgumentException {
        this.graph.transferAttributes(graph);
    }

    @Override
    public Underlines underlines() {
        return this.graph.underlines();
    }

    @Override
    public Paths paths() {
        return this.graph.paths();
    }

    @Override
    public boolean isParameterizable(Node node) {
        return this.graph.isParameterizable(node);
    }

    @Override
    public boolean isTimeLagModel() {
        return this.graph.isTimeLagModel();
    }

    @Override
    public TimeLagGraph getTimeLagGraph() {
        return this.graph.getTimeLagGraph();
    }

    @Override
    public List<Node> getSepset(Node n1, Node n2) {
        return this.graph.getSepset(n1, n2);
    }

    @Override
    public void setNodes(List<Node> nodes) {
        this.graph.setNodes(nodes);
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.graph.getAllAttributes();
    }

    @Override
    public Object getAttribute(String key) {
        return this.graph.getAttribute(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.graph.removeAttribute(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.graph.addAttribute(key, value);
    }
}

