/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeTypeProbability;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;
import java.util.List;

public final class Edges {
    public static Edge bidirectedEdge(Node nodeA, Node nodeB) {
        return new Edge(nodeA, nodeB, Endpoint.ARROW, Endpoint.ARROW);
    }

    public static Edge directedEdge(Node nodeA, Node nodeB) {
        return new Edge(nodeA, nodeB, Endpoint.TAIL, Endpoint.ARROW);
    }

    public static Edge partiallyOrientedEdge(Node nodeA, Node nodeB) {
        return new Edge(nodeA, nodeB, Endpoint.CIRCLE, Endpoint.ARROW);
    }

    public static Edge nondirectedEdge(Node nodeA, Node nodeB) {
        return new Edge(nodeA, nodeB, Endpoint.CIRCLE, Endpoint.CIRCLE);
    }

    public static Edge undirectedEdge(Node nodeA, Node nodeB) {
        return new Edge(nodeA, nodeB, Endpoint.TAIL, Endpoint.TAIL);
    }

    public static boolean isBidirectedEdge(Edge edge) {
        return edge.getEndpoint1() == Endpoint.ARROW && edge.getEndpoint2() == Endpoint.ARROW;
    }

    public static boolean isDirectedEdge(Edge edge) {
        if (edge.getEndpoint1() == Endpoint.TAIL) {
            return edge.getEndpoint2() == Endpoint.ARROW;
        }
        if (edge.getEndpoint2() == Endpoint.TAIL) {
            return edge.getEndpoint1() == Endpoint.ARROW;
        }
        return false;
    }

    public static boolean isPartiallyOrientedEdge(Edge edge) {
        if (edge.getEndpoint1() == Endpoint.CIRCLE) {
            return edge.getEndpoint2() == Endpoint.ARROW;
        }
        if (edge.getEndpoint2() == Endpoint.CIRCLE) {
            return edge.getEndpoint1() == Endpoint.ARROW;
        }
        return false;
    }

    public static boolean isNondirectedEdge(Edge edge) {
        return edge.getEndpoint1() == Endpoint.CIRCLE && edge.getEndpoint2() == Endpoint.CIRCLE;
    }

    public static boolean isUndirectedEdge(Edge edge) {
        return edge.getEndpoint1() == Endpoint.TAIL && edge.getEndpoint2() == Endpoint.TAIL;
    }

    public static Node traverse(Node node, Edge edge) {
        if (node == null) {
            return null;
        }
        if (node.equals(edge.getNode1())) {
            return edge.getNode2();
        }
        if (node.equals(edge.getNode2())) {
            return edge.getNode1();
        }
        return null;
    }

    public static Node traverseDirected(Node node, Edge edge) {
        if (node == edge.getNode1()) {
            if (edge.getEndpoint1() == Endpoint.TAIL && edge.getEndpoint2() == Endpoint.ARROW) {
                return edge.getNode2();
            }
        } else if (node == edge.getNode2() && edge.getEndpoint2() == Endpoint.TAIL && edge.getEndpoint1() == Endpoint.ARROW) {
            return edge.getNode1();
        }
        return null;
    }

    public static Node traverseReverseDirected(Node node, Edge edge) {
        if (edge == null) {
            return null;
        }
        if (node == edge.getNode1()) {
            if (edge.getEndpoint1() == Endpoint.ARROW && edge.getEndpoint2() == Endpoint.TAIL) {
                return edge.getNode2();
            }
        } else if (node == edge.getNode2() && edge.getEndpoint2() == Endpoint.ARROW && edge.getEndpoint1() == Endpoint.TAIL) {
            return edge.getNode1();
        }
        return null;
    }

    public static Node traverseSemiDirected(Node node, Edge edge) {
        if (node == edge.getNode1()) {
            if (edge.getEndpoint1() == Endpoint.TAIL || edge.getEndpoint1() == Endpoint.CIRCLE) {
                return edge.getNode2();
            }
        } else if (node == edge.getNode2() && (edge.getEndpoint2() == Endpoint.TAIL || edge.getEndpoint2() == Endpoint.CIRCLE)) {
            return edge.getNode1();
        }
        return null;
    }

    public static Node getDirectedEdgeHead(Edge edge) {
        if (edge.getEndpoint1() == Endpoint.ARROW && edge.getEndpoint2() == Endpoint.TAIL) {
            return edge.getNode1();
        }
        if (edge.getEndpoint2() == Endpoint.ARROW && edge.getEndpoint1() == Endpoint.TAIL) {
            return edge.getNode2();
        }
        throw new IllegalArgumentException("Not a directed edge: " + edge);
    }

    public static Node getDirectedEdgeTail(Edge edge) {
        if (edge.getEndpoint2() == Endpoint.ARROW && edge.getEndpoint1() == Endpoint.TAIL) {
            return edge.getNode1();
        }
        if (edge.getEndpoint1() == Endpoint.ARROW && edge.getEndpoint2() == Endpoint.TAIL) {
            return edge.getNode2();
        }
        throw new IllegalArgumentException("Not a directed edge: " + edge);
    }

    public static void sortEdges(List<Edge> edges) {
        edges.sort((edge1, edge2) -> {
            if (edge1 == null || edge2 == null) {
                return 0;
            }
            Node left1 = edge1.getNode1();
            Node right1 = edge1.getNode2();
            Node left2 = edge2.getNode1();
            Node right2 = edge2.getNode2();
            ArrayList<Edge.Property> propertiesLeft = edge1.getProperties();
            List<EdgeTypeProbability> edgeTypePropertiesLeft = edge1.getEdgeTypeProbabilities();
            ArrayList<Edge.Property> propertiesRight = edge2.getProperties();
            List<EdgeTypeProbability> edgeTypePropertiesRight = edge2.getEdgeTypeProbabilities();
            int compareEdgeTypeProperty = 0;
            if (!edgeTypePropertiesLeft.isEmpty() && !edgeTypePropertiesRight.isEmpty()) {
                double probLeft = 0.0;
                for (EdgeTypeProbability etp : edgeTypePropertiesLeft) {
                    if (etp.getEdgeType() == EdgeTypeProbability.EdgeType.nil || !(etp.getProbability() > probLeft)) continue;
                    probLeft = etp.getProbability();
                }
                double probRight = 0.0;
                for (EdgeTypeProbability etp : edgeTypePropertiesRight) {
                    if (etp.getEdgeType() == EdgeTypeProbability.EdgeType.nil || !(etp.getProbability() > probRight)) continue;
                    probRight = etp.getProbability();
                }
                if (probLeft - probRight > 0.0) {
                    compareEdgeTypeProperty = -1;
                } else if (probLeft - probRight < 0.0) {
                    compareEdgeTypeProperty = 1;
                }
            }
            if (compareEdgeTypeProperty != 0) {
                return compareEdgeTypeProperty;
            }
            int compareProperty = 0;
            int scorePropertyLeft = 0;
            for (Object property : propertiesLeft) {
                if (property == Edge.Property.dd || property == Edge.Property.nl) {
                    scorePropertyLeft += 2;
                }
                if (property != Edge.Property.pd && property != Edge.Property.pl) continue;
                ++scorePropertyLeft;
            }
            int scorePropertyRight = 0;
            for (Edge.Property property : propertiesRight) {
                if (property == Edge.Property.dd || property == Edge.Property.nl) {
                    scorePropertyRight += 2;
                }
                if (property != Edge.Property.pd && property != Edge.Property.pl) continue;
                ++scorePropertyRight;
            }
            if (scorePropertyLeft - scorePropertyRight > 0) {
                compareProperty = -1;
            } else if (scorePropertyLeft - scorePropertyRight < 0) {
                compareProperty = 1;
            }
            if (compareProperty != 0) {
                return compareProperty;
            }
            int compareLeft = left1.toString().compareTo(left2.toString());
            int compareRight = right1.toString().compareTo(right2.toString());
            if (compareLeft != 0) {
                return compareLeft;
            }
            return compareRight;
        });
    }
}

