/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.RandomUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.apache.commons.math3.util.FastMath;

public final class GraphGeneratorRandomNumEdges {
    private static final int ANY_DAG = 0;
    private final int structure;
    private int numNodes;
    private int maxEdges;
    private int minEdges;
    private int numIterations;
    private int[][] parentMatrix;
    private int[][] childMatrix;
    private int randomParent;
    private int randomChild = 1;

    public GraphGeneratorRandomNumEdges(int structure) {
        if (structure != 0) {
            throw new IllegalArgumentException("Unrecognized structure.");
        }
        this.structure = structure;
        this.numNodes = 4;
        this.minEdges = 0;
        this.maxEdges = this.numNodes - 1;
        this.numIterations = 6 * this.numNodes * this.numNodes;
    }

    private int getNumNodes() {
        return this.numNodes;
    }

    public void setNumNodes(int numNodes) {
        if (numNodes < 4) {
            throw new IllegalArgumentException("Number of nodes must be >= 4.");
        }
        this.numNodes = numNodes;
        this.maxEdges = numNodes - 1;
        this.numIterations = 6 * numNodes * numNodes;
        this.parentMatrix = null;
        this.childMatrix = null;
    }

    private int getMaxEdges() {
        return this.maxEdges;
    }

    private int getNumIterations() {
        return this.numIterations;
    }

    private int getStructure() {
        return this.structure;
    }

    private int getMinEdges() {
        return this.minEdges;
    }

    public void setMinEdges(int minEdges) {
        if (minEdges < 0) {
            throw new IllegalArgumentException("Min edges must be >= 0.");
        }
        if (minEdges >= this.maxEdges - 2) {
            throw new IllegalArgumentException("Min edges must be < max edges - 1.");
        }
        this.minEdges = minEdges;
    }

    private int getMaxPossibleEdges() {
        return this.getNumNodes() * (this.getNumNodes() - 1) / 2;
    }

    public void setMaxEdges(int maxEdges) {
        if (maxEdges < 1) {
            throw new IllegalArgumentException("Max edges must be >= 1.");
        }
        if (maxEdges <= this.getMinEdges() + 2) {
            throw new IllegalArgumentException("Max edgs must be > max edges - 2.");
        }
        if (maxEdges > this.getMaxPossibleEdges()) {
            maxEdges = this.getMaxPossibleEdges();
        }
        this.maxEdges = maxEdges;
    }

    public void generate() {
        if (0 != this.getStructure()) {
            throw new IllegalStateException("Unknown structure type.");
        }
        this.generateArbitraryDag();
    }

    public Dag getDag() {
        int i;
        Dag dag = new Dag();
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        int numDigits = (int)FastMath.ceil(FastMath.log(this.numNodes) / FastMath.log(10.0));
        nf.setMinimumIntegerDigits(numDigits);
        for (i = 1; i <= this.getNumNodes(); ++i) {
            GraphNode node = new GraphNode("X" + nf.format(i));
            dag.addNode(node);
            nodes.add(node);
        }
        for (i = 0; i < this.getNumNodes(); ++i) {
            Node child = (Node)nodes.get(i);
            if (this.parentMatrix[i][0] == 1) continue;
            for (int j = 1; j < this.parentMatrix[i][0]; ++j) {
                Node parent = (Node)nodes.get(this.parentMatrix[i][j]);
                dag.addDirectedEdge(parent, child);
            }
        }
        LayoutUtil.circleLayout(dag, 200, 200, 150);
        return dag;
    }

    public String toString() {
        return "\nStructural information for generated graph:\n\tNumber of nodes:" + this.getNumNodes() + "\n\tNumber of transitions between samples:" + this.getNumIterations();
    }

    private void generateArbitraryDag() {
        this.initializeGraphAsEmpty();
        int numEdges = 0;
        for (int i = 0; i < this.getNumIterations(); ++i) {
            this.sampleEdge();
            if (this.edgeExists()) {
                if (numEdges <= this.getMinEdges()) continue;
                this.removeEdge();
                --numEdges;
                continue;
            }
            if (numEdges >= this.getMaxEdges() || !this.isAcyclic()) continue;
            this.addEdge();
            ++numEdges;
        }
    }

    private boolean edgeExists() {
        for (int i = 1; i < this.parentMatrix[this.randomChild][0]; ++i) {
            if (this.parentMatrix[this.randomChild][i] != this.randomParent) continue;
            return true;
        }
        return false;
    }

    private boolean isAcyclic() {
        boolean[] visited = new boolean[this.getNumNodes()];
        boolean noCycle = true;
        int[] list = new int[this.getNumNodes() + 1];
        int lastIndex = 1;
        list[0] = this.randomParent;
        visited[this.randomParent] = true;
        for (int index = 0; index < lastIndex && noCycle; ++index) {
            int currentNode = list[index];
            for (int i = 1; i < this.parentMatrix[currentNode][0] && noCycle; ++i) {
                if (visited[this.parentMatrix[currentNode][i]]) continue;
                if (this.parentMatrix[currentNode][i] != this.randomChild) {
                    list[lastIndex] = this.parentMatrix[currentNode][i];
                    ++lastIndex;
                } else {
                    noCycle = false;
                }
                visited[this.parentMatrix[currentNode][i]] = true;
            }
        }
        return noCycle;
    }

    private void initializeGraphAsEmpty() {
        int i;
        int max = this.getNumNodes();
        this.parentMatrix = new int[this.getNumNodes()][max];
        this.childMatrix = new int[this.getNumNodes()][max];
        for (i = 0; i < this.getNumNodes(); ++i) {
            this.parentMatrix[i][0] = 1;
            this.childMatrix[i][0] = 1;
        }
        for (i = 0; i < this.getNumNodes(); ++i) {
            for (int j = 1; j < max; ++j) {
                this.parentMatrix[i][j] = -5;
                this.childMatrix[i][j] = -5;
            }
        }
    }

    private void sampleEdge() {
        int rand = RandomUtil.getInstance().nextInt(this.getNumNodes() * (this.getNumNodes() - 1));
        this.randomParent = rand / (this.getNumNodes() - 1);
        int rest = rand - this.randomParent * (this.getNumNodes() - 1);
        this.randomChild = rest >= this.randomParent ? rest + 1 : rest;
    }

    private void addEdge() {
        this.childMatrix[this.randomParent][this.childMatrix[this.randomParent][0]] = this.randomChild;
        int[] nArray = this.childMatrix[this.randomParent];
        nArray[0] = nArray[0] + 1;
        this.parentMatrix[this.randomChild][this.parentMatrix[this.randomChild][0]] = this.randomParent;
        int[] nArray2 = this.parentMatrix[this.randomChild];
        nArray2[0] = nArray2[0] + 1;
    }

    private void removeEdge() {
        boolean go = true;
        if (this.parentMatrix[this.randomChild][0] != 1 && this.childMatrix[this.randomParent][0] != 1) {
            int proxNode;
            int atualNode;
            int i;
            int lastNode = this.parentMatrix[this.randomChild][this.parentMatrix[this.randomChild][0] - 1];
            for (i = this.parentMatrix[this.randomChild][0] - 1; i > 0 && go; --i) {
                atualNode = this.parentMatrix[this.randomChild][i];
                if (atualNode != this.randomParent) {
                    proxNode = atualNode;
                    this.parentMatrix[this.randomChild][i] = lastNode;
                    lastNode = proxNode;
                    continue;
                }
                this.parentMatrix[this.randomChild][i] = lastNode;
                go = false;
            }
            if (this.childMatrix[this.randomParent][0] != 1 && this.childMatrix[this.randomParent][0] != 1) {
                lastNode = this.childMatrix[this.randomParent][this.childMatrix[this.randomParent][0] - 1];
                go = true;
                for (i = this.childMatrix[this.randomParent][0] - 1; i > 0 && go; --i) {
                    atualNode = this.childMatrix[this.randomParent][i];
                    if (atualNode != this.randomChild) {
                        proxNode = atualNode;
                        this.childMatrix[this.randomParent][i] = lastNode;
                        lastNode = proxNode;
                        continue;
                    }
                    this.childMatrix[this.randomParent][i] = lastNode;
                    go = false;
                }
            }
            this.childMatrix[this.randomParent][this.childMatrix[this.randomParent][0] - 1] = -4;
            int[] nArray = this.childMatrix[this.randomParent];
            nArray[0] = nArray[0] - 1;
            this.parentMatrix[this.randomChild][this.parentMatrix[this.randomChild][0] - 1] = -4;
            int[] nArray2 = this.parentMatrix[this.randomChild];
            nArray2[0] = nArray2[0] - 1;
        }
    }
}

