/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeEqualityMode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.NodeVariableType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;

public class GraphNode
implements Node {
    static final long serialVersionUID = 23L;
    private String name = "??";
    private NodeType nodeType = NodeType.MEASURED;
    private NodeVariableType nodeVariableType = NodeVariableType.DOMAIN;
    private int centerX = -1;
    private int centerY = -1;
    private transient PropertyChangeSupport pcs;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public GraphNode(String name) {
        this.setName(name);
    }

    public GraphNode(GraphNode node) {
        this.name = node.name;
        this.nodeType = node.nodeType;
        this.centerX = node.centerX;
        this.centerY = node.centerY;
    }

    public static GraphNode serializableInstance() {
        return new GraphNode("X");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public final void setNodeType(NodeType nodeType) {
        if (nodeType == null) {
            throw new NullPointerException("Node type must not be null.");
        }
        this.nodeType = nodeType;
    }

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        String oldName = this.name;
        this.name = name;
        this.getPcs().firePropertyChange("name", oldName, this.name);
    }

    @Override
    public final int getCenterX() {
        return this.centerX;
    }

    @Override
    public final void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    @Override
    public final int getCenterY() {
        return this.centerY;
    }

    @Override
    public final void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    @Override
    public final void setCenter(int centerX, int centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int hashCode() {
        if (NodeEqualityMode.getEqualityType() == NodeEqualityMode.Type.OBJECT) {
            return super.hashCode();
        }
        if (NodeEqualityMode.getEqualityType() == NodeEqualityMode.Type.NAME) {
            return this.getName().hashCode();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean equals(Object o) {
        if (NodeEqualityMode.getEqualityType() == NodeEqualityMode.Type.OBJECT) {
            return o == this;
        }
        if (NodeEqualityMode.getEqualityType() == NodeEqualityMode.Type.NAME) {
            return o instanceof GraphNode && this.getName().equals(((Node)o).getName());
        }
        throw new IllegalStateException();
    }

    @Override
    public Node like(String name) {
        GraphNode node = new GraphNode(name);
        node.setNodeType(this.getNodeType());
        return node;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.name == null) {
            throw new NullPointerException();
        }
        if (this.nodeType == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public int compareTo(Node node) {
        String node1 = this.getName();
        String node2 = node.getName();
        boolean isAlpha1 = Node.ALPHA.matcher(node1).matches();
        boolean isAlpha2 = Node.ALPHA.matcher(node2).matches();
        boolean isAlphaNum1 = Node.ALPHA_NUM.matcher(node1).matches();
        boolean isAlphaNum2 = Node.ALPHA_NUM.matcher(node2).matches();
        boolean isLag1 = Node.LAG.matcher(node1).matches();
        boolean isLag2 = Node.LAG.matcher(node2).matches();
        if (isAlpha1) {
            if (isLag2) {
                return -1;
            }
        } else if (isAlphaNum1) {
            if (isAlphaNum2) {
                String s2;
                String s1 = node1.replaceAll("\\d+", "");
                if (s1.equals(s2 = node2.replaceAll("\\d+", ""))) {
                    String n1 = node1.replaceAll("\\D+", "");
                    String n2 = node2.replaceAll("\\D+", "");
                    return Integer.valueOf(n1).compareTo(Integer.valueOf(n2));
                }
                return s1.compareTo(s2);
            }
            if (isLag2) {
                return -1;
            }
        } else if (isLag1) {
            if (isAlpha2 || isAlphaNum2) {
                return 1;
            }
            if (isLag2) {
                String s2;
                String l1 = node1.replaceAll(":", "");
                String l2 = node2.replaceAll(":", "");
                String s1 = l1.replaceAll("\\d+", "");
                if (s1.equals(s2 = l2.replaceAll("\\d+", ""))) {
                    String n1 = l1.replaceAll("\\D+", "");
                    String n2 = l2.replaceAll("\\D+", "");
                    return Integer.valueOf(n1).compareTo(Integer.valueOf(n2));
                }
                return s1.compareTo(s2);
            }
        }
        return node1.compareTo(node2);
    }

    @Override
    public NodeVariableType getNodeVariableType() {
        return this.nodeVariableType;
    }

    @Override
    public void setNodeVariableType(NodeVariableType nodeVariableType) {
        this.nodeVariableType = nodeVariableType;
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }
}

