/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public final class IndependenceFact
implements Comparable<IndependenceFact>,
TetradSerializable {
    static final long serialVersionUID = 23L;
    private final Node x;
    private final Node y;
    private final Set<Node> _z;

    public IndependenceFact(Node x, Node y, List<Node> z) {
        if (x == null || y == null || z == null) {
            throw new NullPointerException();
        }
        this.x = x;
        this.y = y;
        this._z = new HashSet<Node>(z);
    }

    public IndependenceFact(Node x, Node y, Set<Node> z) {
        if (x == null || y == null || z == null) {
            throw new NullPointerException();
        }
        this.x = x;
        this.y = y;
        this._z = z;
    }

    public IndependenceFact(Node x, Node y, Node ... z) {
        if (x == null || y == null || z == null) {
            throw new NullPointerException();
        }
        this.x = x;
        this.y = y;
        HashSet<Node> cond = new HashSet<Node>();
        Collections.addAll(cond, z);
        this._z = cond;
    }

    public static IndependenceFact serializableInstance() {
        return new IndependenceFact((Node)new GraphNode("X"), (Node)new GraphNode("Y"), new Node[0]);
    }

    public Node getX() {
        return this.x;
    }

    public Node getY() {
        return this.y;
    }

    public List<Node> getZ() {
        return new LinkedList<Node>(this._z);
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IndependenceFact)) {
            return false;
        }
        IndependenceFact fact = (IndependenceFact)obj;
        HashSet<String> zString1 = new HashSet<String>();
        for (Node node : this._z) {
            zString1.add(node.getName());
        }
        HashSet<String> zString2 = new HashSet<String>();
        for (Node n : fact._z) {
            zString2.add(n.getName());
        }
        String string = this.x.getName();
        String xN2 = fact.x.getName();
        String yN1 = this.y.getName();
        String yN2 = fact.y.getName();
        return zString1.equals(zString2) && (string.equals(xN2) && yN1.equals(yN2) || string.equals(yN2) && yN1.equals(xN2));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.x).append(" _||_ ").append(this.y);
        if (!this._z.isEmpty()) {
            builder.append(" | ");
            ArrayList<Node> z = new ArrayList<Node>(this._z);
            Collections.sort(z);
            for (int i = 0; i < z.size(); ++i) {
                builder.append(z.get(i));
                if (i >= z.size() - 1) continue;
                builder.append(", ");
            }
        }
        return builder.toString();
    }

    @Override
    public int compareTo(IndependenceFact fact) {
        int c = this.getX().getName().compareTo(fact.getX().getName());
        if (c != 0) {
            return c;
        }
        c = this.getY().getName().compareTo(fact.getY().getName());
        if (c != 0) {
            return c;
        }
        List<Node> z = this.getZ();
        List<Node> factZ = fact.getZ();
        int max = FastMath.max(z.size(), factZ.size());
        for (int i = 0; i < max; ++i) {
            String s2;
            if (z.size() <= i && factZ.size() > i) {
                return -1;
            }
            if (factZ.size() <= i && z.size() > i) {
                return 1;
            }
            String s = z.get(i).getName();
            c = s.compareTo(s2 = factZ.get(i).getName());
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

