/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.OrderedPair;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetrad.util.TaskManager;
import edu.cmu.tetrad.util.TetradSerializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class Paths
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private final Graph graph;

    public Paths(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("Null graph");
        }
        this.graph = graph;
    }

    public List<Node> validOrder(List<Node> initialOrder, boolean forward) {
        ArrayList<Node> _initialOrder = new ArrayList<Node>(initialOrder);
        EdgeListGraph _graph = new EdgeListGraph(this.graph);
        if (forward) {
            Collections.reverse(_initialOrder);
        }
        ArrayList<Node> newOrder = new ArrayList<Node>();
        while (!_initialOrder.isEmpty()) {
            Node x;
            Iterator itr = _initialOrder.iterator();
            do {
                if (!itr.hasNext()) {
                    throw new IllegalArgumentException("This graph has a cycle.");
                }
                x = (Node)itr.next();
            } while (this.invalidSink(x, _graph));
            newOrder.add(x);
            _graph.removeNode(x);
            itr.remove();
        }
        Collections.reverse(newOrder);
        return newOrder;
    }

    private boolean invalidSink(Node x, Graph graph) {
        LinkedList<Node> neighbors = new LinkedList<Node>();
        for (Edge edge : graph.getEdges(x)) {
            if (edge.getDistalEndpoint(x) == Endpoint.ARROW) {
                return true;
            }
            if (edge.getProximalEndpoint(x) != Endpoint.TAIL) continue;
            neighbors.add(edge.getDistalNode(x));
        }
        while (!neighbors.isEmpty()) {
            Node y = (Node)neighbors.pop();
            for (Node z : neighbors) {
                if (graph.isAdjacentTo(y, z)) continue;
                return true;
            }
        }
        return false;
    }

    public List<List<Node>> connectedComponents() {
        LinkedList<List<Node>> components = new LinkedList<List<Node>>();
        LinkedList<Node> unsortedNodes = new LinkedList<Node>(this.graph.getNodes());
        while (!unsortedNodes.isEmpty()) {
            Node seed = unsortedNodes.removeFirst();
            ConcurrentSkipListSet<Node> component = new ConcurrentSkipListSet<Node>();
            this.collectComponentVisit(seed, component, unsortedNodes);
            components.add(new ArrayList<Node>(component));
        }
        return components;
    }

    public List<List<Node>> directedPathsFromTo(Node node1, Node node2, int maxLength) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        this.directedPathsFromToVisit(node1, node2, new LinkedList<Node>(), paths, maxLength);
        return paths;
    }

    private void directedPathsFromToVisit(Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths, int maxLength) {
        if (maxLength != -1 && path.size() > maxLength - 2) {
            return;
        }
        int witnessed = 0;
        for (Node node : path) {
            if (node != node1) continue;
            ++witnessed;
        }
        if (witnessed > 1) {
            return;
        }
        path.addLast(node1);
        for (Edge edge : this.graph.getEdges(node1)) {
            Node child = Edges.traverseDirected(node1, edge);
            if (child == null || path.contains(child)) continue;
            if (child == node2) {
                LinkedList<Node> _path = new LinkedList<Node>(path);
                _path.add(child);
                paths.add(_path);
                continue;
            }
            this.directedPathsFromToVisit(child, node2, path, paths, maxLength);
        }
        path.removeLast();
    }

    public List<List<Node>> semidirectedPathsFromTo(Node node1, Node node2, int maxLength) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        this.semidirectedPathsFromToVisit(node1, node2, new LinkedList<Node>(), paths, maxLength);
        return paths;
    }

    private void semidirectedPathsFromToVisit(Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths, int maxLength) {
        if (maxLength != -1 && path.size() > maxLength - 2) {
            return;
        }
        int witnessed = 0;
        for (Node node : path) {
            if (node != node1) continue;
            ++witnessed;
        }
        if (witnessed > 1) {
            return;
        }
        path.addLast(node1);
        for (Edge edge : this.graph.getEdges(node1)) {
            Node child = Edges.traverseSemiDirected(node1, edge);
            if (child == null) continue;
            if (child == node2) {
                LinkedList<Node> _path = new LinkedList<Node>(path);
                _path.add(child);
                paths.add(_path);
                continue;
            }
            if (path.contains(child)) continue;
            this.semidirectedPathsFromToVisit(child, node2, path, paths, maxLength);
        }
        path.removeLast();
    }

    public List<List<Node>> allPathsFromTo(Node node1, Node node2, int maxLength) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        this.allPathsFromToVisit(node1, node2, new LinkedList<Node>(), paths, maxLength);
        return paths;
    }

    private void allPathsFromToVisit(Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths, int maxLength) {
        path.addLast(node1);
        if (path.size() > (maxLength == -1 ? 1000 : maxLength)) {
            return;
        }
        for (Edge edge : this.graph.getEdges(node1)) {
            Node child = Edges.traverse(node1, edge);
            if (child == null || path.contains(child)) continue;
            if (child == node2) {
                ArrayList<Node> _path = new ArrayList<Node>(path);
                _path.add(child);
                paths.add(_path);
                continue;
            }
            this.allPathsFromToVisit(child, node2, path, paths, maxLength);
        }
        path.removeLast();
    }

    public List<List<Node>> allDirectedPathsFromTo(Node node1, Node node2, int maxLength) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        this.allDirectedPathsFromToVisit(node1, node2, new LinkedList<Node>(), paths, maxLength);
        return paths;
    }

    private void allDirectedPathsFromToVisit(Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths, int maxLength) {
        path.addLast(node1);
        if (path.size() > (maxLength == -1 ? 1000 : maxLength)) {
            path.removeLast();
            return;
        }
        for (Edge edge : this.graph.getEdges(node1)) {
            Node child = Edges.traverseDirected(node1, edge);
            if (child == null || path.contains(child)) continue;
            if (child == node2) {
                ArrayList<Node> _path = new ArrayList<Node>(path);
                _path.add(child);
                paths.add(_path);
                continue;
            }
            this.allDirectedPathsFromToVisit(child, node2, path, paths, maxLength);
        }
        path.removeLast();
    }

    public List<List<Node>> treks(Node node1, Node node2, int maxLength) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        this.treks(node1, node2, new LinkedList<Node>(), paths, maxLength);
        return paths;
    }

    private void treks(Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths, int maxLength) {
        if (path.size() > (maxLength == -1 ? 1000 : maxLength - 2)) {
            return;
        }
        if (path.contains(node1)) {
            return;
        }
        if (node1 == node2) {
            return;
        }
        path.addLast(node1);
        for (Edge edge : this.graph.getEdges(node1)) {
            Node node0;
            Node next = Edges.traverse(node1, edge);
            if (!edge.isDirected() || path.size() > 1 && (next == (node0 = path.get(path.size() - 2)) || this.graph.isDefCollider(node0, node1, next))) continue;
            if (next == node2 && !path.isEmpty()) {
                LinkedList<Node> _path = new LinkedList<Node>(path);
                _path.add(next);
                paths.add(_path);
                continue;
            }
            if (path.contains(next)) continue;
            this.treks(next, node2, path, paths, maxLength);
        }
        path.removeLast();
    }

    public List<List<Node>> treksIncludingBidirected(Node node1, Node node2) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        this.treksIncludingBidirected(node1, node2, new LinkedList<Node>(), paths);
        return paths;
    }

    private void treksIncludingBidirected(Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths) {
        if (!(this.graph instanceof SemGraph)) {
            throw new IllegalArgumentException("Expecting a SEM graph");
        }
        SemGraph _graph = (SemGraph)this.graph;
        if (!_graph.isShowErrorTerms()) {
            throw new IllegalArgumentException("The SEM Graph must be showing its error terms; this method doesn't traverse two edges between the same nodes well.");
        }
        if (path.contains(node1)) {
            return;
        }
        if (node1 == node2) {
            return;
        }
        path.addLast(node1);
        for (Edge edge : this.graph.getEdges(node1)) {
            Node node0;
            Node next = Edges.traverse(node1, edge);
            if (!edge.isDirected() && !Edges.isBidirectedEdge(edge) || path.size() > 1 && (next == (node0 = path.get(path.size() - 2)) || this.graph.isDefCollider(node0, node1, next))) continue;
            if (next == node2 && !path.isEmpty()) {
                LinkedList<Node> _path = new LinkedList<Node>(path);
                _path.add(next);
                paths.add(_path);
                continue;
            }
            if (path.contains(next)) continue;
            this.treksIncludingBidirected(next, node2, path, paths);
        }
        path.removeLast();
    }

    public boolean existsDirectedPathFromTo(Node node1, Node node2, int depth) {
        return node1 == node2 || this.existsDirectedPathVisit(node1, node2, new LinkedList<Node>(), depth);
    }

    private boolean existsDirectedPathVisit(Node node1, Node node2, LinkedList<Node> path, int depth) {
        path.addLast(node1);
        if (depth == -1) {
            depth = Integer.MAX_VALUE;
        }
        if (path.size() >= depth) {
            return false;
        }
        for (Edge edge : this.graph.getEdges(node1)) {
            Node child = Edges.traverseDirected(node1, edge);
            if (this.graph.getEdges(node1, child).size() == 2) {
                return true;
            }
            if (child == null) continue;
            if (child == node2) {
                return true;
            }
            if (path.contains(child) || !this.existsDirectedPathVisit(child, node2, path, depth)) continue;
            return true;
        }
        path.removeLast();
        return false;
    }

    public boolean existsSemiDirectedPath(Node from, Node to) {
        LinkedList<Node> Q = new LinkedList<Node>();
        HashSet<Node> V = new HashSet<Node>();
        for (Node u : this.graph.getAdjacentNodes(from)) {
            Edge edge = this.graph.getEdge(from, u);
            Node c = GraphUtils.traverseSemiDirected(from, edge);
            if (c == null || V.contains(c)) continue;
            V.add(c);
            Q.offer(c);
        }
        while (!Q.isEmpty()) {
            Node t = (Node)Q.remove();
            if (t == to) {
                return true;
            }
            for (Node u : this.graph.getAdjacentNodes(t)) {
                Edge edge = this.graph.getEdge(t, u);
                Node c = GraphUtils.traverseSemiDirected(t, edge);
                if (c == null || V.contains(c)) continue;
                V.add(c);
                Q.offer(c);
            }
        }
        return false;
    }

    public boolean isDConnectedTo(List<Node> x, List<Node> y, List<Node> z) {
        Set<Node> ancestors = this.ancestorsOf(z);
        ArrayDeque<OrderedPair<Node>> Q = new ArrayDeque<OrderedPair<Node>>();
        HashSet<OrderedPair<Node>> V = new HashSet<OrderedPair<Node>>();
        for (Node _x : x) {
            for (Node node : this.graph.getAdjacentNodes(_x)) {
                if (y.contains(node)) {
                    return true;
                }
                OrderedPair<Node> edge = new OrderedPair<Node>(_x, node);
                Q.offer(edge);
                V.add(edge);
            }
        }
        while (!Q.isEmpty()) {
            OrderedPair t = (OrderedPair)Q.poll();
            Node b = (Node)t.getFirst();
            Node a = (Node)t.getSecond();
            for (Node c : this.graph.getAdjacentNodes(b)) {
                boolean collider;
                if (c == a || (!(collider = this.graph.isDefCollider(a, b, c)) || !ancestors.contains(b)) && (collider || z.contains(b))) continue;
                if (y.contains(c)) {
                    return true;
                }
                OrderedPair<Node> u = new OrderedPair<Node>(b, c);
                if (V.contains(u)) continue;
                V.add(u);
                Q.offer(u);
            }
        }
        return false;
    }

    public Set<Node> getDconnectedVars(Node y, List<Node> z) {
        HashSet<Node> Y = new HashSet<Node>();
        class EdgeNode {
            private final Edge edge;
            private final Node node;

            public EdgeNode(Edge edge, Node node) {
                this.edge = edge;
                this.node = node;
            }

            public int hashCode() {
                return this.edge.hashCode() + this.node.hashCode();
            }

            public boolean equals(Object o) {
                if (!(o instanceof EdgeNode)) {
                    throw new IllegalArgumentException();
                }
                EdgeNode _o = (EdgeNode)o;
                return _o.edge == this.edge && _o.node == this.node;
            }
        }
        ArrayDeque<EdgeNode> Q = new ArrayDeque<EdgeNode>();
        HashSet<EdgeNode> V = new HashSet<EdgeNode>();
        for (Edge edge : this.graph.getEdges(y)) {
            EdgeNode edgeNode = new EdgeNode(edge, y);
            Q.offer(edgeNode);
            V.add(edgeNode);
            Y.add(edge.getDistalNode(y));
        }
        while (!Q.isEmpty()) {
            EdgeNode t = (EdgeNode)Q.poll();
            Edge edge1 = t.edge;
            Node a = t.node;
            Node b = edge1.getDistalNode(a);
            for (Edge edge2 : this.graph.getEdges(b)) {
                EdgeNode u;
                Node c = edge2.getDistalNode(b);
                if (c == a || !this.reachable(edge1, edge2, a, z) || V.contains(u = new EdgeNode(edge2, b))) continue;
                V.add(u);
                Q.offer(u);
                Y.add(c);
            }
        }
        return Y;
    }

    private boolean reachable(Edge e1, Edge e2, Node a, List<Node> z) {
        boolean collider;
        Node b = e1.getDistalNode(a);
        Node c = e2.getDistalNode(b);
        boolean bl = collider = e1.getProximalEndpoint(b) == Endpoint.ARROW && e2.getProximalEndpoint(b) == Endpoint.ARROW;
        if (!(collider && !this.graph.underlines().isUnderlineTriple(a, b, c) || z.contains(b))) {
            return true;
        }
        boolean ancestor = this.isAncestor(b, z);
        return collider && ancestor;
    }

    private boolean isAncestor(Node b, List<Node> z) {
        if (z.contains(b)) {
            return true;
        }
        ArrayDeque<Node> Q = new ArrayDeque<Node>();
        HashSet<Node> V = new HashSet<Node>();
        for (Node node : z) {
            Q.offer(node);
            V.add(node);
        }
        while (!Q.isEmpty()) {
            Node t = (Node)Q.poll();
            if (t == b) {
                return true;
            }
            for (Node c : this.graph.getParents(t)) {
                if (V.contains(c)) continue;
                Q.offer(c);
                V.add(c);
            }
        }
        return false;
    }

    private boolean reachable(Node a, Node b, Node c, List<Node> z) {
        boolean collider = this.graph.isDefCollider(a, b, c);
        if (!(collider && !this.graph.underlines().isUnderlineTriple(a, b, c) || z.contains(b))) {
            return true;
        }
        boolean ancestor = this.isAncestor(b, z);
        return collider && ancestor;
    }

    private List<Node> getPassNodes(Node a, Node b, List<Node> z) {
        ArrayList<Node> passNodes = new ArrayList<Node>();
        for (Node c : this.graph.getAdjacentNodes(b)) {
            if (c == a || !this.reachable(a, b, c, z)) continue;
            passNodes.add(c);
        }
        return passNodes;
    }

    private Set<Node> ancestorsOf(List<Node> z) {
        ArrayDeque<Node> Q = new ArrayDeque<Node>();
        HashSet<Node> V = new HashSet<Node>();
        for (Node node : z) {
            Q.offer(node);
            V.add(node);
        }
        while (!Q.isEmpty()) {
            Node t = (Node)Q.poll();
            for (Node c : this.graph.getParents(t)) {
                if (V.contains(c)) continue;
                Q.offer(c);
                V.add(c);
            }
        }
        return V;
    }

    public boolean existsInducingPath(Node x, Node y) {
        if (x.getNodeType() != NodeType.MEASURED) {
            throw new IllegalArgumentException();
        }
        if (y.getNodeType() != NodeType.MEASURED) {
            throw new IllegalArgumentException();
        }
        LinkedList<Node> path = new LinkedList<Node>();
        path.add(x);
        for (Node b : this.graph.getAdjacentNodes(x)) {
            if (!this.existsInducingPathVisit(x, b, x, y, path)) continue;
            return true;
        }
        return false;
    }

    public boolean existsInducingPathVisit(Node a, Node b, Node x, Node y, LinkedList<Node> path) {
        if (path.contains(b)) {
            return false;
        }
        path.addLast(b);
        if (b == y) {
            return true;
        }
        for (Node c : this.graph.getAdjacentNodes(b)) {
            if (c == a || b.getNodeType() == NodeType.MEASURED && !this.graph.isDefCollider(a, b, c) || this.graph.isDefCollider(a, b, c) && !this.graph.paths().isAncestorOf(b, x) && !this.graph.paths().isAncestorOf(b, y) || !this.existsInducingPathVisit(b, c, x, y, path)) continue;
            return true;
        }
        path.removeLast();
        return false;
    }

    public List<Node> getInducingPath(Node x, Node y) {
        if (x.getNodeType() != NodeType.MEASURED) {
            throw new IllegalArgumentException();
        }
        if (y.getNodeType() != NodeType.MEASURED) {
            throw new IllegalArgumentException();
        }
        LinkedList<Node> path = new LinkedList<Node>();
        path.add(x);
        for (Node b : this.graph.getAdjacentNodes(x)) {
            if (!this.existsInducingPathVisit(x, b, x, y, path)) continue;
            return path;
        }
        return null;
    }

    public List<Node> possibleDsep(Node x, Node y, int maxPathLength) {
        HashSet<Node> dsep = new HashSet<Node>();
        ArrayDeque<OrderedPair<Node>> Q = new ArrayDeque<OrderedPair<Node>>();
        HashSet<OrderedPair<Node>> V = new HashSet<OrderedPair<Node>>();
        HashMap<Node, Set<Node>> previous = new HashMap<Node, Set<Node>>();
        previous.put(x, new HashSet());
        OrderedPair<Node> e = null;
        int distance = 0;
        HashSet<Node> adjacentNodes = new HashSet<Node>(this.graph.getAdjacentNodes(x));
        for (Node b : adjacentNodes) {
            if (b == y) continue;
            OrderedPair<Node> edge = new OrderedPair<Node>(x, b);
            if (e == null) {
                e = edge;
            }
            Q.offer(edge);
            V.add(edge);
            Paths.addToSet(previous, b, x);
            dsep.add(b);
        }
        while (!Q.isEmpty()) {
            OrderedPair t = (OrderedPair)Q.poll();
            if (e == t) {
                e = null;
                if (++distance > 0 && distance > (maxPathLength == -1 ? 1000 : maxPathLength)) break;
            }
            Node a = (Node)t.getFirst();
            Node b = (Node)t.getSecond();
            if (this.existOnePathWithPossibleParents(previous, b, x, b)) {
                dsep.add(b);
            }
            for (Node c : this.graph.getAdjacentNodes(b)) {
                OrderedPair<Node> u;
                if (c == a || c == x || c == y) continue;
                Paths.addToSet(previous, b, c);
                if (!this.graph.isDefCollider(a, b, c) && !this.graph.isAdjacentTo(a, c) || V.contains(u = new OrderedPair<Node>(a, c))) continue;
                V.add(u);
                Q.offer(u);
                if (e != null) continue;
                e = u;
            }
        }
        dsep.remove(x);
        dsep.remove(y);
        ArrayList<Node> _dsep = new ArrayList<Node>(dsep);
        Collections.sort(_dsep);
        Collections.reverse(_dsep);
        return _dsep;
    }

    public void removeByPossibleDsep(IndependenceTest test, SepsetMap sepsets) {
        block0: for (Edge edge : this.graph.getEdges()) {
            List<Node> sepset;
            int[] choice;
            Node a = edge.getNode1();
            Node b = edge.getNode2();
            List<Node> possibleDsep = this.possibleDsep(a, b, -1);
            SublistGenerator gen = new SublistGenerator(possibleDsep.size(), possibleDsep.size());
            while ((choice = gen.next()) != null) {
                if (choice.length < 2) continue;
                sepset = GraphUtils.asList(choice, possibleDsep);
                if (new HashSet<Node>(this.graph.getAdjacentNodes(a)).containsAll(sepset) || new HashSet<Node>(this.graph.getAdjacentNodes(b)).containsAll(sepset) || !test.checkIndependence(a, b, sepset).independent()) continue;
                this.graph.removeEdge(edge);
                if (sepsets == null) break;
                sepsets.set(a, b, sepset);
                break;
            }
            if (!this.graph.containsEdge(edge)) continue;
            possibleDsep = this.possibleDsep(b, a, -1);
            gen = new SublistGenerator(possibleDsep.size(), possibleDsep.size());
            while ((choice = gen.next()) != null) {
                if (choice.length < 2) continue;
                sepset = GraphUtils.asList(choice, possibleDsep);
                if (new HashSet<Node>(this.graph.getAdjacentNodes(a)).containsAll(sepset) || new HashSet<Node>(this.graph.getAdjacentNodes(b)).containsAll(sepset) || !test.checkIndependence(a, b, sepset).independent()) continue;
                this.graph.removeEdge(edge);
                if (sepsets == null) continue block0;
                sepsets.set(a, b, sepset);
                continue block0;
            }
        }
    }

    private boolean existOnePathWithPossibleParents(Map<Node, Set<Node>> previous, Node w, Node x, Node b) {
        if (w == x) {
            return true;
        }
        Set<Node> p = previous.get(w);
        if (p == null) {
            return false;
        }
        for (Node r : p) {
            if (r == b || r == x || !this.existsSemidirectedPath(r, x) && !this.existsSemidirectedPath(r, b)) continue;
            return true;
        }
        return false;
    }

    private static void addToSet(Map<Node, Set<Node>> previous, Node b, Node c) {
        previous.computeIfAbsent(c, k -> new HashSet());
        Set<Node> list = previous.get(c);
        list.add(b);
    }

    public boolean existsSemidirectedPath(Node from, Node to) {
        LinkedList<Node> Q = new LinkedList<Node>();
        HashSet<Node> V = new HashSet<Node>();
        for (Node u : this.graph.getAdjacentNodes(from)) {
            Edge edge = this.graph.getEdge(from, u);
            Node c = GraphUtils.traverseSemiDirected(from, edge);
            if (c == null || V.contains(c)) continue;
            V.add(c);
            Q.offer(c);
        }
        while (!Q.isEmpty()) {
            Node t = (Node)Q.remove();
            if (t == to) {
                return true;
            }
            for (Node u : this.graph.getAdjacentNodes(t)) {
                Edge edge = this.graph.getEdge(t, u);
                Node c = GraphUtils.traverseSemiDirected(t, edge);
                if (c == null || V.contains(c)) continue;
                V.add(c);
                Q.offer(c);
            }
        }
        return false;
    }

    public boolean isSatisfyBackDoorCriterion(Graph graph, Node x, Node y, List<Node> z) {
        Dag dag = new Dag(graph);
        if (z.stream().anyMatch(zNode -> dag.paths().isDescendentOf((Node)zNode, x))) {
            return false;
        }
        List<List<Node>> directedPaths = this.allDirectedPathsFromTo(x, y, -1);
        directedPaths.forEach(nodes -> nodes.forEach(node -> {
            if (node != x && node != y) {
                dag.removeNode((Node)node);
            }
        }));
        return dag.paths().isDSeparatedFrom(x, y, z);
    }

    public List<Node> getSepset(Node x, Node y) {
        List<Node> sepset = this.getSepsetVisit(x, y);
        if (sepset == null) {
            sepset = this.getSepsetVisit(y, x);
        }
        return sepset;
    }

    private List<Node> getSepsetVisit(Node x, Node y) {
        ArrayList _z;
        if (x == y) {
            return null;
        }
        ArrayList<Node> z = new ArrayList<Node>();
        do {
            _z = new ArrayList(z);
            HashSet<Node> path = new HashSet<Node>();
            path.add(x);
            HashSet<Triple> colliders = new HashSet<Triple>();
            for (Node b : this.graph.getAdjacentNodes(x)) {
                if (!this.sepsetPathFound(x, b, y, path, z, colliders, -1)) continue;
                return null;
            }
        } while (!new HashSet(z).equals(new HashSet(_z)));
        return z;
    }

    private boolean sepsetPathFound(Node a, Node b, Node y, Set<Node> path, List<Node> z, Set<Triple> colliders, int bound) {
        if (b == y) {
            return true;
        }
        if (path.contains(b)) {
            return false;
        }
        if (path.size() > (bound == -1 ? 1000 : bound)) {
            return false;
        }
        path.add(b);
        if (b.getNodeType() == NodeType.LATENT || z.contains(b)) {
            List<Node> passNodes = this.getPassNodes(a, b, z);
            for (Node c : passNodes) {
                if (!this.sepsetPathFound(b, c, y, path, z, colliders, bound)) continue;
                path.remove(b);
                return true;
            }
            path.remove(b);
            return false;
        }
        boolean found1 = false;
        HashSet<Triple> _colliders1 = new HashSet<Triple>();
        for (Node c : this.getPassNodes(a, b, z)) {
            if (!this.sepsetPathFound(b, c, y, path, z, _colliders1, bound)) continue;
            found1 = true;
            break;
        }
        if (!found1) {
            path.remove(b);
            colliders.addAll(_colliders1);
            return false;
        }
        z.add(b);
        boolean found2 = false;
        HashSet<Triple> _colliders2 = new HashSet<Triple>();
        for (Node c : this.getPassNodes(a, b, z)) {
            if (!this.sepsetPathFound(b, c, y, path, z, _colliders2, bound)) continue;
            found2 = true;
            break;
        }
        if (!found2) {
            path.remove(b);
            colliders.addAll(_colliders2);
            return false;
        }
        z.remove(b);
        path.remove(b);
        return true;
    }

    public boolean isDConnectedTo(Node x, Node y, List<Node> z) {
        class EdgeNode {
            private final Edge edge;
            private final Node node;

            public EdgeNode(Edge edge, Node node) {
                this.edge = edge;
                this.node = node;
            }

            public int hashCode() {
                return this.edge.hashCode() + this.node.hashCode();
            }

            public boolean equals(Object o) {
                if (!(o instanceof EdgeNode)) {
                    throw new IllegalArgumentException();
                }
                EdgeNode _o = (EdgeNode)o;
                return _o.edge == this.edge && _o.node == this.node;
            }
        }
        ArrayDeque<EdgeNode> Q = new ArrayDeque<EdgeNode>();
        HashSet<EdgeNode> V = new HashSet<EdgeNode>();
        if (x == y) {
            return true;
        }
        for (Edge edge : this.graph.getEdges(x)) {
            if (edge.getDistalNode(x) == y) {
                return true;
            }
            EdgeNode edgeNode = new EdgeNode(edge, x);
            Q.offer(edgeNode);
            V.add(edgeNode);
        }
        while (!Q.isEmpty()) {
            EdgeNode t = (EdgeNode)Q.poll();
            Edge edge1 = t.edge;
            Node a = t.node;
            Node b = edge1.getDistalNode(a);
            for (Edge edge2 : this.graph.getEdges(b)) {
                Node c = edge2.getDistalNode(b);
                if (c == a || !this.reachable(edge1, edge2, a, z)) continue;
                if (c == y) {
                    return true;
                }
                EdgeNode u = new EdgeNode(edge2, b);
                if (V.contains(u)) continue;
                V.add(u);
                Q.offer(u);
            }
        }
        return false;
    }

    private void collectComponentVisit(Node node, Set<Node> component, List<Node> unsortedNodes) {
        if (TaskManager.getInstance().isCanceled()) {
            return;
        }
        component.add(node);
        unsortedNodes.remove(node);
        List<Node> adj = this.graph.getAdjacentNodes(node);
        for (Node anAdj : adj) {
            if (component.contains(anAdj)) continue;
            this.collectComponentVisit(anAdj, component, unsortedNodes);
        }
    }

    public boolean defVisible(Edge edge) {
        if (!edge.isDirected()) {
            return false;
        }
        if (this.graph.containsEdge(edge)) {
            Node A = Edges.getDirectedEdgeTail(edge);
            Node B = Edges.getDirectedEdgeHead(edge);
            for (Node C : this.graph.getAdjacentNodes(A)) {
                Edge e;
                if (C == B || this.graph.isAdjacentTo(C, B) || (e = this.graph.getEdge(C, A)).getProximalEndpoint(A) != Endpoint.ARROW) continue;
                return true;
            }
            return this.visibleEdgeHelper(A, B);
        }
        throw new IllegalArgumentException("Given edge is not in the graph.");
    }

    private boolean visibleEdgeHelper(Node A, Node B) {
        if (A.getNodeType() != NodeType.MEASURED) {
            return false;
        }
        if (B.getNodeType() != NodeType.MEASURED) {
            return false;
        }
        LinkedList<Node> path = new LinkedList<Node>();
        path.add(A);
        for (Node C : this.graph.getNodesInTo(A, Endpoint.ARROW)) {
            if (this.graph.isParentOf(C, A)) {
                return true;
            }
            if (!this.visibleEdgeHelperVisit(C, A, B, path)) continue;
            return true;
        }
        return false;
    }

    private boolean visibleEdgeHelperVisit(Node c, Node a, Node b, LinkedList<Node> path) {
        if (path.contains(a)) {
            return false;
        }
        path.addLast(a);
        if (a == b) {
            return true;
        }
        for (Node D : this.graph.getNodesInTo(a, Endpoint.ARROW)) {
            if (this.graph.isParentOf(D, c)) {
                return true;
            }
            if (a.getNodeType() == NodeType.MEASURED && !this.graph.isDefCollider(D, c, a) || this.graph.isDefCollider(D, c, a) && !this.graph.isParentOf(c, b) || !this.visibleEdgeHelperVisit(D, c, b, path)) continue;
            return true;
        }
        path.removeLast();
        return false;
    }

    public boolean existsDirectedCycle() {
        for (Node node : this.graph.getNodes()) {
            if (!this.existsDirectedPathFromTo(node, node)) continue;
            return true;
        }
        return false;
    }

    public boolean existsDirectedPathFromTo(Node node1, Node node2) {
        LinkedList<Node> Q = new LinkedList<Node>();
        HashSet<Node> V = new HashSet<Node>();
        Q.add(node1);
        V.add(node1);
        while (!Q.isEmpty()) {
            Node t = (Node)Q.poll();
            for (Node c : this.graph.getChildren(t)) {
                if (c == node2) {
                    return true;
                }
                if (V.contains(c)) continue;
                V.add(c);
                Q.offer(c);
            }
        }
        return false;
    }

    public boolean existsSemiDirectedPathFromTo(Node node1, Node node2) {
        return this.existsSemiDirectedPathFromTo(node1, Collections.singleton(node2));
    }

    public boolean existsSemiDirectedPathFromTo(Node node1, Set<Node> nodes) {
        return this.existsSemiDirectedPathVisit(node1, nodes, new LinkedList<Node>());
    }

    public boolean existsTrek(Node node1, Node node2) {
        for (Node node : this.graph.getNodes()) {
            if (!this.isAncestorOf(node, node1) || !this.isAncestorOf(node, node2)) continue;
            return true;
        }
        return false;
    }

    public List<Node> getDescendants(List<Node> nodes) {
        HashSet<Node> ancestors = new HashSet<Node>();
        for (Node n : this.graph.getNodes()) {
            for (Node m : nodes) {
                if (!this.isDescendentOf(n, m)) continue;
                ancestors.add(n);
            }
        }
        return new ArrayList<Node>(ancestors);
    }

    public boolean isAncestorOf(Node node1, Node node2) {
        return node1 == node2 || this.existsDirectedPathFromTo(node1, node2);
    }

    public List<Node> getAncestors(List<Node> nodes) {
        HashSet<Node> ancestors = new HashSet<Node>();
        for (Node n : this.graph.getNodes()) {
            for (Node m : nodes) {
                if (!this.isAncestorOf(n, m)) continue;
                ancestors.add(n);
            }
        }
        return new ArrayList<Node>(ancestors);
    }

    public boolean isDescendentOf(Node node1, Node node2) {
        return node1 == node2 || this.existsDirectedPathFromTo(node2, node1);
    }

    public boolean defNonDescendent(Node node1, Node node2) {
        return !this.possibleAncestor(node1, node2);
    }

    public boolean isDSeparatedFrom(Node node1, Node node2, List<Node> z) {
        return !this.isDConnectedTo(node1, node2, z);
    }

    private boolean existsSemiDirectedPathVisit(Node node1, Set<Node> nodes2, LinkedList<Node> path) {
        path.addLast(node1);
        for (Edge edge : this.graph.getEdges(node1)) {
            Node child = Edges.traverseSemiDirected(node1, edge);
            if (child == null) continue;
            if (nodes2.contains(child)) {
                return true;
            }
            if (path.contains(child) || !this.existsSemiDirectedPathVisit(child, nodes2, path)) continue;
            return true;
        }
        path.removeLast();
        return false;
    }

    public boolean isDirectedFromTo(Node node1, Node node2) {
        List<Edge> edges = this.graph.getEdges(node1, node2);
        if (edges.size() != 1) {
            return false;
        }
        Edge edge = edges.get(0);
        return edge.pointsTowards(node2);
    }

    public boolean isUndirectedFromTo(Node node1, Node node2) {
        Edge edge = this.graph.getEdge(node1, node2);
        return edge != null && edge.getEndpoint1() == Endpoint.TAIL && edge.getEndpoint2() == Endpoint.TAIL;
    }

    public boolean possibleAncestor(Node node1, Node node2) {
        return this.existsSemiDirectedPathFromTo(node1, Collections.singleton(node2));
    }
}

