/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.util.RandomUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public class RandomGraph {
    public static Graph randomDag(int numNodes, int numLatentConfounders, int maxNumEdges, int maxDegree, int maxIndegree, int maxOutdegree, boolean connected) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.add(new GraphNode("X" + (i + 1)));
        }
        return RandomGraph.randomDag(nodes, numLatentConfounders, maxNumEdges, maxDegree, maxIndegree, maxOutdegree, connected);
    }

    public static Dag randomDag(List<Node> nodes, int numLatentConfounders, int maxNumEdges, int maxDegree, int maxIndegree, int maxOutdegree, boolean connected) {
        return new Dag(RandomGraph.randomGraph(nodes, numLatentConfounders, maxNumEdges, maxDegree, maxIndegree, maxOutdegree, connected));
    }

    public static Graph randomGraph(int numNodes, int numLatentConfounders, int numEdges, int maxDegree, int maxIndegree, int maxOutdegree, boolean connected) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.add(new GraphNode("X" + (i + 1)));
        }
        return RandomGraph.randomGraph(nodes, numLatentConfounders, numEdges, maxDegree, maxIndegree, maxOutdegree, connected);
    }

    public static Graph randomGraph(List<Node> nodes, int numLatentConfounders, int maxNumEdges, int maxDegree, int maxIndegree, int maxOutdegree, boolean connected) {
        return RandomGraph.randomGraphRandomForwardEdges(nodes, numLatentConfounders, maxNumEdges, maxDegree, maxIndegree, maxOutdegree, connected, true);
    }

    public static Graph randomGraphUniform(List<Node> nodes, int numLatentConfounders, int maxNumEdges, int maxDegree, int maxIndegree, int maxOutdegree, boolean connected, int numIterations) {
        int numNodes = nodes.size();
        if (numNodes == 0) {
            throw new IllegalArgumentException("NumNodes most be > 0: " + numNodes);
        }
        if (maxNumEdges < 0 || maxNumEdges > numNodes * (numNodes - 1)) {
            throw new IllegalArgumentException("NumEdges must be at least 0 and at most (#nodes)(#nodes - 1) / 2: " + maxNumEdges);
        }
        if (numLatentConfounders < 0 || numLatentConfounders > numNodes) {
            throw new IllegalArgumentException("Max # latent confounders must be at least 0 and at most the number of nodes: " + numLatentConfounders);
        }
        for (Node node : nodes) {
            node.setNodeType(NodeType.MEASURED);
        }
        UniformGraphGenerator generator = connected ? new UniformGraphGenerator(1) : new UniformGraphGenerator(0);
        generator.setNumNodes(numNodes);
        generator.setMaxEdges(maxNumEdges);
        generator.setMaxDegree(maxDegree);
        generator.setMaxInDegree(maxIndegree);
        generator.setMaxOutDegree(maxOutdegree);
        generator.setNumIterations(numIterations);
        generator.generate();
        Graph dag = generator.getDag(nodes);
        RandomGraph.fixLatents1(numLatentConfounders, dag);
        LayoutUtil.circleLayout(dag, 200, 200, 150);
        return dag;
    }

    static List<Node> getCommonCauses(Graph dag) {
        ArrayList<Node> commonCauses = new ArrayList<Node>();
        List<Node> nodes = dag.getNodes();
        for (Node node : nodes) {
            List<Node> children = dag.getChildren(node);
            if (children.size() < 2) continue;
            commonCauses.add(node);
        }
        return commonCauses;
    }

    public static Graph randomGraphRandomForwardEdges(int numNodes, int numLatentConfounders, int numEdges, int maxDegree, int maxIndegree, int maxOutdegree, boolean connected) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.add(new GraphNode("X" + (i + 1)));
        }
        return RandomGraph.randomGraph(nodes, numLatentConfounders, numEdges, maxDegree, maxIndegree, maxOutdegree, connected);
    }

    public static Graph randomGraphRandomForwardEdges(List<Node> nodes, int numLatentConfounders, int numEdges, int maxDegree, int maxIndegree, int maxOutdegree, boolean connected) {
        return RandomGraph.randomGraphRandomForwardEdges(nodes, numLatentConfounders, numEdges, maxDegree, maxIndegree, maxOutdegree, connected, true);
    }

    public static Graph randomGraphRandomForwardEdges(List<Node> nodes, int numLatentConfounders, int numEdges, int maxDegree, int maxIndegree, int maxOutdegree, boolean connected, boolean layoutAsCircle) {
        EdgeListGraph dag;
        if (nodes.size() == 0) {
            throw new IllegalArgumentException("NumNodes most be > 0");
        }
        long size = nodes.size();
        if (numEdges < 0 || (long)numEdges > size * (size - 1L)) {
            throw new IllegalArgumentException("numEdges must be greater than 0 and <= (#nodes)(#nodes - 1) / 2: " + numEdges);
        }
        if (numLatentConfounders < 0 || numLatentConfounders > nodes.size()) {
            throw new IllegalArgumentException("MaxNumLatents must be greater than 0 and less than the number of nodes: " + numLatentConfounders);
        }
        LinkedList allEdges = new LinkedList();
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                ArrayList<Integer> pair = new ArrayList<Integer>(2);
                pair.add(i);
                pair.add(j);
                allEdges.add(pair);
            }
        }
        int numTriesForGraph = 0;
        do {
            dag = new EdgeListGraph(nodes);
            RandomUtil.shuffle(allEdges);
            while (!allEdges.isEmpty() && dag.getNumEdges() < numEdges) {
                List e = (List)allEdges.removeFirst();
                Node n1 = nodes.get((Integer)e.get(0));
                Node n2 = nodes.get((Integer)e.get(1));
                if (dag.getIndegree(n2) >= maxIndegree || dag.getOutdegree(n1) >= maxOutdegree || dag.getIndegree(n1) + dag.getOutdegree(n1) >= maxDegree || dag.getIndegree(n2) + dag.getOutdegree(n2) >= maxDegree) continue;
                dag.addDirectedEdge(n1, n2);
            }
        } while (++numTriesForGraph < 1000 && connected && new Paths(dag).connectedComponents().size() != 1);
        RandomGraph.fixLatents4(numLatentConfounders, dag);
        if (layoutAsCircle) {
            LayoutUtil.circleLayout(dag, 200, 200, 150);
        }
        return dag;
    }

    public static Graph randomScaleFreeGraph(int numNodes, int numLatentConfounders, double alpha, double beta, double delta_in, double delta_out) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.add(new GraphNode("X" + (i + 1)));
        }
        return RandomGraph.randomScaleFreeGraph(nodes, numLatentConfounders, alpha, beta, delta_in, delta_out);
    }

    private static Graph randomScaleFreeGraph(List<Node> _nodes, int numLatentConfounders, double alpha, double beta, double delta_in, double delta_out) {
        if (alpha + beta >= 1.0) {
            throw new IllegalArgumentException("For the Bollobas et al. algorithm,\napha + beta + gamma = 1, so alpha + beta must be < 1.");
        }
        RandomUtil.shuffle(_nodes);
        LinkedList<Node> nodes = new LinkedList<Node>();
        nodes.add(_nodes.get(0));
        EdgeListGraph G = new EdgeListGraph(_nodes);
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha must be > 0.");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta must be > 0.");
        }
        double gamma = 1.0 - alpha - beta;
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("alpha + beta must be < 1.");
        }
        if (delta_in <= 0.0) {
            throw new IllegalArgumentException("delta_in must be > 0.");
        }
        if (delta_out <= 0.0) {
            throw new IllegalArgumentException("delta_out must be > 0.");
        }
        HashMap<Node, Set<Node>> parents = new HashMap<Node, Set<Node>>();
        HashMap<Node, Set<Node>> children = new HashMap<Node, Set<Node>>();
        parents.put(_nodes.get(0), new HashSet());
        children.put(_nodes.get(0), new HashSet());
        while (nodes.size() < _nodes.size()) {
            Node m;
            int w;
            int v;
            double r = RandomUtil.getInstance().nextDouble();
            if (r < alpha) {
                v = nodes.size();
                w = RandomGraph.chooseNode(RandomGraph.indegrees(nodes, parents), delta_in);
                m = _nodes.get(v);
                nodes.addFirst(m);
                parents.put(m, new HashSet());
                children.put(m, new HashSet());
                v = 0;
                ++w;
            } else if (r < alpha + beta) {
                v = RandomGraph.chooseNode(RandomGraph.outdegrees(nodes, children), delta_out);
                w = RandomGraph.chooseNode(RandomGraph.indegrees(nodes, parents), delta_in);
                if (w <= v) {
                    continue;
                }
            } else {
                v = RandomGraph.chooseNode(RandomGraph.outdegrees(nodes, children), delta_out);
                w = nodes.size();
                m = _nodes.get(w);
                nodes.addLast(m);
                parents.put(m, new HashSet());
                children.put(m, new HashSet());
            }
            if (G.isAdjacentTo(nodes.get(v), nodes.get(w))) continue;
            G.addDirectedEdge(nodes.get(v), nodes.get(w));
            ((Set)parents.get(nodes.get(w))).add(nodes.get(v));
            ((Set)children.get(nodes.get(v))).add(nodes.get(w));
        }
        RandomGraph.fixLatents1(numLatentConfounders, G);
        LayoutUtil.circleLayout(G, 200, 200, 150);
        return G;
    }

    private static int chooseNode(int[] distribution, double delta) {
        double cumsum = 0.0;
        double psum = (double)RandomGraph.sum(distribution) + delta * (double)distribution.length;
        double r = RandomUtil.getInstance().nextDouble();
        for (int i = 0; i < distribution.length; ++i) {
            if (!(r < (cumsum += ((double)distribution[i] + delta) / psum))) continue;
            return i;
        }
        throw new IllegalArgumentException("Didn't pick a node.");
    }

    private static int sum(int[] distribution) {
        int sum = 0;
        for (int w : distribution) {
            sum += w;
        }
        return sum;
    }

    private static int[] indegrees(List<Node> nodes, Map<Node, Set<Node>> parents) {
        int[] indegrees = new int[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            indegrees[i] = parents.get(nodes.get(i)).size();
        }
        return indegrees;
    }

    private static int[] outdegrees(List<Node> nodes, Map<Node, Set<Node>> children) {
        int[] outdegrees = new int[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            outdegrees[i] = children.get(nodes.get(i)).size();
        }
        return outdegrees;
    }

    public static void fixLatents1(int numLatentConfounders, Graph graph) {
        List<Node> commonCauses = RandomGraph.getCommonCauses(graph);
        int index = 0;
        while (index++ < numLatentConfounders && commonCauses.size() != 0) {
            int i = RandomUtil.getInstance().nextInt(commonCauses.size());
            Node node = commonCauses.get(i);
            node.setNodeType(NodeType.LATENT);
            commonCauses.remove(i);
        }
    }

    public static void fixLatents4(int numLatentConfounders, Graph graph) {
        if (numLatentConfounders == 0) {
            return;
        }
        List<Node> commonCausesAndEffects = RandomGraph.getCommonCausesAndEffects(graph);
        int index = 0;
        while (index++ < numLatentConfounders && commonCausesAndEffects.size() != 0) {
            int i = RandomUtil.getInstance().nextInt(commonCausesAndEffects.size());
            Node node = commonCausesAndEffects.get(i);
            node.setNodeType(NodeType.LATENT);
            commonCausesAndEffects.remove(i);
        }
        List<Node> nodes = graph.getNodes();
        while (true) {
            int n = --index;
            ++index;
            if (n >= numLatentConfounders) break;
            int r = RandomUtil.getInstance().nextInt(nodes.size());
            if (nodes.get(r).getNodeType() == NodeType.LATENT) {
                --index;
                continue;
            }
            nodes.get(r).setNodeType(NodeType.LATENT);
        }
    }

    private static List<Node> getCommonCausesAndEffects(Graph dag) {
        ArrayList<Node> commonCausesAndEffects = new ArrayList<Node>();
        List<Node> nodes = dag.getNodes();
        for (Node node : nodes) {
            List<Node> children = dag.getChildren(node);
            if (children.size() >= 2) {
                commonCausesAndEffects.add(node);
                continue;
            }
            List<Node> parents = dag.getParents(node);
            if (parents.size() < 2 || children.size() < 1) continue;
            commonCausesAndEffects.add(node);
        }
        return commonCausesAndEffects;
    }

    public static Graph randomCyclicGraph2(int numNodes, int numEdges, int maxDegree) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.add(new GraphNode("X" + (i + 1)));
        }
        EdgeListGraph graph = new EdgeListGraph(nodes);
        block1: while (graph.getEdges().size() < numEdges) {
            Edge edge;
            int i;
            int cycleSize = RandomUtil.getInstance().nextInt(3) + 3;
            ArrayList<Node> cycleNodes = new ArrayList<Node>();
            int count2 = -1;
            for (int i2 = 0; i2 < cycleSize; ++i2) {
                Node node = (Node)nodes.get(RandomUtil.getInstance().nextInt(nodes.size()));
                if (cycleNodes.contains(node)) {
                    --i2;
                    if (++count2 < 10) continue;
                }
                cycleNodes.add(node);
            }
            for (Node cycleNode : cycleNodes) {
                if (graph.getDegree(cycleNode) < maxDegree) continue;
                continue block1;
            }
            for (i = 0; i < cycleNodes.size() - 1; ++i) {
                edge = Edges.directedEdge((Node)cycleNodes.get(i + 1), (Node)cycleNodes.get(i));
                if (graph.containsEdge(edge)) continue block1;
            }
            edge = Edges.directedEdge((Node)cycleNodes.get(0), (Node)cycleNodes.get(cycleNodes.size() - 1));
            if (graph.containsEdge(edge)) continue;
            for (i = 0; i < cycleNodes.size() - 1; ++i) {
                edge = Edges.directedEdge((Node)cycleNodes.get(i), (Node)cycleNodes.get(i + 1));
                if (graph.containsEdge(edge)) continue;
                graph.addEdge(edge);
                if (graph.getNumEdges() == numEdges) break block1;
            }
            edge = Edges.directedEdge((Node)cycleNodes.get(cycleNodes.size() - 1), (Node)cycleNodes.get(0));
            if (graph.containsEdge(edge)) continue;
            graph.addEdge(edge);
            if (graph.getNumEdges() != numEdges) continue;
            break;
        }
        LayoutUtil.circleLayout(graph, 200, 200, 150);
        return graph;
    }

    public static Graph randomCyclicGraph3(int numNodes, int numEdges, int maxDegree, double probCycle, double probTwoCycle) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.add(new GraphNode("X" + (i + 1)));
        }
        EdgeListGraph graph = new EdgeListGraph(nodes);
        block1: while (graph.getEdges().size() < numEdges) {
            Edge edge;
            int i;
            int cycleSize = RandomUtil.getInstance().nextInt(3) + 3;
            ArrayList<Node> cycleNodes = new ArrayList<Node>();
            int count2 = -1;
            for (int i2 = 0; i2 < cycleSize; ++i2) {
                Node node = (Node)nodes.get(RandomUtil.getInstance().nextInt(nodes.size()));
                if (cycleNodes.contains(node)) {
                    --i2;
                    if (++count2 < 10) continue;
                }
                cycleNodes.add(node);
            }
            for (Node cycleNode : cycleNodes) {
                if (graph.getDegree(cycleNode) < maxDegree) continue;
                continue block1;
            }
            for (i = 0; i < cycleNodes.size() - 1; ++i) {
                edge = Edges.directedEdge((Node)cycleNodes.get(i + 1), (Node)cycleNodes.get(i));
                if (graph.containsEdge(edge)) continue block1;
            }
            edge = Edges.directedEdge((Node)cycleNodes.get(0), (Node)cycleNodes.get(cycleNodes.size() - 1));
            if (graph.containsEdge(edge)) continue;
            for (i = 0; i < cycleNodes.size() - 1; ++i) {
                edge = Edges.directedEdge((Node)cycleNodes.get(i), (Node)cycleNodes.get(i + 1));
                if (graph.containsEdge(edge)) continue;
                graph.addEdge(edge);
                if (graph.getNumEdges() == numEdges) break block1;
            }
            edge = RandomUtil.getInstance().nextDouble() < probCycle ? Edges.directedEdge((Node)cycleNodes.get(cycleNodes.size() - 1), (Node)cycleNodes.get(0)) : Edges.directedEdge((Node)cycleNodes.get(0), (Node)cycleNodes.get(cycleNodes.size() - 1));
            if (graph.containsEdge(edge)) continue;
            graph.addEdge(edge);
            if (graph.getNumEdges() != numEdges) continue;
            break;
        }
        Set<Edge> edges = graph.getEdges();
        for (Edge edge : edges) {
            Node a = edge.getNode1();
            Node b = edge.getNode2();
            if (!(RandomUtil.getInstance().nextDouble() < probTwoCycle)) continue;
            graph.removeEdges(a, b);
            graph.addEdge(Edges.directedEdge(a, b));
            graph.addEdge(Edges.directedEdge(b, a));
        }
        LayoutUtil.circleLayout(graph, 200, 200, 150);
        return graph;
    }

    public static void addTwoCycles(Graph graph, int numTwoCycles) {
        ArrayList<Edge> edges = new ArrayList<Edge>(graph.getEdges());
        RandomUtil.shuffle(edges);
        for (int i = 0; i < FastMath.min(numTwoCycles, edges.size()); ++i) {
            Edge edge = (Edge)edges.get(i);
            Edge reversed = Edges.directedEdge(edge.getNode2(), edge.getNode1());
            if (graph.containsEdge(reversed)) {
                --i;
                continue;
            }
            graph.addEdge(reversed);
        }
    }

    public static final class UniformGraphGenerator {
        public static final int ANY_DAG = 0;
        public static final int CONNECTED_DAG = 1;
        private final int structure;
        private int numNodes;
        private int maxInDegree;
        private int maxOutDegree;
        private int maxDegree;
        private int maxEdges;
        private int numIterations;
        private int[][] parentMatrix;
        private int[][] childMatrix;
        private int randomParent;
        private int randomChild = 1;
        private final RandomUtil randomUtil = RandomUtil.getInstance();

        public UniformGraphGenerator(int structure) {
            switch (structure) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized structure.");
                }
            }
            this.structure = structure;
            this.numNodes = 4;
            this.maxInDegree = 3;
            this.maxOutDegree = 3;
            this.maxDegree = 6;
            this.maxEdges = this.numNodes - 1;
            this.numIterations = 6 * this.numNodes * this.numNodes;
        }

        private int getNumNodes() {
            return this.numNodes;
        }

        public void setNumNodes(int numNodes) {
            if (numNodes < 1) {
                throw new IllegalArgumentException("Number of nodes must be >= 1.");
            }
            this.numNodes = numNodes;
            this.maxDegree = numNodes - 1;
            this.maxInDegree = numNodes - 1;
            this.maxOutDegree = numNodes - 1;
            this.maxEdges = numNodes - 1;
            this.numIterations = 6 * numNodes * numNodes;
            if (this.numIterations > 300000000) {
                this.numIterations = 300000000;
            }
            this.parentMatrix = null;
            this.childMatrix = null;
        }

        private int getMaxDegree() {
            return this.maxDegree;
        }

        public void setMaxDegree(int maxDegree) {
            if (maxDegree < 3) {
                throw new IllegalArgumentException("Degree of nodes must be >= 3.");
            }
            this.maxDegree = maxDegree;
        }

        private int getMaxInDegree() {
            return this.maxInDegree;
        }

        public void setMaxInDegree(int maxInDegree) {
            if (0 == this.getStructure() && this.getMaxInDegree() < 0) {
                throw new IllegalArgumentException("Max indegree must be >= 1 when generating DAGs without the assumption of connectedness.");
            }
            if (1 == this.getStructure() && this.getMaxInDegree() < 2) {
                throw new IllegalArgumentException("Max indegree must be >= 2 when generating DAGs under the assumption of connectedness.");
            }
            this.maxInDegree = maxInDegree;
        }

        private int getMaxOutDegree() {
            return this.maxOutDegree;
        }

        public void setMaxOutDegree(int maxOutDegree) {
            if (0 == this.getStructure() && this.getMaxInDegree() < 1) {
                throw new IllegalArgumentException("Max indegree must be >= 1 when generating DAGs without the assumption of connectedness.");
            }
            if (1 == this.getStructure() && this.getMaxInDegree() < 2) {
                throw new IllegalArgumentException("Max indegree must be >= 2 when generating DAGs under the assumption of connectedness.");
            }
            this.maxOutDegree = maxOutDegree;
        }

        private int getMaxEdges() {
            return this.maxEdges;
        }

        private int getMaxPossibleEdges() {
            return this.getNumNodes() * this.getMaxDegree() / 2;
        }

        public void setMaxEdges(int maxEdges) {
            if (maxEdges < 0) {
                throw new IllegalArgumentException("Max edges must be >= 0.");
            }
            if (maxEdges > this.getMaxPossibleEdges()) {
                maxEdges = this.getMaxPossibleEdges();
            }
            this.maxEdges = maxEdges;
        }

        private int getNumIterations() {
            return this.numIterations;
        }

        public void setNumIterations(int numIterations) {
            this.numIterations = numIterations;
        }

        private int getStructure() {
            return this.structure;
        }

        public void generate() {
            if (0 == this.getStructure()) {
                this.generateArbitraryDag();
            } else if (1 == this.getStructure()) {
                this.generateConnectedDag();
            } else {
                throw new IllegalStateException("Unknown structure type.");
            }
        }

        public Graph getDag() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(0);
            int numDigits = (int)FastMath.ceil(FastMath.log(this.numNodes) / FastMath.log(10.0));
            nf.setMinimumIntegerDigits(numDigits);
            nf.setGroupingUsed(false);
            for (int i = 1; i <= this.getNumNodes(); ++i) {
                GraphNode node = new GraphNode("X" + nf.format(i));
                nodes.add(node);
            }
            return this.getDag(nodes);
        }

        public Graph getDag(List<Node> nodes) {
            if (nodes.size() != this.getNumNodes()) {
                throw new IllegalArgumentException("Only " + nodes.size() + " nodes were provided, but the simulated graph has " + this.getNumNodes() + ".");
            }
            EdgeListGraph dag = new EdgeListGraph(nodes);
            for (int i = 0; i < this.getNumNodes(); ++i) {
                Node child = nodes.get(i);
                if (this.parentMatrix[i][0] == 1) continue;
                for (int j = 1; j < this.parentMatrix[i][0]; ++j) {
                    Node parent = nodes.get(this.parentMatrix[i][j]);
                    dag.addDirectedEdge(parent, child);
                }
            }
            LayoutUtil.circleLayout(dag, 200, 200, 150);
            return dag;
        }

        public void printEdges() {
            System.out.println("Edges:");
            for (int i = 0; i < this.getNumNodes(); ++i) {
                for (int j = 1; j < this.childMatrix[i][0]; ++j) {
                    System.out.println("\t" + i + " --> " + this.childMatrix[i][j]);
                }
            }
        }

        public String toString() {
            return "\nStructural information for generated graph:\n\tNumber of nodes:" + this.getNumNodes() + "\n\tMax degree for each node:" + this.getMaxDegree() + "\n\tMaximum number of incoming edges for each node:" + this.getMaxInDegree() + "\n\tMaximum number of outgoing edges for each node:" + this.getMaxOutDegree() + "\n\tMaximum total number of edges:" + this.getMaxEdges() + " of " + this.getNumNodes() * this.getMaxDegree() / 2 + " possibles\n\tNumber of transitions between samples:" + this.getNumIterations();
        }

        private void generateArbitraryDag() {
            this.initializeGraphAsEmpty();
            if (this.getNumNodes() <= 1) {
                return;
            }
            int numEdges = 0;
            for (int i = 0; i < this.getNumIterations(); ++i) {
                this.sampleEdge();
                if (this.edgeExists()) {
                    this.removeEdge();
                    --numEdges;
                    continue;
                }
                if (numEdges >= this.getMaxEdges() || !this.maxDegreeNotExceeded() || !this.maxIndegreeNotExceeded() || !this.maxOutdegreeNotExceeded() || !this.isAcyclic()) continue;
                this.addEdge();
                ++numEdges;
            }
        }

        private void generateConnectedDag() {
            this.initializeGraphAsChain();
            if (this.getNumNodes() <= 1) {
                return;
            }
            int totalEdges = this.getNumNodes() - 1;
            while (this.isDisconnecting()) {
                this.sampleEdge();
                if (this.edgeExists() || !this.isAcyclic() || !this.maxDegreeNotExceeded()) continue;
                this.addEdge();
                ++totalEdges;
            }
            for (int i = 0; i < this.getNumIterations(); ++i) {
                this.sampleEdge();
                if (this.edgeExists()) {
                    if (this.isDisconnecting()) {
                        this.removeEdge();
                        this.reverseDirection();
                        if (!(totalEdges < this.getMaxEdges() && this.maxDegreeNotExceeded() && this.maxIndegreeNotExceeded() && this.maxOutdegreeNotExceeded() && this.isAcyclic())) {
                            this.reverseDirection();
                        }
                        this.addEdge();
                        continue;
                    }
                    this.removeEdge();
                    --totalEdges;
                    continue;
                }
                if (totalEdges >= this.getMaxEdges() || !this.maxDegreeNotExceeded() || !this.maxIndegreeNotExceeded() || !this.maxOutdegreeNotExceeded() || !this.isAcyclic()) continue;
                this.addEdge();
                ++totalEdges;
            }
        }

        private void reverseDirection() {
            int temp = this.randomChild;
            this.randomChild = this.randomParent;
            this.randomParent = temp;
        }

        private boolean edgeExists() {
            for (int i = 1; i < this.parentMatrix[this.randomChild][0]; ++i) {
                if (this.parentMatrix[this.randomChild][i] != this.randomParent) continue;
                return true;
            }
            return false;
        }

        private boolean maxDegreeNotExceeded() {
            int parentDegree = this.parentMatrix[this.randomParent][0] + this.childMatrix[this.randomParent][0] - 1;
            int childDegree = this.parentMatrix[this.randomChild][0] + this.childMatrix[this.randomChild][0] - 1;
            return parentDegree <= this.getMaxDegree() && childDegree <= this.getMaxDegree();
        }

        private boolean maxIndegreeNotExceeded() {
            return this.parentMatrix[this.randomChild][0] <= this.getMaxInDegree();
        }

        private boolean maxOutdegreeNotExceeded() {
            return this.childMatrix[this.randomParent][0] <= this.getMaxOutDegree();
        }

        private boolean isDisconnecting() {
            boolean[] visited = new boolean[this.getNumNodes()];
            int[] list = new int[this.getNumNodes()];
            int lastIndex = 1;
            list[0] = 0;
            visited[0] = true;
            for (int index = 0; index < lastIndex; ++index) {
                int i;
                int currentNode = list[index];
                for (i = 1; i < this.parentMatrix[currentNode][0]; ++i) {
                    if (currentNode == this.randomChild && this.parentMatrix[currentNode][i] == this.randomParent || visited[this.parentMatrix[currentNode][i]]) continue;
                    list[lastIndex] = this.parentMatrix[currentNode][i];
                    visited[this.parentMatrix[currentNode][i]] = true;
                    ++lastIndex;
                }
                for (i = 1; i < this.childMatrix[currentNode][0]; ++i) {
                    if (currentNode == this.randomParent && this.childMatrix[currentNode][i] == this.randomChild || visited[this.childMatrix[currentNode][i]]) continue;
                    list[lastIndex] = this.childMatrix[currentNode][i];
                    visited[this.childMatrix[currentNode][i]] = true;
                    ++lastIndex;
                }
            }
            for (boolean aVisited : visited) {
                if (aVisited) continue;
                return true;
            }
            return false;
        }

        private boolean isAcyclic() {
            boolean[] visited = new boolean[this.getNumNodes()];
            boolean noCycle = true;
            int[] list = new int[this.getNumNodes() + 1];
            int lastIndex = 1;
            list[0] = this.randomParent;
            visited[this.randomParent] = true;
            for (int index = 0; index < lastIndex && noCycle; ++index) {
                int currentNode = list[index];
                for (int i = 1; i < this.parentMatrix[currentNode][0] && noCycle; ++i) {
                    if (visited[this.parentMatrix[currentNode][i]]) continue;
                    if (this.parentMatrix[currentNode][i] != this.randomChild) {
                        list[lastIndex] = this.parentMatrix[currentNode][i];
                        ++lastIndex;
                    } else {
                        noCycle = false;
                    }
                    visited[this.parentMatrix[currentNode][i]] = true;
                }
            }
            return noCycle;
        }

        private void initializeGraphAsEmpty() {
            int i;
            int max = FastMath.max(this.getMaxInDegree() + this.getMaxOutDegree(), this.getMaxDegree());
            this.parentMatrix = new int[this.getNumNodes()][++max];
            this.childMatrix = new int[this.getNumNodes()][max];
            for (i = 0; i < this.getNumNodes(); ++i) {
                this.parentMatrix[i][0] = 1;
                this.childMatrix[i][0] = 1;
            }
            for (i = 0; i < this.getNumNodes(); ++i) {
                for (int j = 1; j < max; ++j) {
                    this.parentMatrix[i][j] = -5;
                    this.childMatrix[i][j] = -5;
                }
            }
        }

        private void initializeGraphAsChain() {
            int i;
            this.parentMatrix = new int[this.getNumNodes()][this.getMaxDegree() + 2];
            this.childMatrix = new int[this.getNumNodes()][this.getMaxDegree() + 2];
            for (i = 0; i < this.getNumNodes(); ++i) {
                for (int j = 1; j < this.getMaxDegree() + 1; ++j) {
                    this.parentMatrix[i][j] = -5;
                    this.childMatrix[i][j] = -5;
                }
            }
            this.parentMatrix[0][0] = 1;
            this.childMatrix[0][0] = 2;
            this.childMatrix[0][1] = 1;
            this.parentMatrix[this.getNumNodes() - 1][0] = 2;
            this.parentMatrix[this.getNumNodes() - 1][1] = this.getNumNodes() - 2;
            this.childMatrix[this.getNumNodes() - 1][0] = 1;
            for (i = 1; i < this.getNumNodes() - 1; ++i) {
                this.parentMatrix[i][0] = 2;
                this.parentMatrix[i][1] = i - 1;
                this.childMatrix[i][0] = 2;
                this.childMatrix[i][1] = i + 1;
            }
        }

        private void sampleEdge() {
            int rand = this.randomUtil.nextInt(this.getNumNodes() * (this.getNumNodes() - 1));
            this.randomParent = rand / (this.getNumNodes() - 1);
            int rest = rand - this.randomParent * (this.getNumNodes() - 1);
            this.randomChild = rest >= this.randomParent ? rest + 1 : rest;
        }

        private void addEdge() {
            this.childMatrix[this.randomParent][this.childMatrix[this.randomParent][0]] = this.randomChild;
            int[] nArray = this.childMatrix[this.randomParent];
            nArray[0] = nArray[0] + 1;
            this.parentMatrix[this.randomChild][this.parentMatrix[this.randomChild][0]] = this.randomParent;
            int[] nArray2 = this.parentMatrix[this.randomChild];
            nArray2[0] = nArray2[0] + 1;
        }

        private void removeEdge() {
            boolean go = true;
            if (this.parentMatrix[this.randomChild][0] != 1 && this.childMatrix[this.randomParent][0] != 1) {
                int proxNode;
                int atualNode;
                int i;
                int lastNode = this.parentMatrix[this.randomChild][this.parentMatrix[this.randomChild][0] - 1];
                for (i = this.parentMatrix[this.randomChild][0] - 1; i > 0 && go; --i) {
                    atualNode = this.parentMatrix[this.randomChild][i];
                    if (atualNode != this.randomParent) {
                        proxNode = atualNode;
                        this.parentMatrix[this.randomChild][i] = lastNode;
                        lastNode = proxNode;
                        continue;
                    }
                    this.parentMatrix[this.randomChild][i] = lastNode;
                    go = false;
                }
                if (this.childMatrix[this.randomParent][0] != 1 && this.childMatrix[this.randomParent][0] != 1) {
                    lastNode = this.childMatrix[this.randomParent][this.childMatrix[this.randomParent][0] - 1];
                    go = true;
                    for (i = this.childMatrix[this.randomParent][0] - 1; i > 0 && go; --i) {
                        atualNode = this.childMatrix[this.randomParent][i];
                        if (atualNode != this.randomChild) {
                            proxNode = atualNode;
                            this.childMatrix[this.randomParent][i] = lastNode;
                            lastNode = proxNode;
                            continue;
                        }
                        this.childMatrix[this.randomParent][i] = lastNode;
                        go = false;
                    }
                }
                this.childMatrix[this.randomParent][this.childMatrix[this.randomParent][0] - 1] = -4;
                int[] nArray = this.childMatrix[this.randomParent];
                nArray[0] = nArray[0] - 1;
                this.parentMatrix[this.randomChild][this.parentMatrix[this.randomChild][0] - 1] = -4;
                int[] nArray2 = this.parentMatrix[this.randomChild];
                nArray2[0] = nArray2[0] - 1;
            }
        }
    }
}

