/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.graph.Underlines;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SemGraph
implements Graph {
    static final long serialVersionUID = 23L;
    private final Graph graph;
    private Map<Node, Node> errorNodes = new HashMap<Node, Node>();
    private boolean showErrorTerms;
    private boolean pag;
    private boolean cpdag;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Paths paths;

    public SemGraph() {
        this.graph = new EdgeListGraph();
        this.paths = new Paths(this);
    }

    public SemGraph(Graph graph) {
        if (graph instanceof SemGraph) {
            this.graph = graph.isTimeLagModel() ? new TimeLagGraph((TimeLagGraph)((SemGraph)graph).graph) : new EdgeListGraph(graph);
            this.errorNodes = new HashMap<Node, Node>(((SemGraph)graph).errorNodes);
            for (Node node : graph.getNodes()) {
                if (this.errorNodes.containsKey(node)) continue;
                this.addErrorNode(node);
            }
            this.showErrorTerms = ((SemGraph)graph).showErrorTerms;
            this.setShowErrorTerms(this.showErrorTerms);
        } else if (graph instanceof TimeLagGraph) {
            this.graph = new TimeLagGraph((TimeLagGraph)graph);
        } else {
            this.graph = new EdgeListGraph(graph.getNodes());
            for (Node node : this.graph.getNodes()) {
                this.addErrorNode(node);
            }
            this.setShowErrorTerms(true);
            for (Edge edge : graph.getEdges()) {
                if (Edges.isDirectedEdge(edge)) {
                    this.addEdge(edge);
                    continue;
                }
                if (Edges.isBidirectedEdge(edge)) {
                    Node node1 = edge.getNode1();
                    Node node2 = edge.getNode2();
                    this.addBidirectedEdge(this.getExogenous(node1), this.getExogenous(node2));
                    continue;
                }
                throw new IllegalArgumentException("A SEM graph may contain only directed and bidirected edges: " + edge);
            }
            this.setShowErrorTerms(false);
        }
        this.paths = new Paths(this);
    }

    public SemGraph(SemGraph graph) {
        this.graph = graph.isTimeLagModel() ? new TimeLagGraph((TimeLagGraph)graph.graph) : new EdgeListGraph(graph.getGraph());
        this.errorNodes = new HashMap<Node, Node>(graph.errorNodes);
        this.pag = graph.pag;
        this.cpdag = graph.cpdag;
        if (graph.showErrorTerms) {
            for (Node node : this.graph.getNodes()) {
                if (this.errorNodes().containsKey(node)) continue;
                this.addErrorNode(node);
            }
        }
        this.showErrorTerms = graph.showErrorTerms;
        this.setShowErrorTerms(this.showErrorTerms);
        this.paths = new Paths(this);
    }

    public static SemGraph serializableInstance() {
        return new SemGraph();
    }

    public Node getErrorNode(Node node) {
        return this.errorNodes.get(node);
    }

    @Override
    public boolean isParameterizable(Node node) {
        return this.getGraph().isParameterizable(node);
    }

    public List<Node> getFullTierOrdering() {
        if (this.paths.existsDirectedCycle()) {
            throw new IllegalStateException("The tier ordering method assumes acyclicity.");
        }
        LinkedList<Node> found = new LinkedList<Node>();
        HashSet<Node> notFound = new HashSet<Node>(this.getNodes());
        while (!notFound.isEmpty()) {
            Iterator it = notFound.iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                List<Node> parents = this.getParents(node);
                if (!new HashSet<Node>(found).containsAll(parents)) continue;
                found.add(node);
                it.remove();
            }
        }
        return found;
    }

    public static boolean isErrorEdge(Edge edge) {
        return edge.getNode1().getNodeType() == NodeType.ERROR || edge.getNode2().getNodeType() == NodeType.ERROR;
    }

    public Node getVarNode(Node node) {
        boolean isError;
        boolean bl = isError = node.getNodeType() == NodeType.ERROR;
        if (!this.containsNode(node)) {
            throw new NullPointerException("Node is not in graph: " + node);
        }
        if (isError) {
            return GraphUtils.getAssociatedNode(node, this);
        }
        return node;
    }

    public Node getExogenous(Node node) {
        return this.isExogenous(node) ? node : this.errorNodes.get(node);
    }

    @Override
    public void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transferAttributes(Graph graph) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Underlines underlines() {
        return this.graph.underlines();
    }

    @Override
    public Paths paths() {
        return this.paths;
    }

    @Override
    public List<String> getNodeNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        return this.getGraph().getAdjacentNodes(node);
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint endpoint) {
        return this.getGraph().getNodesInTo(node, endpoint);
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint n) {
        return this.getGraph().getNodesOutTo(node, n);
    }

    @Override
    public List<Node> getNodes() {
        return this.getGraph().getNodes();
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        List<Edge> edges = this.getEdges(node1, node2);
        if (edges.size() > 1) {
            throw new IllegalStateException("There is more than one edge between " + node1 + " and " + node2);
        }
        return this.removeEdges(edges);
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        return this.removeEdges(this.getEdges(node1, node2));
    }

    @Override
    public boolean isAdjacentTo(Node nodeX, Node nodeY) {
        return this.getGraph().isAdjacentTo(nodeX, nodeY);
    }

    @Override
    public boolean setEndpoint(Node node1, Node node2, Endpoint endpoint) {
        return this.getGraph().setEndpoint(node1, node2, endpoint);
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        return this.getGraph().getEndpoint(node1, node2);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SemGraph && this.getGraph().equals(o);
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        return this.getGraph().subgraph(nodes);
    }

    @Override
    public boolean addDirectedEdge(Node nodeA, Node nodeB) {
        return this.addEdge(Edges.directedEdge(nodeA, nodeB));
    }

    @Override
    public boolean addUndirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addNondirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addBidirectedEdge(Node nodeA, Node nodeB) {
        return this.addEdge(Edges.bidirectedEdge(nodeA, nodeB));
    }

    @Override
    public boolean addEdge(Edge edge) {
        Node node1 = edge.getNode1();
        Node node2 = edge.getNode2();
        if (!this.getGraph().containsNode(node1) || !this.getGraph().containsNode(node2)) {
            if (node1.getNodeType() == NodeType.ERROR || node2.getNodeType() == NodeType.ERROR) {
                return false;
            }
            throw new IllegalArgumentException("Nodes for edge must be in graph already: " + edge);
        }
        if (Edges.isDirectedEdge(edge)) {
            if (this.getGraph().containsEdge(edge)) {
                return false;
            }
            Node head = Edges.getDirectedEdgeHead(edge);
            if (head.getNodeType() == NodeType.ERROR) {
                return false;
            }
            this.getGraph().addEdge(edge);
            this.adjustErrorForNode(head);
            return true;
        }
        if (Edges.isBidirectedEdge(edge)) {
            if (this.getGraph().containsEdge(edge)) {
                return false;
            }
            this.getGraph().addEdge(edge);
            return true;
        }
        throw new IllegalArgumentException("Only directed and bidirected edges allowed.");
    }

    @Override
    public boolean addNode(Node node) {
        if (node.getNodeType() == NodeType.ERROR) {
            throw new IllegalArgumentException("Error nodes cannot be added directly to the graph: " + node);
        }
        return this.getGraph().addNode(node);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getGraph().addPropertyChangeListener(l);
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.getGraph().containsEdge(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.getGraph().containsNode(node);
    }

    @Override
    public Set<Edge> getEdges() {
        return this.getGraph().getEdges();
    }

    @Override
    public List<Edge> getEdges(Node node) {
        return this.getGraph().getEdges(node);
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        return this.getGraph().getEdges(node1, node2);
    }

    @Override
    public Node getNode(String name) {
        return this.getGraph().getNode(name);
    }

    @Override
    public int getNumEdges() {
        return this.getGraph().getNumEdges();
    }

    @Override
    public int getNumNodes() {
        return this.getGraph().getNumNodes();
    }

    @Override
    public int getNumEdges(Node node) {
        return this.getGraph().getNumEdges(node);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        if (!this.getGraph().containsEdge(edge)) {
            throw new IllegalArgumentException("Can only remove edges that are already in the graph: " + edge);
        }
        if (Edges.isDirectedEdge(edge)) {
            Node head = Edges.getDirectedEdgeHead(edge);
            Node tail = Edges.getDirectedEdgeTail(edge);
            if (tail.getNodeType() != NodeType.ERROR) {
                this.getGraph().removeEdge(edge);
                this.adjustErrorForNode(head);
                return true;
            }
            return false;
        }
        if (Edges.isBidirectedEdge(edge)) {
            return this.getGraph().removeEdge(edge);
        }
        throw new IllegalArgumentException("Only directed and bidirected edges allowed.");
    }

    @Override
    public boolean removeEdges(Collection<Edge> edges) {
        boolean change = false;
        for (Edge edge : edges) {
            boolean _change = this.removeEdge(edge);
            change = change || _change;
        }
        return change;
    }

    @Override
    public boolean removeNode(Node node) {
        if (!this.getGraph().containsNode(node)) {
            throw new IllegalArgumentException("Graph must contain node: " + node);
        }
        if (node.getNodeType() == NodeType.ERROR) {
            throw new IllegalArgumentException("Error nodes cannot be removed directly from the graph: " + node);
        }
        Node errorNode = this.getErrorNode(node);
        if (errorNode != null) {
            this.getGraph().removeNode(errorNode);
            this.errorNodes.remove(errorNode);
            this.errorNodes.remove(node);
        }
        List<Node> children = this.getGraph().getChildren(node);
        this.getGraph().removeNode(node);
        for (Node child : children) {
            this.adjustErrorForNode(child);
        }
        return true;
    }

    @Override
    public void clear() {
        this.getGraph().clear();
    }

    @Override
    public boolean removeNodes(List<Node> nodes) {
        return this.getGraph().removeNodes(nodes);
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefNoncollider(node1, node2, node3);
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefCollider(node1, node2, node3);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return this.getGraph().getChildren(node);
    }

    @Override
    public int getDegree() {
        return this.getGraph().getDegree();
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        return this.getGraph().getEdge(node1, node2);
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        return this.graph.getDirectedEdge(node1, node2);
    }

    @Override
    public List<Node> getParents(Node node) {
        return this.getGraph().getParents(node);
    }

    @Override
    public int getIndegree(Node node) {
        return this.getGraph().getIndegree(node);
    }

    @Override
    public int getDegree(Node node) {
        return this.getGraph().getDegree(node);
    }

    @Override
    public int getOutdegree(Node node) {
        return this.getGraph().getOutdegree(node);
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        return this.getGraph().isChildOf(node1, node2);
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        return this.getGraph().isParentOf(node1, node2);
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.getGraph().isExogenous(node) || this.isShowErrorTerms() && this.getErrorNode(node) == null;
    }

    @Override
    public String toString() {
        return this.getGraph().toString();
    }

    public boolean isShowErrorTerms() {
        return this.showErrorTerms;
    }

    public void setShowErrorTerms(boolean showErrorTerms) {
        this.showErrorTerms = showErrorTerms;
        List<Node> nodes = this.getNodes();
        for (Node node : nodes) {
            if (!this.isParameterizable(node) || node.getNodeType() == NodeType.ERROR) continue;
            this.adjustErrorForNode(node);
        }
    }

    @Override
    public boolean isTimeLagModel() {
        return this.graph instanceof TimeLagGraph;
    }

    @Override
    public TimeLagGraph getTimeLagGraph() {
        if (!this.isTimeLagModel()) {
            throw new IllegalArgumentException("Not a time lag model.");
        }
        return new TimeLagGraph((TimeLagGraph)this.graph);
    }

    @Override
    public List<Node> getSepset(Node n1, Node n2) {
        return this.graph.getSepset(n1, n2);
    }

    @Override
    public void setNodes(List<Node> nodes) {
        this.graph.setNodes(nodes);
    }

    private void addErrorNode(Node node) {
        if (this.errorNodes.get(node) != null) {
            throw new IllegalArgumentException("Node already in map.");
        }
        List<Node> nodes = this.getGraph().getNodes();
        Node error = this.errorNodes().get(node);
        if (error == null) {
            error = new GraphNode("E_" + node.getName());
            error.setCenter(node.getCenterX() + 50, node.getCenterY() + 50);
            error.setNodeType(NodeType.ERROR);
            this.errorNodes.put(node, error);
        }
        for (Node possibleError : nodes) {
            if (!error.getName().equals(possibleError.getName())) continue;
            this.moveAttachedBidirectedEdges(possibleError, node);
            if (this.getGraph().containsNode(possibleError)) {
                this.getGraph().removeNode(possibleError);
            }
            this.errorNodes.remove(node);
            this.errorNodes.remove(possibleError);
        }
        this.getGraph().addNode(error);
        this.errorNodes.put(node, error);
        this.errorNodes.put(error, error);
        this.addDirectedEdge(error, node);
    }

    private Map<Node, Node> errorNodes() {
        if (this.errorNodes == null) {
            this.errorNodes = new HashMap<Node, Node>();
        }
        return this.errorNodes;
    }

    private void moveAttachedBidirectedEdges(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            throw new IllegalArgumentException("Node must not be null.");
        }
        Graph graph = this.getGraph();
        List<Edge> edges = graph.getEdges(node1);
        if (edges == null) {
            System.out.println();
            edges = new ArrayList<Edge>();
        }
        LinkedList<Edge> attachedEdges = new LinkedList<Edge>(edges);
        for (Edge edge : attachedEdges) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            graph.removeEdge(edge);
            Node distal = edge.getDistalNode(node1);
            graph.addBidirectedEdge(node2, distal);
        }
    }

    private void adjustErrorForNode(Node node) {
        Node errorNode = this.getErrorNode(node);
        if (!this.showErrorTerms) {
            if (errorNode != null && this.graph.containsNode(errorNode)) {
                this.moveAttachedBidirectedEdges(errorNode, node);
                this.getGraph().removeNode(errorNode);
                this.errorNodes.remove(node);
                this.errorNodes.remove(errorNode);
            }
        } else {
            if (errorNode == null) {
                this.addErrorNode(node);
            }
            errorNode = this.getErrorNode(node);
            this.moveAttachedBidirectedEdges(node, errorNode);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getGraph() == null) {
            throw new NullPointerException();
        }
    }

    private Graph getGraph() {
        return this.graph;
    }

    public void resetErrorPositions() {
        for (Node node : this.getNodes()) {
            Node error = this.errorNodes().get(node);
            if (error == null) continue;
            error.setCenter(node.getCenterX() + 50, node.getCenterY() + 50);
        }
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }
}

