/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.graph.Underlines;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimeLagGraph
implements Graph {
    static final long serialVersionUID = 23L;
    private transient PropertyChangeSupport pcs;
    private EdgeListGraph graph = new EdgeListGraph();
    private int maxLag = 1;
    private int numInitialLags = 1;
    private List<Node> lag0Nodes = new ArrayList<Node>();
    private boolean pag;
    private boolean cpdag;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Paths paths;

    public TimeLagGraph() {
    }

    public TimeLagGraph(TimeLagGraph graph) {
        this.graph = new EdgeListGraph(graph.getGraph());
        this.maxLag = graph.getMaxLag();
        this.numInitialLags = graph.getNumInitialLags();
        this.lag0Nodes = graph.getLag0Nodes();
        this.pag = graph.pag;
        this.cpdag = graph.cpdag;
        this.paths = new Paths(this.graph);
        this.graph.addPropertyChangeListener(evt -> this.getPcs().firePropertyChange(evt));
    }

    public static TimeLagGraph serializableInstance() {
        return new TimeLagGraph();
    }

    @Override
    public boolean addNode(Node node) {
        NodeId id = this.getNodeId(node);
        if (id.getLag() != 0) {
            node = node.like(id.getName());
        }
        boolean added = this.getGraph().addNode(node);
        if (!this.lag0Nodes.contains(node) && !node.getName().startsWith("E_")) {
            this.lag0Nodes.add(node);
        }
        if (node.getNodeType() == NodeType.ERROR) {
            for (int i = 1; i <= this.getMaxLag(); ++i) {
                Node node1 = node.like(id.getName() + ":" + i);
                if (i >= this.getNumInitialLags()) continue;
                this.getGraph().addNode(node1);
            }
        } else {
            for (int i = 1; i <= this.getMaxLag(); ++i) {
                String name = id.getName() + ":" + i;
                Node node1 = node.like(name);
                if (this.getGraph().getNode(name) != null) continue;
                this.getGraph().addNode(node1);
            }
        }
        this.getPcs().firePropertyChange("editingFinished", null, null);
        return added;
    }

    @Override
    public boolean removeNode(Node node) {
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("That is not a node in this graph: " + node);
        }
        NodeId id = this.getNodeId(node);
        for (int lag = 0; lag < this.maxLag; ++lag) {
            Node _node = this.getNode(id.getName(), lag);
            if (_node != null) {
                this.getGraph().removeNode(_node);
            }
            if (_node == null || lag != 0) continue;
            this.lag0Nodes.remove(_node);
        }
        this.getPcs().firePropertyChange("editingFinished", null, null);
        return this.getGraph().containsNode(node) && this.getGraph().removeNode(node);
    }

    @Override
    public boolean addEdge(Edge edge) {
        if (!Edges.isDirectedEdge(edge)) {
            throw new IllegalArgumentException("Only directed edges supported: " + edge);
        }
        if (!this.lag0Nodes.contains(edge.getNode2())) {
            throw new IllegalArgumentException("Edges into the current time lag only: " + edge);
        }
        Node node1 = Edges.getDirectedEdgeTail(edge);
        Node node2 = Edges.getDirectedEdgeHead(edge);
        NodeId id1 = this.getNodeId(node1);
        NodeId id2 = this.getNodeId(node2);
        int lag = id1.getLag() - id2.getLag();
        if (lag < 0) {
            throw new IllegalArgumentException("Backward edges not permitted: " + edge);
        }
        for (int _lag = this.getNodeId(node2).getLag() % this.getNumInitialLags(); _lag <= this.getMaxLag() - lag; _lag += this.getNumInitialLags()) {
            Node from = this.getNode(id1.getName(), _lag + lag);
            Node to = this.getNode(id2.getName(), _lag);
            if (from == null || to == null) continue;
            Edge _edge = Edges.directedEdge(from, to);
            if (this.getGraph().containsEdge(_edge)) continue;
            this.getGraph().addDirectedEdge(from, to);
        }
        return true;
    }

    @Override
    public boolean removeEdge(Edge edge) {
        if (!Edges.isDirectedEdge(edge)) {
            throw new IllegalArgumentException("Only directed edges are expected in the model.");
        }
        Node node1 = Edges.getDirectedEdgeTail(edge);
        Node node2 = Edges.getDirectedEdgeHead(edge);
        NodeId id1 = this.getNodeId(node1);
        NodeId id2 = this.getNodeId(node2);
        int lag = id1.getLag() - id2.getLag();
        boolean removed = false;
        for (int _lag = 0; _lag <= this.getMaxLag(); ++_lag) {
            Edge _edge;
            Node from = this.getNode(id1.getName(), _lag + lag);
            Node to = this.getNode(id2.getName(), _lag);
            if (from == null || to == null || (_edge = this.getGraph().getEdge(from, to)) == null) continue;
            boolean b = this.getGraph().removeEdge(_edge);
            removed = removed || b;
        }
        return removed;
    }

    public boolean setMaxLag(int maxLag) {
        if (maxLag < 0) {
            throw new IllegalArgumentException("Max lag must be at least 0: " + maxLag);
        }
        List<Node> lag0Nodes = this.getLag0Nodes();
        boolean changed = false;
        if (maxLag > this.getMaxLag()) {
            this.maxLag = maxLag;
            for (Node node : lag0Nodes) {
                this.addNode(node);
            }
            for (Node node : lag0Nodes) {
                List<Edge> edges = this.getGraph().getEdges(node);
                for (Edge edge : edges) {
                    boolean b = this.addEdge(edge);
                    changed = changed || b;
                }
            }
        } else if (maxLag < this.getMaxLag()) {
            for (Node node : lag0Nodes) {
                List<Edge> edges = this.getGraph().getEdges(node);
                for (Edge edge : edges) {
                    Node tail = Edges.getDirectedEdgeTail(edge);
                    if (this.getNodeId(tail).getLag() <= maxLag) continue;
                    this.getGraph().removeEdge(edge);
                }
            }
            for (Node _node : this.getNodes()) {
                if (this.getNodeId(_node).getLag() <= maxLag) continue;
                boolean b = this.getGraph().removeNode(_node);
                changed = changed || b;
            }
            this.maxLag = maxLag;
        }
        this.getPcs().firePropertyChange("editingFinished", null, null);
        return changed;
    }

    public boolean removeHighLagEdges(int maxLag) {
        List<Node> lag0Nodes = this.getLag0Nodes();
        boolean changed = false;
        for (Node node : lag0Nodes) {
            List<Edge> edges = this.getGraph().getEdges(node);
            for (Edge edge : new ArrayList<Edge>(edges)) {
                Node tail = Edges.getDirectedEdgeTail(edge);
                if (this.getNodeId(tail).getLag() <= maxLag) continue;
                boolean b = this.getGraph().removeEdge(edge);
                changed = changed || b;
            }
        }
        return changed;
    }

    public boolean setNumInitialLags(int numInitialLags) {
        if (numInitialLags < 1) {
            throw new IllegalArgumentException("The number of initial lags must be at least 1: " + numInitialLags);
        }
        if (numInitialLags == this.numInitialLags) {
            return false;
        }
        List<Node> lag0Nodes = this.getLag0Nodes();
        boolean changed = false;
        for (Node node : lag0Nodes) {
            NodeId id = this.getNodeId(node);
            for (int lag = 1; lag <= this.getMaxLag(); ++lag) {
                Node _node = this.getNode(id.getName(), lag);
                List<Node> nodesInto = this.getGraph().getNodesInTo(_node, Endpoint.ARROW);
                for (Node _node2 : nodesInto) {
                    Edge edge = Edges.directedEdge(_node2, _node);
                    boolean b = this.getGraph().removeEdge(edge);
                    changed = changed || b;
                }
            }
        }
        this.numInitialLags = numInitialLags;
        for (Node node : lag0Nodes) {
            for (int lag = 0; lag < numInitialLags; ++lag) {
                List<Edge> edges = this.getGraph().getEdges(node);
                for (Edge edge : edges) {
                    boolean b = this.addEdge(edge);
                    changed = changed || b;
                }
            }
        }
        this.getPcs().firePropertyChange("editingFinished", null, null);
        return changed;
    }

    public NodeId getNodeId(Node node) {
        int lag;
        String _name = node.getName();
        String[] tokens = _name.split(":");
        if (tokens.length > 2) {
            throw new IllegalArgumentException("Name may contain only one colon: " + _name);
        }
        if (tokens[0].length() == 0) {
            throw new IllegalArgumentException("Part to the left of the colon may not be empty; that's the name of the variable: " + _name);
        }
        String name = tokens[0];
        if (tokens.length == 1) {
            lag = 0;
        } else {
            lag = Integer.parseInt(tokens[1]);
            if (lag == 0) {
                throw new IllegalArgumentException("Lag 0 edges don't have :0 descriptors");
            }
        }
        if (lag < 0) {
            throw new IllegalArgumentException("Lag is less than 0: " + lag);
        }
        if (lag > this.getMaxLag()) {
            throw new IllegalArgumentException("Lag is greater than the maximum lag: " + lag);
        }
        return new NodeId(name, lag);
    }

    public Node getNode(String name, int lag) {
        if (name.length() == 0) {
            throw new IllegalArgumentException("Empty node name: " + name);
        }
        if (lag < 0) {
            throw new IllegalArgumentException("Negative lag: " + lag);
        }
        String _name = lag == 0 ? name : name + ":" + lag;
        return this.getNode(_name);
    }

    public List<Node> getLag0Nodes() {
        return new ArrayList<Node>(this.lag0Nodes);
    }

    private EdgeListGraph getGraph() {
        return this.graph;
    }

    public int getMaxLag() {
        return this.maxLag;
    }

    public int getNumInitialLags() {
        return this.numInitialLags;
    }

    @Override
    public String toString() {
        return this.getGraph().toString() + "\n" + this.lag0Nodes;
    }

    @Override
    public boolean addDirectedEdge(Node node1, Node node2) {
        return this.graph.addDirectedEdge(node1, node2);
    }

    @Override
    public boolean addUndirectedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException("Undirected edges not currently supported.");
    }

    @Override
    public boolean addNondirectedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException("Nondireced edges not supported.");
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException("Partially oriented edges not supported.");
    }

    @Override
    public boolean addBidirectedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException("Bidireced edges not currently supported.");
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefNoncollider(node1, node2, node3);
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefCollider(node1, node2, node3);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return this.getGraph().getChildren(node);
    }

    @Override
    public int getDegree() {
        return this.getGraph().getDegree();
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        return this.getGraph().getEdge(node1, node2);
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        return this.getGraph().getDirectedEdge(node1, node2);
    }

    @Override
    public List<Node> getParents(Node node) {
        return this.getGraph().getParents(node);
    }

    @Override
    public int getIndegree(Node node) {
        return this.getGraph().getIndegree(node);
    }

    @Override
    public int getDegree(Node node) {
        return this.getGraph().getDegree(node);
    }

    @Override
    public int getOutdegree(Node node) {
        return this.getGraph().getOutdegree(node);
    }

    @Override
    public boolean isAdjacentTo(Node node1, Node node2) {
        return this.getGraph().isAdjacentTo(node1, node2);
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        return this.getGraph().isChildOf(node1, node2);
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        return this.graph.isParentOf(node1, node2);
    }

    @Override
    public void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        this.getGraph().transferNodesAndEdges(graph);
    }

    @Override
    public void transferAttributes(Graph graph) throws IllegalArgumentException {
        this.getGraph().transferAttributes(graph);
    }

    @Override
    public Underlines underlines() {
        return this.graph.underlines();
    }

    @Override
    public Paths paths() {
        return this.paths;
    }

    @Override
    public boolean isParameterizable(Node node) {
        return this.getNodeId(node).getLag() < this.getNumInitialLags();
    }

    @Override
    public boolean isTimeLagModel() {
        return true;
    }

    @Override
    public TimeLagGraph getTimeLagGraph() {
        return this;
    }

    @Override
    public List<Node> getSepset(Node n1, Node n2) {
        return this.graph.getSepset(n1, n2);
    }

    @Override
    public void setNodes(List<Node> nodes) {
        throw new IllegalArgumentException("Sorry, you cannot replace the variables for a time lag graph.");
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.getGraph().isExogenous(node);
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        return this.getGraph().getAdjacentNodes(node);
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        return this.getGraph().getEndpoint(node1, node2);
    }

    @Override
    public boolean setEndpoint(Node from, Node to, Endpoint endPoint) throws IllegalArgumentException {
        return this.getGraph().setEndpoint(from, to, endPoint);
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint endpoint) {
        return this.getGraph().getNodesInTo(node, endpoint);
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint endpoint) {
        return this.getGraph().getNodesOutTo(node, endpoint);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
        this.getGraph().addPropertyChangeListener(l);
    }

    @Override
    public Set<Edge> getEdges() {
        return this.getGraph().getEdges();
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.getGraph().containsEdge(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.getGraph().containsNode(node);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        if (this.getGraph().containsNode(node)) {
            return this.getGraph().getEdges(node);
        }
        return null;
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        return this.getGraph().getEdges(node1, node2);
    }

    public int hashCode() {
        return this.getGraph().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Graph)) {
            return false;
        }
        return this.getGraph().equals(o);
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        this.getGraph().fullyConnect(endpoint);
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        this.getGraph().reorientAllWith(endpoint);
    }

    @Override
    public Node getNode(String name) {
        return this.getGraph().getNode(name);
    }

    @Override
    public int getNumNodes() {
        return this.getGraph().getNumNodes();
    }

    @Override
    public int getNumEdges() {
        return this.getGraph().getNumEdges();
    }

    @Override
    public int getNumEdges(Node node) {
        return this.getGraph().getNumEdges(node);
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        return this.getGraph().subgraph(nodes);
    }

    @Override
    public List<Node> getNodes() {
        return this.getGraph().getNodes();
    }

    @Override
    public List<String> getNodeNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public void clear() {
        this.getGraph().clear();
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        return this.removeEdge(this.getEdge(node1, node2));
    }

    @Override
    public boolean removeEdges(Collection<Edge> edges) {
        boolean change = false;
        for (Edge edge : edges) {
            boolean _change = this.removeEdge(edge);
            change = change || _change;
        }
        return change;
    }

    @Override
    public boolean removeNodes(List<Node> nodes) {
        return this.getGraph().removeNodes(nodes);
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        return this.removeEdges(this.getEdges(node1, node2));
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public static class NodeId {
        private final String name;
        private final int lag;

        public NodeId(String name, int lag) {
            this.name = name;
            this.lag = lag;
        }

        public String getName() {
            return this.name;
        }

        public int getLag() {
            return this.lag;
        }
    }
}

