/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.TetradSerializable;
import java.util.ArrayList;

public final class Triple
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private final Node x;
    private final Node y;
    private final Node z;

    public Triple(Node x, Node y, Node z) {
        if (x == null || y == null || z == null) {
            throw new NullPointerException();
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Triple serializableInstance() {
        return new Triple(new GraphNode("X"), new GraphNode("Y"), new GraphNode("Z"));
    }

    public Node getX() {
        return this.x;
    }

    public Node getY() {
        return this.y;
    }

    public Node getZ() {
        return this.z;
    }

    public int hashCode() {
        int hash = 17;
        hash += 19 * this.x.hashCode() * this.z.hashCode();
        return hash += 23 * this.y.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Triple)) {
            return false;
        }
        Triple triple = (Triple)obj;
        return this.x == triple.x && this.y == triple.y && this.z == triple.z || this.x == triple.z && this.y == triple.y && this.z == triple.x;
    }

    public String toString() {
        return "<" + this.x + ", " + this.y + ", " + this.z + ">";
    }

    public boolean alongPathIn(Graph graph) {
        return graph.isAdjacentTo(this.x, this.y) && graph.isAdjacentTo(this.y, this.z) && this.x != this.z;
    }

    public static String pathString(Graph graph, Node x, Node y, Node z) {
        ArrayList<Node> path = new ArrayList<Node>();
        path.add(x);
        path.add(y);
        path.add(z);
        return GraphUtils.pathString(graph, path);
    }
}

