/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.graph.TripleClassifier;
import edu.cmu.tetrad.util.TetradSerializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Underlines
implements TripleClassifier,
TetradSerializable {
    static final long serialVersionUID = 23L;
    private final Graph graph;
    private Set<Triple> underLineTriples;
    private Set<Triple> dottedUnderLineTriples;
    private Set<Triple> ambiguousTriples;

    public Underlines(Graph graph) {
        this.graph = graph;
        this.underLineTriples = new HashSet<Triple>();
        this.dottedUnderLineTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
    }

    public Underlines(Underlines underlineModel) {
        this(underlineModel.graph);
        this.underLineTriples = underlineModel.getUnderLines();
        this.dottedUnderLineTriples = underlineModel.getDottedUnderlines();
        this.ambiguousTriples = underlineModel.getAmbiguousTriples();
    }

    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    public void setAmbiguousTriples(Set<Triple> triples) {
        this.ambiguousTriples.clear();
        for (Triple triple : triples) {
            this.addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    public Set<Triple> getUnderLines() {
        return new HashSet<Triple>(this.underLineTriples);
    }

    public Set<Triple> getDottedUnderlines() {
        return new HashSet<Triple>(this.dottedUnderLineTriples);
    }

    public boolean isAmbiguousTriple(Node x, Node y, Node z) {
        return this.ambiguousTriples.contains(new Triple(x, y, z));
    }

    public boolean isUnderlineTriple(Node x, Node y, Node z) {
        return this.underLineTriples.contains(new Triple(x, y, z));
    }

    public void addAmbiguousTriple(Node x, Node y, Node z) {
        this.ambiguousTriples.add(new Triple(x, y, z));
    }

    public void addUnderlineTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        if (!triple.alongPathIn(this.graph)) {
            return;
        }
        this.underLineTriples.add(new Triple(x, y, z));
    }

    public void addDottedUnderlineTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        if (!triple.alongPathIn(this.graph)) {
            return;
        }
        this.dottedUnderLineTriples.add(triple);
    }

    public void removeAmbiguousTriple(Node x, Node y, Node z) {
        this.ambiguousTriples.remove(new Triple(x, y, z));
    }

    public void removeUnderlineTriple(Node x, Node y, Node z) {
        this.underLineTriples.remove(new Triple(x, y, z));
    }

    public void removeDottedUnderlineTriple(Node x, Node y, Node z) {
        this.dottedUnderLineTriples.remove(new Triple(x, y, z));
    }

    public void setUnderLineTriples(Set<Triple> triples) {
        this.underLineTriples.clear();
        for (Triple triple : triples) {
            this.addUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    public void setDottedUnderLineTriples(Set<Triple> triples) {
        this.dottedUnderLineTriples.clear();
        for (Triple triple : triples) {
            this.addDottedUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    public void removeTriplesNotInGraph() {
        for (Triple triple : new HashSet<Triple>(this.ambiguousTriples)) {
            if (!(this.graph.containsNode(triple.getX()) && this.graph.containsNode(triple.getY()) && this.graph.containsNode(triple.getZ()))) {
                this.ambiguousTriples.remove(triple);
                continue;
            }
            if (this.graph.isAdjacentTo(triple.getX(), triple.getY()) && this.graph.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.ambiguousTriples.remove(triple);
        }
        for (Triple triple : new HashSet<Triple>(this.underLineTriples)) {
            if (!(this.graph.containsNode(triple.getX()) && this.graph.containsNode(triple.getY()) && this.graph.containsNode(triple.getZ()))) {
                this.underLineTriples.remove(triple);
                continue;
            }
            if (this.graph.isAdjacentTo(triple.getX(), triple.getY()) && this.graph.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.underLineTriples.remove(triple);
        }
        for (Triple triple : new HashSet<Triple>(this.dottedUnderLineTriples)) {
            if (!(this.graph.containsNode(triple.getX()) && this.graph.containsNode(triple.getY()) && this.graph.containsNode(triple.getZ()))) {
                this.dottedUnderLineTriples.remove(triple);
                continue;
            }
            if (this.graph.isAdjacentTo(triple.getX(), triple.getY()) && !this.graph.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.dottedUnderLineTriples.remove(triple);
        }
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("Underlines");
        names.add("Dotted Underlines");
        names.add("Ambiguous Triples");
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        triplesList.add(GraphUtils.getUnderlinedTriplesFromGraph(node, this.graph));
        triplesList.add(GraphUtils.getDottedUnderlinedTriplesFromGraph(node, this.graph));
        triplesList.add(GraphUtils.getAmbiguousTriplesFromGraph(node, this.graph));
        return triplesList;
    }
}

