/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.performance;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphPersistence;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.RandomGraph;
import edu.cmu.tetrad.performance.ComparisonParameters;
import edu.cmu.tetrad.performance.ComparisonResult;
import edu.cmu.tetrad.search.BDeuScore;
import edu.cmu.tetrad.search.Cpc;
import edu.cmu.tetrad.search.Fci;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.GFci;
import edu.cmu.tetrad.search.GraphScore;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndTestChiSquare;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.search.PcLocal;
import edu.cmu.tetrad.search.PcStableMax;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SemBicScore;
import edu.cmu.tetrad.search.SvarFci;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.search.TsDagToPag;
import edu.cmu.tetrad.sem.LargeScaleSimulation;
import edu.cmu.tetrad.sem.ScoreType;
import edu.cmu.tetrad.util.DataConvertUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TextTable;
import edu.pitt.dbmi.data.reader.DatasetFileReader;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.tabular.ContinuousTabularDatasetFileReader;
import edu.pitt.dbmi.data.reader.tabular.VerticalDiscreteTabularDatasetFileReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Comparison2 {
    public static ComparisonResult compare(ComparisonParameters params) {
        GraphSearch search;
        ArrayList<Node> nodes;
        DataSet dataSet = null;
        Graph trueDag = null;
        IndependenceTest test = null;
        Score score = null;
        ComparisonResult result = new ComparisonResult(params);
        if (params.isDataFromFile()) {
            String path = "/Users/dmalinsky/Documents/research/data/danexamples";
            File dir = new File("/Users/dmalinsky/Documents/research/data/danexamples");
            File[] files = dir.listFiles();
            if (files == null) {
                throw new NullPointerException("No files in /Users/dmalinsky/Documents/research/data/danexamples");
            }
            for (File file : files) {
                if (!file.getName().startsWith("graph") || !file.getName().contains(String.valueOf(params.getGraphNum())) || !file.getName().endsWith(".g.txt")) continue;
                params.setGraphFile(file.getName());
                trueDag = GraphPersistence.loadGraphTxt(file);
                break;
            }
            String trialGraph = String.valueOf(params.getGraphNum()).concat("-").concat(String.valueOf(params.getTrial())).concat(".dat.txt");
            for (File file : files) {
                DatasetFileReader dataReader;
                if (!file.getName().startsWith("graph") || !file.getName().endsWith(trialGraph)) continue;
                Path dataFile = Paths.get("/Users/dmalinsky/Documents/research/data/danexamples".concat("/").concat(file.getName()), new String[0]);
                Delimiter delimiter = Delimiter.TAB;
                if (params.getDataType() == ComparisonParameters.DataType.Continuous) {
                    try {
                        dataReader = new ContinuousTabularDatasetFileReader(dataFile, delimiter);
                        dataSet = (DataSet)DataConvertUtils.toDataModel(((ContinuousTabularDatasetFileReader)dataReader).readInData());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        dataReader = new VerticalDiscreteTabularDatasetFileReader(dataFile, delimiter);
                        dataSet = (DataSet)DataConvertUtils.toDataModel(((VerticalDiscreteTabularDatasetFileReader)dataReader).readInData());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                params.setDataFile(file.getName());
                break;
            }
            System.out.println("current graph file = " + params.getGraphFile());
            System.out.println("current data set file = " + params.getDataFile());
        }
        if (params.isNoData()) {
            GraphSearch search2;
            nodes = new ArrayList<Node>();
            for (int i = 0; i < params.getNumVars(); ++i) {
                nodes.add(new ContinuousVariable("X" + (i + 1)));
            }
            trueDag = RandomGraph.randomGraphRandomForwardEdges(nodes, 0, params.getNumEdges(), 10, 10, 10, false, true);
            if (params.getAlgorithm() == ComparisonParameters.Algorithm.SVARFCI) {
                trueDag = RandomGraph.randomGraphRandomForwardEdges(nodes, 0, params.getNumEdges(), 10, 10, 10, false, true);
                trueDag = TimeSeriesUtils.graphToLagGraph(trueDag, 2);
                System.out.println("Creating Time Lag Graph : " + trueDag);
            }
            test = new IndTestDSep(trueDag);
            score = new GraphScore(trueDag);
            if (params.getAlgorithm() == null) {
                throw new IllegalArgumentException("Algorithm not set.");
            }
            long time1 = MillisecondTimes.timeMillis();
            if (params.getAlgorithm() == ComparisonParameters.Algorithm.PC) {
                search2 = new Pc(test);
                result.setResultGraph(((Pc)search2).search());
                result.setCorrectResult(SearchGraphUtils.cpdagForDag(new EdgeListGraph(trueDag)));
            } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.CPC) {
                search2 = new Cpc(test);
                result.setResultGraph(((Cpc)search2).search());
                result.setCorrectResult(SearchGraphUtils.cpdagForDag(new EdgeListGraph(trueDag)));
            } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.PCLocal) {
                search2 = new PcLocal(test);
                result.setResultGraph(((PcLocal)search2).search());
                result.setCorrectResult(SearchGraphUtils.cpdagForDag(new EdgeListGraph(trueDag)));
            } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.PCStableMax) {
                search2 = new PcStableMax(test);
                result.setResultGraph(((PcStableMax)search2).search());
                result.setCorrectResult(SearchGraphUtils.cpdagForDag(new EdgeListGraph(trueDag)));
            } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.FGES) {
                search2 = new Fges(score);
                result.setResultGraph(((Fges)search2).search());
                result.setCorrectResult(SearchGraphUtils.cpdagForDag(new EdgeListGraph(trueDag)));
            } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.FCI) {
                search2 = new Fci(test);
                result.setResultGraph(((Fci)search2).search());
                result.setCorrectResult(SearchGraphUtils.dagToPag(trueDag));
            } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.GFCI) {
                search2 = new GFci(test, score);
                result.setResultGraph(((GFci)search2).search());
                result.setCorrectResult(SearchGraphUtils.dagToPag(trueDag));
            } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.SVARFCI) {
                search2 = new SvarFci(test);
                Knowledge knowledge = Comparison2.getKnowledge(trueDag);
                ((SvarFci)search2).setKnowledge(knowledge);
                result.setResultGraph(((SvarFci)search2).search());
                result.setCorrectResult(new TsDagToPag(trueDag).convert());
                System.out.println("Correct result for trial = " + result.getCorrectResult());
                System.out.println("Search result for trial = " + result.getResultGraph());
            } else {
                throw new IllegalArgumentException("Unrecognized algorithm.");
            }
            long time2 = MillisecondTimes.timeMillis();
            long elapsed = time2 - time1;
            result.setElapsed(elapsed);
            result.setTrueDag(trueDag);
            return result;
        }
        if (params.getDataFile() != null) {
            System.out.println("Using data from file... ");
            if (params.getGraphFile() == null) {
                throw new IllegalArgumentException("True graph file not set.");
            }
            System.out.println("Using graph from file... ");
        } else {
            if (params.getNumVars() == -1) {
                throw new IllegalArgumentException("Number of variables not set.");
            }
            if (params.getNumEdges() == -1) {
                throw new IllegalArgumentException("Number of edges not set.");
            }
            if (params.getDataType() == ComparisonParameters.DataType.Continuous) {
                nodes = new ArrayList();
                for (int i = 0; i < params.getNumVars(); ++i) {
                    nodes.add(new ContinuousVariable("X" + (i + 1)));
                }
                trueDag = RandomGraph.randomGraphRandomForwardEdges(nodes, 0, params.getNumEdges(), 10, 10, 10, false, true);
                if (params.getAlgorithm() == ComparisonParameters.Algorithm.SVARFCI) {
                    trueDag = RandomGraph.randomGraphRandomForwardEdges(nodes, 0, params.getNumEdges(), 10, 10, 10, false, true);
                    trueDag = TimeSeriesUtils.graphToLagGraph(trueDag, 2);
                    System.out.println("Creating Time Lag Graph : " + trueDag);
                }
                if (params.getDataType() == null) {
                    throw new IllegalArgumentException("Data type not set or inferred.");
                }
                if (params.getSampleSize() == -1) {
                    throw new IllegalArgumentException("Sample size not set.");
                }
                LargeScaleSimulation sim = new LargeScaleSimulation(trueDag);
                if (params.getAlgorithm() == ComparisonParameters.Algorithm.SVARFCI) {
                    sim.setCoefRange(0.2, 0.5);
                }
                if (params.getAlgorithm() == ComparisonParameters.Algorithm.SVARFCI) {
                    boolean isStableTetradMatrix;
                    int attempt = 1;
                    int tierSize = params.getNumVars();
                    int[] sub = new int[tierSize];
                    int[] sub2 = new int[tierSize];
                    for (int i = 0; i < tierSize; ++i) {
                        sub[i] = i;
                        sub2[i] = tierSize + i;
                    }
                    do {
                        dataSet = sim.simulateDataFisher(params.getSampleSize());
                        Matrix coefMat = new Matrix(sim.getCoefficientMatrix());
                        Matrix B = coefMat.getSelection(sub, sub);
                        Matrix Gamma1 = coefMat.getSelection(sub2, sub);
                        Matrix Gamma0 = Matrix.identity(tierSize).minus(B);
                        Matrix A1 = Gamma0.inverse().times(Gamma1);
                        isStableTetradMatrix = TimeSeriesUtils.allEigenvaluesAreSmallerThanOneInModulus(A1);
                        System.out.println("isStableTetradMatrix? : " + isStableTetradMatrix);
                    } while (!isStableTetradMatrix && ++attempt <= 5);
                    if (!isStableTetradMatrix) {
                        System.out.println("%%%%%%%%%% WARNING %%%%%%%% not a stable coefficient matrix, forcing coefs to [0.15,0.3]");
                        System.out.println("Made " + (attempt - 1) + " attempts to get stable matrix.");
                        sim.setCoefRange(0.15, 0.3);
                        dataSet = sim.simulateDataFisher(params.getSampleSize());
                    } else {
                        System.out.println("Coefficient matrix is stable.");
                    }
                }
            } else if (params.getDataType() == ComparisonParameters.DataType.Discrete) {
                nodes = new ArrayList();
                for (int i = 0; i < params.getNumVars(); ++i) {
                    nodes.add(new DiscreteVariable("X" + (i + 1), 3));
                }
                trueDag = RandomGraph.randomGraphRandomForwardEdges(nodes, 0, params.getNumEdges(), 10, 10, 10, false, true);
                if (params.getDataType() == null) {
                    throw new IllegalArgumentException("Data type not set or inferred.");
                }
                if (params.getSampleSize() == -1) {
                    throw new IllegalArgumentException("Sample size not set.");
                }
                int[] tiers = new int[nodes.size()];
                for (int i = 0; i < nodes.size(); ++i) {
                    tiers[i] = i;
                }
                BayesPm pm = new BayesPm(trueDag, 3, 3);
                MlBayesIm im = new MlBayesIm(pm, 1);
                dataSet = im.simulateData(params.getSampleSize(), false, tiers);
            } else {
                throw new IllegalArgumentException("Unrecognized data type.");
            }
            if (dataSet == null) {
                throw new IllegalArgumentException("No data set.");
            }
        }
        if (params.getIndependenceTest() == ComparisonParameters.IndependenceTestType.FisherZ) {
            if (params.getDataType() != null && params.getDataType() != ComparisonParameters.DataType.Continuous) {
                throw new IllegalArgumentException("Data type previously set to something other than continuous.");
            }
            if (Double.isNaN(params.getAlpha())) {
                throw new IllegalArgumentException("Alpha not set.");
            }
            assert (dataSet != null);
            test = new IndTestFisherZ(dataSet, params.getAlpha());
            params.setDataType(ComparisonParameters.DataType.Continuous);
        } else if (params.getIndependenceTest() == ComparisonParameters.IndependenceTestType.ChiSquare) {
            if (params.getDataType() != null && params.getDataType() != ComparisonParameters.DataType.Discrete) {
                throw new IllegalArgumentException("Data type previously set to something other than discrete.");
            }
            if (Double.isNaN(params.getAlpha())) {
                throw new IllegalArgumentException("Alpha not set.");
            }
            assert (dataSet != null);
            test = new IndTestChiSquare(dataSet, params.getAlpha());
            params.setDataType(ComparisonParameters.DataType.Discrete);
        }
        if (params.getScore() == ScoreType.SemBic) {
            if (params.getDataType() != null && params.getDataType() != ComparisonParameters.DataType.Continuous) {
                throw new IllegalArgumentException("Data type previously set to something other than continuous.");
            }
            if (Double.isNaN(params.getPenaltyDiscount())) {
                throw new IllegalArgumentException("Penalty discount not set.");
            }
            SemBicScore semBicScore = new SemBicScore(new CovarianceMatrix(dataSet));
            semBicScore.setPenaltyDiscount(params.getPenaltyDiscount());
            score = semBicScore;
            params.setDataType(ComparisonParameters.DataType.Continuous);
        } else if (params.getScore() == ScoreType.BDeu) {
            if (params.getDataType() != null && params.getDataType() != ComparisonParameters.DataType.Discrete) {
                throw new IllegalArgumentException("Data type previously set to something other than discrete.");
            }
            if (Double.isNaN(params.getSamplePrior())) {
                throw new IllegalArgumentException("Sample prior not set.");
            }
            if (Double.isNaN(params.getStructurePrior())) {
                throw new IllegalArgumentException("Structure prior not set.");
            }
            score = new BDeuScore(dataSet);
            ((BDeuScore)score).setSamplePrior(params.getSamplePrior());
            ((BDeuScore)score).setStructurePrior(params.getStructurePrior());
            params.setDataType(ComparisonParameters.DataType.Discrete);
            params.setDataType(ComparisonParameters.DataType.Discrete);
        }
        if (params.getAlgorithm() == null) {
            throw new IllegalArgumentException("Algorithm not set.");
        }
        long time1 = MillisecondTimes.timeMillis();
        if (params.getAlgorithm() == ComparisonParameters.Algorithm.PC) {
            if (test == null) {
                throw new IllegalArgumentException("Test not set.");
            }
            search = new Pc(test);
            result.setResultGraph(((Pc)search).search());
            result.setCorrectResult(SearchGraphUtils.cpdagForDag(new EdgeListGraph(trueDag)));
        } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.CPC) {
            if (test == null) {
                throw new IllegalArgumentException("Test not set.");
            }
            search = new Cpc(test);
            result.setResultGraph(((Cpc)search).search());
            result.setCorrectResult(SearchGraphUtils.cpdagForDag(new EdgeListGraph(trueDag)));
        } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.PCLocal) {
            if (test == null) {
                throw new IllegalArgumentException("Test not set.");
            }
            search = new PcLocal(test);
            result.setResultGraph(((PcLocal)search).search());
            result.setCorrectResult(SearchGraphUtils.cpdagForDag(new EdgeListGraph(trueDag)));
        } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.PCStableMax) {
            if (test == null) {
                throw new IllegalArgumentException("Test not set.");
            }
            search = new PcStableMax(test);
            result.setResultGraph(((PcStableMax)search).search());
            result.setCorrectResult(SearchGraphUtils.cpdagForDag(new EdgeListGraph(trueDag)));
        } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.FGES) {
            if (score == null) {
                throw new IllegalArgumentException("Score not set.");
            }
            search = new Fges(score);
            result.setResultGraph(((Fges)search).search());
            result.setCorrectResult(SearchGraphUtils.cpdagForDag(new EdgeListGraph(trueDag)));
        } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.FCI) {
            if (test == null) {
                throw new IllegalArgumentException("Test not set.");
            }
            search = new Fci(test);
            result.setResultGraph(((Fci)search).search());
            result.setCorrectResult(SearchGraphUtils.dagToPag(trueDag));
        } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.GFCI) {
            if (test == null) {
                throw new IllegalArgumentException("Test not set.");
            }
            search = new GFci(test, score);
            result.setResultGraph(((GFci)search).search());
            result.setCorrectResult(SearchGraphUtils.dagToPag(trueDag));
        } else if (params.getAlgorithm() == ComparisonParameters.Algorithm.SVARFCI) {
            if (test == null) {
                throw new IllegalArgumentException("Test not set.");
            }
            search = new SvarFci(test);
            assert (trueDag != null);
            Knowledge knowledge = Comparison2.getKnowledge(trueDag);
            ((SvarFci)search).setKnowledge(knowledge);
            result.setResultGraph(((SvarFci)search).search());
            result.setCorrectResult(new TsDagToPag(trueDag).convert());
        } else {
            throw new IllegalArgumentException("Unrecognized algorithm.");
        }
        long time2 = MillisecondTimes.timeMillis();
        long elapsed = time2 - time1;
        result.setElapsed(elapsed);
        result.setTrueDag(trueDag);
        return result;
    }

    public static TextTable summarize(List<ComparisonResult> results, List<TableColumn> tableColumns) {
        ArrayList<Node> variables = new ArrayList<Node>();
        for (TableColumn column : tableColumns) {
            variables.add(new ContinuousVariable(column.toString()));
        }
        BoxDataSet dataSet = new BoxDataSet(new DoubleDataBox(0, variables.size()), variables);
        dataSet.setNumberFormat(new DecimalFormat("0"));
        for (int i = 0; i < results.size(); ++i) {
            System.out.println("\nRun " + (i + 1) + "\n" + results.get(i));
        }
        System.out.println();
        for (ComparisonResult _result : results) {
            Graph correctGraph = _result.getCorrectResult();
            Graph resultGraph = _result.getResultGraph();
            GraphUtils.GraphComparison comparison = SearchGraphUtils.getGraphComparison2(correctGraph, resultGraph);
            int newRow = dataSet.getNumRows();
            if (tableColumns.contains((Object)TableColumn.AdjCor)) {
                dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.AdjCor), comparison.getAdjCor());
            }
            if (tableColumns.contains((Object)TableColumn.AdjFn)) {
                dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.AdjFn), comparison.getAdjFn());
            }
            if (tableColumns.contains((Object)TableColumn.AdjFp)) {
                dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.AdjFp), comparison.getAdjFp());
            }
            if (tableColumns.contains((Object)TableColumn.AhdCor)) {
                dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.AhdCor), comparison.getAhdCor());
            }
            if (tableColumns.contains((Object)TableColumn.AhdFn)) {
                dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.AhdFn), comparison.getAhdFn());
            }
            if (tableColumns.contains((Object)TableColumn.AhdFp)) {
                dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.AhdFp), comparison.getAhdFp());
            }
            if (tableColumns.contains((Object)TableColumn.AdjPrec)) {
                dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.AdjPrec), comparison.getAdjPrec());
            }
            if (tableColumns.contains((Object)TableColumn.AdjRec)) {
                dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.AdjRec), comparison.getAdjRec());
            }
            if (tableColumns.contains((Object)TableColumn.AhdPrec)) {
                dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.AhdPrec), comparison.getAhdPrec());
            }
            if (tableColumns.contains((Object)TableColumn.AhdRec)) {
                dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.AhdRec), comparison.getAhdRec());
            }
            if (tableColumns.contains((Object)TableColumn.Elapsed)) {
                dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.Elapsed), _result.getElapsed());
            }
            if (!tableColumns.contains((Object)TableColumn.SHD)) continue;
            dataSet.setDouble(newRow, tableColumns.indexOf((Object)TableColumn.SHD), comparison.getShd());
        }
        int[] cols = new int[tableColumns.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = i;
        }
        return Comparison2.getTextTable(dataSet, cols, new DecimalFormat("0.00"));
    }

    private static TextTable getTextTable(DataSet dataSet, int[] columns, NumberFormat nf) {
        int j;
        int i;
        TextTable table = new TextTable(dataSet.getNumRows() + 2, columns.length + 1);
        table.setToken(0, 0, "Run #");
        for (int j2 = 0; j2 < columns.length; ++j2) {
            table.setToken(0, j2 + 1, dataSet.getVariable(columns[j2]).getName());
        }
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            table.setToken(i + 1, 0, Integer.toString(i + 1));
        }
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            for (j = 0; j < columns.length; ++j) {
                table.setToken(i + 1, j + 1, nf.format(dataSet.getDouble(i, columns[j])));
            }
        }
        DecimalFormat nf2 = new DecimalFormat("0.00");
        for (j = 0; j < columns.length; ++j) {
            double sum = 0.0;
            for (int i2 = 0; i2 < dataSet.getNumRows(); ++i2) {
                sum += dataSet.getDouble(i2, columns[j]);
            }
            double avg = sum / (double)dataSet.getNumRows();
            table.setToken(dataSet.getNumRows() + 2 - 1, j + 1, nf2.format(avg));
        }
        table.setToken(dataSet.getNumRows() + 2 - 1, 0, "Avg");
        return table;
    }

    public static Knowledge getKnowledge(Graph graph) {
        String tmp;
        int lag;
        String varName;
        List<Node> variables = graph.getNodes();
        ArrayList<Integer> laglist = new ArrayList<Integer>();
        Knowledge knowledge = new Knowledge();
        for (Node node : variables) {
            varName = node.getName();
            if (varName.indexOf(58) == -1) {
                lag = 0;
            } else {
                tmp = varName.substring(varName.indexOf(58) + 1);
                lag = Integer.parseInt(tmp);
            }
            laglist.add(lag);
        }
        int numLags = (Integer)Collections.max(laglist);
        variables.sort((o1, o2) -> {
            String name1 = Comparison2.getNameNoLag(o1);
            String name2 = Comparison2.getNameNoLag(o2);
            String prefix1 = Comparison2.getPrefix(name1);
            String prefix2 = Comparison2.getPrefix(name2);
            int index1 = Comparison2.getIndex(name1);
            int index2 = Comparison2.getIndex(name2);
            if (Comparison2.getLag(o1.getName()) == Comparison2.getLag(o2.getName())) {
                if (prefix1.compareTo(prefix2) == 0) {
                    return Integer.compare(index1, index2);
                }
                return prefix1.compareTo(prefix2);
            }
            return Comparison2.getLag(o1.getName()) - Comparison2.getLag(o2.getName());
        });
        for (Node node : variables) {
            varName = node.getName();
            if (varName.indexOf(58) == -1) {
                lag = 0;
            } else {
                tmp = varName.substring(varName.indexOf(58) + 1);
                lag = Integer.parseInt(tmp);
            }
            knowledge.addToTier(numLags - lag, node.getName());
        }
        return knowledge;
    }

    public static String getNameNoLag(Object obj) {
        String tempS = obj.toString();
        if (tempS.indexOf(58) == -1) {
            return tempS;
        }
        return tempS.substring(0, tempS.indexOf(58));
    }

    public static String getPrefix(String s) {
        return s.substring(0, 1);
    }

    public static int getIndex(String s) {
        int y = 0;
        for (int i = s.length() - 1; i >= 0; --i) {
            try {
                y = Integer.parseInt(s.substring(i));
                continue;
            }
            catch (NumberFormatException e) {
                return y;
            }
        }
        throw new IllegalArgumentException("Not integer suffix.");
    }

    public static int getLag(String s) {
        if (s.indexOf(58) == -1) {
            return 0;
        }
        String tmp = s.substring(s.indexOf(58) + 1);
        return Integer.parseInt(tmp);
    }

    public static enum TableColumn {
        AdjCor,
        AdjFn,
        AdjFp,
        AhdCor,
        AhdFn,
        AhdFp,
        SHD,
        AdjPrec,
        AdjRec,
        AhdPrec,
        AhdRec,
        Elapsed;

    }
}

