/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetrad.util.TextTable;
import edu.cmu.tetrad.util.Vector;
import java.text.NumberFormat;

public class RegressionResult
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private final boolean zeroInterceptAssumed;
    private final String[] regressorNames;
    private final int n;
    private final double[] b;
    private final double[] t;
    private final double[] p;
    private final double[] se;
    private final double r2;
    private final double rss;
    private final double alpha;
    private final Vector res;

    public RegressionResult(boolean zeroInterceptAssumed, String[] regressorNames, int n, double[] b, double[] t, double[] p, double[] se, double r2, double rss, double alpha, Vector res) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (t == null) {
            throw new NullPointerException();
        }
        if (p == null) {
            throw new NullPointerException();
        }
        if (se == null) {
            throw new NullPointerException();
        }
        this.zeroInterceptAssumed = zeroInterceptAssumed;
        this.regressorNames = regressorNames;
        this.n = n;
        this.b = b;
        this.t = t;
        this.p = p;
        this.se = se;
        this.r2 = r2;
        this.alpha = alpha;
        this.rss = rss;
        this.res = res;
    }

    public static RegressionResult serializableInstance() {
        return new RegressionResult(true, new String[0], 10, new double[0], new double[0], new double[0], new double[0], 0.0, 0.0, 0.0, null);
    }

    public int getN() {
        return this.n;
    }

    public int getNumRegressors() {
        return this.regressorNames.length;
    }

    public double[] getCoef() {
        return this.b;
    }

    public double[] getT() {
        return this.t;
    }

    public double[] getP() {
        return this.p;
    }

    public double[] getSe() {
        return this.se;
    }

    public String[] getRegressorNames() {
        return this.regressorNames;
    }

    public double getPredictedValue(double[] x) {
        double yHat = 0.0;
        int offset = this.zeroInterceptAssumed ? 0 : 1;
        for (int i = 0; i < this.getNumRegressors(); ++i) {
            yHat += this.b[i + offset] * x[i];
        }
        if (!this.zeroInterceptAssumed) {
            yHat += this.b[0];
        }
        return yHat;
    }

    public String toString() {
        StringBuilder summary = new StringBuilder(this.getPreamble());
        TextTable table = this.getResultsTable();
        summary.append("\n").append(table.toString());
        return summary.toString();
    }

    public TextTable getResultsTable() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        TextTable table = new TextTable(this.getNumRegressors() + 3, 6);
        table.setToken(0, 0, "VAR");
        table.setToken(0, 1, "COEF");
        table.setToken(0, 2, "SE");
        table.setToken(0, 3, "T");
        table.setToken(0, 4, "P");
        table.setToken(0, 5, "");
        for (int i = 0; i < this.getNumRegressors() + 1; ++i) {
            String variableName = i > 0 ? this.regressorNames[i - 1] : "const";
            table.setToken(i + 2, 0, variableName);
            table.setToken(i + 2, 1, nf.format(this.b[i]));
            if (this.se.length != 0) {
                table.setToken(i + 2, 2, nf.format(this.se[i]));
            } else {
                table.setToken(i + 2, 2, "-1");
            }
            if (this.t.length != 0) {
                table.setToken(i + 2, 3, nf.format(this.t[i]));
            } else {
                table.setToken(i + 2, 3, "-1");
            }
            if (this.p.length != 0) {
                table.setToken(i + 2, 4, nf.format(this.p[i]));
            } else {
                table.setToken(i + 2, 4, "-1");
            }
            if (this.p.length != 0) {
                table.setToken(i + 2, 5, this.p[i] < this.alpha ? "significant " : "");
                continue;
            }
            table.setToken(i + 2, 5, "(p not defined)");
        }
        return table;
    }

    public String getPreamble() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        String rssString = nf.format(this.rss);
        String r2String = nf.format(this.r2);
        return "\n REGRESSION RESULT\n n = " + this.n + ", k = " + (this.getNumRegressors() + 1) + ", alpha = " + this.alpha + "\n SSE = " + rssString + "\n R^2 = " + r2String + "\n";
    }

    public Vector getResiduals() {
        return this.res;
    }
}

