/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;

public class AdLeafTree {
    private final DataSet dataSet;
    private List<Vary> baseCase;
    private final Map<Node, Integer> nodesHash;
    private final int[][] discreteData;
    private final int[] dims;

    public AdLeafTree(DataSet dataSet) {
        Node v;
        int j;
        this.dataSet = dataSet;
        this.discreteData = new int[dataSet.getNumColumns()][];
        this.dims = new int[dataSet.getNumColumns()];
        for (j = 0; j < dataSet.getNumColumns(); ++j) {
            v = dataSet.getVariable(j);
            if (!(v instanceof DiscreteVariable)) continue;
            int[] col = new int[dataSet.getNumRows()];
            for (int i = 0; i < dataSet.getNumRows(); ++i) {
                col[i] = dataSet.getInt(i, j);
            }
            this.discreteData[j] = col;
            this.dims[j] = ((DiscreteVariable)v).getNumCategories();
        }
        this.nodesHash = new HashMap<Node, Integer>();
        for (j = 0; j < dataSet.getNumColumns(); ++j) {
            v = dataSet.getVariable(j);
            this.nodesHash.put(v, j);
        }
    }

    public List<List<Integer>> getCellLeaves(List<DiscreteVariable> A) {
        A.sort(Comparator.comparingInt(this.nodesHash::get));
        if (this.baseCase == null) {
            Vary vary = new Vary();
            this.baseCase = new ArrayList<Vary>();
            this.baseCase.add(vary);
        }
        List<Vary> varies = this.baseCase;
        for (DiscreteVariable v : A) {
            varies = this.getVaries(varies, this.nodesHash.get(v));
        }
        ArrayList<List<Integer>> rows = new ArrayList<List<Integer>>();
        for (Vary vary : varies) {
            rows.addAll(vary.getRows());
        }
        return rows;
    }

    public List<List<List<Integer>>> getCellLeaves(List<DiscreteVariable> A, DiscreteVariable B) {
        A.sort(Comparator.comparingInt(this.nodesHash::get));
        if (this.baseCase == null) {
            Vary vary = new Vary();
            this.baseCase = new ArrayList<Vary>();
            this.baseCase.add(vary);
        }
        List<Vary> varies = this.baseCase;
        for (DiscreteVariable v : A) {
            varies = this.getVaries(varies, this.nodesHash.get(v));
        }
        ArrayList<List<List<Integer>>> rows = new ArrayList<List<List<Integer>>>();
        for (Vary vary : varies) {
            for (int i = 0; i < vary.getNumCategories(); ++i) {
                Vary subvary = vary.getSubvary(this.nodesHash.get(B), i);
                rows.add(subvary.getRows());
            }
        }
        return rows;
    }

    public void setColumn(DiscreteVariable var, int[] col) {
        this.discreteData[this.dataSet.getColumn((Node)var)] = col;
    }

    private List<Vary> getVaries(List<Vary> varies, int v) {
        ArrayList<Vary> _varies = new ArrayList<Vary>();
        for (Vary vary : varies) {
            for (int i = 0; i < vary.getNumCategories(); ++i) {
                _varies.add(vary.getSubvary(v, i));
            }
        }
        return _varies;
    }

    private class Vary {
        int col;
        int numCategories;
        List<List<Integer>> rows = new ArrayList<List<Integer>>();
        List<Map<Integer, Vary>> subVaries = new ArrayList<Map<Integer, Vary>>();

        public Vary() {
            ArrayList<Integer> _rows = new ArrayList<Integer>();
            for (int i = 0; i < AdLeafTree.this.dataSet.getNumRows(); ++i) {
                _rows.add(i);
            }
            this.subVaries.add(new HashMap());
            this.numCategories = 1;
            this.rows.add(_rows);
            this.subVaries = new ArrayList<Map<Integer, Vary>>();
            this.subVaries.add(new HashMap());
        }

        public Vary(int col, int numCategories, List<Integer> supRows, int[][] discreteData) {
            int i;
            this.col = col;
            this.numCategories = numCategories;
            for (i = 0; i < numCategories; ++i) {
                this.rows.add(new ArrayList());
            }
            for (i = 0; i < numCategories; ++i) {
                this.subVaries.add(new HashedMap());
            }
            for (int i2 : supRows) {
                int index = discreteData[col][i2];
                if (index == -99) continue;
                this.rows.get(index).add(i2);
            }
        }

        public List<List<Integer>> getRows() {
            return this.rows;
        }

        public Vary getSubvary(int w, int cat) {
            Vary vary = this.subVaries.get(cat).get(w);
            if (vary == null) {
                vary = new Vary(w, AdLeafTree.this.dims[w], this.rows.get(cat), AdLeafTree.this.discreteData);
                this.subVaries.get(cat).put(w, vary);
            }
            return vary;
        }

        public int getNumCategories() {
            return this.numCategories;
        }
    }
}

