/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.LocalDiscreteScore;
import java.util.List;
import org.apache.commons.math3.special.Gamma;

public class BDeScore
implements LocalDiscreteScore {
    private final DataSet dataSet;

    public BDeScore(DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        if (!dataSet.isDiscrete()) {
            throw new IllegalArgumentException("Need a discrete data set.");
        }
        this.dataSet = dataSet;
    }

    @Override
    public double localScore(int i, int[] parents) {
        int r = this.numCategories(i);
        int[] dims = new int[parents.length];
        for (int p = 0; p < parents.length; ++p) {
            dims[p] = this.numCategories(parents[p]);
        }
        int q = 1;
        for (int p = 0; p < parents.length; ++p) {
            q *= dims[p];
        }
        int[][] n_ijk = new int[q][r];
        int[] n_ij = new int[q];
        int[] values = new int[parents.length];
        for (int n = 0; n < this.sampleSize(); ++n) {
            for (int p = 0; p < parents.length; ++p) {
                int parentValue = this.dataSet().getInt(n, parents[p]);
                if (parentValue == -99) {
                    throw new IllegalStateException("Please remove or impute missing values.");
                }
                values[p] = parentValue;
            }
            int childValue = this.dataSet().getInt(n, i);
            if (childValue == -99) {
                throw new IllegalStateException("Please remove or impute missing values (record " + n + " column " + i + ")");
            }
            int rowIndex = this.getRowIndex(dims, values);
            int[] nArray = n_ijk[rowIndex];
            int n2 = childValue;
            nArray[n2] = nArray[n2] + 1;
        }
        for (int j = 0; j < q; ++j) {
            for (int k = 0; k < r; ++k) {
                int n = j;
                n_ij[n] = n_ij[n] + n_ijk[j][k];
            }
        }
        double score = 0.0;
        for (int j = 0; j < q; ++j) {
            for (int k = 0; k < r; ++k) {
                double nPrimeijk = 1.0 / (double)(r * q);
                score += Gamma.logGamma((double)n_ijk[j][k] + nPrimeijk);
                score -= Gamma.logGamma(nPrimeijk);
            }
            double nPrimeij = 1.0 / (double)q;
            score += Gamma.logGamma(nPrimeij);
            score -= Gamma.logGamma((double)n_ij[j] + nPrimeij);
        }
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, this.append(z, x)) - this.localScore(y, z);
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScore(y, x) - this.localScore(y);
    }

    int[] append(int[] parents, int extra) {
        int[] all = new int[parents.length + 1];
        System.arraycopy(parents, 0, all, 0, parents.length);
        all[parents.length] = extra;
        return all;
    }

    @Override
    public double localScore(int i, int parent) {
        return this.localScore(i, new int[]{parent});
    }

    @Override
    public double localScore(int i) {
        return this.localScore(i, new int[0]);
    }

    @Override
    public DataSet getDataSet() {
        return this.dataSet;
    }

    private int getRowIndex(int[] dim, int[] values) {
        int rowIndex = 0;
        for (int i = 0; i < dim.length; ++i) {
            rowIndex *= dim[i];
            rowIndex += values[i];
        }
        return rowIndex;
    }

    private int sampleSize() {
        return this.dataSet().getNumRows();
    }

    private int numCategories(int i) {
        return ((DiscreteVariable)this.dataSet().getVariable(i)).getNumCategories();
    }

    private DataSet dataSet() {
        return this.dataSet;
    }

    @Override
    public void setStructurePrior(double structurePrior) {
    }

    @Override
    public void setSamplePrior(double samplePrior) {
    }

    @Override
    public List<Node> getVariables() {
        return this.dataSet.getVariables();
    }

    @Override
    public int getSampleSize() {
        return this.dataSet.getNumRows();
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > -20.0;
    }

    @Override
    public Node getVariable(String targetName) {
        for (Node node : this.dataSet.getVariables()) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getMaxDegree() {
        return 1000;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    @Override
    public String toString() {
        return "BDe Score";
    }
}

