/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Bes;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.TeyssierScorerExperimental;
import java.util.ArrayList;
import java.util.List;

public class Bdce {
    private final List<Node> variables;
    private final TeyssierScorerExperimental scorer;
    private final Bes bes;
    private boolean verbose = true;
    private int depth = -1;
    private int numStarts = 1;

    public Bdce(Score score) {
        this.variables = new ArrayList<Node>(score.getVariables());
        this.scorer = new TeyssierScorerExperimental(score);
        this.bes = new Bes(score);
        this.bes.setDepth(this.depth);
        this.bes.setVerbose(false);
    }

    public Graph search() {
        Graph bestGraph = null;
        double best = Double.NEGATIVE_INFINITY;
        for (int r = 0; r < this.numStarts; ++r) {
            double s1;
            this.scorer.shuffleOrder();
            double s2 = this.scorer.getScore();
            do {
                s1 = s2;
                this.divide(0, this.scorer.size() / 2, this.scorer.size());
                Graph graph = this.scorer.getGraph(true);
                this.bes.bes(graph, this.variables);
                this.scorer.setOrder(graph);
            } while ((s2 = this.scorer.getScore()) > s1);
            if (s2 < best) continue;
            bestGraph = this.scorer.getGraph(true);
            best = s2;
        }
        return bestGraph;
    }

    public void divide(int a, int b, int c) {
        if (a < b - 1) {
            this.divide(a, (a + b) / 2, b);
        }
        if (b < c - 1) {
            this.divide(b, (b + c) / 2, c);
        }
        this.conquer(a, b, c);
    }

    public void conquer(int a, int b, int c) {
        for (int i = b; i < c; ++i) {
            for (int j = a; !(j >= b || this.scorer.hasParent(i, j) && this.scorer.tuck(i, j)); ++j) {
            }
        }
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public List<Node> getVariables() {
        return this.variables;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth should be >= -1.");
        }
        this.depth = depth;
    }
}

