/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.BDeuScore;
import edu.cmu.tetrad.search.IBDeuScore;
import java.util.ArrayList;
import java.util.List;

public class BdeuScoreImages
implements IBDeuScore {
    private final List<BDeuScore> scores;
    private final List<Node> variables;
    private int sampleSize;
    private boolean verbose;
    private double samplePrior = 1.0;
    private double structurePrior = 1.0;

    public BdeuScoreImages(List<DataModel> dataModels) {
        if (dataModels == null) {
            throw new NullPointerException();
        }
        ArrayList<BDeuScore> scores = new ArrayList<BDeuScore>();
        for (DataModel model : dataModels) {
            if (model instanceof DataSet) {
                DataSet dataSet = (DataSet)model;
                if (!dataSet.isDiscrete()) {
                    throw new IllegalArgumentException("Datasets must be discrete.");
                }
                scores.add(new BDeuScore(dataSet));
                continue;
            }
            throw new IllegalArgumentException("Only continuous data sets and covariance matrices may be used as input.");
        }
        List<Node> variables = ((BDeuScore)scores.get(0)).getVariables();
        for (int i = 2; i < scores.size(); ++i) {
            ((BDeuScore)scores.get(i)).setVariables(variables);
        }
        this.scores = scores;
        this.variables = variables;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        double sum = 0.0;
        for (BDeuScore score : this.scores) {
            sum += score.localScoreDiff(x, y, z);
        }
        return sum / (double)this.scores.size();
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScoreDiff(x, y, new int[0]);
    }

    @Override
    public double localScore(int i, int[] parents) {
        double sum = 0.0;
        for (BDeuScore score : this.scores) {
            sum += score.localScore(i, parents);
        }
        double score = sum / (double)this.scores.size();
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    public double localScore(int i, int[] parents, int index) {
        return this.localScoreOneDataSet(i, parents, index);
    }

    private double localScoreOneDataSet(int i, int[] parents, int index) {
        return this.scores.get(index).localScore(i, parents);
    }

    @Override
    public double localScore(int i, int parent) {
        double sum = 0.0;
        for (BDeuScore score : this.scores) {
            sum += score.localScore(i, parent);
        }
        return sum / (double)this.scores.size();
    }

    @Override
    public double localScore(int i) {
        double sum = 0.0;
        for (BDeuScore score : this.scores) {
            sum += score.localScore(i);
        }
        return sum / (double)this.scores.size();
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return false;
    }

    public DataSet getDataSet() {
        throw new UnsupportedOperationException();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public int getSampleSize() {
        return this.scores.get(0).getSampleSize();
    }

    @Override
    public double getSamplePrior() {
        return this.samplePrior;
    }

    @Override
    public void setSamplePrior(double samplePrior) {
        for (BDeuScore score : this.scores) {
            score.setSamplePrior(samplePrior);
        }
        this.samplePrior = samplePrior;
    }

    @Override
    public double getStructurePrior() {
        return this.structurePrior;
    }

    @Override
    public void setStructurePrior(double structurePrior) {
        for (BDeuScore score : this.scores) {
            score.setStructurePrior(structurePrior);
        }
        this.structurePrior = structurePrior;
    }

    @Override
    public Node getVariable(String targetName) {
        for (Node node : this.variables) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getMaxDegree() {
        return 1000;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    @Override
    public String toString() {
        return "BDeu Score Images";
    }
}

