/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Boss;
import edu.cmu.tetrad.search.FciOrient;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MagSemBicScore;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SepsetsGreedy;
import edu.cmu.tetrad.search.TeyssierScorer;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class BfciFoo
implements GraphSearch {
    private final Score score;
    private final TetradLogger logger = TetradLogger.getInstance();
    ICovarianceMatrix covarianceMatrix;
    private IndependenceTest test;
    private boolean completeRuleSetUsed = true;
    private int maxPathLength = -1;
    private boolean verbose;
    private PrintStream out = System.out;
    private int numStarts = 1;
    private int depth = -1;
    private boolean useRaskuttiUhler;
    private boolean useDataOrder = true;
    private boolean useScore = true;
    private boolean doDiscriminatingPathRule = true;
    private Knowledge knowledge = new Knowledge();
    private Boss.AlgType algType = Boss.AlgType.BOSS1;

    public BfciFoo(IndependenceTest test, Score score) {
        this.test = test;
        this.score = score;
    }

    @Override
    public Graph search() {
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getTest() + ".");
        TeyssierScorer scorer = new TeyssierScorer(this.test, this.score);
        Boss boss = new Boss(scorer);
        boss.setAlgType(this.algType);
        boss.setUseScore(this.useScore);
        boss.setUseRaskuttiUhler(this.useRaskuttiUhler);
        boss.setUseDataOrder(this.useDataOrder);
        boss.setDepth(this.depth);
        boss.setNumStarts(this.numStarts);
        boss.setVerbose(false);
        List<Node> variables = this.score.getVariables();
        assert (variables != null);
        boss.bestOrder(variables);
        Graph graph = boss.getGraph(false);
        if (this.score instanceof MagSemBicScore) {
            ((MagSemBicScore)this.score).setMag(graph);
        }
        Knowledge knowledge2 = new Knowledge(this.knowledge);
        for (Edge edge : graph.getEdges()) {
            if (edge.getEndpoint1() == Endpoint.TAIL) {
                edge.setEndpoint1(Endpoint.CIRCLE);
            }
            if (edge.getEndpoint2() != Endpoint.TAIL) continue;
            edge.setEndpoint2(Endpoint.CIRCLE);
        }
        SepsetsGreedy sepsets = new SepsetsGreedy(graph, this.test, null, this.depth);
        FciOrient fciOrient = new FciOrient(sepsets);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setKnowledge(knowledge2);
        fciOrient.doFinalOrientation(graph);
        return graph;
    }

    private static void triangleReduce1(Graph graph, TeyssierScorer scorer, Knowledge knowledge) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Edge edge : graph.getEdges()) {
                int[] choice;
                Node b;
                Node a = edge.getNode1();
                if (!graph.isAdjacentTo(a, b = edge.getNode2())) continue;
                List<Node> inTriangle = graph.getAdjacentNodes(a);
                inTriangle.retainAll(graph.getAdjacentNodes(b));
                HashSet<Node> _all = new HashSet<Node>(inTriangle);
                _all.addAll(graph.getAdjacentNodes(a));
                _all.addAll(graph.getAdjacentNodes(b));
                ArrayList<Node> all = new ArrayList<Node>(_all);
                SublistGenerator gen = new SublistGenerator(all.size(), all.size());
                double maxScore = Double.NEGATIVE_INFINITY;
                ArrayList<Node> maxAfter = null;
                boolean remove = false;
                while ((choice = gen.next()) != null) {
                    List<Node> before = GraphUtils.asList(choice, all);
                    ArrayList<Node> after = new ArrayList<Node>(inTriangle);
                    after.removeAll(before);
                    ArrayList<Node> perm = new ArrayList<Node>(before);
                    perm.add(a);
                    perm.add(b);
                    perm.addAll(after);
                    double score = scorer.score(perm);
                    if (!(score >= maxScore) || scorer.adjacent(a, b)) continue;
                    maxScore = score;
                    maxAfter = after;
                    remove = !scorer.adjacent(a, b);
                }
                if (!remove) continue;
                for (Node x : maxAfter) {
                    changed = true;
                    graph.removeEdge(a, b);
                    graph.setEndpoint(a, x, Endpoint.ARROW);
                    graph.setEndpoint(b, x, Endpoint.ARROW);
                    if (graph.getEndpoint(x, a) == Endpoint.CIRCLE && knowledge.isForbidden(a.getName(), x.getName())) {
                        graph.setEndpoint(x, a, Endpoint.ARROW);
                    }
                    if (graph.getEndpoint(x, b) != Endpoint.CIRCLE || !knowledge.isForbidden(b.getName(), x.getName())) continue;
                    graph.setEndpoint(x, b, Endpoint.ARROW);
                }
            }
        }
    }

    private static void triangleReduce2(Graph graph, TeyssierScorer scorer0, Knowledge knowledge) {
        TeyssierScorer scorer = new TeyssierScorer(scorer0);
        EdgeListGraph origGaph = new EdgeListGraph(graph);
        for (Edge edge : graph.getEdges()) {
            Node a = edge.getNode1();
            Node b = edge.getNode2();
            BfciFoo.t2visit(origGaph, graph, scorer0, knowledge, scorer, a, b);
            BfciFoo.t2visit(origGaph, graph, scorer0, knowledge, scorer, b, a);
        }
    }

    private static boolean t2visit(Graph origGraph, Graph graph, TeyssierScorer scorer0, Knowledge knowledge, TeyssierScorer scorer, Node a, Node b) {
        int[] choice;
        if (!graph.isAdjacentTo(a, b)) {
            return false;
        }
        boolean changed = false;
        List<Node> _inTriangle = origGraph.getAdjacentNodes(a);
        _inTriangle.retainAll(origGraph.getAdjacentNodes(b));
        List<Node> parents = origGraph.getParents(a);
        parents.remove(b);
        for (Node n : _inTriangle) {
            parents.remove(n);
        }
        ArrayList<Node> inTriangle = new ArrayList<Node>();
        ArrayList<Node> all = new ArrayList<Node>();
        for (Node n : scorer0.getPi()) {
            if (_inTriangle.contains(n)) {
                inTriangle.add(n);
            }
            if (!_inTriangle.contains(n) && n != a && n != b) continue;
            all.add(n);
        }
        if (_inTriangle.isEmpty()) {
            return false;
        }
        SublistGenerator gen = new SublistGenerator(all.size(), all.size());
        double maxScore = Double.NEGATIVE_INFINITY;
        ArrayList maxAfter = null;
        boolean remove = false;
        while ((choice = gen.next()) != null) {
            int[] choice2;
            List<Node> before = GraphUtils.asList(choice, all);
            ArrayList after = new ArrayList(inTriangle);
            after.removeAll(before);
            SublistGenerator gen2 = new SublistGenerator(parents.size(), -1);
            while ((choice2 = gen2.next()) != null) {
                List<Node> p = GraphUtils.asList(choice2, parents);
                ArrayList<Node> perm = new ArrayList<Node>(p);
                for (Node n : all) {
                    perm.remove(n);
                    perm.add(n);
                }
                for (Node n : after) {
                    perm.remove(n);
                    perm.add(n);
                }
                double score = scorer.score(perm);
                if (!(score >= maxScore) || scorer.adjacent(a, b)) continue;
                maxScore = score;
                maxAfter = after;
                remove = !scorer.adjacent(a, b);
            }
        }
        if (remove) {
            for (Node x : maxAfter) {
                changed = true;
                graph.removeEdge(a, b);
                if (graph.isAdjacentTo(a, x)) {
                    graph.setEndpoint(a, x, Endpoint.ARROW);
                }
                if (!graph.isAdjacentTo(b, x)) continue;
                graph.setEndpoint(b, x, Endpoint.ARROW);
            }
        }
        return changed;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getTest() {
        return this.test;
    }

    public void setTest(IndependenceTest test) {
        this.test = test;
    }

    public ICovarianceMatrix getCovMatrix() {
        return this.covarianceMatrix;
    }

    public ICovarianceMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public void setCovarianceMatrix(ICovarianceMatrix covarianceMatrix) {
        this.covarianceMatrix = covarianceMatrix;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setUseRaskuttiUhler(boolean useRaskuttiUhler) {
        this.useRaskuttiUhler = useRaskuttiUhler;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    public void setUseDataOrder(boolean useDataOrder) {
        this.useDataOrder = useDataOrder;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public void setAlgType(Boss.AlgType algType) {
        this.algType = algType;
    }
}

