/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Boss;
import edu.cmu.tetrad.search.FciOrient;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndTestScore;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SepsetsGreedy;
import edu.cmu.tetrad.search.TeyssierScorer;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class BfciTr
implements GraphSearch {
    private final Score score;
    private final TetradLogger logger = TetradLogger.getInstance();
    ICovarianceMatrix covarianceMatrix;
    private IndependenceTest test;
    private boolean completeRuleSetUsed = true;
    private int maxPathLength = -1;
    private boolean verbose;
    private PrintStream out = System.out;
    private int numStarts = 1;
    private int depth = 4;
    private boolean useRaskuttiUhler;
    private boolean useDataOrder = true;
    private boolean useScore = true;
    private boolean doDiscriminatingPathRule = true;
    private boolean possibleDsepSearchDone = true;
    private Knowledge knowledge = new Knowledge();
    private Boss.AlgType algType = Boss.AlgType.BOSS1;

    public BfciTr(IndependenceTest test, Score score) {
        this.test = test;
        this.score = score;
    }

    @Override
    public Graph search() {
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getTest() + ".");
        TeyssierScorer scorer = new TeyssierScorer(this.test, this.score);
        Boss boss = new Boss(scorer);
        boss.setAlgType(this.algType);
        boss.setUseScore(this.useScore);
        boss.setUseRaskuttiUhler(this.useRaskuttiUhler);
        boss.setUseDataOrder(this.useDataOrder);
        boss.setDepth(this.depth);
        boss.setNumStarts(this.numStarts);
        boss.setCaching(true);
        boss.setVerbose(false);
        List<Node> variables = this.score.getVariables();
        assert (variables != null);
        boss.bestOrder(variables);
        Graph graph = boss.getGraph(false);
        this.test = new IndTestScore(this.score);
        this.knowledge = new Knowledge(this.knowledge);
        GraphUtils.retainUnshieldedColliders(graph, this.knowledge);
        BfciTr.triangleReduce(graph, scorer, this.knowledge);
        GraphUtils.retainUnshieldedColliders(graph, this.knowledge);
        SepsetsGreedy sepsets = new SepsetsGreedy(graph, this.test, null, this.depth);
        FciOrient fciOrient = new FciOrient(sepsets);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setDoDiscriminatingPathColliderRule(true);
        fciOrient.setDoDiscriminatingPathTailRule(true);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.doFinalOrientation(graph);
        return graph;
    }

    private static void triangleReduce(Graph graph, TeyssierScorer scorer, Knowledge knowledge) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Edge edge : graph.getEdges()) {
                Node a = edge.getNode1();
                Node b = edge.getNode2();
                changed = changed || BfciTr.triangleReduceVisit(graph, scorer, knowledge, a, b);
                changed = changed || BfciTr.triangleReduceVisit(graph, scorer, knowledge, b, a);
            }
        }
    }

    private static boolean triangleReduceVisit(Graph graph, TeyssierScorer scorer, Knowledge knowledge, Node a, Node b) {
        List<Node> inTriangle = graph.getAdjacentNodes(a);
        inTriangle.retainAll(graph.getAdjacentNodes(b));
        if (graph.isAdjacentTo(a, b)) {
            Iterator iterator;
            int[] choice;
            SublistGenerator gen = new SublistGenerator(inTriangle.size(), inTriangle.size());
            double maxScore = Double.NEGATIVE_INFINITY;
            ArrayList<Node> maxAfter = null;
            boolean remove = false;
            block0: while ((choice = gen.next()) != null) {
                List<Node> before = GraphUtils.asList(choice, inTriangle);
                ArrayList<Node> after = new ArrayList<Node>(inTriangle);
                for (Node node : after) {
                    if (!knowledge.isForbidden(a.getName(), node.getName()) && !knowledge.isForbidden(b.getName(), node.getName())) continue;
                    continue block0;
                }
                after.removeAll(before);
                ArrayList<Node> perm = new ArrayList<Node>(graph.getParents(a));
                for (Node n : before) {
                    perm.remove(n);
                    perm.add(n);
                }
                perm.add(a);
                perm.add(b);
                for (Node n : after) {
                    perm.remove(n);
                    perm.add(n);
                }
                double d = scorer.score(perm);
                if (!(d > maxScore) || scorer.adjacent(a, b)) continue;
                maxScore = d;
                maxAfter = after;
                remove = !scorer.adjacent(a, b);
            }
            if (remove && (iterator = maxAfter.iterator()).hasNext()) {
                Node x = (Node)iterator.next();
                graph.removeEdge(a, b);
                graph.setEndpoint(a, x, Endpoint.ARROW);
                graph.setEndpoint(b, x, Endpoint.ARROW);
                return true;
            }
        }
        return false;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getTest() {
        return this.test;
    }

    public void setTest(IndependenceTest test) {
        this.test = test;
    }

    public ICovarianceMatrix getCovMatrix() {
        return this.covarianceMatrix;
    }

    public ICovarianceMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public void setCovarianceMatrix(ICovarianceMatrix covarianceMatrix) {
        this.covarianceMatrix = covarianceMatrix;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setUseRaskuttiUhler(boolean useRaskuttiUhler) {
        this.useRaskuttiUhler = useRaskuttiUhler;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    public void setUseDataOrder(boolean useDataOrder) {
        this.useDataOrder = useDataOrder;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }

    public void setPossibleDsepSearchDone(boolean possibleDsepSearchDone) {
        this.possibleDsepSearchDone = possibleDsepSearchDone;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public void setAlgType(Boss.AlgType algType) {
        this.algType = algType;
    }
}

