/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataBox;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.VerticalIntDataBox;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IBDeuScore;
import edu.cmu.tetrad.search.LocalDiscreteScore;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class BicScore
implements LocalDiscreteScore,
IBDeuScore {
    private List<Node> variables;
    private final int[][] data;
    private final int sampleSize;
    private double penaltyDiscount = 1.0;
    private final int[] numCategories;
    private double structurePrior = 1.0;

    public BicScore(DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException("Data was not provided.");
        }
        if (dataSet instanceof BoxDataSet && ((BoxDataSet)dataSet).getDataBox() instanceof VerticalIntDataBox) {
            DataBox dataBox = ((BoxDataSet)dataSet).getDataBox();
            this.variables = dataSet.getVariables();
            VerticalIntDataBox box = (VerticalIntDataBox)dataBox;
            this.data = box.getVariableVectors();
            this.sampleSize = box.numRows();
        } else {
            this.data = new int[dataSet.getNumColumns()][];
            this.variables = dataSet.getVariables();
            for (int j = 0; j < dataSet.getNumColumns(); ++j) {
                this.data[j] = new int[dataSet.getNumRows()];
                for (int i = 0; i < dataSet.getNumRows(); ++i) {
                    this.data[j][i] = dataSet.getInt(i, j);
                }
            }
            this.sampleSize = dataSet.getNumRows();
        }
        List<Node> variables = dataSet.getVariables();
        this.numCategories = new int[variables.size()];
        for (int i = 0; i < variables.size(); ++i) {
            this.numCategories[i] = this.getVariable(i).getNumCategories();
        }
    }

    private DiscreteVariable getVariable(int i) {
        return (DiscreteVariable)this.variables.get(i);
    }

    @Override
    public double localScore(int node, int[] parents) {
        int rowIndex;
        if (!(this.variables.get(node) instanceof DiscreteVariable)) {
            throw new IllegalArgumentException("Not discrete: " + this.variables.get(node));
        }
        for (int t : parents) {
            if (this.variables.get(t) instanceof DiscreteVariable) continue;
            throw new IllegalArgumentException("Not discrete: " + this.variables.get(t));
        }
        int c = this.numCategories[node];
        int[] dims = new int[parents.length];
        for (int p = 0; p < parents.length; ++p) {
            dims[p] = this.numCategories[parents[p]];
        }
        int r = 1;
        for (int p = 0; p < parents.length; ++p) {
            r *= dims[p];
        }
        int[][] n_jk = new int[r][c];
        int[] n_j = new int[r];
        int[] parentValues = new int[parents.length];
        int[][] myParents = new int[parents.length][];
        for (int i = 0; i < parents.length; ++i) {
            myParents[i] = this.data[parents[i]];
        }
        int[] myChild = this.data[node];
        int N = 0;
        block4: for (int i = 0; i < this.sampleSize; ++i) {
            for (int p = 0; p < parents.length; ++p) {
                if (myParents[p][i] == -99) continue block4;
                parentValues[p] = myParents[p][i];
            }
            int childValue = myChild[i];
            if (childValue == -99) continue;
            rowIndex = BicScore.getRowIndex(dims, parentValues);
            int[] nArray = n_jk[rowIndex];
            int n = childValue;
            nArray[n] = nArray[n] + 1;
            int n2 = rowIndex;
            n_j[n2] = n_j[n2] + 1;
            ++N;
        }
        double lik = 0.0;
        for (rowIndex = 0; rowIndex < r; ++rowIndex) {
            for (int childValue = 0; childValue < c; ++childValue) {
                int cellCount = n_jk[rowIndex][childValue];
                int rowCount = n_j[rowIndex];
                if (cellCount == 0) continue;
                lik += (double)cellCount * FastMath.log((double)cellCount / (double)rowCount);
            }
        }
        int params = r * (c - 1);
        double score = 2.0 * lik - this.penaltyDiscount * (double)params * FastMath.log(N) + 2.0 * this.getPriorForStructure(parents.length);
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    private double getPriorForStructure(int numParents) {
        double e = this.getStructurePrior();
        int vm = this.data.length - 1;
        return (double)numParents * FastMath.log(e / (double)vm) + (double)(vm - numParents) * FastMath.log(1.0 - e / (double)vm);
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, this.append(z, x)) - this.localScore(y, z);
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScore(y, x) - this.localScore(y);
    }

    int[] append(int[] parents, int extra) {
        int[] all = new int[parents.length + 1];
        System.arraycopy(parents, 0, all, 0, parents.length);
        all[parents.length] = extra;
        return all;
    }

    @Override
    public double localScore(int node, int parent) {
        return this.localScore(node, new int[]{parent});
    }

    @Override
    public double localScore(int node) {
        return this.localScore(node, new int[0]);
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    @Override
    public DataSet getDataSet() {
        throw new UnsupportedOperationException();
    }

    private static int getRowIndex(int[] dim, int[] values) {
        int rowIndex = 0;
        for (int i = 0; i < dim.length; ++i) {
            rowIndex *= dim[i];
            rowIndex += values[i];
        }
        return rowIndex;
    }

    @Override
    public double getStructurePrior() {
        return this.structurePrior;
    }

    @Override
    public double getSamplePrior() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStructurePrior(double structurePrior) {
        this.structurePrior = structurePrior;
    }

    @Override
    public void setSamplePrior(double samplePrior) {
        throw new UnsupportedOperationException();
    }

    public void setVariables(List<Node> variables) {
        for (int i = 0; i < variables.size(); ++i) {
            if (variables.get(i).getName().equals(this.variables.get(i).getName())) continue;
            throw new IllegalArgumentException("Variable in index " + (i + 1) + " does not have the same name as the variable being substituted for it.");
        }
        this.variables = variables;
    }

    public double getPenaltyDiscount() {
        return this.penaltyDiscount;
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        this.penaltyDiscount = penaltyDiscount;
    }

    @Override
    public Node getVariable(String targetName) {
        for (Node node : this.variables) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getMaxDegree() {
        return 1000;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    @Override
    public String toString() {
        return "BIC Score";
    }
}

