/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.graph.OrderedPair;
import edu.cmu.tetrad.search.Bes;
import edu.cmu.tetrad.search.GraphScore;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.TeyssierScorer;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Boss {
    private final List<Node> variables;
    private final Score score;
    private IndependenceTest test;
    private Knowledge knowledge = new Knowledge();
    private final TeyssierScorer scorer;
    private long start;
    long stop;
    private boolean useScore = true;
    private boolean useRaskuttiUhler;
    private boolean useDataOrder = true;
    private boolean verbose = true;
    private int depth = -1;
    private int numStarts = 1;
    private AlgType algType = AlgType.BOSS1;
    private boolean caching = true;
    private double epsilon = 1.0E-10;

    public Boss(@NotNull IndependenceTest test, Score score) {
        this.test = test;
        this.score = score;
        this.variables = new ArrayList<Node>(score.getVariables());
        this.useScore = true;
        this.scorer = new TeyssierScorer(this.test, this.score);
    }

    public Boss(Score score) {
        this.test = null;
        this.score = score;
        this.variables = new ArrayList<Node>(score.getVariables());
        this.useScore = true;
        this.scorer = new TeyssierScorer(null, this.score);
    }

    public Boss(TeyssierScorer scorer) {
        this.scorer = scorer;
        this.score = scorer.getScoreObject();
        this.variables = new ArrayList<Node>(scorer.getPi());
    }

    public List<Node> bestOrder(@NotNull List<Node> order) {
        this.scorer.setCachingScores(this.caching);
        this.scorer.setKnowledge(this.knowledge);
        long start = MillisecondTimes.timeMillis();
        order = new ArrayList<Node>(order);
        this.scorer.setUseRaskuttiUhler(this.useRaskuttiUhler);
        if (this.useRaskuttiUhler) {
            this.scorer.setUseScore(false);
        } else {
            this.scorer.setUseScore(this.useScore && !(this.score instanceof GraphScore));
        }
        this.scorer.setKnowledge(this.knowledge);
        this.scorer.clearBookmarks();
        List<Node> bestPerm = null;
        double best = Double.NEGATIVE_INFINITY;
        this.scorer.score(order);
        for (int r = 0; r < this.numStarts; ++r) {
            double s1;
            double s2;
            if (r == 0 && !this.useDataOrder || r > 0) {
                RandomUtil.shuffle(order);
            }
            this.start = MillisecondTimes.timeMillis();
            this.makeValidKnowledgeOrder(order);
            boolean count = false;
            if (this.algType == AlgType.BOSS1) {
                this.betterMutation1(this.scorer);
            } else if (this.algType == AlgType.BOSS2) {
                this.betterMutation2(this.scorer);
            } else if (this.algType == AlgType.BOSS3) {
                this.betterMutationBryan(this.scorer);
            }
            do {
                s1 = this.scorer.score();
                if (this.algType == AlgType.BOSS1) {
                    this.besMutation(this.scorer);
                    this.betterMutation1(this.scorer);
                    continue;
                }
                if (this.algType == AlgType.BOSS2) {
                    this.besMutation(this.scorer);
                    this.betterMutation2(this.scorer);
                    continue;
                }
                if (this.algType != AlgType.BOSS3) continue;
                this.besMutation(this.scorer);
                this.betterMutationBryan(this.scorer);
            } while ((s2 = this.scorer.score()) > s1);
            if (!(this.scorer.score() > best)) continue;
            best = this.scorer.score();
            bestPerm = this.scorer.getPi();
        }
        this.scorer.score(bestPerm);
        this.stop = MillisecondTimes.timeMillis();
        if (this.verbose) {
            TetradLogger.getInstance().forceLogMessage("\nFinal " + (Object)((Object)this.algType) + " order = " + this.scorer.getPi());
            TetradLogger.getInstance().forceLogMessage("Final score = " + this.scorer.score());
            TetradLogger.getInstance().forceLogMessage("Elapsed time = " + (double)(this.stop - start) / 1000.0 + " s");
        }
        return bestPerm;
    }

    public void betterMutation1(@NotNull TeyssierScorer scorer) {
        double originalScore;
        double bestScore = scorer.score();
        scorer.bookmark();
        HashSet<Node> introns2 = new HashSet<Node>(scorer.getPi());
        int[] range = new int[2];
        do {
            originalScore = bestScore;
            HashSet<Node> introns1 = introns2;
            introns2 = new HashSet();
            for (int i = 1; i < scorer.size(); ++i) {
                Node x = scorer.get(i);
                if (!introns1.contains(x)) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!scorer.adjacent(scorer.get(j), x)) continue;
                    this.tuck(x, j, scorer, range);
                    if (scorer.score() > bestScore + this.epsilon || this.violatesKnowledge(scorer.getPi())) {
                        for (int l = range[0]; l <= range[1]; ++l) {
                            introns2.add(scorer.get(l));
                        }
                        bestScore = scorer.score();
                        scorer.bookmark();
                    } else {
                        scorer.goToBookmark();
                    }
                    if (!this.verbose) continue;
                    System.out.print("\rIndex = " + (i + 1) + " Score = " + scorer.score() + " (betterMutationTuck) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " s");
                    System.out.print("\r# Edges = " + scorer.getNumEdges() + " Index = " + (i + 1) + " Score = " + scorer.score() + " (betterMutationTuck) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " s");
                }
            }
            if (!this.verbose) continue;
            System.out.println();
        } while (bestScore > originalScore + this.epsilon);
    }

    public void betterMutation2(@NotNull TeyssierScorer scorer) {
        double s1;
        double s2;
        scorer.bookmark();
        do {
            s1 = scorer.score();
            scorer.bookmark(1);
            for (Node k : scorer.getPi()) {
                double _sp = Double.NEGATIVE_INFINITY;
                scorer.bookmark();
                for (int j = 0; j < scorer.size(); ++j) {
                    scorer.moveTo(k, j);
                    if (!(scorer.score() >= _sp + this.epsilon) || this.violatesKnowledge(scorer.getPi())) continue;
                    _sp = scorer.score();
                    scorer.bookmark();
                    if (!this.verbose) continue;
                    System.out.print("\rIndex = " + (scorer.index(k) + 1) + " Score = " + scorer.score() + " (betterMutation2) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " s");
                }
                scorer.goToBookmark();
            }
            if (!this.verbose) continue;
            System.out.println();
        } while ((s2 = scorer.score()) > s1 + this.epsilon);
        scorer.goToBookmark(1);
    }

    public void betterMutationBryan(@NotNull TeyssierScorer scorer) {
        double s1;
        double s2;
        double bestScore = scorer.score();
        scorer.bookmark();
        HashSet<Node> introns2 = new HashSet<Node>(scorer.getPi());
        int[] range = new int[2];
        do {
            s1 = scorer.score();
            HashSet<Node> introns1 = introns2;
            introns2 = new HashSet();
            List<OrderedPair<Node>> edges = scorer.getEdges();
            int m = 0;
            int all = edges.size();
            for (OrderedPair<Node> edge : edges) {
                ++m;
                Node x = edge.getFirst();
                Node y = edge.getSecond();
                if (scorer.index(x) > scorer.index(y) || !scorer.adjacent(y, x) || !introns1.contains(y) && !introns1.contains(x)) continue;
                this.tuck(y, scorer.index(x), scorer, range);
                if (scorer.score() < bestScore || this.violatesKnowledge(scorer.getPi())) {
                    scorer.goToBookmark();
                } else {
                    bestScore = scorer.score();
                    for (int l = range[0]; l <= range[1]; ++l) {
                        introns2.add(scorer.get(l));
                    }
                    if (this.verbose) {
                        System.out.print("\r Score " + m + " / " + all + " = " + scorer.score() + " (boss) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " s");
                    }
                }
                scorer.bookmark();
                if (!this.verbose) continue;
                System.out.print("\r Score " + m + " / " + all + " = " + scorer.score() + " (boss) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " s");
            }
            if (!this.verbose) continue;
            System.out.println();
        } while ((s2 = scorer.score()) > s1);
    }

    public void tubes(@NotNull TeyssierScorer scorer) {
        double s;
        do {
            s = scorer.score();
            for (NodePair edge : scorer.getAdjacencies()) {
                Node y;
                Node x = edge.getFirst();
                if (!scorer.adjacent(x, y = edge.getSecond())) continue;
                scorer.bookmark();
                this.tuck(y, scorer.index(x), scorer, new int[2]);
                if (scorer.score() >= s) {
                    this.besMutation(scorer);
                    continue;
                }
                scorer.goToBookmark();
            }
        } while (scorer.score() > s);
    }

    private void tuck(Node k, int j, TeyssierScorer scorer, int[] range) {
        if (scorer.index(k) < j) {
            return;
        }
        Set<Node> ancestors = scorer.getAncestors(k);
        int minIndex = j;
        for (int i = j + 1; i <= scorer.index(k); ++i) {
            if (!ancestors.contains(scorer.get(i))) continue;
            scorer.moveTo(scorer.get(i), j++);
        }
        range[0] = minIndex;
        range[1] = scorer.index(k);
    }

    public void besMutation(TeyssierScorer scorer) {
        Graph graph = scorer.getGraph(true);
        Bes bes = new Bes(this.score);
        bes.setDepth(this.depth);
        bes.setVerbose(false);
        bes.setKnowledge(this.knowledge);
        bes.bes(graph, scorer.getPi());
        List<Node> pi = graph.paths().validOrder(scorer.getPi(), true);
        scorer.score(pi);
    }

    public int getNumEdges() {
        return this.scorer.getNumEdges();
    }

    private void makeValidKnowledgeOrder(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            order.sort((o1, o2) -> {
                if (o1.getName().equals(o2.getName())) {
                    return 0;
                }
                if (this.knowledge.isRequired(o1.getName(), o2.getName())) {
                    return -1;
                }
                if (this.knowledge.isRequired(o2.getName(), o1.getName())) {
                    return 1;
                }
                if (this.knowledge.isForbidden(o1.getName(), o2.getName())) {
                    return 1;
                }
                if (this.knowledge.isForbidden(o2.getName(), o1.getName())) {
                    return -1;
                }
                return 0;
            });
        }
        System.out.println("Initial knowledge sort order = " + order);
        if (this.violatesKnowledge(order)) {
            throw new IllegalArgumentException("The initial sorting procedure could not find a permutation consistent with that knowledge.");
        }
    }

    public Graph getGraph(boolean cpDag) {
        if (this.scorer == null) {
            throw new IllegalArgumentException("Please run algorithm first.");
        }
        Graph graph = this.scorer.getGraph(cpDag);
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        graph.addAttribute("score ", nf.format(this.scorer.score()));
        return graph;
    }

    public void orientbk(Knowledge bk, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(from, to, Endpoint.ARROW);
        }
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public List<Node> getVariables() {
        return this.variables;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth should be >= -1.");
        }
        this.depth = depth;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    private boolean violatesKnowledge(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            for (int i = 0; i < order.size(); ++i) {
                for (int j = i + 1; j < order.size(); ++j) {
                    if (this.knowledge.isForbidden(order.get(i).getName(), order.get(j).getName())) {
                        return true;
                    }
                    if (!this.knowledge.isRequired(order.get(j).getName(), order.get(i).getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setUseRaskuttiUhler(boolean useRaskuttiUhler) {
        this.useRaskuttiUhler = useRaskuttiUhler;
    }

    public void setUseDataOrder(boolean useDataOrder) {
        this.useDataOrder = useDataOrder;
    }

    public void setAlgType(AlgType algType) {
        this.algType = algType;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public static enum AlgType {
        BOSS1,
        BOSS2,
        BOSS3;

    }
}

