/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Bes;
import edu.cmu.tetrad.search.Boss;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.TeyssierScorer;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BossDC {
    private final List<Node> variables;
    private final Score score;
    private final TeyssierScorer scorer;
    private boolean useDataOrder = true;
    private boolean verbose = true;
    private int depth = -1;
    private int numStarts = 1;
    private Boss.AlgType algType = Boss.AlgType.BOSS1;
    private boolean caching = true;

    public BossDC(Score score) {
        this.score = score;
        this.variables = new ArrayList<Node>(score.getVariables());
        this.scorer = new TeyssierScorer(null, this.score);
    }

    public BossDC(TeyssierScorer scorer) {
        this.scorer = scorer;
        this.score = scorer.getScoreObject();
        this.variables = new ArrayList<Node>(scorer.getPi());
    }

    /*
     * Unable to fully structure code
     */
    public List<Node> bestOrder(@NotNull List<Node> order) {
        this.scorer.setCachingScores(this.caching);
        this.scorer.setUseRaskuttiUhler(false);
        this.scorer.setUseScore(true);
        this.scorer.clearBookmarks();
        bestPerm = null;
        best = -Infinity;
        order = new ArrayList<Node>(order);
        this.scorer.score(order);
        for (r = 0; r < this.numStarts; ++r) {
            if (r == 0 && !this.useDataOrder || r > 0) {
                RandomUtil.shuffle(order);
            }
            s2 = this.scorer.score();
            do lbl-1000:
            // 3 sources

            {
                s1 = s2;
                this.divide(this.scorer, 0, this.scorer.size() / 2, this.scorer.size());
                s2 = this.scorer.score();
                if (s2 > s1) ** GOTO lbl-1000
                this.besMutation(this.scorer);
            } while ((s2 = this.scorer.score()) > s1);
            if (!(this.scorer.score() > best)) continue;
            best = this.scorer.score();
            bestPerm = this.scorer.getPi();
        }
        this.scorer.score(bestPerm);
        return bestPerm;
    }

    public void divide(@NotNull TeyssierScorer scorer, int a, int b, int c) {
        if (a < b - 1) {
            this.divide(scorer, a, (a + b) / 2, b);
        }
        if (b < c - 1) {
            this.divide(scorer, b, (b + c) / 2, c);
        }
        if (this.algType == Boss.AlgType.BOSS1) {
            this.conquerRTL(scorer, a, b, c);
        } else if (this.algType == Boss.AlgType.BOSS2) {
            this.conquerLTR(scorer, a, b, c);
        } else if (this.algType == Boss.AlgType.BOSS3) {
            this.conquerMT(scorer, a, b, c);
        }
    }

    public void conquerRTL(@NotNull TeyssierScorer scorer, int a, int b, int c) {
        double currentScore;
        double bestScore = currentScore = scorer.score();
        scorer.bookmark();
        for (int i = b; i < c; ++i) {
            Node x = scorer.get(i);
            Set<Node> ancestors = scorer.getAncestors(x);
            for (int j = b - 1; j >= a; --j) {
                if (!scorer.adjacent(scorer.get(j), x)) continue;
                this.tuck(x, j, scorer, ancestors);
                currentScore = scorer.score();
                if (!(currentScore > bestScore + 1.0E-10)) continue;
                bestScore = currentScore;
                ancestors = scorer.getAncestors(x);
                scorer.bookmark();
            }
            if (!(currentScore < bestScore + 1.0E-10)) continue;
            scorer.goToBookmark();
        }
    }

    public void conquerLTR(@NotNull TeyssierScorer scorer, int a, int b, int c) {
        double currentScore;
        double bestScore = currentScore = scorer.score();
        scorer.bookmark();
        block0: for (int i = b; i < c; ++i) {
            Node x = scorer.get(i);
            for (int j = a; j < b; ++j) {
                if (!scorer.adjacent(scorer.get(j), x)) continue;
                this.tuck(x, j, scorer);
                currentScore = scorer.score();
                if (currentScore > bestScore + 1.0E-10) {
                    bestScore = currentScore;
                    scorer.bookmark();
                    continue block0;
                }
                scorer.goToBookmark();
            }
        }
    }

    public void conquerMT(@NotNull TeyssierScorer scorer, int a, int b, int c) {
        int j;
        Node x;
        int i;
        double currentScore;
        double bestScore = currentScore = scorer.score();
        scorer.bookmark();
        for (i = a; i < b; ++i) {
            x = scorer.get(i);
            for (j = c - 1; j >= b; --j) {
                scorer.moveTo(x, j);
                currentScore = scorer.score();
                if (!(currentScore > bestScore + 1.0E-10)) continue;
                bestScore = currentScore;
                scorer.bookmark();
            }
            if (!(currentScore < bestScore + 1.0E-10)) continue;
            scorer.goToBookmark();
        }
        for (i = b; i < c; ++i) {
            x = scorer.get(i);
            for (j = b - 1; j >= a; --j) {
                scorer.moveTo(x, j);
                currentScore = scorer.score();
                if (!(currentScore > bestScore + 1.0E-10)) continue;
                bestScore = currentScore;
                scorer.bookmark();
            }
            if (!(currentScore < bestScore + 1.0E-10)) continue;
            scorer.goToBookmark();
        }
    }

    private void tuck(Node k, int j, TeyssierScorer scorer) {
        if (scorer.index(k) < j) {
            return;
        }
        Set<Node> ancestors = scorer.getAncestors(k);
        for (int i = j + 1; i <= scorer.index(k); ++i) {
            if (!ancestors.contains(scorer.get(i))) continue;
            scorer.moveTo(scorer.get(i), j++);
        }
    }

    private void tuck(Node k, int j, TeyssierScorer scorer, Set<Node> ancestors) {
        if (scorer.index(k) < j) {
            return;
        }
        for (int i = j + 1; i <= scorer.index(k); ++i) {
            if (!ancestors.contains(scorer.get(i))) continue;
            scorer.moveTo(scorer.get(i), j++);
        }
    }

    public void besMutation(TeyssierScorer scorer) {
        Graph graph = scorer.getGraph(true);
        Bes bes = new Bes(this.score);
        bes.setDepth(this.depth);
        bes.setVerbose(false);
        bes.bes(graph, scorer.getPi());
        List<Node> pi = graph.paths().validOrder(scorer.getPi(), true);
        scorer.score(pi);
    }

    public int getNumEdges() {
        return this.scorer.getNumEdges();
    }

    public Graph getGraph(boolean cpDag) {
        if (this.scorer == null) {
            throw new IllegalArgumentException("Please run algorithm first.");
        }
        Graph graph = this.scorer.getGraph(cpDag);
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        graph.addAttribute("score ", nf.format(this.scorer.score()));
        return graph;
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public List<Node> getVariables() {
        return this.variables;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth should be >= -1.");
        }
        this.depth = depth;
    }

    public void setUseDataOrder(boolean useDataOrder) {
        this.useDataOrder = useDataOrder;
    }

    public void setAlgType(Boss.AlgType algType) {
        this.algType = algType;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public static enum AlgType {
        BOSS1,
        BOSS2,
        BOSS3;

    }
}

