/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Bes;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.TeyssierScorer2;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BossMB {
    private final List<Node> variables;
    private final Score score;
    private Knowledge knowledge = new Knowledge();
    private TeyssierScorer2 scorer;
    private long start;
    private boolean useDataOrder = true;
    private boolean verbose = true;
    private int depth = 4;
    private int numStarts = 1;
    private boolean findMb = false;
    private Graph graph;

    public BossMB(@NotNull Score score) {
        this.score = score;
        this.variables = new ArrayList<Node>(score.getVariables());
    }

    public List<Node> bestOrder(@NotNull List<Node> order, List<Node> targets) {
        long start = MillisecondTimes.timeMillis();
        order = new ArrayList<Node>(order);
        this.scorer = new TeyssierScorer2(this.score);
        this.scorer.setKnowledge(this.knowledge);
        this.scorer.clearBookmarks();
        List<Node> bestPerm = null;
        int bestSize = this.scorer.size();
        this.scorer.score(order);
        System.out.println("Initial score = " + this.scorer.score());
        for (int r = 0; r < this.numStarts; ++r) {
            List<Node> pi1;
            Iterator<Node> pi2;
            if (r == 0 && !this.useDataOrder || r > 0) {
                RandomUtil.shuffle(order);
            }
            this.start = MillisecondTimes.timeMillis();
            this.makeValidKnowledgeOrder(order);
            do {
                pi1 = this.scorer.getPi();
                this.betterMutationBoss(this.scorer, targets);
            } while (!(pi2 = this.besOrder(this.scorer)).equals(pi1));
            if (this.scorer.size() > bestSize) continue;
            bestSize = this.scorer.size();
            bestPerm = this.scorer.getPi();
        }
        this.scorer.score(bestPerm);
        this.graph = this.scorer.getGraph(false);
        if (this.findMb) {
            HashSet mb = new HashSet();
            for (Node n : this.graph.getNodes()) {
                for (Node t : targets) {
                    if (this.graph.isAdjacentTo(t, n)) {
                        mb.add(n);
                        continue;
                    }
                    for (Node m : this.graph.getChildren(t)) {
                        if (!this.graph.isParentOf(n, m)) continue;
                        mb.add(n);
                    }
                }
            }
            block5: for (Node n : this.graph.getNodes()) {
                for (Node t : targets) {
                    if (t != n) continue;
                    continue block5;
                }
                if (mb.contains(n)) continue;
                this.graph.removeNode(n);
            }
        } else {
            for (Edge e : this.graph.getEdges()) {
                if (targets.contains(e.getNode1()) || targets.contains(e.getNode2())) continue;
                this.graph.removeEdge(e);
            }
        }
        this.graph = SearchGraphUtils.cpdagForDag(this.graph);
        long stop = MillisecondTimes.timeMillis();
        if (this.verbose) {
            TetradLogger.getInstance().forceLogMessage("Final order = " + this.scorer.getPi());
            TetradLogger.getInstance().forceLogMessage("Elapsed time = " + (double)(stop - start) / 1000.0 + " s");
        }
        return bestPerm;
    }

    public void setFindMb(boolean findMb) {
        this.findMb = findMb;
    }

    public void betterMutationBoss(@NotNull TeyssierScorer2 scorer, List<Node> targets) {
        List<Node> p2;
        List<Node> p1;
        do {
            p1 = scorer.getPi();
            Graph g = scorer.getGraph(false);
            HashSet<Node> keep = new HashSet<Node>(targets);
            for (Node n : targets) {
                keep.addAll(g.getAdjacentNodes(n));
            }
            if (this.findMb) {
                for (Node k : new HashSet<Node>(keep)) {
                    keep.addAll(g.getAdjacentNodes(k));
                }
            }
            ArrayList<Node> _pi = new ArrayList<Node>();
            for (Node n : scorer.getPi()) {
                if (!keep.contains(n)) continue;
                _pi.add(n);
            }
            double sp = scorer.score(_pi);
            scorer.bookmark();
            System.out.println("After snips: # vars = " + scorer.getPi().size() + " # Edges = " + scorer.getNumEdges() + " Score = " + scorer.score() + " (betterMutation) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " s" + " order = " + scorer.getPi());
            for (Node x : scorer.getPi()) {
                int i = scorer.index(x);
                for (int j = i - 1; j >= 0; --j) {
                    if (!scorer.tuck(x, j)) continue;
                    if ((double)scorer.score() > sp && !this.violatesKnowledge(scorer.getPi())) {
                        sp = scorer.score();
                        scorer.bookmark();
                        if (!this.verbose) continue;
                        System.out.println("# vars = " + scorer.getPi().size() + " # Edges = " + scorer.getNumEdges() + " Score = " + scorer.score() + " (betterMutation) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " s");
                        continue;
                    }
                    scorer.goToBookmark();
                }
            }
        } while (!p1.equals(p2 = scorer.getPi()));
    }

    public List<Node> besOrder(TeyssierScorer2 scorer) {
        Graph graph = scorer.getGraph(true);
        Bes bes = new Bes(this.score);
        bes.setDepth(this.depth);
        bes.setVerbose(this.verbose);
        bes.setKnowledge(this.knowledge);
        bes.bes(graph, scorer.getPi());
        return graph.paths().validOrder(scorer.getPi(), true);
    }

    public int getNumEdges() {
        return this.scorer.getNumEdges();
    }

    private void makeValidKnowledgeOrder(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            order.sort((o1, o2) -> {
                if (o1.getName().equals(o2.getName())) {
                    return 0;
                }
                if (this.knowledge.isRequired(o1.getName(), o2.getName())) {
                    return 1;
                }
                if (this.knowledge.isRequired(o2.getName(), o1.getName())) {
                    return -1;
                }
                if (this.knowledge.isForbidden(o2.getName(), o1.getName())) {
                    return -1;
                }
                if (this.knowledge.isForbidden(o1.getName(), o2.getName())) {
                    return 1;
                }
                return 1;
            });
        }
    }

    @NotNull
    public Graph getGraph() {
        return this.graph;
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public List<Node> getVariables() {
        return this.variables;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth should be >= -1.");
        }
        this.depth = depth;
    }

    private boolean violatesKnowledge(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            for (int i = 0; i < order.size(); ++i) {
                for (int j = i + 1; j < order.size(); ++j) {
                    if (!this.knowledge.isForbidden(order.get(i).getName(), order.get(j).getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setUseDataOrder(boolean useDataOrder) {
        this.useDataOrder = useDataOrder;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public static enum AlgType {
        BOSS_OLD,
        BOSS;

    }
}

