/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.GraphScore;
import edu.cmu.tetrad.search.GraphScorer;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.ISemBicScore;
import edu.cmu.tetrad.search.LocalDiscreteScore;
import edu.cmu.tetrad.search.Score;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class Bridges2
implements GraphSearch,
GraphScorer {
    private Knowledge knowledge = new Knowledge();
    private final List<Node> variables;
    private final Score score;
    private final HashMap<Node, Integer> hashIndices;
    private PrintStream out = System.out;
    private Graph adjacencies = null;
    private int maxDegree = -1;

    public Bridges2(Score score) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.score = score;
        this.variables = score.getVariables();
        this.hashIndices = new HashMap();
        for (int i = 0; i < this.variables.size(); ++i) {
            this.hashIndices.put(this.variables.get(i), i);
        }
    }

    @Override
    public Graph search() {
        Fges fges = new Fges(this.score);
        Graph g0 = fges.search();
        double s0 = fges.getModelScore();
        boolean flag = true;
        while (flag && !Thread.interrupted()) {
            flag = false;
            Iterator<Edge> edges = g0.getEdges().iterator();
            while (!flag && edges.hasNext()) {
                Edge edge = edges.next();
                if (!edge.isDirected()) continue;
                EdgeListGraph g = new EdgeListGraph(g0);
                Node a = Edges.getDirectedEdgeHead(edge);
                Node b = Edges.getDirectedEdgeTail(edge);
                for (Node c : g.getAdjacentNodes(b)) {
                    if (!g.paths().existsSemidirectedPath(c, a)) continue;
                    g.removeEdge(g.getEdge(b, c));
                    g.addDirectedEdge(c, b);
                }
                Edge reversed = edge.reverse();
                g.removeEdge(edge);
                g.addEdge(reversed);
                fges.setInitialGraph(g);
                Graph g1 = fges.search();
                double s1 = fges.getModelScore();
                if (!(s1 > s0)) continue;
                flag = true;
                g0 = g1;
                s0 = s1;
                this.getOut().println(g0.getNumEdges());
            }
        }
        return g0;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public Graph getAdjacencies() {
        return this.adjacencies;
    }

    public void setAdjacencies(Graph adjacencies) {
        this.adjacencies = adjacencies;
    }

    public double getPenaltyDiscount() {
        if (this.score instanceof ISemBicScore) {
            return ((ISemBicScore)this.score).getPenaltyDiscount();
        }
        return 2.0;
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        if (this.score instanceof ISemBicScore) {
            ((ISemBicScore)this.score).setPenaltyDiscount(penaltyDiscount);
        }
    }

    public void setSamplePrior(double samplePrior) {
        if (this.score instanceof LocalDiscreteScore) {
            ((LocalDiscreteScore)this.score).setSamplePrior(samplePrior);
        }
    }

    public void setStructurePrior(double expectedNumParents) {
        if (this.score instanceof LocalDiscreteScore) {
            ((LocalDiscreteScore)this.score).setStructurePrior(expectedNumParents);
        }
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public void setMaxDegree(int maxDegree) {
        if (maxDegree < -1) {
            throw new IllegalArgumentException();
        }
        this.maxDegree = maxDegree;
    }

    @Override
    public double scoreDag(Graph dag) {
        if (this.score instanceof GraphScore) {
            return 0.0;
        }
        dag = GraphUtils.replaceNodes(dag, this.getVariables());
        Score score = this.score.defaultScore();
        double _score = 0.0;
        for (Node node : this.getVariables()) {
            List<Node> x = dag.getParents(node);
            int[] parentIndices = new int[x.size()];
            int count = 0;
            for (Node parent : x) {
                parentIndices[count++] = this.hashIndices.get(parent);
            }
            double nodeScore = score.localScore((int)this.hashIndices.get(node), parentIndices);
            node.addAttribute("Score", nodeScore);
            _score += nodeScore;
        }
        dag.addAttribute("Score", _score);
        return _score;
    }

    private List<Node> getVariables() {
        return this.variables;
    }
}

