/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.util.RandomUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BridgesOld {
    private final List<Node> variables;
    private final Fges ges;
    private final MeekRules meeks;
    private Knowledge knowledge = new Knowledge();

    public BridgesOld(@NotNull Score score) {
        this.variables = new ArrayList<Node>(score.getVariables());
        this.ges = new Fges(score);
        this.meeks = new MeekRules();
    }

    public Graph search() {
        Graph g0 = this.ges.search();
        double s0 = this.ges.getModelScore();
        boolean flag = true;
        while (flag && !Thread.interrupted()) {
            flag = false;
            ArrayList<Edge> edges = new ArrayList<Edge>(g0.getEdges());
            RandomUtil.shuffle(edges);
            Iterator edgeItr = edges.iterator();
            while (!flag && edgeItr.hasNext()) {
                Edge edge = (Edge)edgeItr.next();
                if (!edge.isDirected()) continue;
                EdgeListGraph g = new EdgeListGraph((EdgeListGraph)g0);
                Node a = Edges.getDirectedEdgeHead(edge);
                Node b = Edges.getDirectedEdgeTail(edge);
                for (Node c : g.getAdjacentNodes(b)) {
                    if (c != a && !g.paths().existsSemidirectedPath(c, a)) continue;
                    g.removeEdge(g.getEdge(b, c));
                    g.addDirectedEdge(c, b);
                }
                this.meeks.orientImplied(g);
                this.ges.setInitialGraph(g);
                Graph g1 = this.ges.search();
                double s1 = this.ges.getModelScore();
                if (!(s1 > s0)) continue;
                flag = true;
                g0 = g1;
                s0 = s1;
                this.getOut().println(g0.getNumEdges());
            }
        }
        return g0;
    }

    public List<Node> getVariables() {
        return this.variables;
    }

    public int getMaxDegree() {
        return this.ges.getMaxDegree();
    }

    public void setMaxDegree(int maxDegree) {
        this.ges.setMaxDegree(maxDegree);
    }

    public void setSymmetricFirstStep(boolean symmetricFirstStep) {
        this.ges.setSymmetricFirstStep(symmetricFirstStep);
    }

    public void setFaithfulnessAssumed(boolean faithfulnessAssumed) {
        this.ges.setFaithfulnessAssumed(faithfulnessAssumed);
    }

    public void setParallelized(boolean parallelized) {
        this.ges.setParallelized(parallelized);
    }

    public void setVerbose(boolean verbose) {
        this.ges.setVerbose(verbose);
    }

    public PrintStream getOut() {
        return this.ges.getOut();
    }

    public void setOut(PrintStream out) {
        this.ges.setOut(out);
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }
}

