/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.ClusterSignificance;
import edu.cmu.tetrad.search.ClusterUtils;
import edu.cmu.tetrad.search.ContinuousTetradTest;
import edu.cmu.tetrad.search.DiscreteTetradTest;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestGSquare;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.search.TetradTest;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public final class BuildPureClusters {
    private boolean outputMessage;
    private ICovarianceMatrix covarianceMatrix;
    private int numVariables;
    private TestType sigTestType;
    private int[] labels;
    private boolean scoreTestMode;
    final int EDGE_NONE = 0;
    final int EDGE_BLACK = 1;
    final int EDGE_GRAY = 2;
    final int EDGE_BLUE = 3;
    final int EDGE_YELLOW = 4;
    final int EDGE_RED = 4;
    final int MAX_CLIQUE_TRIALS = 50;
    private TetradTest tetradTest;
    private IndependenceTest independenceTest;
    private DataSet dataSet;
    private double alpha;
    private boolean verbose;
    private ClusterSignificance.CheckType checkType = ClusterSignificance.CheckType.Clique;

    public BuildPureClusters(ICovarianceMatrix covarianceMatrix, double alpha, TestType sigTestType) {
        if (covarianceMatrix == null) {
            throw new IllegalArgumentException("Covariance matrix cannot be null.");
        }
        this.covarianceMatrix = covarianceMatrix;
        this.initAlgorithm(alpha, sigTestType);
    }

    public BuildPureClusters(CovarianceMatrix covarianceMatrix, double alpha, TestType sigTestType) {
        if (covarianceMatrix == null) {
            throw new IllegalArgumentException("Covariance matrix cannot be null.");
        }
        this.covarianceMatrix = covarianceMatrix;
        this.initAlgorithm(alpha, sigTestType);
    }

    public BuildPureClusters(DataSet dataSet, double alpha, TestType sigTestType) {
        if (dataSet.isContinuous()) {
            this.dataSet = dataSet;
            this.covarianceMatrix = new CovarianceMatrix(dataSet);
            this.initAlgorithm(alpha, sigTestType);
        } else if (dataSet.isDiscrete()) {
            throw new IllegalArgumentException("Discrete data is not supported for this search.");
        }
    }

    private void initAlgorithm(double alpha, TestType sigTestType) {
        if (this.getCovarianceMatrix() != null && DataUtils.containsMissingValue(this.getCovarianceMatrix().getMatrix())) {
            throw new IllegalArgumentException("Please remove or impute missing values first.");
        }
        this.alpha = alpha;
        this.outputMessage = true;
        this.sigTestType = sigTestType;
        boolean bl = this.scoreTestMode = this.sigTestType == TestType.DISCRETE || this.sigTestType == TestType.GAUSSIAN_FACTOR;
        if (sigTestType == TestType.DISCRETE) {
            this.numVariables = this.dataSet.getNumColumns();
            this.independenceTest = new IndTestGSquare(this.dataSet, alpha);
            this.tetradTest = new DiscreteTetradTest(this.dataSet, alpha);
        } else {
            assert (this.getCovarianceMatrix() != null);
            this.numVariables = this.getCovarianceMatrix().getSize();
            this.independenceTest = new IndTestFisherZ(this.getCovarianceMatrix(), 0.1);
            if (sigTestType != TestType.TETRAD_WISHART && sigTestType != TestType.TETRAD_DELTA && sigTestType != TestType.GAUSSIAN_FACTOR) {
                throw new IllegalArgumentException("Expecting TETRAD_WISHART, TETRAD_DELTA, or GAUSSIAN FACTOR " + sigTestType);
            }
            TestType type = sigTestType;
            this.tetradTest = this.dataSet != null ? new ContinuousTetradTest(this.dataSet, type, alpha) : new ContinuousTetradTest(this.getCovarianceMatrix(), type, alpha);
        }
        this.labels = new int[this.numVariables()];
        for (int i = 0; i < this.numVariables(); ++i) {
            this.labels[i] = i + 1;
        }
    }

    public Graph search() {
        long start = MillisecondTimes.timeMillis();
        TetradLogger.getInstance().log("info", "BPC alpha = " + this.alpha + " test = " + this.sigTestType);
        List<Node> variables = this.tetradTest.getVariables();
        List<int[]> clustering = this.findMeasurementPattern(variables);
        clustering.removeIf(cluster -> ((int[])cluster).length < 3);
        HashSet<Set<Integer>> clusters = new HashSet<Set<Integer>>();
        for (int[] _c : clustering) {
            HashSet<Integer> cluster2 = new HashSet<Integer>();
            for (int i : _c) {
                cluster2.add(i);
            }
            clusters.add(cluster2);
        }
        ClusterUtils.logClusters(clusters, variables);
        Graph graph = this.convertSearchGraph(clustering);
        TetradLogger.getInstance().log("graph", "\nReturning this graph: " + graph);
        long stop = MillisecondTimes.timeMillis();
        long elapsed = stop - start;
        TetradLogger.getInstance().log("elapsed", "Elapsed " + elapsed + " ms");
        HashSet<List<Integer>> _clustering = new HashSet<List<Integer>>();
        for (int[] _cluster : clustering) {
            ArrayList<Integer> __cluster = new ArrayList<Integer>();
            for (int i : _cluster) {
                __cluster.add(i);
            }
            _clustering.add(__cluster);
        }
        ClusterSignificance clusterSignificance = new ClusterSignificance(variables, this.covarianceMatrix);
        clusterSignificance.printClusterPValues(_clustering);
        return graph;
    }

    private Graph convertSearchGraph(List<int[]> clusters) {
        int i;
        List<Node> nodes = this.tetradTest.getVariables();
        EdgeListGraph graph = new EdgeListGraph(nodes);
        ArrayList<GraphNode> latents = new ArrayList<GraphNode>();
        for (i = 0; i < clusters.size(); ++i) {
            GraphNode latent = new GraphNode("_L" + (i + 1));
            latent.setNodeType(NodeType.LATENT);
            latents.add(latent);
            graph.addNode(latent);
        }
        for (i = 0; i < latents.size(); ++i) {
            for (int j : clusters.get(i)) {
                graph.addDirectedEdge((Node)latents.get(i), nodes.get(j));
            }
        }
        return graph;
    }

    private boolean clusteredPartial1(int v1, int v2, int v3, int v4) {
        if (this.scoreTestMode) {
            return !this.tetradTest.oneFactorTest(v1, v2, v3, v4);
        }
        return !this.tetradTest.tetradScore3(v1, v2, v3, v4);
    }

    private boolean validClusterPairPartial1(int v1, int v2, int v3, int v4, int[][] cv) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(v1, v2, v3, v4);
        }
        if (cv[v1][v4] == this.EDGE_NONE && cv[v2][v4] == this.EDGE_NONE && cv[v3][v4] == this.EDGE_NONE) {
            return true;
        }
        boolean test1 = this.tetradTest.tetradHolds(v1, v2, v3, v4);
        boolean test2 = this.tetradTest.tetradHolds(v1, v2, v4, v3);
        if (test1 && test2) {
            return true;
        }
        boolean test3 = this.tetradTest.tetradHolds(v1, v3, v4, v2);
        return test1 && test3 || test2 && test3;
    }

    private boolean clusteredPartial2(int v1, int v2, int v3, int v4, int v5) {
        if (this.scoreTestMode) {
            return !this.tetradTest.oneFactorTest(v1, v2, v3, v5) || this.tetradTest.oneFactorTest(v1, v2, v3, v4, v5) || !this.tetradTest.twoFactorTest(v1, v2, v3, v4, v5);
        }
        return !this.tetradTest.tetradScore3(v1, v2, v3, v5) || !this.tetradTest.tetradScore1(v1, v2, v4, v5) || !this.tetradTest.tetradScore1(v2, v3, v4, v5) || !this.tetradTest.tetradScore1(v1, v3, v4, v5);
    }

    private boolean validClusterPairPartial2(int v1, int v2, int v3, int v5, int[][] cv) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(v1, v2, v3, v5);
        }
        if (cv[v1][v5] == this.EDGE_NONE && cv[v2][v5] == this.EDGE_NONE && cv[v3][v5] == this.EDGE_NONE) {
            return true;
        }
        boolean test1 = this.tetradTest.tetradHolds(v1, v2, v3, v5);
        boolean test2 = this.tetradTest.tetradHolds(v1, v2, v5, v3);
        boolean test3 = this.tetradTest.tetradHolds(v1, v3, v5, v2);
        return test1 && test2 || test1 && test3 || test2 && test3;
    }

    private boolean unclusteredPartial3(int v1, int v2, int v3, int v4, int v5, int v6) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(v1, v2, v3, v6) && this.tetradTest.oneFactorTest(v4, v5, v6, v1) && this.tetradTest.oneFactorTest(v4, v5, v6, v2) && this.tetradTest.oneFactorTest(v4, v5, v6, v3) && this.tetradTest.twoFactorTest(v1, v2, v3, v4, v5, v6);
        }
        return this.tetradTest.tetradScore3(v1, v2, v3, v6) && this.tetradTest.tetradScore3(v4, v5, v6, v1) && this.tetradTest.tetradScore3(v4, v5, v6, v2) && this.tetradTest.tetradScore3(v4, v5, v6, v3) && this.tetradTest.tetradScore1(v1, v2, v4, v6) && this.tetradTest.tetradScore1(v1, v2, v5, v6) && this.tetradTest.tetradScore1(v2, v3, v4, v6) && this.tetradTest.tetradScore1(v2, v3, v5, v6) && this.tetradTest.tetradScore1(v1, v3, v4, v6) && this.tetradTest.tetradScore1(v1, v3, v5, v6);
    }

    private boolean validClusterPairPartial3(int v1, int v2, int v3, int v4, int v5, int v6, int[][] cv) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(v1, v2, v3, v6) && this.tetradTest.oneFactorTest(v4, v5, v6, v1) && this.tetradTest.oneFactorTest(v4, v5, v6, v2) && this.tetradTest.oneFactorTest(v4, v5, v6, v3);
        }
        if (cv[v1][v6] == this.EDGE_NONE && cv[v2][v6] == this.EDGE_NONE && cv[v3][v6] == this.EDGE_NONE) {
            return true;
        }
        boolean test1 = this.tetradTest.tetradHolds(v1, v2, v3, v6);
        boolean test2 = this.tetradTest.tetradHolds(v1, v2, v6, v3);
        boolean test3 = this.tetradTest.tetradHolds(v1, v3, v6, v2);
        if (!(test1 && test2 || test1 && test3 || test2 && test3)) {
            return false;
        }
        test1 = this.tetradTest.tetradHolds(v4, v5, v6, v1);
        test2 = this.tetradTest.tetradHolds(v4, v5, v1, v6);
        test3 = this.tetradTest.tetradHolds(v4, v6, v1, v5);
        if (!(test1 && test2 || test1 && test3 || test2 && test3)) {
            return false;
        }
        test1 = this.tetradTest.tetradHolds(v4, v5, v6, v2);
        test2 = this.tetradTest.tetradHolds(v4, v5, v2, v6);
        test3 = this.tetradTest.tetradHolds(v4, v6, v2, v5);
        if (!(test1 && test2 || test1 && test3 || test2 && test3)) {
            return false;
        }
        test1 = this.tetradTest.tetradHolds(v4, v5, v6, v3);
        test2 = this.tetradTest.tetradHolds(v4, v5, v3, v6);
        test3 = this.tetradTest.tetradHolds(v4, v6, v3, v5);
        return test1 && test2 || test1 && test3 || test2 && test3;
    }

    private boolean partialRule1_1(int x1, int x2, int x3, int y1) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(x1, y1, x2, x3);
        }
        return this.tetradTest.tetradScore3(x1, y1, x2, x3);
    }

    private boolean partialRule1_2(int x1, int x2, int y1, int y2) {
        if (this.scoreTestMode) {
            return !this.tetradTest.oneFactorTest(x1, x2, y1, y2) && this.tetradTest.twoFactorTest(x1, x2, y1, y2);
        }
        return !this.tetradTest.tetradHolds(x1, x2, y2, y1) && !this.tetradTest.tetradHolds(x1, y1, x2, y2) && this.tetradTest.tetradHolds(x1, y1, y2, x2);
    }

    private boolean partialRule1_3(int x1, int y1, int y2, int y3) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(x1, y1, y2, y3);
        }
        return this.tetradTest.tetradScore3(x1, y1, y2, y3);
    }

    private boolean partialRule2_1(int x1, int x2, int y1, int y2) {
        if (this.scoreTestMode) {
            return !this.tetradTest.oneFactorTest(x1, x2, y1, y2) && this.tetradTest.twoFactorTest(x1, x2, y1, y2);
        }
        return this.tetradTest.tetradHolds(x1, y1, y2, x2) && !this.tetradTest.tetradHolds(x1, x2, y2, y1) && !this.tetradTest.tetradHolds(x1, y1, x2, y2) && this.tetradTest.tetradHolds(x1, y1, y2, x2);
    }

    private boolean partialRule2_2(int x1, int x2, int x3, int y2) {
        if (this.scoreTestMode) {
            return this.tetradTest.twoFactorTest(x1, x3, x2, y2);
        }
        return this.tetradTest.tetradHolds(x1, x2, y2, x3);
    }

    private boolean partialRule2_3(int x2, int y1, int y2, int y3) {
        if (this.scoreTestMode) {
            this.tetradTest.twoFactorTest(x2, y2, y1, y3);
        }
        return this.tetradTest.tetradHolds(x2, y1, y3, y2);
    }

    private boolean uncorrelated(int v1, int v2) {
        if (this.getCovarianceMatrix() != null) {
            List<Node> variables = this.getCovarianceMatrix().getVariables();
            return this.getIndependenceTest().checkIndependence(variables.get(v1), variables.get(v2), new Node[0]).independent();
        }
        return this.getIndependenceTest().checkIndependence(this.dataSet.getVariable(v1), this.dataSet.getVariable(v2), new Node[0]).independent();
    }

    private void printClustering(List<int[]> clustering) {
        for (int[] cluster : clustering) {
            this.printClusterNames(cluster);
        }
    }

    private void printClusterIds(int[] c) {
        int i;
        int[] sorted = new int[c.length];
        for (i = 0; i < c.length; ++i) {
            sorted[i] = this.labels[c[i]];
        }
        for (i = 0; i < sorted.length - 1; ++i) {
            int min = Integer.MAX_VALUE;
            int min_idx = -1;
            for (int j = i; j < sorted.length; ++j) {
                if (sorted[j] >= min) continue;
                min = sorted[j];
                min_idx = j;
            }
            int temp = sorted[i];
            sorted[i] = min;
            sorted[min_idx] = temp;
        }
    }

    private void printClusterNames(int[] c) {
        int i;
        String[] sorted = new String[c.length];
        for (i = 0; i < c.length; ++i) {
            sorted[i] = this.tetradTest.getVarNames()[c[i]];
        }
        for (i = 0; i < sorted.length - 1; ++i) {
            String min = sorted[i];
            int min_idx = i;
            for (int j = i + 1; j < sorted.length; ++j) {
                if (sorted[j].compareTo(min) >= 0) continue;
                min = sorted[j];
                min_idx = j;
            }
            String temp = sorted[i];
            sorted[i] = min;
            sorted[min_idx] = temp;
        }
    }

    private void printLatentClique(int[] latents) {
        int[] sorted = new int[latents.length];
        System.arraycopy(latents, 0, sorted, 0, latents.length);
        for (int i = 0; i < sorted.length - 1; ++i) {
            int min = Integer.MAX_VALUE;
            int min_idx = -1;
            for (int j = i; j < sorted.length; ++j) {
                if (sorted[j] >= min) continue;
                min = sorted[j];
                min_idx = j;
            }
            int temp = sorted[i];
            sorted[i] = min;
            sorted[min_idx] = temp;
        }
    }

    private List<int[]> findComponents(int[][] graph, int size) {
        boolean[] marked = new boolean[size];
        for (int i = 0; i < size; ++i) {
            marked[i] = false;
        }
        int numMarked = 0;
        ArrayList<int[]> output = new ArrayList<int[]>();
        int[] tempComponent = new int[size];
        while (numMarked != size) {
            boolean noChange;
            int sizeTemp = 0;
            do {
                noChange = true;
                for (int i = 0; i < size; ++i) {
                    if (marked[i]) continue;
                    boolean inComponent = false;
                    for (int j = 0; j < sizeTemp; ++j) {
                        if (graph[i][tempComponent[j]] != 3) continue;
                        inComponent = true;
                        break;
                    }
                    if (sizeTemp != 0 && !inComponent) continue;
                    tempComponent[sizeTemp++] = i;
                    marked[i] = true;
                    noChange = false;
                    ++numMarked;
                }
            } while (!noChange);
            if (sizeTemp <= true) continue;
            int[] newPartition = new int[sizeTemp];
            System.arraycopy(tempComponent, 0, newPartition, 0, sizeTemp);
            output.add(newPartition);
        }
        return output;
    }

    private List<int[]> findMaximalCliques(int[] elements, int[][] ng) {
        boolean[][] connected = new boolean[this.numVariables()][this.numVariables()];
        for (int i = 0; i < connected.length; ++i) {
            for (int j = i; j < connected.length; ++j) {
                if (i != j) {
                    boolean bl = ng[i][j] != this.EDGE_NONE;
                    connected[j][i] = bl;
                    connected[i][j] = bl;
                    continue;
                }
                connected[i][j] = true;
            }
        }
        int[] numCalls = new int[1];
        int[] c = new int[1];
        ArrayList<int[]> output = new ArrayList<int[]>();
        int[] compsub = new int[elements.length];
        int[] old = new int[elements.length];
        System.arraycopy(elements, 0, old, 0, elements.length);
        this.findMaximalCliquesOperator(numCalls, output, connected, compsub, c, old, 0, elements.length);
        return output;
    }

    private void findMaximalCliquesOperator(int[] numCalls, List<int[]> output, boolean[][] connected, int[] compsub, int[] c, int[] old, int ne, int ce) {
        int p;
        int i;
        if (numCalls[0] > this.MAX_CLIQUE_TRIALS) {
            return;
        }
        int[] newA = new int[ce];
        int fixp = -1;
        int pos = -1;
        int s = -1;
        int minnod = ce;
        int nod = 0;
        for (i = 0; i < ce && minnod != 0; ++i) {
            p = old[i];
            int count = 0;
            for (int j = ne; j < ce && count < minnod; ++j) {
                if (connected[p][old[j]]) continue;
                ++count;
                pos = j;
            }
            if (count >= minnod) continue;
            fixp = p;
            minnod = count;
            if (i < ne) {
                s = pos;
                continue;
            }
            s = i;
            nod = 1;
        }
        for (nod = minnod + nod; nod >= 1; --nod) {
            p = old[s];
            old[s] = old[ne];
            int sel = old[ne] = p;
            int newne = 0;
            for (i = 0; i < ne; ++i) {
                if (!connected[sel][old[i]]) continue;
                newA[newne++] = old[i];
            }
            int newce = newne;
            for (i = ne + 1; i < ce; ++i) {
                if (!connected[sel][old[i]]) continue;
                newA[newce++] = old[i];
            }
            int n = c[0];
            c[0] = n + 1;
            compsub[n] = sel;
            if (newce == 0) {
                int[] clique = new int[c[0]];
                System.arraycopy(compsub, 0, clique, 0, c[0]);
                output.add(clique);
            } else if (newne < newce) {
                numCalls[0] = numCalls[0] + 1;
                this.findMaximalCliquesOperator(numCalls, output, connected, compsub, c, newA, newne, newce);
            }
            c[0] = c[0] - 1;
            ++ne;
            if (nod <= 1) continue;
            s = ne;
            while (connected[fixp][old[s]]) {
                ++s;
            }
        }
    }

    private boolean cliqueContained(int[] newClique, int size, List<int[]> clustering) {
        for (int[] next : clustering) {
            if (size > next.length) continue;
            boolean found = true;
            block1: for (int i = 0; i < size && found; ++i) {
                found = false;
                for (int k : next) {
                    if (newClique[i] != k) continue;
                    found = true;
                    continue block1;
                }
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    private List<int[]> trimCliqueList(List<int[]> cliqueList) {
        ArrayList<int[]> trimmed = new ArrayList<int[]>();
        ArrayList<int[]> cliqueCopy = new ArrayList<int[]>(cliqueList);
        for (int[] cluster : cliqueList) {
            cliqueCopy.remove(cluster);
            if (!this.cliqueContained(cluster, cluster.length, cliqueCopy)) {
                trimmed.add(cluster);
            }
            cliqueCopy.add(cluster);
        }
        return trimmed;
    }

    private int clustersize(List<int[]> cluster) {
        int total = 0;
        for (int[] next : cluster) {
            total += next.length;
        }
        return total;
    }

    private int clustersize3(List<int[]> cluster) {
        int total = 0;
        for (int[] next : cluster) {
            if (next.length <= 2) continue;
            total += next.length;
        }
        return total;
    }

    private void sortClusterings(int start, int end, List<List<int[]>> clusterings, int[] criterion) {
        for (int i = start; i < end - 1; ++i) {
            int max = -1;
            int max_idx = -1;
            for (int j = i; j < end; ++j) {
                if (criterion[j] <= max) continue;
                max = criterion[j];
                max_idx = j;
            }
            List<int[]> temp = clusterings.get(i);
            clusterings.set(i, clusterings.get(max_idx));
            clusterings.set(max_idx, temp);
            int old_c = criterion[i];
            criterion[i] = criterion[max_idx];
            criterion[max_idx] = old_c;
        }
    }

    private int scoreClustering(List<int[]> clustering, boolean[] buffer) {
        int score = 0;
        Arrays.fill(buffer, true);
        for (int[] currentCluster : clustering) {
            block1: for (int k : currentCluster) {
                if (!buffer[k]) continue;
                for (int[] nextCluster : clustering) {
                    if (nextCluster == currentCluster) continue;
                    for (int i : nextCluster) {
                        if (k != i) continue;
                        buffer[k] = false;
                        continue block1;
                    }
                }
            }
        }
        for (int[] currentCluster : clustering) {
            int localScore = 0;
            for (int k : currentCluster) {
                if (!buffer[k]) continue;
                ++localScore;
            }
            if (localScore <= true) continue;
            score += localScore;
        }
        return score;
    }

    private List<List<int[]>> filterAndOrderClusterings(List<List<int[]>> baseListOfClusterings, List<List<Integer>> baseListOfIds, List<int[]> clusteringIds, int[][] ng, List<Node> variables) {
        int i;
        assert (clusteringIds != null);
        ArrayList<List<int[]>> listOfClusterings = new ArrayList<List<int[]>>();
        clusteringIds.clear();
        for (int i2 = 0; i2 < baseListOfClusterings.size(); ++i2) {
            ArrayList<int[]> newClustering = new ArrayList<int[]>();
            List<int[]> baseClustering = baseListOfClusterings.get(i2);
            System.out.println("* Base mimClustering");
            this.printClustering(baseClustering);
            List<Integer> baseIds = baseListOfIds.get(i2);
            ArrayList<Integer> usedIds = new ArrayList<Integer>();
            for (int j = 0; j < baseClustering.size(); ++j) {
                int[] currentCluster = baseClustering.get(j);
                ClusterSignificance clusterSignificance = new ClusterSignificance(variables, this.covarianceMatrix);
                clusterSignificance.setCheckType(this.checkType);
                List<Integer> cluster = ClusterSignificance.getInts(currentCluster);
                if (!clusterSignificance.significant(cluster, this.alpha)) continue;
                Integer currentId = baseIds.get(j);
                int[] draftArea = new int[currentCluster.length];
                int draftCount = 0;
                int[] nArray = currentCluster;
                int n = nArray.length;
                block2: for (int k = 0; k < n; ++k) {
                    int value = nArray[k];
                    for (int k2 = 0; k2 < baseClustering.size(); ++k2) {
                        int[] nextCluster;
                        if (k2 == j) continue;
                        for (int item : nextCluster = baseClustering.get(k2)) {
                            if (value == item) continue block2;
                        }
                    }
                    draftArea[draftCount++] = value;
                }
                if (draftCount <= true) continue;
                int[] newCluster = new int[draftCount];
                System.arraycopy(draftArea, 0, newCluster, 0, draftCount);
                newClustering.add(newCluster);
                usedIds.add(currentId);
            }
            System.out.println("* Filtered mimClustering 1");
            this.printClustering(newClustering);
            boolean[][] impurities = new boolean[this.numVariables()][this.numVariables()];
            for (int j = 0; j < newClustering.size() - 1; ++j) {
                int[] currentCluster = (int[])newClustering.get(j);
                for (int jj = j + 1; jj < currentCluster.length; ++jj) {
                    for (int k = 0; k < newClustering.size(); ++k) {
                        int[] nextCluster;
                        if (k == j) continue;
                        for (int value : nextCluster = (int[])newClustering.get(k)) {
                            impurities[currentCluster[jj]][value] = ng[currentCluster[jj]][value] != this.EDGE_NONE;
                            impurities[value][currentCluster[jj]] = impurities[currentCluster[jj]][value];
                        }
                    }
                }
            }
            List<int[]> newClustering2 = this.removeMarkedImpurities(newClustering, impurities);
            ArrayList<int[]> finalNewClustering = new ArrayList<int[]>();
            ArrayList<Integer> finalUsedIds = new ArrayList<Integer>();
            for (int j = 0; j < newClustering2.size(); ++j) {
                if (newClustering2.get(j).length <= 0) continue;
                finalNewClustering.add(newClustering2.get(j));
                finalUsedIds.add((Integer)usedIds.get(j));
            }
            if (finalNewClustering.size() <= 0) continue;
            listOfClusterings.add(finalNewClustering);
            int[] usedIdsArray = new int[finalUsedIds.size()];
            for (int j = 0; j < finalUsedIds.size(); ++j) {
                usedIdsArray[j] = (Integer)finalUsedIds.get(j);
            }
            clusteringIds.add(usedIdsArray);
            System.out.println("* Filtered mimClustering 2");
            this.printClustering(finalNewClustering);
            System.out.print("* ID/Size: ");
            this.printLatentClique(usedIdsArray);
            System.out.println();
        }
        int[] numIndicators = new int[listOfClusterings.size()];
        for (i = 0; i < listOfClusterings.size(); ++i) {
            numIndicators[i] = this.clustersize3((List)listOfClusterings.get(i));
        }
        this.sortClusterings(0, listOfClusterings.size(), listOfClusterings, numIndicators);
        for (i = 0; i < listOfClusterings.size(); ++i) {
            numIndicators[i] = this.clustersize((List)listOfClusterings.get(i));
        }
        int start = 0;
        while (start < listOfClusterings.size()) {
            int size3 = this.clustersize3((List)listOfClusterings.get(start));
            int end = start + 1;
            for (int j = start + 1; j < listOfClusterings.size() && size3 == this.clustersize3((List)listOfClusterings.get(j)); ++j) {
                ++end;
            }
            this.sortClusterings(start, end, listOfClusterings, numIndicators);
            start = end;
        }
        return listOfClusterings;
    }

    private List<int[]> removeMarkedImpurities(List<int[]> partition, boolean[][] impurities) {
        Object object;
        System.out.println("sizecluster = " + this.clustersize(partition));
        int[][] elements = new int[this.clustersize(partition)][3];
        int[] partitionCount = new int[partition.size()];
        int countElements = 0;
        for (int p = 0; p < partition.size(); ++p) {
            int[] next = partition.get(p);
            partitionCount[p] = 0;
            object = next;
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                int j;
                elements[countElements][0] = j = object[i];
                elements[countElements][1] = p;
                ++countElements;
                int n2 = p;
                partitionCount[n2] = partitionCount[n2] + 1;
            }
        }
        for (int i = 0; i < elements.length; ++i) {
            elements[i][2] = 0;
            for (int j = 0; j < elements.length; ++j) {
                if (!impurities[elements[i][0]][elements[j][0]]) continue;
                int[] nArray = elements[i];
                nArray[2] = nArray[2] + 1;
            }
        }
        boolean[] eliminated = new boolean[this.numVariables()];
        while (!this.validSolution(elements, eliminated)) {
            this.sortByImpurityPriority(elements, partitionCount, eliminated);
            eliminated[elements[0][0]] = true;
            for (int i = 0; i < elements.length; ++i) {
                if (!impurities[elements[i][0]][elements[0][0]]) continue;
                int[] nArray = elements[i];
                nArray[2] = nArray[2] - 1;
            }
            int n = elements[0][1];
            partitionCount[n] = partitionCount[n] - 1;
        }
        ArrayList<int[]> solution = new ArrayList<int[]>();
        object = partition.iterator();
        while (object.hasNext()) {
            int[] next = (int[])object.next();
            int[] draftArea = new int[next.length];
            int draftCount = 0;
            for (int k : next) {
                for (int[] element : elements) {
                    if (element[0] != k || eliminated[element[0]]) continue;
                    draftArea[draftCount++] = k;
                }
            }
            if (draftCount <= 0) continue;
            int[] realCluster = new int[draftCount];
            System.arraycopy(draftArea, 0, realCluster, 0, draftCount);
            solution.add(realCluster);
        }
        return solution;
    }

    private void sortByImpurityPriority(int[][] elements, int[] partitionCount, boolean[] eliminated) {
        int j;
        int total;
        int[] temp = new int[3];
        block0: for (int i = 0; i < elements.length - 1; ++i) {
            if (!eliminated[elements[i][0]]) continue;
            for (int j2 = i + 1; j2 < elements.length; ++j2) {
                if (eliminated[elements[j2][0]]) continue;
                this.swapElements(elements, i, j2, temp);
                continue block0;
            }
        }
        for (total = 0; total < elements.length && !eliminated[elements[total][0]]; ++total) {
        }
        for (int i = 0; i < total - 1; ++i) {
            int max = -1;
            int max_idx = -1;
            for (j = i; j < total; ++j) {
                if (elements[j][2] <= max) continue;
                max = elements[j][2];
                max_idx = j;
            }
            this.swapElements(elements, i, max_idx, temp);
        }
        int start = 0;
        while (start < total) {
            int i;
            int size = partitionCount[elements[start][1]];
            int end = start + 1;
            for (j = start + 1; j < total && size == partitionCount[elements[j][1]]; ++j) {
                ++end;
            }
            for (i = start + 1; i < end; ++i) {
                if (partitionCount[elements[i][1]] != 1) continue;
                this.swapElements(elements, i, start, temp);
                ++start;
            }
            for (i = start + 1; i < end; ++i) {
                if (partitionCount[elements[i][1]] != 2) continue;
                this.swapElements(elements, i, start, temp);
                ++start;
            }
            for (i = start; i < end - 1; ++i) {
                int max = -1;
                int max_idx = -1;
                for (int j3 = i; j3 < end; ++j3) {
                    if (partitionCount[elements[j3][1]] <= max) continue;
                    max = partitionCount[elements[j3][1]];
                    max_idx = j3;
                }
                this.swapElements(elements, i, max_idx, temp);
            }
            start = end;
        }
    }

    private void swapElements(int[][] elements, int i, int j, int[] buffer) {
        buffer[0] = elements[i][0];
        buffer[1] = elements[i][1];
        buffer[2] = elements[i][2];
        elements[i][0] = elements[j][0];
        elements[i][1] = elements[j][1];
        elements[i][2] = elements[j][2];
        elements[j][0] = buffer[0];
        elements[j][1] = buffer[1];
        elements[j][2] = buffer[2];
    }

    private boolean validSolution(int[][] elements, boolean[] eliminated) {
        for (int[] element : elements) {
            if (eliminated[element[0]] || element[2] <= 0) continue;
            return false;
        }
        return true;
    }

    private List<int[]> initialMeasurementPattern(int[][] ng, int[][] cv, List<Node> variables) {
        int v4;
        int v3;
        boolean notFound;
        int v2;
        int v1;
        boolean[][] notYellow = new boolean[this.numVariables()][this.numVariables()];
        for (v1 = 0; v1 < this.numVariables() - 1; ++v1) {
            for (v2 = v1 + 1; v2 < this.numVariables(); ++v2) {
                int n = this.EDGE_BLACK;
                ng[v2][v1] = n;
                ng[v1][v2] = n;
            }
        }
        for (v1 = 0; v1 < this.numVariables() - 1; ++v1) {
            for (v2 = v1 + 1; v2 < this.numVariables(); ++v2) {
                if (this.uncorrelated(v1, v2)) {
                    int n = this.EDGE_NONE;
                    cv[v2][v1] = n;
                    cv[v1][v2] = n;
                } else {
                    int n = this.EDGE_BLACK;
                    cv[v2][v1] = n;
                    cv[v1][v2] = n;
                }
                int n = cv[v1][v2];
                ng[v2][v1] = n;
                ng[v1][v2] = n;
            }
        }
        for (v1 = 0; v1 < this.numVariables() - 1; ++v1) {
            for (v2 = v1 + 1; v2 < this.numVariables(); ++v2) {
                if (ng[v1][v2] != this.EDGE_BLACK) continue;
                notFound = true;
                for (v3 = 0; v3 < this.numVariables() - 1 && notFound; ++v3) {
                    if (v1 == v3 || v2 == v3 || ng[v1][v3] == this.EDGE_NONE || ng[v1][v3] == this.EDGE_GRAY || ng[v2][v3] == this.EDGE_NONE || ng[v2][v3] == this.EDGE_GRAY) continue;
                    for (v4 = v3 + 1; v4 < this.numVariables() && notFound; ++v4) {
                        if (v1 == v4 || v2 == v4 || ng[v1][v4] == this.EDGE_NONE || ng[v1][v4] == this.EDGE_GRAY || ng[v2][v4] == this.EDGE_NONE || ng[v2][v4] == this.EDGE_GRAY || ng[v3][v4] == this.EDGE_NONE || ng[v3][v4] == this.EDGE_GRAY || !this.tetradTest.tetradScore3(v1, v2, v3, v4)) continue;
                        notFound = false;
                        int n = this.EDGE_BLUE;
                        ng[v2][v1] = n;
                        ng[v1][v2] = n;
                        int n2 = this.EDGE_BLUE;
                        ng[v3][v1] = n2;
                        ng[v1][v3] = n2;
                        int n3 = this.EDGE_BLUE;
                        ng[v4][v1] = n3;
                        ng[v1][v4] = n3;
                        int n4 = this.EDGE_BLUE;
                        ng[v3][v2] = n4;
                        ng[v2][v3] = n4;
                        int n5 = this.EDGE_BLUE;
                        ng[v4][v2] = n5;
                        ng[v2][v4] = n5;
                        int n6 = this.EDGE_BLUE;
                        ng[v4][v3] = n6;
                        ng[v3][v4] = n6;
                    }
                }
                if (!notFound) continue;
                int n = this.EDGE_GRAY;
                ng[v2][v1] = n;
                ng[v1][v2] = n;
            }
        }
        for (int i = 0; i < this.numVariables() - 1; ++i) {
            for (int j = i + 1; j < this.numVariables(); ++j) {
                notYellow[j][i] = false;
                notYellow[i][j] = false;
            }
        }
        for (v1 = 0; v1 < this.numVariables() - 1; ++v1) {
            for (v2 = v1 + 1; v2 < this.numVariables(); ++v2) {
                int v6;
                if (ng[v1][v2] != this.EDGE_BLUE) continue;
                notFound = true;
                for (v3 = 0; v3 < this.numVariables() - 1 && notFound; ++v3) {
                    if (v1 == v3 || v2 == v3 || ng[v1][v3] == this.EDGE_GRAY || ng[v2][v3] == this.EDGE_GRAY || cv[v1][v3] != this.EDGE_BLACK || cv[v2][v3] != this.EDGE_BLACK) continue;
                    for (int v5 = v3 + 1; v5 < this.numVariables() && notFound; ++v5) {
                        if (v1 == v5 || v2 == v5 || ng[v1][v5] == this.EDGE_GRAY || ng[v2][v5] == this.EDGE_GRAY || ng[v3][v5] == this.EDGE_GRAY || cv[v1][v5] != this.EDGE_BLACK || cv[v2][v5] != this.EDGE_BLACK || cv[v3][v5] != this.EDGE_BLACK || this.clusteredPartial1(v1, v3, v5, v2)) continue;
                        for (int v42 = 0; v42 < this.numVariables() - 1 && notFound; ++v42) {
                            if (v1 == v42 || v2 == v42 || v3 == v42 || v5 == v42 || ng[v1][v42] == this.EDGE_GRAY || ng[v2][v42] == this.EDGE_GRAY || ng[v3][v42] == this.EDGE_GRAY || ng[v5][v42] == this.EDGE_GRAY || cv[v1][v42] != this.EDGE_BLACK || cv[v2][v42] != this.EDGE_BLACK || cv[v3][v42] != this.EDGE_BLACK || cv[v5][v42] != this.EDGE_BLACK || this.clusteredPartial2(v1, v3, v5, v2, v42)) continue;
                            for (v6 = v42 + 1; v6 < this.numVariables() && notFound; ++v6) {
                                if (v1 == v6 || v2 == v6 || v3 == v6 || v5 == v6 || ng[v1][v6] == this.EDGE_GRAY || ng[v2][v6] == this.EDGE_GRAY || ng[v3][v6] == this.EDGE_GRAY || ng[v42][v6] == this.EDGE_GRAY || ng[v5][v6] == this.EDGE_GRAY || cv[v1][v6] != this.EDGE_BLACK || cv[v2][v6] != this.EDGE_BLACK || cv[v3][v6] != this.EDGE_BLACK || cv[v42][v6] != this.EDGE_BLACK || cv[v5][v6] != this.EDGE_BLACK || !this.unclusteredPartial3(v1, v3, v5, v2, v42, v6)) continue;
                                notFound = false;
                                int n = this.EDGE_NONE;
                                ng[v2][v1] = n;
                                ng[v1][v2] = n;
                                int n7 = this.EDGE_NONE;
                                ng[v42][v1] = n7;
                                ng[v1][v42] = n7;
                                int n8 = this.EDGE_NONE;
                                ng[v6][v1] = n8;
                                ng[v1][v6] = n8;
                                int n9 = this.EDGE_NONE;
                                ng[v2][v3] = n9;
                                ng[v3][v2] = n9;
                                int n10 = this.EDGE_NONE;
                                ng[v42][v3] = n10;
                                ng[v3][v42] = n10;
                                int n11 = this.EDGE_NONE;
                                ng[v6][v3] = n11;
                                ng[v3][v6] = n11;
                                int n12 = this.EDGE_NONE;
                                ng[v2][v5] = n12;
                                ng[v5][v2] = n12;
                                int n13 = this.EDGE_NONE;
                                ng[v42][v5] = n13;
                                ng[v5][v42] = n13;
                                int n14 = this.EDGE_NONE;
                                ng[v6][v5] = n14;
                                ng[v5][v6] = n14;
                                notYellow[v3][v1] = true;
                                notYellow[v1][v3] = true;
                                notYellow[v5][v1] = true;
                                notYellow[v1][v5] = true;
                                notYellow[v5][v3] = true;
                                notYellow[v3][v5] = true;
                                notYellow[v42][v2] = true;
                                notYellow[v2][v42] = true;
                                notYellow[v6][v2] = true;
                                notYellow[v2][v6] = true;
                                notYellow[v6][v42] = true;
                                notYellow[v42][v6] = true;
                            }
                        }
                    }
                }
                if (notYellow[v1][v2]) {
                    notFound = false;
                }
                if (notFound) {
                    for (v3 = 0; v3 < this.numVariables() && notFound; ++v3) {
                        if (v1 == v3 || v2 == v3 || ng[v1][v3] == this.EDGE_GRAY || ng[v2][v3] == this.EDGE_GRAY || cv[v1][v3] != this.EDGE_BLACK || cv[v2][v3] != this.EDGE_BLACK) continue;
                        for (v4 = 0; v4 < this.numVariables() - 2 && notFound; ++v4) {
                            if (v1 == v4 || v2 == v4 || v3 == v4 || ng[v1][v4] == this.EDGE_GRAY || ng[v2][v4] == this.EDGE_GRAY || ng[v3][v4] == this.EDGE_GRAY || cv[v1][v4] != this.EDGE_BLACK || cv[v2][v4] != this.EDGE_BLACK || cv[v3][v4] != this.EDGE_BLACK || this.clusteredPartial1(v1, v2, v3, v4)) continue;
                            for (int v5 = v4 + 1; v5 < this.numVariables() - 1 && notFound; ++v5) {
                                if (v1 == v5 || v2 == v5 || v3 == v5 || ng[v1][v5] == this.EDGE_GRAY || ng[v2][v5] == this.EDGE_GRAY || ng[v3][v5] == this.EDGE_GRAY || ng[v4][v5] == this.EDGE_GRAY || cv[v1][v5] != this.EDGE_BLACK || cv[v2][v5] != this.EDGE_BLACK || cv[v3][v5] != this.EDGE_BLACK || cv[v4][v5] != this.EDGE_BLACK || this.clusteredPartial2(v1, v2, v3, v4, v5)) continue;
                                for (v6 = v5 + 1; v6 < this.numVariables() && notFound; ++v6) {
                                    if (v1 == v6 || v2 == v6 || v3 == v6 || ng[v1][v6] == this.EDGE_GRAY || ng[v2][v6] == this.EDGE_GRAY || ng[v3][v6] == this.EDGE_GRAY || ng[v4][v6] == this.EDGE_GRAY || ng[v5][v6] == this.EDGE_GRAY || cv[v1][v6] != this.EDGE_BLACK || cv[v2][v6] != this.EDGE_BLACK || cv[v3][v6] != this.EDGE_BLACK || cv[v4][v6] != this.EDGE_BLACK || cv[v5][v6] != this.EDGE_BLACK || !this.unclusteredPartial3(v1, v2, v3, v4, v5, v6)) continue;
                                    notFound = false;
                                    int n = this.EDGE_NONE;
                                    ng[v4][v1] = n;
                                    ng[v1][v4] = n;
                                    int n15 = this.EDGE_NONE;
                                    ng[v5][v1] = n15;
                                    ng[v1][v5] = n15;
                                    int n16 = this.EDGE_NONE;
                                    ng[v6][v1] = n16;
                                    ng[v1][v6] = n16;
                                    int n17 = this.EDGE_NONE;
                                    ng[v4][v2] = n17;
                                    ng[v2][v4] = n17;
                                    int n18 = this.EDGE_NONE;
                                    ng[v5][v2] = n18;
                                    ng[v2][v5] = n18;
                                    int n19 = this.EDGE_NONE;
                                    ng[v6][v2] = n19;
                                    ng[v2][v6] = n19;
                                    int n20 = this.EDGE_NONE;
                                    ng[v4][v3] = n20;
                                    ng[v3][v4] = n20;
                                    int n21 = this.EDGE_NONE;
                                    ng[v5][v3] = n21;
                                    ng[v3][v5] = n21;
                                    int n22 = this.EDGE_NONE;
                                    ng[v6][v3] = n22;
                                    ng[v3][v6] = n22;
                                    notYellow[v2][v1] = true;
                                    notYellow[v1][v2] = true;
                                    notYellow[v3][v1] = true;
                                    notYellow[v1][v3] = true;
                                    notYellow[v3][v2] = true;
                                    notYellow[v2][v3] = true;
                                    notYellow[v5][v4] = true;
                                    notYellow[v4][v5] = true;
                                    notYellow[v6][v4] = true;
                                    notYellow[v4][v6] = true;
                                    notYellow[v6][v5] = true;
                                    notYellow[v5][v6] = true;
                                }
                            }
                        }
                    }
                }
                if (!notFound) continue;
                int[] nArray = ng[v1];
                int[] nArray2 = ng[v2];
                Objects.requireNonNull(this);
                nArray2[v1] = 4;
                nArray[v2] = 4;
            }
        }
        List<int[]> clustering = new ArrayList<int[]>();
        List<int[]> components = this.findComponents(ng, this.numVariables());
        for (int[] component : components) {
            this.printClusterIds(component);
            List<int[]> nextClustering = this.findMaximalCliques(component, ng);
            clustering.addAll(this.trimCliqueList(nextClustering));
        }
        for (int i = 0; i < clustering.size() - 1; ++i) {
            int max = 0;
            int max_idx = -1;
            for (int j = i; j < clustering.size(); ++j) {
                if (clustering.get(j).length <= max) continue;
                max = clustering.get(j).length;
                max_idx = j;
            }
            int[] temp = clustering.get(i);
            clustering.set(i, clustering.get(max_idx));
            clustering.set(max_idx, temp);
        }
        List<int[]> individualOneFactors = this.individualPurification(clustering);
        this.printClustering(individualOneFactors);
        clustering = individualOneFactors;
        ArrayList<List<Integer>> ids = new ArrayList<List<Integer>>();
        List<List<int[]>> clusterings = this.chooseClusterings(clustering, ids, true, cv);
        ArrayList<int[]> orderedIds = new ArrayList<int[]>();
        List<List<int[]>> actualClustering = this.filterAndOrderClusterings(clusterings, ids, orderedIds, ng, variables);
        return this.purify(actualClustering, orderedIds);
    }

    private List<int[]> individualPurification(List<int[]> clustering) {
        boolean oldOutputMessage = this.outputMessage;
        ArrayList<int[]> purified = new ArrayList<int[]>();
        int[] ids = new int[]{1};
        for (int[] rawCluster : clustering) {
            this.outputMessage = false;
            if (rawCluster.length <= 4) {
                this.outputMessage = oldOutputMessage;
                purified.add(rawCluster);
                continue;
            }
            ArrayList<List<int[]>> dummyClusterings = new ArrayList<List<int[]>>();
            ArrayList<int[]> dummyClustering = new ArrayList<int[]>();
            dummyClustering.add(rawCluster);
            dummyClusterings.add(dummyClustering);
            ArrayList<int[]> dummyIds = new ArrayList<int[]>();
            dummyIds.add(ids);
            List<int[]> purification = this.purify(dummyClusterings, dummyIds);
            if (purification.size() > 0) {
                purified.add(purification.get(0));
            } else {
                int[] newFakeCluster = new int[4];
                System.arraycopy(rawCluster, 0, newFakeCluster, 0, 4);
                purified.add(newFakeCluster);
            }
            this.outputMessage = oldOutputMessage;
        }
        return purified;
    }

    private boolean compatibleClusters(int[] cluster1, int[] cluster2, int[][] cv) {
        HashSet<Integer> allNodes = new HashSet<Integer>();
        for (int j : cluster1) {
            allNodes.add(j);
        }
        for (int j : cluster2) {
            allNodes.add(j);
        }
        if (allNodes.size() < cluster1.length + cluster2.length) {
            return false;
        }
        int cset1 = cluster1.length;
        int cset2 = cluster2.length;
        for (int o1 = 0; o1 < cset1 - 2; ++o1) {
            for (int o2 = o1 + 1; o2 < cset1 - 1; ++o2) {
                for (int o3 = o2 + 1; o3 < cset1; ++o3) {
                    for (int o4 = 0; o4 < cset2 - 2; ++o4) {
                        if (!this.validClusterPairPartial1(cluster1[o1], cluster1[o2], cluster1[o3], cluster2[o4], cv)) continue;
                        for (int o5 = o4 + 1; o5 < cset2 - 1; ++o5) {
                            if (!this.validClusterPairPartial2(cluster1[o1], cluster1[o2], cluster1[o3], cluster2[o5], cv)) continue;
                            for (int o6 = o5 + 1; o6 < cset2; ++o6) {
                                if (!this.validClusterPairPartial3(cluster1[o1], cluster1[o2], cluster1[o3], cluster2[o4], cluster2[o5], cluster2[o6], cv)) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        System.out.println("INCOMPATIBLE!:");
        this.printClusterNames(cluster1);
        this.printClusterNames(cluster2);
        return false;
    }

    private List<int[]> findMeasurementPattern(List<Node> variables) {
        int y3;
        int x1;
        int i;
        int[][] ng = new int[this.numVariables()][this.numVariables()];
        int[][] cv = new int[this.numVariables()][this.numVariables()];
        boolean[] selected = new boolean[this.numVariables()];
        for (int i2 = 0; i2 < this.numVariables(); ++i2) {
            selected[i2] = false;
        }
        List<int[]> initialClustering = this.initialMeasurementPattern(ng, cv, variables);
        this.printClustering(initialClustering);
        for (int[] nextCluster : initialClustering) {
            for (int j : nextCluster) {
                selected[j] = true;
            }
        }
        for (i = 0; i < this.numVariables(); ++i) {
            for (int j = 0; j < this.numVariables(); ++j) {
                block24: {
                    block25: {
                        if (!selected[i] || !selected[j]) break block24;
                        if (ng[i][j] == this.EDGE_BLUE) break block25;
                        int n = ng[i][j];
                        Objects.requireNonNull(this);
                        if (n != 4) break block24;
                    }
                    int[] nArray = ng[i];
                    Objects.requireNonNull(this);
                    nArray[j] = 4;
                    continue;
                }
                if (selected[i] && selected[j]) continue;
                int n = ng[i][j];
                Objects.requireNonNull(this);
                if (n != 4) continue;
                ng[i][j] = this.EDGE_BLUE;
            }
        }
        for (x1 = 0; x1 < this.numVariables() - 1; ++x1) {
            block6: for (int y1 = x1 + 1; y1 < this.numVariables(); ++y1) {
                if (ng[x1][y1] != this.EDGE_BLUE) continue;
                for (int x2 = 0; x2 < this.numVariables(); ++x2) {
                    if (x1 == x2 || y1 == x2 || cv[x1][x2] == this.EDGE_NONE || cv[y1][x2] == this.EDGE_NONE) continue;
                    for (int x3 = 0; x3 < this.numVariables(); ++x3) {
                        if (x1 == x3 || x2 == x3 || y1 == x3 || cv[x1][x3] == this.EDGE_NONE || cv[x2][x3] == this.EDGE_NONE || cv[y1][x3] == this.EDGE_NONE || !this.partialRule1_1(x1, x2, x3, y1)) continue;
                        for (int y2 = 0; y2 < this.numVariables(); ++y2) {
                            if (x1 == y2 || x2 == y2 || x3 == y2 || y1 == y2 || cv[x1][y2] == this.EDGE_NONE || cv[x2][y2] == this.EDGE_NONE || cv[x3][y2] == this.EDGE_NONE || cv[y1][y2] == this.EDGE_NONE || !this.partialRule1_2(x1, x2, y1, y2)) continue;
                            for (y3 = 0; y3 < this.numVariables(); ++y3) {
                                if (x1 == y3 || x2 == y3 || x3 == y3 || y1 == y3 || y2 == y3 || cv[x1][y3] == this.EDGE_NONE || cv[x2][y3] == this.EDGE_NONE || cv[x3][y3] == this.EDGE_NONE || cv[y1][y3] == this.EDGE_NONE || cv[y2][y3] == this.EDGE_NONE || !this.partialRule1_3(x1, y1, y2, y3)) continue;
                                int n = this.EDGE_NONE;
                                ng[y1][x1] = n;
                                ng[x1][y1] = n;
                                continue block6;
                            }
                        }
                    }
                }
            }
        }
        System.out.println("Trying RULE 2 now!");
        for (x1 = 0; x1 < this.numVariables() - 1; ++x1) {
            block12: for (int y1 = x1 + 1; y1 < this.numVariables(); ++y1) {
                if (ng[x1][y1] != this.EDGE_BLUE) continue;
                for (int x2 = 0; x2 < this.numVariables(); ++x2) {
                    if (x1 == x2 || y1 == x2 || cv[x1][x2] == this.EDGE_NONE || cv[y1][x2] == this.EDGE_NONE || ng[x1][x2] == this.EDGE_GRAY) continue;
                    for (int y2 = 0; y2 < this.numVariables(); ++y2) {
                        if (x1 == y2 || x2 == y2 || y1 == y2 || cv[x1][y2] == this.EDGE_NONE || cv[x2][y2] == this.EDGE_NONE || cv[y1][y2] == this.EDGE_NONE || ng[y1][y2] == this.EDGE_GRAY || !this.partialRule2_1(x1, x2, y1, y2)) continue;
                        for (int x3 = 0; x3 < this.numVariables(); ++x3) {
                            if (x1 == x3 || x2 == x3 || y1 == x3 || y2 == x3 || ng[x1][x3] == this.EDGE_GRAY || cv[x1][x3] == this.EDGE_NONE || cv[x2][x3] == this.EDGE_NONE || cv[y1][x3] == this.EDGE_NONE || cv[y2][x3] == this.EDGE_NONE || !this.partialRule2_2(x1, x2, x3, y2)) continue;
                            for (y3 = 0; y3 < this.numVariables(); ++y3) {
                                if (x1 == y3 || x2 == y3 || x3 == y3 || y1 == y3 || y2 == y3 || ng[y1][y3] == this.EDGE_GRAY || cv[x1][y3] == this.EDGE_NONE || cv[x2][y3] == this.EDGE_NONE || cv[x3][y3] == this.EDGE_NONE || cv[y1][y3] == this.EDGE_NONE || cv[y2][y3] == this.EDGE_NONE || !this.partialRule2_3(x2, y1, y2, y3)) continue;
                                int n = this.EDGE_NONE;
                                ng[y1][x1] = n;
                                ng[x1][y1] = n;
                                continue block12;
                            }
                        }
                    }
                }
            }
        }
        for (i = 0; i < this.numVariables(); ++i) {
            for (int j = 0; j < this.numVariables(); ++j) {
                int n = ng[i][j];
                Objects.requireNonNull(this);
                if (n != 4) continue;
                ng[i][j] = this.EDGE_BLUE;
            }
        }
        ArrayList<int[]> clustering = new ArrayList<int[]>();
        List<int[]> components = this.findComponents(ng, this.numVariables());
        for (int[] component : components) {
            this.printClusterIds(component);
            List<int[]> nextClustering = this.findMaximalCliques(component, ng);
            clustering.addAll(this.trimCliqueList(nextClustering));
        }
        for (int i3 = 0; i3 < clustering.size() - 1; ++i3) {
            int max = 0;
            int max_idx = -1;
            for (int j = i3; j < clustering.size(); ++j) {
                if (((int[])clustering.get(j)).length <= max) continue;
                max = ((int[])clustering.get(j)).length;
                max_idx = j;
            }
            int[] temp = (int[])clustering.get(i3);
            clustering.set(i3, (int[])clustering.get(max_idx));
            clustering.set(max_idx, temp);
        }
        this.printClustering(clustering);
        ArrayList<List<Integer>> ids = new ArrayList<List<Integer>>();
        List<List<int[]>> clusterings = this.chooseClusterings(clustering, ids, false, cv);
        ArrayList<int[]> orderedIds = new ArrayList<int[]>();
        List<List<int[]>> actualClusterings = this.filterAndOrderClusterings(clusterings, ids, orderedIds, ng, variables);
        List<int[]> finalPureModel = this.purify(actualClusterings, orderedIds);
        this.printClustering(finalPureModel);
        return finalPureModel;
    }

    private List<List<int[]>> chooseClusterings(List<int[]> clustering, List<List<Integer>> outputIds, boolean need3, int[][] cv) {
        int i;
        ArrayList<List<int[]>> clusterings = new ArrayList<List<int[]>>();
        boolean[] marked = new boolean[clustering.size()];
        boolean[] buffer = new boolean[this.numVariables()];
        int max = FastMath.min(clustering.size(), 1000);
        boolean[][] compatibility = new boolean[clustering.size()][clustering.size()];
        if (need3) {
            for (i = 0; i < clustering.size() - 1; ++i) {
                for (int j = i + 1; j < clustering.size(); ++j) {
                    boolean bl = this.compatibleClusters(clustering.get(i), clustering.get(j), cv);
                    compatibility[j][i] = bl;
                    compatibility[i][j] = bl;
                }
            }
        }
        System.out.println("Total number of clusters: " + clustering.size());
        for (i = 0; i < max; ++i) {
            int bestChoice;
            ArrayList<Integer> nextIds = new ArrayList<Integer>();
            ArrayList<int[]> newClustering = new ArrayList<int[]>();
            nextIds.add(i);
            newClustering.add(clustering.get(i));
            for (int j = 0; j < clustering.size(); ++j) {
                marked[j] = false;
            }
            marked[i] = true;
            double bestScore = clustering.get(i).length;
            do {
                bestChoice = -1;
                block5: for (int j = 0; j < clustering.size(); ++j) {
                    if (marked[j]) continue;
                    for (int[] ints : newClustering) {
                        if (!need3 || compatibility[j][clustering.indexOf(ints)]) continue;
                        marked[j] = true;
                        continue block5;
                    }
                    newClustering.add(clustering.get(j));
                    int localScore = this.scoreClustering(newClustering, buffer);
                    newClustering.remove(clustering.get(j));
                    if (!((double)localScore >= bestScore)) continue;
                    bestChoice = j;
                    bestScore = localScore;
                }
                if (bestChoice == -1) continue;
                marked[bestChoice] = true;
                newClustering.add(clustering.get(bestChoice));
                nextIds.add(bestChoice);
            } while (bestChoice > -1);
            if (!this.isNewClustering(clusterings, newClustering)) continue;
            clusterings.add(newClustering);
            outputIds.add(nextIds);
        }
        return clusterings;
    }

    private boolean isNewClustering(List<List<int[]>> clusterings, List<int[]> newClustering) {
        block0: for (List<int[]> clustering : clusterings) {
            Iterator<int[]> iterator = clustering.iterator();
            block1: while (iterator.hasNext()) {
                int[] value;
                int[] cluster = value = iterator.next();
                block2: for (int[] o : newClustering) {
                    int[] newCluster = o;
                    if (cluster.length != newCluster.length) continue;
                    block3: for (int k : cluster) {
                        for (int i : newCluster) {
                            if (k == i) continue block3;
                        }
                        continue block2;
                    }
                    continue block1;
                }
                continue block0;
            }
            return false;
        }
        return true;
    }

    private List<int[]> purify(List<List<int[]>> actualClusterings, List<int[]> clusterIds) {
        if (!actualClusterings.isEmpty()) {
            List<int[]> partition = actualClusterings.get(0);
            this.printLatentClique(clusterIds.get(0));
            Clusters clustering = new Clusters();
            int clusterId = 0;
            this.printClustering(partition);
            for (int[] codes : partition) {
                for (int code : codes) {
                    String var = this.tetradTest.getVarNames()[code];
                    clustering.addToCluster(clusterId, var);
                }
                ++clusterId;
            }
            ArrayList partition2 = new ArrayList();
            Iterator<int[]> iterator = partition.iterator();
            while (iterator.hasNext()) {
                int[] o;
                int[] clusterIndices = o = iterator.next();
                ArrayList<Node> cluster = new ArrayList<Node>();
                for (int clusterIndex : clusterIndices) {
                    cluster.add(this.tetradTest.getVariables().get(clusterIndex));
                }
                partition2.add(cluster);
            }
            System.out.println("Partition = " + partition2);
            return partition;
        }
        return new ArrayList<int[]>();
    }

    public ICovarianceMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public int numVariables() {
        return this.numVariables;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setCheckType(ClusterSignificance.CheckType checkType) {
        this.checkType = checkType;
    }
}

