/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetProducer;
import edu.cmu.tetrad.search.SepsetsSet;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Ccd
implements GraphSearch {
    private final IndependenceTest independenceTest;
    private int depth = -1;
    private Knowledge knowledge;
    private final List<Node> nodes;
    private boolean applyR1;

    public Ccd(IndependenceTest test) {
        if (test == null) {
            throw new NullPointerException();
        }
        this.independenceTest = test;
        this.nodes = test.getVariables();
    }

    @Override
    public Graph search() {
        HashMap<Triple, Set<Node>> supSepsets = new HashMap<Triple, Set<Node>>();
        Fas fas = new Fas(this.independenceTest);
        Graph psi = fas.search();
        psi.reorientAllWith(Endpoint.CIRCLE);
        SepsetsSet sepsets = new SepsetsSet(fas.getSepsets(), this.independenceTest);
        this.stepB(psi);
        this.stepC(psi, sepsets);
        this.stepD(psi, sepsets, supSepsets);
        this.stepE(supSepsets, psi);
        this.stepF(psi, sepsets, supSepsets);
        this.orientAwayFromArrow(psi);
        return psi;
    }

    private void orientAwayFromArrow(Graph graph) {
        for (Edge edge : graph.getEdges()) {
            Node n2;
            Node n1 = edge.getNode1();
            if ((edge = graph.getEdge(n1, n2 = edge.getNode2())).pointsTowards(n1)) {
                this.orientAwayFromArrow(n2, n1, graph);
                continue;
            }
            if (!edge.pointsTowards(n2)) continue;
            this.orientAwayFromArrow(n1, n2, graph);
        }
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public long getElapsedTime() {
        return 0L;
    }

    private void stepB(Graph graph) {
        Node c;
        Node b;
        Node a;
        HashMap<Triple, Double> colliders = new HashMap<Triple, Double>();
        HashMap<Triple, Double> noncolliders = new HashMap<Triple, Double>();
        for (Node node : this.nodes) {
            this.doNodeCollider(graph, colliders, noncolliders, node);
        }
        ArrayList collidersList = new ArrayList(colliders.keySet());
        ArrayList noncollidersList = new ArrayList(noncolliders.keySet());
        for (Triple triple : collidersList) {
            a = triple.getX();
            b = triple.getY();
            c = triple.getZ();
            graph.removeEdge(a, b);
            graph.removeEdge(c, b);
            graph.addDirectedEdge(a, b);
            graph.addDirectedEdge(c, b);
        }
        for (Triple triple : noncollidersList) {
            a = triple.getX();
            b = triple.getY();
            c = triple.getZ();
            graph.underlines().addUnderlineTriple(a, b, c);
        }
    }

    private void doNodeCollider(Graph graph, Map<Triple, Double> colliders, Map<Triple, Double> noncolliders, Node b) {
        int[] combination;
        List<Node> adjacentNodes = graph.getAdjacentNodes(b);
        if (adjacentNodes.size() < 2) {
            return;
        }
        ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
        while ((combination = cg.next()) != null) {
            int[] comb3;
            int[] comb2;
            Node c;
            Node a = adjacentNodes.get(combination[0]);
            if (graph.isAdjacentTo(a, c = adjacentNodes.get(combination[1]))) continue;
            List<Node> adja = graph.getAdjacentNodes(a);
            double score = Double.POSITIVE_INFINITY;
            List<Node> S = null;
            SublistGenerator cg2 = new SublistGenerator(adja.size(), -1);
            while ((comb2 = cg2.next()) != null) {
                List<Node> s = GraphUtils.asList(comb2, adja);
                this.independenceTest.checkIndependence(a, c, s);
                double _score = this.independenceTest.getScore();
                if (!(_score < score)) continue;
                score = _score;
                S = s;
            }
            List<Node> adjc = graph.getAdjacentNodes(c);
            SublistGenerator cg3 = new SublistGenerator(adjc.size(), -1);
            while ((comb3 = cg3.next()) != null) {
                List<Node> s = GraphUtils.asList(comb3, adjc);
                this.independenceTest.checkIndependence(c, a, s);
                double _score = this.independenceTest.getScore();
                if (!(_score < score)) continue;
                score = _score;
                S = s;
            }
            if (S == null) continue;
            if (S.contains(b)) {
                noncolliders.put(new Triple(a, b, c), score);
                continue;
            }
            colliders.put(new Triple(a, b, c), score);
        }
    }

    private void stepC(Graph psi, SepsetProducer sepsets) {
        TetradLogger.getInstance().log("info", "\nStep C");
        block0: for (Edge edge : psi.getEdges()) {
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            List<Node> adjx = psi.getAdjacentNodes(x);
            List<Node> adjy = psi.getAdjacentNodes(y);
            for (Node node : adjx) {
                if (psi.getEdge(node, x).getProximalEndpoint(x) != Endpoint.ARROW || !psi.underlines().isUnderlineTriple(y, x, node)) continue;
                continue block0;
            }
            for (Node a : this.nodes) {
                List<Node> sepset;
                if (a == x || a == y || adjx.contains(a) || adjy.contains(a) || psi.getEndpoint(y, x) != Endpoint.CIRCLE || psi.getEndpoint(x, y) != Endpoint.CIRCLE && psi.getEndpoint(x, y) != Endpoint.TAIL || (sepset = sepsets.getSepset(a, y)) == null || sepset.contains(x) || sepsets.isIndependent(a, x, sepset)) continue;
                psi.removeEdge(x, y);
                psi.addDirectedEdge(y, x);
                this.orientAwayFromArrow(y, x, psi);
                continue block0;
            }
        }
    }

    private void stepD(Graph psi, SepsetProducer sepsets, Map<Triple, Set<Node>> supSepsets) {
        HashMap<Node, List<Node>> local = new HashMap<Node, List<Node>>();
        for (Node node : psi.getNodes()) {
            local.put(node, this.local(psi, node));
        }
        for (Node node : this.nodes) {
            this.doNodeStepD(psi, sepsets, supSepsets, local, node);
        }
    }

    private void doNodeStepD(Graph psi, SepsetProducer sepsets, Map<Triple, Set<Node>> supSepsets, Map<Node, List<Node>> local, Node b) {
        int[] choice;
        List<Node> adj = psi.getAdjacentNodes(b);
        if (adj.size() < 2) {
            return;
        }
        ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
        block0: while ((choice = gen.next()) != null) {
            int[] choice2;
            List<Node> S;
            Node c;
            List<Node> _adj = GraphUtils.asList(choice, adj);
            Node a = _adj.get(0);
            if (!psi.isDefCollider(a, b, c = _adj.get(1)) || (S = sepsets.getSepset(a, c)) == null) continue;
            ArrayList<Node> TT = new ArrayList<Node>((Collection)local.get(a));
            TT.removeAll(S);
            TT.remove(b);
            TT.remove(c);
            SublistGenerator gen2 = new SublistGenerator(TT.size(), -1);
            while ((choice2 = gen2.next()) != null) {
                Set<Node> T = GraphUtils.asSet(choice2, TT);
                HashSet<Node> B = new HashSet<Node>(T);
                B.addAll(S);
                B.add(b);
                if (!sepsets.isIndependent(a, c, new ArrayList<Node>(B))) continue;
                psi.underlines().addDottedUnderlineTriple(a, b, c);
                supSepsets.put(new Triple(a, b, c), B);
                continue block0;
            }
        }
    }

    private void stepE(Map<Triple, Set<Node>> supSepset, Graph psi) {
        TetradLogger.getInstance().log("info", "\nStep E");
        for (Triple triple : psi.underlines().getDottedUnderlines()) {
            Node a = triple.getX();
            Node b = triple.getY();
            Node c = triple.getZ();
            List<Node> aAdj = psi.getAdjacentNodes(a);
            for (Node d : aAdj) {
                if (d == b || psi.getEndpoint(b, d) != Endpoint.CIRCLE) continue;
                if (supSepset.get(triple).contains(d)) {
                    psi.setEndpoint(b, d, Endpoint.TAIL);
                    continue;
                }
                if (psi.getEndpoint(d, b) == Endpoint.ARROW) continue;
                psi.removeEdge(b, d);
                psi.addDirectedEdge(b, d);
                this.orientAwayFromArrow(b, d, psi);
            }
            List<Node> cAdj = psi.getAdjacentNodes(c);
            for (Node d : cAdj) {
                if (d == b || psi.getEndpoint(b, d) != Endpoint.CIRCLE) continue;
                if (supSepset.get(triple).contains(d)) {
                    psi.setEndpoint(b, d, Endpoint.TAIL);
                    continue;
                }
                if (psi.getEndpoint(d, b) == Endpoint.ARROW) continue;
                psi.removeEdge(b, d);
                psi.addDirectedEdge(b, d);
                this.orientAwayFromArrow(b, d, psi);
            }
        }
    }

    private void stepF(Graph psi, SepsetProducer sepsets, Map<Triple, Set<Node>> supSepsets) {
        for (Triple triple : psi.underlines().getDottedUnderlines()) {
            Node a = triple.getX();
            Node b = triple.getY();
            Node c = triple.getZ();
            HashSet<Node> adj = new HashSet<Node>(psi.getAdjacentNodes(a));
            adj.addAll(psi.getAdjacentNodes(c));
            for (Node d : adj) {
                if (psi.getEndpoint(b, d) != Endpoint.CIRCLE || psi.getEndpoint(d, b) == Endpoint.ARROW || psi.isAdjacentTo(a, d) && psi.isAdjacentTo(c, d) || !psi.isAdjacentTo(b, d)) continue;
                HashSet<Node> supSepUnionD = new HashSet<Node>();
                supSepUnionD.add(d);
                supSepUnionD.addAll((Collection)supSepsets.get(triple));
                ArrayList<Node> listSupSepUnionD = new ArrayList<Node>(supSepUnionD);
                if (sepsets.isIndependent(a, c, listSupSepUnionD)) continue;
                psi.removeEdge(b, d);
                psi.addDirectedEdge(b, d);
                this.orientAwayFromArrow(b, d, psi);
            }
        }
    }

    private List<Node> local(Graph psi, Node x) {
        HashSet<Node> nodes = new HashSet<Node>(psi.getAdjacentNodes(x));
        for (Node y : new HashSet<Node>(nodes)) {
            for (Node z : psi.getAdjacentNodes(y)) {
                if (!psi.isDefCollider(x, y, z) || z == x) continue;
                nodes.add(z);
            }
        }
        return new ArrayList<Node>(nodes);
    }

    private void orientAwayFromArrow(Node a, Node b, Graph graph) {
        if (!this.isApplyR1()) {
            return;
        }
        for (Node c : graph.getAdjacentNodes(b)) {
            if (c == a) continue;
            this.orientAwayFromArrowVisit(a, b, c, graph);
        }
    }

    private boolean orientAwayFromArrowVisit(Node a, Node b, Node c, Graph graph) {
        if (!Edges.isNondirectedEdge(graph.getEdge(b, c))) {
            return false;
        }
        if (!graph.underlines().isUnderlineTriple(a, b, c)) {
            return false;
        }
        if (graph.getEdge(b, c).pointsTowards(b)) {
            return false;
        }
        graph.removeEdge(b, c);
        graph.addDirectedEdge(b, c);
        for (Node d : graph.getAdjacentNodes(c)) {
            if (d == b) {
                return true;
            }
            Edge bc = graph.getEdge(b, c);
            if (this.orientAwayFromArrowVisit(b, c, d, graph)) continue;
            graph.removeEdge(b, c);
            graph.addEdge(bc);
        }
        return true;
    }

    public boolean isApplyR1() {
        return this.applyR1;
    }

    public void setApplyR1(boolean applyR1) {
        this.applyR1 = applyR1;
    }
}

