/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerEm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ClusterSignificance {
    private final List<Node> variables;
    private final DataModel dataModel;
    private CheckType checkType = CheckType.Clique;

    public void printClusterPValues(Set<List<Integer>> out) {
        DecimalFormat nf = new DecimalFormat("0.000");
        for (List<Integer> _out : out) {
            ClusterSignificance clusterSignificance = new ClusterSignificance(this.variables, this.dataModel);
            try {
                double p = clusterSignificance.significance(new ArrayList<Integer>(_out));
                TetradLogger.getInstance().forceLogMessage("OUT: " + ClusterSignificance.variablesForIndices(new ArrayList<Integer>(_out), this.variables) + " p = " + nf.format(p));
            }
            catch (Exception e) {
                TetradLogger.getInstance().forceLogMessage("OUT: " + ClusterSignificance.variablesForIndices(new ArrayList<Integer>(_out), this.variables) + " p = EXCEPTION");
            }
        }
    }

    public static List<Node> variablesForIndices(List<Integer> cluster, List<Node> variables) {
        ArrayList<Node> _cluster = new ArrayList<Node>();
        for (int c : cluster) {
            _cluster.add(variables.get(c));
        }
        return _cluster;
    }

    static List<List<Node>> variablesForIndices2(Set<List<Integer>> clusters, List<Node> _variables) {
        ArrayList<List<Node>> variables = new ArrayList<List<Node>>();
        for (List<Integer> cluster : clusters) {
            variables.add(ClusterSignificance.variablesForIndices(cluster, _variables));
        }
        return variables;
    }

    public ClusterSignificance(List<Node> variables, DataModel dataModel) {
        if (variables == null) {
            throw new NullPointerException("Variable null.");
        }
        if (dataModel == null) {
            throw new NullPointerException("Data model null.");
        }
        this.variables = variables;
        this.dataModel = dataModel;
    }

    static List<Integer> getInts(int[] indices) {
        ArrayList<Integer> cluster = new ArrayList<Integer>();
        for (int i : indices) {
            cluster.add(i);
        }
        return cluster;
    }

    public boolean significant(List<Integer> cluster, double alpha) {
        if (this.checkType == CheckType.None) {
            return true;
        }
        if (this.checkType == CheckType.Significance) {
            return this.significance(cluster) > alpha;
        }
        if (this.checkType == CheckType.Clique) {
            return this.clique(cluster, alpha);
        }
        throw new IllegalArgumentException("Unexpected check type: " + (Object)((Object)this.checkType));
    }

    private double significance(List<Integer> cluster) {
        double chisq = this.getClusterChiSquare(cluster);
        int n = cluster.size();
        int dof = ClusterSignificance.dofHarman(n);
        double q = ProbUtils.chisqCdf(chisq, dof);
        return 1.0 - q;
    }

    private boolean clique(List<Integer> cluster, double alpha) {
        Fas fas;
        ArrayList<Node> _cluster = new ArrayList<Node>();
        for (int i : cluster) {
            _cluster.add(this.variables.get(i));
        }
        if (this.dataModel instanceof DataSet) {
            fas = new Fas(new IndTestFisherZ((DataSet)this.dataModel, alpha));
            Graph g = fas.search(_cluster);
            return GraphUtils.isClique(_cluster, g);
        }
        if (this.dataModel instanceof ICovarianceMatrix) {
            fas = new Fas(new IndTestFisherZ((ICovarianceMatrix)this.dataModel, alpha));
            Graph g = fas.search(_cluster);
            return GraphUtils.isClique(_cluster, g);
        }
        throw new IllegalArgumentException("Expecting a data set or a covariance matrix.");
    }

    private static int dofHarman(int n) {
        int dof = n * (n - 5) / 2 + 1;
        if (dof < 0) {
            dof = 0;
        }
        return dof;
    }

    private double getClusterChiSquare(List<Integer> cluster) {
        SemIm im = this.estimateClusterModel(cluster);
        return im.getChiSquare();
    }

    private SemIm estimateClusterModel(List<Integer> quartet) {
        EdgeListGraph g = new EdgeListGraph();
        GraphNode l1 = new GraphNode("L1");
        l1.setNodeType(NodeType.LATENT);
        GraphNode l2 = new GraphNode("L2");
        l2.setNodeType(NodeType.LATENT);
        g.addNode(l1);
        g.addNode(l2);
        for (Integer integer : quartet) {
            Node n = this.variables.get(integer);
            g.addNode(n);
            g.addDirectedEdge(l1, n);
            g.addDirectedEdge(l2, n);
        }
        SemPm pm = new SemPm(g);
        SemEstimator est = this.dataModel instanceof DataSet ? new SemEstimator((DataSet)this.dataModel, pm, (SemOptimizer)new SemOptimizerEm()) : new SemEstimator((CovarianceMatrix)this.dataModel, pm, (SemOptimizer)new SemOptimizerEm());
        return est.estimate();
    }

    private double modelSignificance(List<List<Integer>> clusters) {
        return this.getModelPValue(clusters);
    }

    public double getModelPValue(List<List<Integer>> clusters) {
        SemIm im = this.estimateModel(clusters);
        return im.getPValue();
    }

    private SemIm estimateModel(List<List<Integer>> clusters) {
        Parameter p;
        int i;
        EdgeListGraph g = new EdgeListGraph();
        ArrayList<GraphNode> upperLatents = new ArrayList<GraphNode>();
        ArrayList<GraphNode> lowerLatents = new ArrayList<GraphNode>();
        for (i = 0; i < clusters.size() && !Thread.currentThread().isInterrupted(); ++i) {
            List<Integer> cluster = clusters.get(i);
            GraphNode graphNode = new GraphNode("L1." + (i + 1));
            graphNode.setNodeType(NodeType.LATENT);
            GraphNode l2 = new GraphNode("L2." + (i + 1));
            l2.setNodeType(NodeType.LATENT);
            upperLatents.add(graphNode);
            lowerLatents.add(l2);
            g.addNode(graphNode);
            g.addNode(l2);
            for (Integer integer : cluster) {
                Node n = this.variables.get(integer);
                g.addNode(n);
                g.addDirectedEdge(graphNode, n);
                g.addDirectedEdge(l2, n);
            }
        }
        for (i = 0; i < upperLatents.size(); ++i) {
            for (int j = i + 1; j < upperLatents.size(); ++j) {
                g.addDirectedEdge((Node)upperLatents.get(i), (Node)upperLatents.get(j));
                g.addDirectedEdge((Node)lowerLatents.get(i), (Node)lowerLatents.get(j));
            }
        }
        for (i = 0; i < upperLatents.size(); ++i) {
            for (int j = 0; j < lowerLatents.size(); ++j) {
                if (i == j) continue;
                g.addDirectedEdge((Node)upperLatents.get(i), (Node)lowerLatents.get(j));
            }
        }
        SemPm pm = new SemPm(g);
        for (Node node : upperLatents) {
            p = pm.getParameter(node, node);
            p.setFixed(true);
            p.setStartingValue(1.0);
        }
        for (Node node : lowerLatents) {
            p = pm.getParameter(node, node);
            p.setFixed(true);
            p.setStartingValue(1.0);
        }
        SemEstimator est = this.dataModel instanceof DataSet ? new SemEstimator((DataSet)this.dataModel, pm, (SemOptimizer)new SemOptimizerEm()) : new SemEstimator((CovarianceMatrix)this.dataModel, pm, (SemOptimizer)new SemOptimizerEm());
        return est.estimate();
    }

    public void setCheckType(CheckType checkType) {
        this.checkType = checkType;
    }

    public static enum CheckType {
        Significance,
        Clique,
        None;

    }
}

