/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ConditionalGaussianOtherLikelihood;
import edu.cmu.tetrad.search.Score;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class ConditionalGaussianOtherScore
implements Score {
    private final DataSet dataSet;
    private final List<Node> variables;
    private final ConditionalGaussianOtherLikelihood likelihood;
    private double penaltyDiscount = 1.0;
    private int numCategoriesToDiscretize = 3;
    private final double sp;

    public ConditionalGaussianOtherScore(DataSet dataSet, double sp) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.dataSet = dataSet;
        this.variables = dataSet.getVariables();
        this.sp = sp;
        this.likelihood = new ConditionalGaussianOtherLikelihood(dataSet);
    }

    @Override
    public double localScore(int i, int ... parents) {
        double score;
        this.likelihood.setNumCategoriesToDiscretize(this.numCategoriesToDiscretize);
        this.likelihood.setPenaltyDiscount(this.penaltyDiscount);
        ConditionalGaussianOtherLikelihood.Ret ret = this.likelihood.getLikelihood(i, parents);
        int N = this.dataSet.getNumRows();
        double lik = ret.getLik();
        int k = ret.getDof();
        double strucPrior = this.getStructurePrior(parents);
        if (strucPrior > 0.0) {
            strucPrior = (double)(-2 * k) * strucPrior;
        }
        if (Double.isNaN(score = 2.0 * lik - this.getPenaltyDiscount() * (double)k * FastMath.log(N) + strucPrior) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    private double getStructurePrior(int[] parents) {
        if (this.sp < 0.0) {
            return this.getEBICprior();
        }
        if (this.sp == 0.0) {
            return 0.0;
        }
        int i = parents.length;
        int c = this.dataSet.getNumColumns() - 1;
        double p = this.sp / (double)c;
        return (double)i * FastMath.log(p) + (double)(c - i) * FastMath.log(1.0 - p);
    }

    private double getEBICprior() {
        double n = this.dataSet.getNumColumns();
        double gamma = -this.sp;
        return gamma * FastMath.log(n);
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, this.append(z, x)) - this.localScore(y, z);
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScore(y, x) - this.localScore(y);
    }

    private int[] append(int[] parents, int extra) {
        int[] all = new int[parents.length + 1];
        System.arraycopy(parents, 0, all, 0, parents.length);
        all[parents.length] = extra;
        return all;
    }

    @Override
    public double localScore(int i, int parent) {
        return this.localScore(i, new int[]{parent});
    }

    @Override
    public double localScore(int i) {
        return this.localScore(i, new int[0]);
    }

    @Override
    public int getSampleSize() {
        return this.dataSet.getNumRows();
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String targetName) {
        for (Node node : this.variables) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getMaxDegree() {
        return (int)FastMath.ceil(FastMath.log(this.dataSet.getNumRows()));
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    public double getPenaltyDiscount() {
        return this.penaltyDiscount;
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        this.penaltyDiscount = penaltyDiscount;
    }

    public void setNumCategoriesToDiscretize(int numCategoriesToDiscretize) {
        this.numCategoriesToDiscretize = numCategoriesToDiscretize;
    }

    @Override
    public String toString() {
        DecimalFormat nf = new DecimalFormat("0.00");
        return "Conditional Gaussian Other Score Penalty " + nf.format(this.penaltyDiscount);
    }
}

