/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.DeltaTetradTest;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.search.Tetrad;
import edu.cmu.tetrad.search.TetradTest;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public final class ContinuousTetradTest
implements TetradTest {
    private double sig;
    private double[] prob;
    private ICovarianceMatrix covMatrix;
    private Matrix rho;
    private TestType sigTestType;
    private int sampleSize;
    private final DataSet dataSet;
    private OneFactorEstimator oneFactorEst4;
    private OneFactorEstimator oneFactorEst5;
    private OneFactorEstimator oneFactorEst6;
    private TwoFactorsEstimator twoFactorsEst4;
    private TwoFactorsEstimator twoFactorsEst5;
    private TwoFactorsEstimator twoFactorsEst6;
    private Matrix bufferMatrix;
    private List<Node> variables;
    DeltaTetradTest deltaTest;

    public ContinuousTetradTest(DataSet dataSet, TestType sigTestType, double sig) {
        if (sigTestType == TestType.TETRAD_BOLLEN || sigTestType == null) {
            sigTestType = TestType.TETRAD_DELTA;
        }
        if (sigTestType != TestType.TETRAD_WISHART && sigTestType != TestType.TETRAD_DELTA && sigTestType != TestType.GAUSSIAN_FACTOR) {
            throw new IllegalArgumentException("Unexpected type: " + sigTestType);
        }
        if (dataSet == null) {
            throw new NullPointerException("Data set must not be null.");
        }
        this.covMatrix = new CovarianceMatrix(dataSet);
        this.dataSet = dataSet;
        this.sigTestType = sigTestType;
        this.setSignificance(sig);
        this.sampleSize = dataSet.getNumRows();
        this.variables = dataSet.getVariables();
        this.initialization();
    }

    public ContinuousTetradTest(ICovarianceMatrix covMatrix, TestType sigTestType, double sig) {
        if (sigTestType != TestType.TETRAD_WISHART && sigTestType != TestType.TETRAD_DELTA && sigTestType != TestType.GAUSSIAN_FACTOR) {
            throw new IllegalArgumentException("Unexpected type: " + sigTestType);
        }
        this.dataSet = null;
        this.deltaTest = new DeltaTetradTest(covMatrix);
        this.setCovMatrix(covMatrix);
        this.sigTestType = sigTestType;
        this.setSignificance(sig);
        this.sampleSize = covMatrix.getSize();
        this.initialization();
        this.variables = covMatrix.getVariables();
    }

    public ContinuousTetradTest(CorrelationMatrix correlationMatrix, TestType sigTestType, double sig) {
        if (sigTestType != TestType.TETRAD_WISHART && sigTestType != TestType.TETRAD_DELTA && sigTestType != TestType.GAUSSIAN_FACTOR) {
            throw new IllegalArgumentException("Unexpected type: " + sigTestType);
        }
        if (correlationMatrix == null) {
            throw new NullPointerException();
        }
        this.dataSet = null;
        this.setCovMatrix(correlationMatrix);
        this.sigTestType = sigTestType;
        this.setSignificance(sig);
        this.sampleSize = correlationMatrix.getSize();
        this.initialization();
        this.variables = correlationMatrix.getVariables();
    }

    @Override
    public double getSignificance() {
        return this.sig;
    }

    @Override
    public void setSignificance(double sig) {
        this.sig = sig;
    }

    @Override
    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public ICovarianceMatrix getCovMatrix() {
        if (this.covMatrix != null) {
            return this.covMatrix;
        }
        if (this.dataSet != null) {
            this.covMatrix = new CovarianceMatrix(this.dataSet);
            return this.covMatrix;
        }
        throw new IllegalStateException();
    }

    @Override
    public String[] getVarNames() {
        return this.covMatrix.getVariableNames().toArray(new String[0]);
    }

    @Override
    public List<Node> getVariables() {
        if (this.variables == null) {
            if (this.dataSet != null) {
                this.variables = this.dataSet.getVariables();
            } else if (this.getCovMatrix() != null) {
                this.variables = this.getCovMatrix().getVariables();
            }
        }
        return this.variables;
    }

    public TestType getTestType() {
        return this.sigTestType;
    }

    public void setTestType(TestType sigTestType) {
        this.sigTestType = sigTestType;
    }

    private void initialization() {
        this.sampleSize = this.covMatrix.getSampleSize();
        this.prob = new double[3];
        this.oneFactorEst4 = new OneFactorEstimator(this.covMatrix, this.sig, 4);
        this.oneFactorEst5 = new OneFactorEstimator(this.covMatrix, this.sig, 5);
        this.oneFactorEst6 = new OneFactorEstimator(this.covMatrix, this.sig, 6);
        this.twoFactorsEst4 = new TwoFactorsEstimator(this.covMatrix, this.sig, 4);
        this.twoFactorsEst5 = new TwoFactorsEstimator(this.covMatrix, this.sig, 5);
        this.twoFactorsEst6 = new TwoFactorsEstimator(this.covMatrix, this.sig, 6);
        this.bufferMatrix = new Matrix(4, 4);
        this.rho = this.covMatrix.getMatrix();
    }

    @Override
    public int tetradScore(int v1, int v2, int v3, int v4) {
        boolean holds = this.wishartEvalTetradDifferences2(v1, v2, v3, v4, this.sig);
        if (!holds) {
            return 1;
        }
        return 3;
    }

    @Override
    public boolean tetradScore1(int v1, int v2, int v3, int v4) {
        return this.tetradHolds(v1, v3, v4, v2) && !this.tetradHolds(v1, v3, v2, v4) && !this.tetradHolds(v1, v4, v2, v3);
    }

    @Override
    public boolean tetradScore3(int v1, int v2, int v3, int v4) {
        if (this.sigTestType != TestType.GAUSSIAN_FACTOR) {
            return this.tetradScore(v1, v2, v3, v4) == 3;
        }
        return this.oneFactorTest(v1, v2, v3, v4);
    }

    @Override
    public boolean tetradHolds(int v1, int v2, int v3, int v4) {
        this.evalTetradDifference(v1, v2, v3, v4);
        return this.prob[0] >= this.sig;
    }

    @Override
    public double tetradPValue(int v1, int v2, int v3, int v4) {
        this.evalTetradDifference(v1, v2, v3, v4);
        return this.prob[0];
    }

    @Override
    public double tetradPValue(int i1, int j1, int k1, int l1, int i2, int j2, int k2, int l2) {
        this.evalTetradDifference(i1, j1, k1, l1, i2, j2, k2, l2);
        return this.prob[0];
    }

    private void evalTetradDifferences(int i, int j, int k, int l) {
        switch (this.sigTestType) {
            case TETRAD_BASED: 
            case TETRAD_WISHART: {
                this.wishartEvalTetradDifferences(i, j, k, l);
                break;
            }
            case TETRAD_DELTA: {
                this.bollenEvalTetradDifferences(i, j, k, l);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void evalTetradDifference(int i, int j, int k, int l) {
        switch (this.sigTestType) {
            case TETRAD_BASED: 
            case TETRAD_WISHART: {
                this.wishartEvalTetradDifference(i, j, k, l);
                break;
            }
            case TETRAD_DELTA: {
                this.bollenEvalTetradDifference(i, j, k, l);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void evalTetradDifference(int i1, int j1, int k1, int l1, int i2, int j2, int k2, int l2) {
        this.wishartEvalTetradDifference(i1, j1, k1, l1, i2, j2, k2, l2);
    }

    private void wishartEvalTetradDifferences(int i, int j, int k, int l) {
        double TAUijkl = this.rho.get(i, j) * this.rho.get(k, l) - this.rho.get(i, k) * this.rho.get(j, l);
        double SD = this.wishartTestTetradDifference(i, j, k, l);
        double ratio = TAUijkl / SD;
        this.prob[0] = 2.0 * ProbUtils.normalCdf(FastMath.abs(ratio));
        double TAUijlk = this.rho.get(i, j) * this.rho.get(k, l) - this.rho.get(i, l) * this.rho.get(j, k);
        SD = this.wishartTestTetradDifference(i, j, l, k);
        ratio = TAUijlk / SD;
        this.prob[1] = 2.0 * ProbUtils.normalCdf(FastMath.abs(ratio));
        double TAUiklj = this.rho.get(i, k) * this.rho.get(j, l) - this.rho.get(i, l) * this.rho.get(j, k);
        SD = this.wishartTestTetradDifference(i, k, l, j);
        ratio = TAUiklj / SD;
        this.prob[2] = 2.0 * ProbUtils.normalCdf(FastMath.abs(ratio));
    }

    private boolean wishartEvalTetradDifferences2(int i, int j, int k, int l, double alpha) {
        double SD;
        double TAUijkl = this.rho.get(i, j) * this.rho.get(k, l) - this.rho.get(i, k) * this.rho.get(j, l);
        double ratio = TAUijkl / (SD = this.wishartTestTetradDifference(i, j, k, l));
        boolean holds1 = 2.0 * ProbUtils.normalCdf(FastMath.abs(ratio)) > alpha;
        double TAUijlk = this.rho.get(i, j) * this.rho.get(k, l) - this.rho.get(i, l) * this.rho.get(j, k);
        SD = this.wishartTestTetradDifference(i, j, l, k);
        ratio = TAUijlk / SD;
        boolean holds2 = 2.0 * ProbUtils.normalCdf(FastMath.abs(ratio)) > alpha;
        return holds1 && holds2;
    }

    private void wishartEvalTetradDifference(int i, int j, int k, int l) {
        double pValue;
        double SD;
        double TAUijkl = this.rho.get(i, j) * this.rho.get(k, l) - this.rho.get(i, k) * this.rho.get(j, l);
        double ratio = TAUijkl / (SD = this.wishartTestTetradDifference(i, j, k, l));
        if (ratio > 0.0) {
            ratio = -ratio;
        }
        this.prob[0] = pValue = 2.0 * ProbUtils.normalCdf(ratio);
    }

    private void wishartEvalTetradDifference(int i1, int j1, int k1, int l1, int i2, int j2, int k2, int l2) {
        double SD;
        double TAUijkl = this.rho.get(i1, j1) * this.rho.get(k1, l1) - this.rho.get(i2, j2) * this.rho.get(k2, l2);
        double ratio = TAUijkl / (SD = this.wishartTestTetradDifference(i1, j2, k2, l2));
        if (ratio > 0.0) {
            ratio = -ratio;
        }
        this.prob[0] = 2.0 * ProbUtils.normalCdf(ratio);
    }

    private double wishartTestTetradDifference(int a0, int a1, int a2, int a3) {
        this.bufferMatrix.set(0, 0, this.rho.get(a0, a0));
        this.bufferMatrix.set(0, 1, this.rho.get(a0, a1));
        this.bufferMatrix.set(0, 2, this.rho.get(a0, a2));
        this.bufferMatrix.set(0, 3, this.rho.get(a0, a3));
        this.bufferMatrix.set(1, 0, this.rho.get(a1, a0));
        this.bufferMatrix.set(1, 1, this.rho.get(a1, a1));
        this.bufferMatrix.set(1, 2, this.rho.get(a1, a2));
        this.bufferMatrix.set(1, 3, this.rho.get(a1, a3));
        this.bufferMatrix.set(2, 0, this.rho.get(a2, a0));
        this.bufferMatrix.set(2, 1, this.rho.get(a2, a1));
        this.bufferMatrix.set(2, 2, this.rho.get(a2, a2));
        this.bufferMatrix.set(2, 3, this.rho.get(a2, a3));
        this.bufferMatrix.set(3, 0, this.rho.get(a3, a0));
        this.bufferMatrix.set(3, 1, this.rho.get(a3, a1));
        this.bufferMatrix.set(3, 2, this.rho.get(a3, a2));
        this.bufferMatrix.set(3, 3, this.rho.get(a3, a3));
        double product1 = this.rho.get(a0, a0) * this.rho.get(a3, a3) - this.rho.get(a0, a3) * this.rho.get(a0, a3);
        double product2 = this.rho.get(a1, a1) * this.rho.get(a2, a2) - this.rho.get(a1, a2) * this.rho.get(a1, a2);
        double n = this.sampleSize;
        double product3 = (n + 1.0) / ((n - 1.0) * (n - 2.0)) * product1 * product2;
        double determinant = this.determinant44(this.bufferMatrix);
        double var = product3 - determinant / (n - 2.0);
        return FastMath.sqrt(FastMath.abs(var));
    }

    private double determinant44(Matrix m) {
        double a11 = m.get(0, 0);
        double a12 = m.get(0, 1);
        double a13 = m.get(0, 2);
        double a14 = m.get(0, 3);
        double a21 = m.get(1, 0);
        double a22 = m.get(1, 1);
        double a23 = m.get(1, 2);
        double a24 = m.get(1, 3);
        double a31 = m.get(2, 0);
        double a32 = m.get(2, 1);
        double a33 = m.get(2, 2);
        double a34 = m.get(2, 3);
        double a41 = m.get(3, 0);
        double a42 = m.get(3, 1);
        double a43 = m.get(3, 2);
        double a44 = m.get(3, 3);
        return a14 * a23 * a32 * a41 - a13 * a24 * a32 * a41 - a14 * a22 * a33 * a41 + a12 * a24 * a33 * a41 + a13 * a22 * a34 * a41 - a12 * a23 * a34 * a41 - a14 * a23 * a31 * a42 + a13 * a24 * a31 * a42 + a14 * a21 * a33 * a42 - a11 * a24 * a33 * a42 - a13 * a21 * a34 * a42 + a11 * a23 * a34 * a42 + a14 * a22 * a31 * a43 - a12 * a24 * a31 * a43 - a14 * a21 * a32 * a43 + a11 * a24 * a32 * a43 + a12 * a21 * a34 * a43 - a11 * a22 * a34 * a43 - a13 * a22 * a31 * a44 + a12 * a23 * a31 * a44 + a13 * a21 * a32 * a44 - a11 * a23 * a32 * a44 - a12 * a21 * a33 * a44 + a11 * a22 * a33 * a44;
    }

    private void bollenEvalTetradDifferences(int i, int j, int k, int l) {
        if (this.deltaTest == null) {
            this.deltaTest = this.dataSet != null ? new DeltaTetradTest(this.dataSet) : new DeltaTetradTest(this.covMatrix);
        }
        Node ci = this.getVariables().get(i);
        Node cj = this.getVariables().get(j);
        Node ck = this.getVariables().get(k);
        Node cl = this.getVariables().get(l);
        this.deltaTest.calcChiSquare(new Tetrad(ci, cj, ck, cl));
        this.prob[0] = this.deltaTest.getPValue();
        this.deltaTest.calcChiSquare(new Tetrad(ci, cj, cl, ck));
        this.prob[1] = this.deltaTest.getPValue();
        this.deltaTest.calcChiSquare(new Tetrad(ci, ck, cl, cj));
        this.prob[2] = this.deltaTest.getPValue();
    }

    private void bollenEvalTetradDifference(int i, int j, int k, int l) {
        Node ci = this.getVariables().get(i);
        Node cj = this.getVariables().get(j);
        Node ck = this.getVariables().get(k);
        Node cl = this.getVariables().get(l);
        if (this.deltaTest == null) {
            this.deltaTest = this.dataSet != null ? new DeltaTetradTest(this.dataSet) : new DeltaTetradTest(this.covMatrix);
        }
        this.deltaTest.calcChiSquare(new Tetrad(ci, cj, ck, cl));
        this.prob[0] = this.deltaTest.getPValue();
        TetradLogger.getInstance().log("tetrads", new Tetrad(this.variables.get(i), this.variables.get(j), this.variables.get(k), this.variables.get(l)) + " = 0, p = " + this.prob[0]);
    }

    public void setCovMatrix(ICovarianceMatrix covMatrix) {
        this.covMatrix = covMatrix;
    }

    public void setBollenTest(DeltaTetradTest deltaTest) {
        this.deltaTest = deltaTest;
    }

    @Override
    public boolean oneFactorTest(int v1, int v2, int v3, int v4) {
        int[] indices = new int[]{v1, v2, v3, v4};
        this.oneFactorEst4.init(indices);
        return this.oneFactorEst4.isSignificant();
    }

    @Override
    public boolean oneFactorTest(int v1, int v2, int v3, int v4, int v5) {
        int[] indices = new int[]{v1, v2, v3, v4, v5};
        this.oneFactorEst5.init(indices);
        return this.oneFactorEst5.isSignificant();
    }

    @Override
    public boolean oneFactorTest(int v1, int v2, int v3, int v4, int v5, int v6) {
        int[] indices = new int[]{v1, v2, v3, v4, v5, v6};
        this.oneFactorEst6.init(indices);
        return this.oneFactorEst6.isSignificant();
    }

    @Override
    public boolean twoFactorTest(int v1, int v2, int v3, int v4) {
        int[] indices = new int[]{v1, v2, v3, v4};
        this.twoFactorsEst4.init(indices, 2);
        return this.twoFactorsEst4.isSignificant();
    }

    @Override
    public boolean twoFactorTest(int v1, int v2, int v3, int v4, int v5) {
        int[] indices = new int[]{v1, v2, v3, v4, v5};
        this.twoFactorsEst5.init(indices, 3);
        return this.twoFactorsEst5.isSignificant();
    }

    @Override
    public boolean twoFactorTest(int v1, int v2, int v3, int v4, int v5, int v6) {
        int[] indices = new int[]{v1, v2, v3, v4, v5, v6};
        this.twoFactorsEst6.init(indices, 3);
        return this.twoFactorsEst6.isSignificant();
    }

    static class OneFactorEstimator
    extends SimpleFactorEstimator {
        static final long serialVersionUID = 23L;

        public OneFactorEstimator(ICovarianceMatrix sampleCov, double sig, int nvar) {
            super(sampleCov, sig, nvar);
        }

        @Override
        protected SemPm buildSemPm(int[] values) {
            EdgeListGraph graph = new EdgeListGraph();
            GraphNode latent = new GraphNode("__l");
            latent.setNodeType(NodeType.LATENT);
            graph.addNode(latent);
            for (int i = 0; i < this.nvar; ++i) {
                GraphNode node = new GraphNode(this.submatrixNames[i]);
                graph.addNode(node);
                graph.addDirectedEdge(latent, node);
            }
            this.semPm = new SemPm(graph);
            return this.semPm;
        }
    }

    static class TwoFactorsEstimator
    extends SimpleFactorEstimator {
        static final long serialVersionUID = 23L;
        int nleft;

        public TwoFactorsEstimator(ICovarianceMatrix sampleCov, double sig, int nvar) {
            super(sampleCov, sig, nvar);
        }

        public void init(int[] indices, int nleft) {
            this.nleft = nleft;
            this.init(indices);
        }

        @Override
        protected SemPm buildSemPm(int[] values) {
            EdgeListGraph graph = new EdgeListGraph();
            GraphNode latent1 = new GraphNode("__l1");
            GraphNode latent2 = new GraphNode("__l2");
            latent1.setNodeType(NodeType.LATENT);
            latent2.setNodeType(NodeType.LATENT);
            graph.addNode(latent1);
            graph.addNode(latent2);
            graph.addDirectedEdge(latent1, latent2);
            for (int i = 0; i < this.nvar; ++i) {
                GraphNode node = new GraphNode(this.submatrixNames[i]);
                graph.addNode(node);
                if (i < this.nleft) {
                    graph.addDirectedEdge(latent1, node);
                    continue;
                }
                graph.addDirectedEdge(latent2, node);
            }
            this.semPm = new SemPm(graph);
            return this.semPm;
        }
    }

    static abstract class SimpleFactorEstimator {
        ICovarianceMatrix sampleCov;
        ICovarianceMatrix subSampleCov;
        double sig;
        int nvar;
        SemPm semPm;
        String[] varNames;
        String[] submatrixNames;

        public SimpleFactorEstimator(ICovarianceMatrix sampleCov, double sig, int nvar) {
            this.sampleCov = sampleCov;
            this.sig = sig;
            this.nvar = nvar;
            this.varNames = sampleCov.getVariableNames().toArray(new String[0]);
            this.submatrixNames = new String[nvar];
        }

        public void init(int[] indices) {
            Arrays.sort(indices);
            for (int i = 0; i < indices.length; ++i) {
                this.submatrixNames[i] = this.varNames[indices[i]];
            }
            this.semPm = this.buildSemPm(indices);
            this.subSampleCov = this.sampleCov.getSubmatrix(this.submatrixNames);
        }

        public boolean isSignificant() {
            throw new UnsupportedOperationException();
        }

        protected abstract SemPm buildSemPm(int[] var1);
    }
}

