/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public final class Cpc
implements GraphSearch {
    private final IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private Graph graph;
    private long elapsedTime;
    private Set<Triple> colliderTriples;
    private Set<Triple> noncolliderTriples;
    private Graph externalGraph;
    private Set<Triple> ambiguousTriples;
    private boolean aggressivelyPreventCycles;
    private final TetradLogger logger = TetradLogger.getInstance();
    private SepsetMap sepsets;
    private boolean verbose;

    public Cpc(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0: " + depth);
        }
        if (depth == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Depth must not be Integer.MAX_VALUE, due to a known bug.");
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public int getDepth() {
        return this.depth;
    }

    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    public Set<Triple> getColliderTriples() {
        return new HashSet<Triple>(this.colliderTriples);
    }

    public Set<Triple> getNoncolliderTriples() {
        return new HashSet<Triple>(this.noncolliderTriples);
    }

    public Set<Edge> getAdjacencies() {
        return new HashSet<Edge>(this.graph.getEdges());
    }

    public Set<Edge> getNonadjacencies() {
        Graph complete = GraphUtils.completeGraph(this.graph);
        Set<Edge> nonAdjacencies = complete.getEdges();
        Graph undirected = GraphUtils.undirectedGraph(this.graph);
        nonAdjacencies.removeAll(undirected.getEdges());
        return new HashSet<Edge>(nonAdjacencies);
    }

    @Override
    public Graph search() {
        return this.search(this.independenceTest.getVariables());
    }

    public Graph search(List<Node> nodes) {
        nodes = new ArrayList<Node>(nodes);
        return this.search(new Fas(this.getIndependenceTest()), nodes);
    }

    public Graph search(IFas fas, List<Node> nodes) {
        this.logger.log("info", "Starting CPC algorithm");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        this.ambiguousTriples = new HashSet<Triple>();
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        long startTime = MillisecondTimes.timeMillis();
        List<Node> allNodes = this.getIndependenceTest().getVariables();
        if (!allNodes.containsAll(nodes)) {
            throw new IllegalArgumentException("All of the given nodes must be in the domain of the independence test provided.");
        }
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        fas.setVerbose(this.verbose);
        this.graph = fas.search();
        this.sepsets = fas.getSepsets();
        if (this.verbose) {
            System.out.println("CPC orientation...");
        }
        SearchGraphUtils.pcOrientbk(this.knowledge, this.graph, nodes);
        this.orientUnshieldedTriples(this.knowledge);
        MeekRules meekRules = new MeekRules();
        meekRules.setAggressivelyPreventCycles(this.aggressivelyPreventCycles);
        meekRules.setKnowledge(this.knowledge);
        meekRules.orientImplied(this.graph);
        Set<Triple> ambiguities = this.graph.underlines().getAmbiguousTriples();
        for (Triple triple : new HashSet<Triple>(ambiguities)) {
            Node z;
            Node y;
            Node x = triple.getX();
            if (this.graph.isDefCollider(x, y = triple.getY(), z = triple.getZ())) {
                this.graph.underlines().removeAmbiguousTriple(x, y, z);
            }
            if (!this.graph.getEdge(x, y).pointsTowards(x) && !this.graph.getEdge(y, z).pointsTowards(z)) continue;
            this.graph.underlines().removeAmbiguousTriple(x, y, z);
        }
        TetradLogger.getInstance().log("graph", "\nReturning this graph: " + this.graph);
        long endTime = MillisecondTimes.timeMillis();
        this.elapsedTime = endTime - startTime;
        TetradLogger.getInstance().log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        TetradLogger.getInstance().log("info", "Finishing CPC algorithm.");
        this.logTriples();
        TetradLogger.getInstance().flush();
        return this.graph;
    }

    private void logTriples() {
        TetradLogger.getInstance().log("info", "\nCollider triples:");
        for (Triple triple : this.colliderTriples) {
            TetradLogger.getInstance().log("info", "Collider: " + triple);
        }
        TetradLogger.getInstance().log("info", "\nNoncollider triples:");
        for (Triple triple : this.noncolliderTriples) {
            TetradLogger.getInstance().log("info", "Noncollider: " + triple);
        }
        TetradLogger.getInstance().log("info", "\nAmbiguous triples (i.e. list of triples for which \nthere is ambiguous data about whether they are colliders or not):");
        for (Triple triple : this.getAmbiguousTriples()) {
            TetradLogger.getInstance().log("info", "Ambiguous: " + triple);
        }
    }

    private void orientUnshieldedTriples(Knowledge knowledge) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        List<Node> nodes = this.graph.getNodes();
        for (Node y : nodes) {
            int[] combination;
            List<Node> adjacentNodes = this.graph.getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node z;
                Node x = adjacentNodes.get(combination[0]);
                if (this.graph.isAdjacentTo(x, z = adjacentNodes.get(combination[1]))) continue;
                List<List<Node>> sepsetsxz = this.getSepsets(x, z, this.graph);
                if (this.isColliderSepset(y, sepsetsxz)) {
                    if (this.colliderAllowed(x, y, z, knowledge)) {
                        this.graph.removeEdge(x, y);
                        this.graph.removeEdge(z, y);
                        this.graph.addDirectedEdge(x, y);
                        this.graph.addDirectedEdge(z, y);
                        TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(x, y, z));
                    }
                    this.colliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                if (this.isNoncolliderSepset(y, sepsetsxz)) {
                    this.noncolliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                Triple triple = new Triple(x, y, z);
                this.ambiguousTriples.add(triple);
                this.graph.underlines().addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    private List<List<Node>> getSepsets(Node i, Node k, Graph g) {
        List<Node> adji = g.getAdjacentNodes(i);
        List<Node> adjk = g.getAdjacentNodes(k);
        ArrayList<List<Node>> sepsets = new ArrayList<List<Node>>();
        for (int d = 0; d <= FastMath.max(adji.size(), adjk.size()); ++d) {
            List<Node> v;
            int[] choice;
            ChoiceGenerator gen;
            if (adji.size() >= 2 && d <= adji.size()) {
                gen = new ChoiceGenerator(adji.size(), d);
                while ((choice = gen.next()) != null) {
                    v = GraphUtils.asList(choice, adji);
                    if (!this.getIndependenceTest().checkIndependence(i, k, v).independent()) continue;
                    sepsets.add(v);
                }
            }
            if (adjk.size() < 2 || d > adjk.size()) continue;
            gen = new ChoiceGenerator(adjk.size(), d);
            while ((choice = gen.next()) != null) {
                v = GraphUtils.asList(choice, adjk);
                if (!this.getIndependenceTest().checkIndependence(i, k, v).independent()) continue;
                sepsets.add(v);
            }
        }
        return sepsets;
    }

    private boolean isColliderSepset(Node j, List<List<Node>> sepsets) {
        if (sepsets.isEmpty()) {
            return false;
        }
        for (List<Node> sepset : sepsets) {
            if (!sepset.contains(j)) continue;
            return false;
        }
        return true;
    }

    private boolean isNoncolliderSepset(Node j, List<List<Node>> sepsets) {
        if (sepsets.isEmpty()) {
            return false;
        }
        for (List<Node> sepset : sepsets) {
            if (sepset.contains(j)) continue;
            return false;
        }
        return true;
    }

    private boolean colliderAllowed(Node x, Node y, Node z, Knowledge knowledge) {
        return Cpc.isArrowpointAllowed1(x, y, knowledge) && Cpc.isArrowpointAllowed1(z, y, knowledge);
    }

    public static boolean isArrowpointAllowed1(Node from, Node to, Knowledge knowledge) {
        return knowledge == null || !knowledge.isRequired(to.toString(), from.toString()) && !knowledge.isForbidden(from.toString(), to.toString());
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Graph getExternalGraph() {
        return this.externalGraph;
    }

    public void setExternalGraph(Graph externalGraph) {
        this.externalGraph = externalGraph;
    }
}

