/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.FasConcurrent;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public final class CpcStable
implements GraphSearch {
    private final IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private Graph graph;
    private long elapsedTime;
    private boolean aggressivelyPreventCycles;
    private final TetradLogger logger = TetradLogger.getInstance();
    private SepsetMap sepsets;
    private boolean verbose;
    private PrintStream out = System.out;

    public CpcStable(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0: " + depth);
        }
        if (depth == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Depth must not be Integer.MAX_VALUE, due to a known bug.");
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public int getDepth() {
        return this.depth;
    }

    public Set<Edge> getAdjacencies() {
        return new HashSet<Edge>(this.graph.getEdges());
    }

    public Set<Edge> getNonadjacencies() {
        Graph complete = GraphUtils.completeGraph(this.graph);
        Set<Edge> nonAdjacencies = complete.getEdges();
        Graph undirected = GraphUtils.undirectedGraph(this.graph);
        nonAdjacencies.removeAll(undirected.getEdges());
        return new HashSet<Edge>(nonAdjacencies);
    }

    @Override
    public Graph search() {
        return this.search(this.independenceTest.getVariables());
    }

    public Graph search(List<Node> nodes) {
        nodes = new ArrayList<Node>(nodes);
        this.graph = new EdgeListGraph(nodes);
        FasConcurrent fas = new FasConcurrent(this.getIndependenceTest());
        fas.setStable(true);
        fas.setOut(this.out);
        return this.search(fas, nodes);
    }

    public Graph search(IFas fas, List<Node> nodes) {
        this.logger.log("info", "Starting CPC Stable algorithm");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        long startTime = MillisecondTimes.timeMillis();
        List<Node> allNodes = this.getIndependenceTest().getVariables();
        if (!allNodes.containsAll(nodes)) {
            throw new IllegalArgumentException("All of the given nodes must be in the domain of the independence test provided.");
        }
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        fas.setVerbose(this.verbose);
        fas.setOut(this.out);
        this.graph = fas.search();
        this.sepsets = fas.getSepsets();
        if (this.verbose) {
            this.out.println("CPC orientation...");
        }
        SearchGraphUtils.pcOrientbk(this.knowledge, this.getGraph(), nodes);
        this.orientUnshieldedTriples(this.knowledge);
        MeekRules meekRules = new MeekRules();
        meekRules.setOut(this.out);
        meekRules.orientImplied(this.getGraph());
        long endTime = MillisecondTimes.timeMillis();
        this.elapsedTime = endTime - startTime;
        TetradLogger.getInstance().log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        TetradLogger.getInstance().log("info", "Finishing CPC algorithm.");
        TetradLogger.getInstance().flush();
        return this.getGraph();
    }

    private void orientUnshieldedTriples(Knowledge knowledge) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        List<Node> nodes = this.graph.getNodes();
        for (Node y : nodes) {
            int[] combination;
            List<Node> adjacentNodes = this.graph.getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node z;
                Node x = adjacentNodes.get(combination[0]);
                if (this.graph.isAdjacentTo(x, z = adjacentNodes.get(combination[1]))) continue;
                List<List<Node>> sepsetsxz = this.getSepsets(x, z, this.graph);
                if (this.isColliderSepset(y, sepsetsxz)) {
                    if (!this.colliderAllowed(x, y, z, knowledge)) continue;
                    this.graph.setEndpoint(x, y, Endpoint.ARROW);
                    this.graph.setEndpoint(z, y, Endpoint.ARROW);
                    TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(x, y, z));
                    continue;
                }
                Triple triple = new Triple(x, y, z);
                this.graph.underlines().addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    private List<List<Node>> getSepsets(Node i, Node k, Graph g) {
        List<Node> adji = g.getAdjacentNodes(i);
        List<Node> adjk = g.getAdjacentNodes(k);
        ArrayList<List<Node>> sepsets = new ArrayList<List<Node>>();
        for (int d = 0; d <= FastMath.max(adji.size(), adjk.size()); ++d) {
            List<Node> v;
            int[] choice;
            ChoiceGenerator gen;
            if (adji.size() >= 2 && d <= adji.size()) {
                gen = new ChoiceGenerator(adji.size(), d);
                while ((choice = gen.next()) != null) {
                    v = GraphUtils.asList(choice, adji);
                    if (!this.getIndependenceTest().checkIndependence(i, k, v).independent()) continue;
                    sepsets.add(v);
                }
            }
            if (adjk.size() < 2 || d > adjk.size()) continue;
            gen = new ChoiceGenerator(adjk.size(), d);
            while ((choice = gen.next()) != null) {
                v = GraphUtils.asList(choice, adjk);
                if (!this.getIndependenceTest().checkIndependence(i, k, v).independent()) continue;
                sepsets.add(v);
            }
        }
        return sepsets;
    }

    private boolean isColliderSepset(Node j, List<List<Node>> sepsets) {
        if (sepsets.isEmpty()) {
            return false;
        }
        for (List<Node> sepset : sepsets) {
            if (!sepset.contains(j)) continue;
            return false;
        }
        return true;
    }

    private boolean colliderAllowed(Node x, Node y, Node z, Knowledge knowledge) {
        return CpcStable.isArrowpointAllowed1(x, y, knowledge) && CpcStable.isArrowpointAllowed1(z, y, knowledge);
    }

    public static boolean isArrowpointAllowed1(Node from, Node to, Knowledge knowledge) {
        return knowledge == null || !knowledge.isRequired(to.toString(), from.toString()) && !knowledge.isForbidden(from.toString(), to.toString());
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public PrintStream getOut() {
        return this.out;
    }
}

