/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.algcomparison.independence.ChiSquare;
import edu.cmu.tetrad.data.BootstrapSampler;
import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphPersistence;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ConditionalGaussianScore;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.Grasp;
import edu.cmu.tetrad.search.Ida;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestScore;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.PcStable;
import edu.cmu.tetrad.search.ScoredIndTest;
import edu.cmu.tetrad.search.SemBicScore;
import edu.cmu.tetrad.util.ConcurrencyUtils;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetrad.util.TextTable;
import edu.pitt.dbmi.data.reader.Delimiter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;

public class Cstar {
    private boolean parallelized = false;
    private int numSubsamples = 30;
    private int qFrom = 1;
    private int qTo = 1;
    private int qIncrement = 1;
    private double selectionAlpha = 0.0;
    private IndependenceTest test;
    private PatternAlgorithm patternAlgorithm = PatternAlgorithm.PC_STABLE;
    private SampleStyle sampleStyle = SampleStyle.BOOTSTRAP;
    private boolean verbose;

    public static LinkedList<Record> cStar(LinkedList<LinkedList<Record>> allRecords) {
        HashMap<Edge, List> map = new HashMap<Edge, List>();
        for (List list : allRecords) {
            for (Record record : list) {
                Edge edge = Edges.directedEdge(record.getCauseNode(), record.getEffectNode());
                map.computeIfAbsent(edge, k -> new ArrayList());
                ((List)map.get(edge)).add(record);
            }
        }
        LinkedList<Record> cstar = new LinkedList<Record>();
        for (Edge edge : map.keySet()) {
            List recordList = (List)map.get(edge);
            double[] pis = new double[recordList.size()];
            double[] effects = new double[recordList.size()];
            for (int i = 0; i < recordList.size(); ++i) {
                pis[i] = ((Record)recordList.get(i)).getPi();
                effects[i] = ((Record)recordList.get(i)).getMinBeta();
            }
            double medianPis = StatUtils.median(pis);
            double medianEffects = StatUtils.median(effects);
            Record _record = new Record(edge.getNode1(), edge.getNode2(), medianPis, medianEffects, -1, -1);
            cstar.add(_record);
        }
        cstar.sort((o1, o2) -> {
            if (o1.getPi() == o2.getPi()) {
                return Double.compare(o2.getMinBeta(), o1.getMinBeta());
            }
            return Double.compare(o2.getPi(), o1.getPi());
        });
        return cstar;
    }

    private static double er(double pi, double q, double p) {
        return p * Cstar.pcer(pi, q, p);
    }

    private static double pcer(double pi, double q, double p) {
        return q * q / (p * p * (2.0 * pi - 1.0));
    }

    public void setParallelized(boolean parallelized) {
        this.parallelized = parallelized;
    }

    public LinkedList<LinkedList<Record>> getRecords(DataSet dataSet, List<Node> possibleCauses, List<Node> possibleEffects, IndependenceTest test) {
        return this.getRecords(dataSet, possibleCauses, possibleEffects, test, null);
    }

    public LinkedList<LinkedList<Record>> getRecords(DataSet dataSet, List<Node> possibleCauses, List<Node> possibleEffects, IndependenceTest test, String path) {
        File dir;
        System.out.println("path = " + path);
        test.setVerbose(false);
        possibleEffects = GraphUtils.replaceNodes(possibleEffects, dataSet.getVariables());
        possibleCauses = GraphUtils.replaceNodes(possibleCauses, dataSet.getVariables());
        final int p = possibleCauses.size() * possibleEffects.size();
        ArrayList<Integer> qs = new ArrayList<Integer>();
        for (int q = this.qFrom; q <= this.qTo; q += this.qIncrement) {
            if (q <= p) {
                qs.add(q);
                continue;
            }
            TetradLogger.getInstance().forceLogMessage("q = " + q + " > p = " + p + "; skipping");
        }
        if (qs.isEmpty()) {
            return new LinkedList<LinkedList<Record>>();
        }
        final LinkedList<LinkedList<Record>> allRecords = new LinkedList<LinkedList<Record>>();
        File _dir = null;
        if (path != null) {
            _dir = new File(path);
            System.out.println("dir = " + _dir.getAbsolutePath());
            boolean b = _dir.mkdirs();
            if (b) {
                System.out.println("Creating directories for " + _dir.getAbsolutePath());
            }
        }
        if ((dir = _dir) != null) {
            if (new File(dir, "possible.causes.txt").exists() && new File(dir, "possible.causes.txt").exists()) {
                possibleCauses = this.readVars(dataSet, dir, "possible.causes.txt");
                possibleEffects = this.readVars(dataSet, dir, "possible.effects.txt");
                dataSet = this.readData(dir);
            } else {
                this.writeVars(possibleCauses, dir, "possible.causes.txt");
                this.writeVars(possibleEffects, dir, "possible.effects.txt");
                this.writeData(dataSet, dir);
            }
        }
        if (test instanceof IndTestScore && ((IndTestScore)test).getWrappedScore() instanceof SemBicScore) {
            this.test = test;
        } else if (test instanceof IndTestFisherZ) {
            this.test = test;
        } else if (test instanceof ChiSquare) {
            this.test = test;
        } else {
            throw new IllegalArgumentException("Expecting Fisher Z, Chi Square, or Sem BIC.");
        }
        ArrayList minimalEffects = new ArrayList();
        for (int t = 0; t < possibleEffects.size(); ++t) {
            minimalEffects.add(new ConcurrentHashMap());
            for (int b = 0; b < this.getNumSubsamples(); ++b) {
                ConcurrentHashMap<Node, Double> map = new ConcurrentHashMap<Node, Double>();
                for (Node node : possibleCauses) {
                    map.put(node, 0.0);
                }
                ((Map)minimalEffects.get(t)).put(b, map);
            }
        }
        final int[] edgesTotal = new int[1];
        final int[] edgesCount = new int[1];
        ArrayList<Callable<double[][]>> tasks = new ArrayList<Callable<double[][]>>();
        for (int k = 0; k < this.getNumSubsamples(); ++k) {
            class Task
            implements Callable<double[][]> {
                private final List<Node> possibleCauses;
                private final List<Node> possibleEffects;
                private final int k;
                private final DataSet _dataSet;

                Task(int k, List<Node> possibleCauses, List<Node> possibleEffects, DataSet _dataSet) {
                    this.k = k;
                    this.possibleCauses = possibleCauses;
                    this.possibleEffects = possibleEffects;
                    this._dataSet = _dataSet;
                }

                @Override
                public double[][] call() {
                    try {
                        DataSet sample;
                        BootstrapSampler sampler = new BootstrapSampler();
                        if (sampleStyle == SampleStyle.BOOTSTRAP) {
                            sampler.setWithoutReplacements(false);
                            sample = sampler.sample(this._dataSet, this._dataSet.getNumRows());
                        } else if (sampleStyle == SampleStyle.SPLIT) {
                            sampler.setWithoutReplacements(true);
                            sample = sampler.sample(this._dataSet, this._dataSet.getNumRows() / 2);
                        } else {
                            throw new IllegalArgumentException("That type of sample is not configured: " + (Object)((Object)sampleStyle));
                        }
                        Graph pattern = null;
                        double[][] effects = null;
                        if (dir != null && new File(dir, "pattern." + (this.k + 1) + ".txt").exists() && new File(dir, "effects." + (this.k + 1) + ".txt").exists()) {
                            try {
                                pattern = GraphPersistence.loadGraphTxt(new File(dir, "pattern." + (this.k + 1) + ".txt"));
                                effects = this.loadMatrix(new File(dir, "effects." + (this.k + 1) + ".txt"));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (pattern == null || effects == null) {
                            if (patternAlgorithm == PatternAlgorithm.FGES) {
                                pattern = this.getPatternFges(sample);
                            } else if (patternAlgorithm == PatternAlgorithm.PC_STABLE) {
                                pattern = this.getPatternPcStable(sample);
                            } else if (patternAlgorithm == PatternAlgorithm.GRaSP) {
                                pattern = this.getPatternPcStable(sample);
                            } else {
                                throw new IllegalArgumentException("That type of of pattern algorithm is not configured: " + (Object)((Object)patternAlgorithm));
                            }
                            edgesTotal[0] = edgesTotal[0] + pattern.getNumEdges();
                            edgesCount[0] = edgesCount[0] + 1;
                            if (dir != null) {
                                GraphPersistence.saveGraph(pattern, new File(dir, "pattern." + (this.k + 1) + ".txt"), false);
                            }
                            Ida ida = new Ida(sample, pattern, this.possibleCauses);
                            effects = new double[this.possibleCauses.size()][this.possibleEffects.size()];
                            for (int e = 0; e < this.possibleEffects.size(); ++e) {
                                Map<Node, Double> minEffects = ida.calculateMinimumEffectsOnY(this.possibleEffects.get(e));
                                for (int c = 0; c < this.possibleCauses.size(); ++c) {
                                    effects[c][e] = minEffects.get(this.possibleCauses.get(c));
                                }
                            }
                            if (dir != null) {
                                this.saveMatrix(effects, new File(dir, "effects." + (this.k + 1) + ".txt"));
                            } else {
                                this.saveMatrix(effects, null);
                            }
                        }
                        return effects;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            tasks.add(new Task(k, possibleCauses, possibleEffects, dataSet));
        }
        final List<double[][]> allEffects = this.runCallablesDoubleArray(tasks, this.parallelized);
        int avgEdges = (int)((double)edgesTotal[0] / (double)edgesCount[0]);
        qs.clear();
        qs.add(avgEdges);
        final ArrayList doubles = new ArrayList();
        for (int k = 0; k < this.getNumSubsamples(); ++k) {
            double[][] effects = allEffects.get(k);
            if (effects.length != possibleCauses.size() || effects[0].length != possibleEffects.size()) {
                throw new IllegalStateException("Bootstrap " + (k + 1) + " is damaged; delete the pattern and effect files for that bootstrap and rerun");
            }
            ArrayList<Double> _doubles = new ArrayList<Double>();
            for (int c = 0; c < possibleCauses.size(); ++c) {
                for (int e = 0; e < possibleEffects.size(); ++e) {
                    _doubles.add(effects[c][e]);
                }
            }
            _doubles.sort((o1, o2) -> Double.compare(o2, o1));
            doubles.add(_doubles);
        }
        ArrayList<Callable<Boolean>> task2s = new ArrayList<Callable<Boolean>>();
        Iterator iterator = qs.iterator();
        while (iterator.hasNext()) {
            int q = (Integer)iterator.next();
            class Task2
            implements Callable<Boolean> {
                private final List<Node> possibleCauses;
                private final List<Node> possibleEffects;
                private final int q;

                Task2(List<Node> possibleCauses, List<Node> possibleEffects, int q) {
                    this.possibleCauses = possibleCauses;
                    this.possibleEffects = possibleEffects;
                    this.q = q;
                }

                @Override
                public Boolean call() {
                    try {
                        if (verbose) {
                            TetradLogger.getInstance().forceLogMessage("Examining q = " + this.q);
                        }
                        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
                        for (int e = 0; e < this.possibleEffects.size(); ++e) {
                            for (int c = 0; c < this.possibleCauses.size(); ++c) {
                                int count = 0;
                                for (int k = 0; k < this.getNumSubsamples(); ++k) {
                                    if (this.q > ((List)doubles.get(k)).size()) continue;
                                    double cutoff = (Double)((List)doubles.get(k)).get(this.q - 1);
                                    if (!(((double[][])allEffects.get(k))[c][e] >= cutoff)) continue;
                                    ++count;
                                }
                                double pi = (double)count / (double)this.getNumSubsamples();
                                if (pi < (double)this.q / (double)p) continue;
                                Node cause = this.possibleCauses.get(c);
                                Node effect = this.possibleEffects.get(e);
                                tuples.add(new Tuple(cause, effect, pi, this.avgMinEffect(this.possibleCauses, this.possibleEffects, allEffects, cause, effect)));
                            }
                        }
                        tuples.sort((o1, o2) -> {
                            if (o1.getPi() == o2.getPi()) {
                                return Double.compare(o2.getMinBeta(), o1.getMinBeta());
                            }
                            return Double.compare(o2.getPi(), o1.getPi());
                        });
                        LinkedList<Record> records = new LinkedList<Record>();
                        for (Tuple tuple : tuples) {
                            double avg = tuple.getMinBeta();
                            Node causeNode = tuple.getCauseNode();
                            Node effectNode = tuple.getEffectNode();
                            if (!(tuple.getMinBeta() > selectionAlpha)) continue;
                            records.add(new Record(causeNode, effectNode, tuple.getPi(), avg, this.q, p));
                        }
                        allRecords.add(records);
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
            task2s.add(new Task2(possibleCauses, possibleEffects, q));
        }
        ConcurrencyUtils.runCallables(task2s, this.parallelized);
        allRecords.sort(Comparator.comparingDouble(List::size));
        return allRecords;
    }

    private DataSet readData(File dir) {
        try {
            DataSet dataSet = SimpleDataLoader.loadContinuousData(new File(dir, "data.txt"), "//", '*', "*", true, Delimiter.TAB);
            TetradLogger.getInstance().forceLogMessage("Loaded data " + dataSet.getNumRows() + " x " + dataSet.getNumColumns());
            return dataSet;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeData(DataSet dataSet, File dir) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(new File(dir, "data.txt")));
            out.println(dataSet.toString());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Node> readVars(DataSet dataSet, File dir, String s) {
        try {
            String line;
            ArrayList<Node> vars = new ArrayList<Node>();
            File file = new File(dir, s);
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                vars.add(dataSet.getVariable(line.trim()));
            }
            return vars;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeVars(List<Node> vars, File dir, String s) {
        try {
            File file = new File(dir, s);
            PrintStream out = new PrintStream(new FileOutputStream(file));
            for (Node node : vars) {
                out.println(node.getName());
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private double avgMinEffect(List<Node> possibleCauses, List<Node> possibleEffects, List<double[][]> allEffects, Node causeNode, Node effectNode) {
        ArrayList<Double> f = new ArrayList<Double>();
        if (allEffects == null) {
            throw new NullPointerException("effects null");
        }
        for (int k = 0; k < this.getNumSubsamples(); ++k) {
            int c = possibleCauses.indexOf(causeNode);
            int e = possibleEffects.indexOf(effectNode);
            f.add(allEffects.get(k)[c][e]);
        }
        double[] _f = new double[f.size()];
        for (int b = 0; b < f.size(); ++b) {
            _f[b] = (Double)f.get(b);
        }
        return StatUtils.mean(_f);
    }

    public String makeTable(LinkedList<Record> records, boolean printTable) {
        int numColumns = 8;
        TextTable table = new TextTable(records.size() + 1, numColumns);
        DecimalFormat nf = new DecimalFormat("0.0000");
        int column = 0;
        table.setToken(0, column++, "Index");
        table.setToken(0, column++, "Cause");
        table.setToken(0, column++, "Effect");
        table.setToken(0, column++, "PI");
        table.setToken(0, column++, "Effect");
        table.setToken(0, column++, "R-SUM(Pi)");
        table.setToken(0, column++, "E(V)");
        table.setToken(0, column, "PCER");
        double sumPi = 0.0;
        if (records.isEmpty()) {
            return "\nThere are no records above chance.\n";
        }
        int p = records.getLast().getP();
        int q = records.getLast().getQ();
        for (int i = 0; i < records.size(); ++i) {
            Node cause = records.get(i).getCauseNode();
            Node effect = records.get(i).getEffectNode();
            int R = i + 1;
            sumPi += records.get(i).getPi();
            column = 0;
            table.setToken(i + 1, column++, "" + (i + 1));
            table.setToken(i + 1, column++, cause.getName());
            table.setToken(i + 1, column++, effect.getName());
            table.setToken(i + 1, column++, nf.format(records.get(i).getPi()));
            table.setToken(i + 1, column++, nf.format(records.get(i).getMinBeta()));
            table.setToken(i + 1, column++, nf.format((double)R - sumPi));
            double er = Cstar.er(records.get(i).getPi(), i + 1, p);
            table.setToken(i + 1, column++, records.get(i).getPi() <= 0.5 ? "*" : nf.format(er));
            double pcer = Cstar.pcer(records.get(i).getPi(), i + 1, p);
            table.setToken(i + 1, column, records.get(i).getPi() <= 0.5 ? "*" : nf.format(pcer));
        }
        return (printTable ? "\n" + table : "") + "p = " + p + " q = " + q + (printTable ? " Type: C = continuous, D = discrete\n" : "");
    }

    public Graph makeGraph(List<Record> records) {
        ArrayList<Node> outNodes = new ArrayList<Node>();
        EdgeListGraph graph = new EdgeListGraph(outNodes);
        for (Record record : records) {
            graph.addNode(record.getCauseNode());
            graph.addNode(record.getEffectNode());
            graph.addDirectedEdge(record.getCauseNode(), record.getEffectNode());
        }
        return graph;
    }

    public void setqFrom(int qFrom) {
        this.qFrom = qFrom;
    }

    public void setqTo(int qTo) {
        this.qTo = qTo;
    }

    public void setqIncrement(int qIncrement) {
        this.qIncrement = qIncrement;
    }

    public void setPatternAlgorithm(PatternAlgorithm patternAlgorithm) {
        this.patternAlgorithm = patternAlgorithm;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setSelectionAlpha(double selectionAlpha) {
        this.selectionAlpha = selectionAlpha;
    }

    public void setSampleStyle(SampleStyle sampleStyle) {
        this.sampleStyle = sampleStyle;
    }

    private int getNumSubsamples() {
        return this.numSubsamples;
    }

    public void setNumSubsamples(int numSubsamples) {
        this.numSubsamples = numSubsamples;
    }

    private Graph getPatternPcStable(DataSet sample) {
        IndependenceTest test = this.getIndependenceTest(sample, this.test);
        test.setVerbose(false);
        PcStable pc = new PcStable(test);
        pc.setVerbose(false);
        return pc.search();
    }

    private Graph getPatternGRaSP(DataSet sample) {
        this.test.setVerbose(false);
        Grasp alg = new Grasp(new SemBicScore(sample));
        alg.setVerbose(false);
        alg.bestOrder(sample.getVariables());
        return alg.getGraph(true);
    }

    private Graph getPatternFges(DataSet sample) {
        ScoredIndTest score = new ScoredIndTest(this.getIndependenceTest(sample, this.test));
        Fges fges = new Fges(score);
        fges.setVerbose(false);
        return fges.search();
    }

    private IndependenceTest getIndependenceTest(DataSet sample, IndependenceTest test) {
        if (test instanceof IndTestScore && ((IndTestScore)test).getWrappedScore() instanceof SemBicScore) {
            SemBicScore score = new SemBicScore(new CorrelationMatrix(sample));
            score.setPenaltyDiscount(((SemBicScore)((IndTestScore)test).getWrappedScore()).getPenaltyDiscount());
            return new IndTestScore(score);
        }
        if (test instanceof IndTestFisherZ) {
            double alpha = test.getAlpha();
            return new IndTestFisherZ(new CorrelationMatrix(sample), alpha);
        }
        if (test instanceof ChiSquare) {
            double alpha = test.getAlpha();
            return new IndTestFisherZ(sample, alpha);
        }
        if (test instanceof IndTestScore && ((IndTestScore)test).getWrappedScore() instanceof ConditionalGaussianScore) {
            ConditionalGaussianScore score = (ConditionalGaussianScore)((IndTestScore)test).getWrappedScore();
            double penaltyDiscount = score.getPenaltyDiscount();
            ConditionalGaussianScore _score = new ConditionalGaussianScore(sample, 1.0, 0.0, false);
            _score.setPenaltyDiscount(penaltyDiscount);
            return new IndTestScore(_score);
        }
        throw new IllegalArgumentException("That test is not configured: " + test);
    }

    private void saveMatrix(double[][] effects, File file) {
        try {
            ArrayList<Node> vars = new ArrayList<Node>();
            for (int i = 0; i < effects[0].length; ++i) {
                vars.add(new ContinuousVariable("V" + (i + 1)));
            }
            BoxDataSet data = new BoxDataSet(new DoubleDataBox(effects), vars);
            if (file != null) {
                PrintStream out = new PrintStream(new FileOutputStream(file));
                out.println(data);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private double[][] loadMatrix(File file) {
        try {
            DataSet dataSet = SimpleDataLoader.loadContinuousData(file, "//", '\"', "*", true, Delimiter.TAB);
            return dataSet.getDoubleData().toArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<double[][]> runCallablesDoubleArray(List<Callable<double[][]>> tasks, boolean parallelized) {
        if (tasks.isEmpty()) {
            return new ArrayList<double[][]>();
        }
        ArrayList<double[][]> results = new ArrayList<double[][]>();
        if (!parallelized) {
            for (Callable<double[][]> task : tasks) {
                try {
                    results.add(task.call());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            ForkJoinPool executorService = ForkJoinPool.commonPool();
            try {
                List<Future<double[][]>> futures = executorService.invokeAll(tasks);
                for (Future<double[][]> future : futures) {
                    results.add(future.get());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public static enum PatternAlgorithm {
        FGES,
        PC_STABLE,
        GRaSP;

    }

    public static enum SampleStyle {
        BOOTSTRAP,
        SPLIT;

    }

    public static class Record
    implements TetradSerializable {
        static final long serialVersionUID = 23L;
        private final Node causeNode;
        private final Node target;
        private final double pi;
        private final double effect;
        private final int q;
        private final int p;

        Record(Node predictor, Node target, double pi, double minEffect, int q, int p) {
            this.causeNode = predictor;
            this.target = target;
            this.pi = pi;
            this.effect = minEffect;
            this.q = q;
            this.p = p;
        }

        public Node getCauseNode() {
            return this.causeNode;
        }

        public Node getEffectNode() {
            return this.target;
        }

        public double getPi() {
            return this.pi;
        }

        double getMinBeta() {
            return this.effect;
        }

        public int getQ() {
            return this.q;
        }

        public int getP() {
            return this.p;
        }
    }

    private static class Tuple {
        private final Node cause;
        private final Node effect;
        private final double pi;
        private final double minBeta;

        private Tuple(Node cause, Node effect, double pi, double minBeta) {
            this.cause = cause;
            this.effect = effect;
            this.pi = pi;
            this.minBeta = minBeta;
        }

        public Node getCauseNode() {
            return this.cause;
        }

        public Node getEffectNode() {
            return this.effect;
        }

        public double getPi() {
            return this.pi;
        }

        public double getMinBeta() {
            return this.minBeta;
        }
    }
}

