/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import java.util.LinkedList;

public class DagIterator {
    private final LinkedList<DecoratedGraph> decoratedGraphs = new LinkedList();
    private Graph storedDag;

    public DagIterator(Graph CPDAG) {
        for (Edge edge : CPDAG.getEdges()) {
            if (Edges.isDirectedEdge(edge) || Edges.isUndirectedEdge(edge)) continue;
            throw new IllegalArgumentException("The graph may consist only of directed and undirected edges: " + edge);
        }
        this.decoratedGraphs.add(new DecoratedGraph(CPDAG));
    }

    public Graph next() {
        DecoratedGraph graph;
        if (this.storedDag != null) {
            Graph temp = this.storedDag;
            this.storedDag = null;
            return temp;
        }
        if (this.decoratedGraphs.isEmpty()) {
            return null;
        }
        if (!this.decoratedGraphs.getLast().hasUndirectedEdge()) {
            DecoratedGraph graph1;
            while (true) {
                if (this.decoratedGraphs.isEmpty()) {
                    return null;
                }
                graph = this.decoratedGraphs.removeLast();
                if (graph.hasUndirectedEdge() && !graph.wasDirectedRight()) {
                    throw new IllegalStateException();
                }
                if (this.decoratedGraphs.isEmpty() && !graph.hasUndirectedEdge()) {
                    return new EdgeListGraph(graph.getGraph());
                }
                if (!graph.wasDirectedRight() || graph.wasDirectedLeft()) continue;
                this.decoratedGraphs.add(graph);
                graph1 = graph.directLeft();
                if (graph1 != null) break;
            }
            this.decoratedGraphs.add(graph1);
        }
        while (this.decoratedGraphs.getLast().hasUndirectedEdge()) {
            graph = this.decoratedGraphs.getLast().directRight();
            if (graph == null) continue;
            this.decoratedGraphs.add(graph);
        }
        return new EdgeListGraph(this.decoratedGraphs.getLast().getGraph());
    }

    public boolean hasNext() {
        if (this.storedDag == null) {
            this.storedDag = this.next();
        }
        return this.storedDag != null;
    }

    private static class DecoratedGraph {
        private Graph graph;
        private Edge edge;
        private boolean wasDirectedRight;
        private boolean wasDirectedLeft;

        public DecoratedGraph(Graph graph) {
            this.setGraph(graph);
            this.edge = this.findUndirectedEdge(graph);
        }

        private Edge findUndirectedEdge(Graph graph) {
            for (Edge edge : graph.getEdges()) {
                if (!Edges.isUndirectedEdge(edge)) continue;
                return edge;
            }
            return null;
        }

        private boolean hasUndirectedEdge() {
            return this.edge != null;
        }

        public Graph getGraph() {
            return this.graph;
        }

        public void setGraph(Graph graph) {
            this.graph = graph;
        }

        public Edge getEdge() {
            return this.edge;
        }

        public void setEdge(Edge edge) {
            this.edge = edge;
        }

        public boolean wasDirectedRight() {
            return this.wasDirectedRight;
        }

        public boolean wasDirectedLeft() {
            return this.wasDirectedLeft;
        }

        public DecoratedGraph directLeft() {
            if (this.edge == null) {
                throw new IllegalArgumentException();
            }
            if (this.graph.paths().isAncestorOf(this.edge.getNode1(), this.edge.getNode2()) && !this.graph.paths().isAncestorOf(this.edge.getNode2(), this.edge.getNode1())) {
                this.wasDirectedLeft = true;
                return this.directRight();
            }
            if (!this.wasDirectedLeft) {
                EdgeListGraph graph = new EdgeListGraph(this.graph);
                graph.removeEdge(this.edge.getNode1(), this.edge.getNode2());
                graph.addDirectedEdge(this.edge.getNode2(), this.edge.getNode1());
                this.wasDirectedLeft = true;
                return new DecoratedGraph(graph);
            }
            return null;
        }

        public DecoratedGraph directRight() {
            if (this.edge == null) {
                throw new IllegalArgumentException();
            }
            if (this.graph.paths().isAncestorOf(this.edge.getNode2(), this.edge.getNode1()) && !this.graph.paths().isAncestorOf(this.edge.getNode1(), this.edge.getNode2())) {
                this.wasDirectedRight = true;
                return this.directLeft();
            }
            if (!this.wasDirectedRight) {
                EdgeListGraph graph = new EdgeListGraph(this.graph);
                graph.removeEdge(this.edge.getNode1(), this.edge.getNode2());
                graph.addDirectedEdge(this.edge.getNode1(), this.edge.getNode2());
                this.wasDirectedRight = true;
                return new DecoratedGraph(graph);
            }
            return null;
        }

        public String toString() {
            return this.graph.toString();
        }
    }
}

