/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SepsetProducer;
import java.util.List;

public class DagSepsets
implements SepsetProducer {
    private final EdgeListGraph dag;
    private boolean verbose;

    public DagSepsets(Graph dag) {
        this.dag = new EdgeListGraph(dag);
    }

    @Override
    public List<Node> getSepset(Node a, Node b) {
        return this.dag.getSepset(a, b);
    }

    @Override
    public boolean isUnshieldedCollider(Node i, Node j, Node k) {
        List<Node> sepset = this.dag.getSepset(i, k);
        return sepset != null && !sepset.contains(j);
    }

    @Override
    public boolean isUnshieldedNoncollider(Node i, Node j, Node k) {
        List<Node> sepset = this.dag.getSepset(i, k);
        return sepset != null && sepset.contains(j);
    }

    @Override
    public double getScore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIndependent(Node a, Node b, List<Node> c) {
        return this.dag.paths().isDSeparatedFrom(a, b, c);
    }

    @Override
    public List<Node> getVariables() {
        return this.dag.getNodes();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Graph getDag() {
        return this.dag;
    }
}

