/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.DagSepsets;
import edu.cmu.tetrad.search.FciOrient;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;

public final class DagToPag {
    private final Graph dag;
    private Knowledge knowledge = new Knowledge();
    private boolean completeRuleSetUsed = true;
    private final TetradLogger logger = TetradLogger.getInstance();
    private boolean verbose;
    private int maxPathLength = -1;
    private Graph truePag;
    private boolean doDiscriminatingPathRule = true;
    private static final WeakHashMap<Graph, Graph> history = new WeakHashMap();

    public DagToPag(Graph dag) {
        this.dag = new EdgeListGraph(dag);
    }

    public Graph convert() {
        this.logger.log("info", "Starting DAG to PAG_of_the_true_DAG.");
        if (history.get(this.dag) != null) {
            return history.get(this.dag);
        }
        if (this.verbose) {
            System.out.println("DAG to PAG_of_the_true_DAG: Starting adjacency search");
        }
        Graph graph = this.calcAdjacencyGraph();
        if (this.verbose) {
            System.out.println("DAG to PAG_of_the_true_DAG: Starting collider orientation");
        }
        this.orientUnshieldedColliders(graph, this.dag);
        if (this.verbose) {
            System.out.println("DAG to PAG_of_the_true_DAG: Starting final orientation");
        }
        FciOrient fciOrient = new FciOrient(new DagSepsets(this.dag));
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setKnowledge(this.knowledge);
        fciOrient.setVerbose(false);
        fciOrient.doFinalOrientation(graph);
        if (this.verbose) {
            System.out.println("Finishing final orientation");
        }
        history.put(this.dag, graph);
        return graph;
    }

    private Graph calcAdjacencyGraph() {
        List<Node> allNodes = this.dag.getNodes();
        ArrayList<Node> measured = new ArrayList<Node>(allNodes);
        measured.removeIf(node -> node.getNodeType() == NodeType.LATENT);
        EdgeListGraph graph = new EdgeListGraph(measured);
        for (int i = 0; i < measured.size(); ++i) {
            for (int j = i + 1; j < measured.size(); ++j) {
                boolean exists;
                Node n2;
                Node n1 = (Node)measured.get(i);
                if (graph.isAdjacentTo(n1, n2 = (Node)measured.get(j))) continue;
                List<Node> inducingPath = this.dag.paths().getInducingPath(n1, n2);
                boolean bl = exists = inducingPath != null;
                if (!exists) continue;
                graph.addEdge(Edges.nondirectedEdge(n1, n2));
            }
        }
        return graph;
    }

    private void orientUnshieldedColliders(Graph graph, Graph dag) {
        graph.reorientAllWith(Endpoint.CIRCLE);
        List<Node> allNodes = dag.getNodes();
        ArrayList<Node> measured = new ArrayList<Node>();
        for (Node node : allNodes) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            measured.add(node);
        }
        for (Node b : measured) {
            List<Node> adjb = graph.getAdjacentNodes(b);
            if (adjb.size() < 2) continue;
            for (int i = 0; i < adjb.size(); ++i) {
                for (int j = i + 1; j < adjb.size(); ++j) {
                    boolean found;
                    Node c;
                    Node a = adjb.get(i);
                    if (graph.isDefCollider(a, b, c = adjb.get(j)) || graph.isAdjacentTo(a, c) || !(found = this.foundCollider(dag, a, b, c))) continue;
                    if (this.verbose) {
                        System.out.println("Orienting collider " + a + "*->" + b + "<-*" + c);
                    }
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    graph.setEndpoint(c, b, Endpoint.ARROW);
                }
            }
        }
    }

    private boolean foundCollider(Graph dag, Node a, Node b, Node c) {
        boolean ipba = DagToPag.existsInducingPathInto(b, a, dag);
        boolean ipbc = DagToPag.existsInducingPathInto(b, c, dag);
        if (!ipba || !ipbc) {
            this.printTrueDefCollider(a, b, c, false);
            return false;
        }
        this.printTrueDefCollider(a, b, c, true);
        return true;
    }

    private void printTrueDefCollider(Node a, Node b, Node c, boolean found) {
        if (this.truePag != null) {
            boolean defCollider = this.truePag.isDefCollider(a, b, c);
            if (this.verbose) {
                if (!found && defCollider) {
                    System.out.println("FOUND COLLIDER FCI");
                } else if (found && !defCollider) {
                    System.out.println("DIDN'T FIND COLLIDER FCI");
                }
            }
        }
    }

    public static boolean existsInducingPathInto(Node x, Node y, Graph graph) {
        if (x.getNodeType() != NodeType.MEASURED) {
            throw new IllegalArgumentException();
        }
        if (y.getNodeType() != NodeType.MEASURED) {
            throw new IllegalArgumentException();
        }
        LinkedList<Node> path = new LinkedList<Node>();
        path.add(x);
        for (Node b : graph.getAdjacentNodes(x)) {
            Edge edge = graph.getEdge(x, b);
            if (edge.getProximalEndpoint(x) != Endpoint.ARROW || !graph.paths().existsInducingPathVisit(x, b, x, y, path)) continue;
            return true;
        }
        return false;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public Graph getTruePag() {
        return this.truePag;
    }

    public void setTruePag(Graph truePag) {
        this.truePag = truePag;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }
}

