/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CorrelationMatrixOnTheFly;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.CovarianceMatrixOnTheFly;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SemBicScore;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.Matrix;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.FastMath;

public class EbicScore
implements Score {
    private DataSet dataSet;
    private ICovarianceMatrix covariances;
    private final List<Node> variables;
    private final int sampleSize;
    private boolean verbose;
    private double N;
    private Matrix data;
    private boolean calculateRowSubsets;
    private double gamma = 1.0;

    public EbicScore(ICovarianceMatrix covariances) {
        if (covariances == null) {
            throw new NullPointerException();
        }
        this.setCovariances(covariances);
        this.variables = covariances.getVariables();
        this.sampleSize = covariances.getSampleSize();
    }

    public EbicScore(DataSet dataSet, boolean precomputeCovariances) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.dataSet = dataSet;
        this.variables = dataSet.getVariables();
        this.sampleSize = dataSet.getNumRows();
        DataSet _dataSet = DataUtils.center(dataSet);
        this.data = _dataSet.getDoubleData();
        if (!dataSet.existsMissingValue()) {
            if (!precomputeCovariances) {
                this.setCovariances(new CovarianceMatrixOnTheFly(dataSet));
            } else {
                this.setCovariances(new CovarianceMatrix(dataSet));
            }
            this.calculateRowSubsets = false;
        } else {
            this.calculateRowSubsets = true;
        }
    }

    private int[] indices(List<Node> __adj) {
        int[] indices = new int[__adj.size()];
        for (int t = 0; t < __adj.size(); ++t) {
            indices[t] = this.variables.indexOf(__adj.get(t));
        }
        return indices;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, EbicScore.append(z, x)) - this.localScore(y, z);
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScoreDiff(x, y, new int[0]);
    }

    @Override
    public double localScore(int i, int ... parents) throws RuntimeException {
        double varRy;
        int pi = parents.length;
        try {
            varRy = SemBicScore.getVarRy(i, parents, this.data, this.covariances, this.calculateRowSubsets);
        }
        catch (SingularMatrixException e) {
            return Double.NaN;
        }
        double gamma = this.gamma;
        double score = -(this.N * FastMath.log(varRy) + ((double)pi * FastMath.log(this.N) + (double)(2 * pi) * gamma * ChoiceGenerator.logCombinations(this.variables.size() - 1, pi)));
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    public static double getP(int pn, int m0, double lambda) {
        return 2.0 - FastMath.pow(1.0 + FastMath.exp(-(lambda - 1.0) / 2.0) * FastMath.sqrt(lambda), (double)pn - (double)m0);
    }

    @Override
    public double localScore(int i, int parent) {
        return this.localScore(i, new int[]{parent});
    }

    @Override
    public double localScore(int i) {
        return this.localScore(i, new int[0]);
    }

    public ICovarianceMatrix getCovariances() {
        return this.covariances;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String targetName) {
        for (Node node : this.variables) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getMaxDegree() {
        return (int)FastMath.ceil(FastMath.log(this.sampleSize));
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        int i = this.variables.indexOf(y);
        int[] k = this.indices(z);
        double v = this.localScore(i, k);
        return Double.isNaN(v);
    }

    public DataModel getData() {
        return this.dataSet;
    }

    private void setCovariances(ICovarianceMatrix covariances) {
        CorrelationMatrixOnTheFly correlations = new CorrelationMatrixOnTheFly(covariances);
        this.covariances = covariances;
        boolean exists = false;
        double correlationThreshold = 1.0;
        for (int i = 0; i < correlations.getSize(); ++i) {
            for (int j = 0; j < correlations.getSize(); ++j) {
                double r;
                if (i == j || !(FastMath.abs(r = correlations.getValue(i, j)) > correlationThreshold)) continue;
                System.out.println("Absolute correlation too high: " + r);
                exists = true;
            }
        }
        if (exists) {
            throw new IllegalArgumentException("Some correlations are too high (> " + correlationThreshold + ") in absolute value.");
        }
        this.N = covariances.getSampleSize();
    }

    private static int[] append(int[] z, int x) {
        int[] _z = Arrays.copyOf(z, z.length + 1);
        _z[z.length] = x;
        return _z;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }
}

