/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Fas
implements IFas {
    private final IndependenceTest test;
    private final TetradLogger logger = TetradLogger.getInstance();
    private final NumberFormat nf = new DecimalFormat("0.00E0");
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private int numIndependenceTests;
    private int numDependenceJudgement;
    private SepsetMap sepset = new SepsetMap();
    private boolean verbose;
    private int heuristic;
    private boolean stable;

    public Fas(IndependenceTest test) {
        this.test = test;
    }

    @Override
    public Graph search(List<Node> nodes) {
        HashMap<Edge, Double> scores;
        ArrayList<Edge> edges;
        int _depth;
        block19: {
            block18: {
                nodes = new ArrayList<Node>(nodes);
                if (this.verbose) {
                    this.logger.log("info", "Starting Fast Adjacency Search.");
                }
                this.test.setVerbose(this.verbose);
                _depth = this.depth;
                if (_depth == -1) {
                    _depth = 1000;
                }
                this.sepset = new SepsetMap();
                edges = new ArrayList<Edge>();
                scores = new HashMap<Edge, Double>();
                if (this.heuristic == 1) {
                    Collections.sort(nodes);
                }
                for (int i = 0; i < nodes.size(); ++i) {
                    for (int j = i + 1; j < nodes.size(); ++j) {
                        edges.add(Edges.undirectedEdge(nodes.get(i), nodes.get(j)));
                    }
                }
                for (Edge edge : edges) {
                    this.test.checkIndependence(edge.getNode1(), edge.getNode2(), new ArrayList<Node>());
                    scores.put(edge, this.test.getScore());
                }
                if (this.heuristic == 2) break block18;
                if (this.heuristic != 3) break block19;
            }
            edges.sort(Comparator.comparing(scores::get));
        }
        HashMap<Node, Set<Node>> adjacencies = new HashMap<Node, Set<Node>>();
        for (Node node : nodes) {
            LinkedHashSet<Node> set = new LinkedHashSet<Node>();
            for (Node _node : nodes) {
                if (_node == node) continue;
                set.add(_node);
            }
            adjacencies.put(node, set);
        }
        for (Edge edge : new ArrayList(edges)) {
            if (!(scores.get(edge) != null && (Double)scores.get(edge) < 0.0) && (!this.knowledge.isForbidden(edge.getNode1().getName(), edge.getNode2().getName()) || !this.knowledge.isForbidden(edge.getNode2().getName(), edge.getNode1().getName()))) continue;
            edges.remove(edge);
            ((Set)adjacencies.get(edge.getNode1())).remove(edge.getNode2());
            ((Set)adjacencies.get(edge.getNode2())).remove(edge.getNode1());
            this.sepset.set(edge.getNode1(), edge.getNode2(), new ArrayList<Node>());
        }
        for (int d = 0; d <= _depth; ++d) {
            boolean more;
            if (this.stable) {
                HashMap adjacenciesCopy = new HashMap();
                for (Node node : adjacencies.keySet()) {
                    adjacenciesCopy.put(node, new LinkedHashSet((Collection)adjacencies.get(node)));
                }
                adjacencies = adjacenciesCopy;
            }
            if (!(more = this.searchAtDepth(scores, edges, this.test, adjacencies, d))) break;
        }
        EdgeListGraph graph = new EdgeListGraph(nodes);
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node x = nodes.get(i);
                Node y = nodes.get(j);
                if (!((Set)adjacencies.get(x)).contains(y)) continue;
                graph.addUndirectedEdge(x, y);
            }
        }
        if (this.verbose) {
            this.logger.log("info", "Finishing Fast Adjacency Search.");
        }
        return graph;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    private int freeDegree(Map<Node, Set<Node>> adjacencies) {
        int max = 0;
        for (Node x : adjacencies.keySet()) {
            Set<Node> opposites = adjacencies.get(x);
            for (Node y : opposites) {
                LinkedHashSet<Node> adjx = new LinkedHashSet<Node>(opposites);
                adjx.remove(y);
                if (adjx.size() <= max) continue;
                max = adjx.size();
            }
        }
        return max;
    }

    private boolean searchAtDepth(Map<Edge, Double> scores, List<Edge> edges, IndependenceTest test, Map<Node, Set<Node>> adjacencies, int depth) {
        for (Edge edge : edges) {
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            if (Thread.currentThread().isInterrupted()) break;
            boolean b = this.checkSide(scores, test, adjacencies, depth, x, y);
            if (b) continue;
            this.checkSide(scores, test, adjacencies, depth, y, x);
        }
        return this.freeDegree(adjacencies) > depth;
    }

    private boolean checkSide(Map<Edge, Double> scores, IndependenceTest test, Map<Node, Set<Node>> adjacencies, int depth, Node x, Node y) {
        if (!adjacencies.get(x).contains(y)) {
            return false;
        }
        ArrayList<Node> _adjx = new ArrayList<Node>((Collection)adjacencies.get(x));
        _adjx.remove(y);
        if (this.heuristic == 1 || this.heuristic == 2) {
            Collections.sort(_adjx);
        }
        List<Node> ppx = this.possibleParents(x, _adjx, this.knowledge, y);
        HashMap<Node, Double> scores2 = new HashMap<Node, Double>();
        for (Node node : ppx) {
            Double _score = scores.get(Edges.undirectedEdge(node, x));
            scores2.put(node, _score);
        }
        if (this.heuristic == 3) {
            ppx.sort(Comparator.comparing(scores2::get));
            Collections.reverse(ppx);
        }
        if (ppx.size() >= depth) {
            int[] choice;
            ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
            while ((choice = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
                List<Node> Z = GraphUtils.asList(choice, ppx);
                ++this.numIndependenceTests;
                boolean independent = test.checkIndependence(x, y, Z).independent();
                if (!independent) {
                    ++this.numDependenceJudgement;
                }
                boolean noEdgeRequired = this.knowledge.noEdgeRequired(x.getName(), y.getName());
                if (!independent || !noEdgeRequired) continue;
                adjacencies.get(x).remove(y);
                adjacencies.get(y).remove(x);
                this.getSepsets().set(x, y, Z);
                return true;
            }
        }
        return false;
    }

    private List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge, Node y) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z;
            if (z == x || z == y || !this.possibleParentOf(_z = z.getName(), _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.isForbidden(z, x) && !knowledge.isRequired(x, z);
    }

    @Override
    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    @Override
    public int getNumDependenceJudgments() {
        return this.numDependenceJudgement;
    }

    @Override
    public SepsetMap getSepsets() {
        return this.sepset;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isAggressivelyPreventCycles() {
        return false;
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        return null;
    }

    @Override
    public Graph search() {
        return this.search(this.test.getVariables());
    }

    @Override
    public long getElapsedTime() {
        return 0L;
    }

    @Override
    public List<Node> getNodes() {
        return this.test.getVariables();
    }

    @Override
    public List<Triple> getAmbiguousTriples(Node node) {
        return null;
    }

    @Override
    public void setOut(PrintStream out) {
    }

    public void setHeuristic(int heuristic) {
        this.heuristic = heuristic;
    }

    public void setStable(boolean stable) {
        this.stable = stable;
    }
}

