/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FasConcurrent
implements IFas {
    private final IndependenceTest test;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private int numIndependenceTests;
    private TetradLogger logger = TetradLogger.getInstance();
    private SepsetMap sepsets = new SepsetMap();
    private boolean verbose;
    private PrintStream out = System.out;
    private boolean stable = true;

    public FasConcurrent(IndependenceTest test) {
        this.test = test;
    }

    @Override
    public Graph search() {
        boolean more;
        this.logger.log("info", "Starting Fast Adjacency Search.");
        EdgeListGraph graph = new EdgeListGraph(this.test.getVariables());
        this.sepsets = new SepsetMap();
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        ConcurrentHashMap<Node, Set<Node>> adjacencies = new ConcurrentHashMap<Node, Set<Node>>();
        List<Node> nodes = graph.getNodes();
        for (Node node : nodes) {
            adjacencies.put(node, new HashSet());
        }
        for (int d = 0; d <= _depth && (more = d == 0 ? this.searchAtDepth0(nodes, adjacencies) : this.searchAtDepth(d, nodes, adjacencies)); ++d) {
        }
        if (this.verbose) {
            this.out.println("Finished with search, constructing Graph...");
        }
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node x = nodes.get(i);
                Node y = nodes.get(j);
                if (!((Set)adjacencies.get(x)).contains(y)) continue;
                graph.addUndirectedEdge(x, y);
            }
        }
        if (this.verbose) {
            this.out.println("Finished constructing Graph.");
        }
        if (this.verbose) {
            this.logger.log("info", "Finishing Fast Adjacency Search.");
        }
        return graph;
    }

    private boolean searchAtDepth0(final List<Node> nodes, final Map<Node, Set<Node>> adjacencies) {
        if (this.verbose) {
            System.out.println("Searching at depth 0.");
        }
        final List empty = Collections.emptyList();
        class Depth0Task
        implements Callable<Boolean> {
            private final int i;

            Depth0Task(int i) {
                this.i = i;
            }

            @Override
            public Boolean call() {
                FasConcurrent.this.doNodeDepth0(this.i, nodes, FasConcurrent.this.test, empty, adjacencies);
                return true;
            }
        }
        ArrayList<Depth0Task> tasks = new ArrayList<Depth0Task>();
        for (int i = 0; i < nodes.size(); ++i) {
            tasks.add(new Depth0Task(i));
        }
        ExecutorService pool = Executors.newWorkStealingPool(Runtime.getRuntime().availableProcessors());
        try {
            pool.invokeAll(tasks);
        }
        catch (InterruptedException exception) {
            this.out.print("Task has been interrupted");
            Thread.currentThread().interrupt();
        }
        this.shutdownAndAwaitTermination(pool);
        return this.freeDegree(nodes, adjacencies) > this.depth;
    }

    private boolean searchAtDepth(int depth, final List<Node> nodes, final Map<Node, Set<Node>> adjacencies) {
        Map<Node, Set<Node>> adjacenciesCopy;
        if (this.verbose) {
            System.out.println("Searching at depth " + depth);
        }
        if (this.stable) {
            adjacenciesCopy = new ConcurrentHashMap<Node, Set<Node>>();
            for (Node node : adjacencies.keySet()) {
                adjacenciesCopy.put(node, new HashSet(adjacencies.get(node)));
            }
        } else {
            adjacenciesCopy = adjacencies;
        }
        new ConcurrentHashMap();
        for (Node node : adjacencies.keySet()) {
            adjacenciesCopy.put(node, new HashSet(adjacencies.get(node)));
        }
        class DepthTask
        implements Callable<Boolean> {
            private final int i;
            private final int depth;

            public DepthTask(int i, int depth) {
                this.i = i;
                this.depth = depth;
            }

            @Override
            public Boolean call() {
                FasConcurrent.this.doNodeAtDepth(this.i, nodes, this.depth, FasConcurrent.this.test, adjacencies);
                return true;
            }
        }
        ArrayList<DepthTask> tasks = new ArrayList<DepthTask>();
        for (int i = 0; i < nodes.size(); ++i) {
            tasks.add(new DepthTask(i, depth));
        }
        ExecutorService pool = Executors.newWorkStealingPool(Runtime.getRuntime().availableProcessors());
        try {
            pool.invokeAll(tasks);
        }
        catch (InterruptedException exception) {
            this.out.print("Task has been interrupted");
            Thread.currentThread().interrupt();
        }
        this.shutdownAndAwaitTermination(pool);
        return this.freeDegree(nodes, adjacencies) > depth;
    }

    @Override
    public Graph search(List<Node> nodes) {
        nodes = new ArrayList<Node>(nodes);
        return null;
    }

    @Override
    public long getElapsedTime() {
        return 0L;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    @Override
    public boolean isAggressivelyPreventCycles() {
        return false;
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        return this.test;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    private void doNodeDepth0(int i, List<Node> nodes, IndependenceTest test, List<Node> empty, Map<Node, Set<Node>> adjacencies) {
        if (this.verbose && (i + 1) % 1000 == 0) {
            System.out.println("i = " + (i + 1));
        }
        if (this.verbose && (i + 1) % 100 == 0) {
            this.out.println("Node # " + (i + 1));
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Node x = nodes.get(i);
        for (int j = i + 1; j < nodes.size(); ++j) {
            boolean independent;
            Node y = nodes.get(j);
            try {
                ++this.numIndependenceTests;
                independent = test.checkIndependence(x, y, empty).independent();
            }
            catch (Exception e) {
                e.printStackTrace();
                independent = false;
            }
            boolean noEdgeRequired = this.knowledge.noEdgeRequired(x.getName(), y.getName());
            if (independent && noEdgeRequired) {
                this.getSepsets().set(x, y, empty);
                continue;
            }
            if (this.forbiddenEdge(x, y)) continue;
            adjacencies.get(x).add(y);
            adjacencies.get(y).add(x);
        }
    }

    private void doNodeAtDepth(int i, List<Node> nodes, int depth, IndependenceTest test, Map<Node, Set<Node>> adjacencies) {
        if (this.verbose && (i + 1) % 1000 == 0) {
            System.out.println("i = " + (i + 1));
        }
        Node x = nodes.get(i);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        ArrayList adjx = new ArrayList(adjacencies.get(x));
        block2: for (Node y : adjx) {
            int[] choice;
            ArrayList<Node> _adjx = new ArrayList<Node>((Collection)adjacencies.get(x));
            _adjx.remove(y);
            List<Node> ppx = this.possibleParents(x, _adjx, this.knowledge);
            if (ppx.size() < depth) continue;
            ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
            while ((choice = cg.next()) != null) {
                boolean independent;
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                List<Node> condSet = GraphUtils.asList(choice, ppx);
                try {
                    ++this.numIndependenceTests;
                    independent = test.checkIndependence(x, y, condSet).independent();
                }
                catch (Exception e) {
                    independent = false;
                }
                boolean noEdgeRequired = this.knowledge.noEdgeRequired(x.getName(), y.getName());
                if (!independent || !noEdgeRequired) continue;
                adjacencies.get(x).remove(y);
                adjacencies.get(y).remove(x);
                this.getSepsets().set(x, y, condSet);
                continue block2;
            }
        }
    }

    private boolean forbiddenEdge(Node x, Node y) {
        String name2;
        String name1 = x.getName();
        if (this.knowledge.isForbidden(name1, name2 = y.getName()) && this.knowledge.isForbidden(name2, name1)) {
            if (this.verbose) {
                this.logger.log("edgeRemoved", "Removed " + Edges.undirectedEdge(x, y) + " because it was forbidden by background knowledge.");
            }
            return true;
        }
        return false;
    }

    private int freeDegree(List<Node> nodes, Map<Node, Set<Node>> adjacencies) {
        int max = 0;
        for (Node x : nodes) {
            Set<Node> opposites = adjacencies.get(x);
            for (Node y : opposites) {
                HashSet<Node> adjx = new HashSet<Node>(opposites);
                adjx.remove(y);
                if (adjx.size() <= max) continue;
                max = adjx.size();
            }
        }
        return max;
    }

    private List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.isForbidden(z, x) && !knowledge.isRequired(x, z);
    }

    @Override
    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    @Override
    public List<Node> getNodes() {
        return null;
    }

    @Override
    public List<Triple> getAmbiguousTriples(Node node) {
        return null;
    }

    @Override
    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public TetradLogger getLogger() {
        return this.logger;
    }

    public void setLogger(TetradLogger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public int getNumDependenceJudgments() {
        return 0;
    }

    @Override
    public void setOut(PrintStream out) {
        if (out == null) {
            throw new NullPointerException();
        }
        this.out = out;
    }

    public PrintStream getOut() {
        return this.out;
    }

    private void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(1L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(1L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void setStable(boolean stable) {
        this.stable = stable;
    }
}

