/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class FasDeterministic
implements IFas {
    private final Graph graph;
    private final IndependenceTest test;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private int numIndependenceTests;
    private final TetradLogger logger = TetradLogger.getInstance();
    private int numDependenceJudgement;
    private SepsetMap sepset = new SepsetMap();
    private Graph externalGraph;
    private final NumberFormat nf = new DecimalFormat("0.00E0");
    private boolean verbose;
    private PrintStream out = System.out;

    public FasDeterministic(Graph graph, IndependenceTest test) {
        this.graph = graph;
        this.test = test;
    }

    public FasDeterministic(IndependenceTest test) {
        this.graph = new EdgeListGraph(test.getVariables());
        this.test = test;
    }

    @Override
    public Graph search() {
        boolean more;
        this.logger.log("info", "Starting Fast Adjacency Search.");
        this.graph.removeEdges(this.graph.getEdges());
        this.sepset = new SepsetMap();
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        HashMap<Node, Set<Node>> adjacencies = new HashMap<Node, Set<Node>>();
        List<Node> nodes = this.graph.getNodes();
        for (Node node : nodes) {
            adjacencies.put(node, new TreeSet());
        }
        for (int d = 0; d <= _depth && (more = d == 0 ? this.searchAtDepth0(nodes, this.test, adjacencies) : this.searchAtDepth(nodes, this.test, adjacencies, d)); ++d) {
        }
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node x = nodes.get(i);
                Node y = nodes.get(j);
                if (!((Set)adjacencies.get(x)).contains(y)) continue;
                this.graph.addUndirectedEdge(x, y);
            }
        }
        this.logger.log("info", "Finishing Fast Adjacency Search.");
        return this.graph;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException("Cannot set knowledge to null");
        }
        this.knowledge = knowledge;
    }

    private boolean searchAtDepth0(List<Node> nodes, IndependenceTest test, Map<Node, Set<Node>> adjacencies) {
        List<Node> empty = Collections.emptyList();
        for (int i = 0; i < nodes.size(); ++i) {
            if (this.verbose && (i + 1) % 100 == 0) {
                this.out.println("Node # " + (i + 1));
            }
            Node x = nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                IndependenceResult result;
                Node y2;
                Node x2;
                Node y = nodes.get(j);
                if (this.externalGraph != null && !this.externalGraph.isAdjacentTo(x2 = this.externalGraph.getNode(x.getName()), y2 = this.externalGraph.getNode(y.getName()))) continue;
                try {
                    ++this.numIndependenceTests;
                    result = test.checkIndependence(x, y, empty);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = new IndependenceResult(new IndependenceFact(x, y, empty), false, Double.NaN);
                }
                if (!result.independent()) {
                    ++this.numDependenceJudgement;
                }
                boolean noEdgeRequired = this.knowledge.noEdgeRequired(x.getName(), y.getName());
                if (result.independent() && noEdgeRequired) {
                    this.getSepsets().set(x, y, empty);
                    TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFact(x, y, empty) + " p = " + this.nf.format(result.getPValue()));
                    if (!this.verbose) continue;
                    this.out.println(SearchLogUtils.independenceFact(x, y, empty) + " p = " + this.nf.format(result.getPValue()));
                    continue;
                }
                if (this.forbiddenEdge(x, y)) continue;
                adjacencies.get(x).add(y);
                adjacencies.get(y).add(x);
                TetradLogger.getInstance().log("dependencies", SearchLogUtils.independenceFact(x, y, empty) + " p = " + this.nf.format(result.getPValue()));
            }
        }
        return this.freeDegree(nodes, adjacencies) > 0;
    }

    private int freeDegree(List<Node> nodes, Map<Node, Set<Node>> adjacencies) {
        int max = 0;
        for (Node x : nodes) {
            Set<Node> opposites = adjacencies.get(x);
            for (Node y : opposites) {
                HashSet<Node> adjx = new HashSet<Node>(opposites);
                adjx.remove(y);
                if (adjx.size() <= max) continue;
                max = adjx.size();
            }
        }
        return max;
    }

    private boolean forbiddenEdge(Node x, Node y) {
        String name2;
        String name1 = x.getName();
        if (this.knowledge.isForbidden(name1, name2 = y.getName()) && this.knowledge.isForbidden(name2, name1)) {
            this.logger.log("edgeRemoved", "Removed " + Edges.undirectedEdge(x, y) + " because it was forbidden by background knowledge.");
            return true;
        }
        return false;
    }

    private boolean searchAtDepth(List<Node> nodes, IndependenceTest test, Map<Node, Set<Node>> adjacencies, int depth) {
        int count = 0;
        ArrayList<IndependenceFact> facts = new ArrayList<IndependenceFact>();
        for (Node x : nodes) {
            if (this.verbose && ++count % 100 == 0) {
                this.out.println("count " + count + " of " + nodes.size());
            }
            ArrayList adjx = new ArrayList(adjacencies.get(x));
            block3: for (Node y : adjx) {
                int[] choice;
                ArrayList<Node> _adjx = new ArrayList<Node>((Collection)adjacencies.get(x));
                _adjx.remove(y);
                List<Node> ppx = this.possibleParents(x, _adjx, this.knowledge);
                if (ppx.size() < depth) continue;
                ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
                while ((choice = cg.next()) != null) {
                    boolean independent;
                    List<Node> condSet = GraphUtils.asList(choice, ppx);
                    IndependenceFact fact = new IndependenceFact(x, y, condSet);
                    if (facts.contains(fact)) continue;
                    facts.add(fact);
                    try {
                        ++this.numIndependenceTests;
                        independent = test.checkIndependence(x, y, condSet).independent();
                    }
                    catch (Exception e) {
                        independent = false;
                    }
                    if (!independent) {
                        ++this.numDependenceJudgement;
                    }
                    boolean noEdgeRequired = this.knowledge.noEdgeRequired(x.getName(), y.getName());
                    if (!independent || !noEdgeRequired) continue;
                    adjacencies.get(x).remove(y);
                    adjacencies.get(y).remove(x);
                    this.getSepsets().set(x, y, condSet);
                    continue block3;
                }
            }
        }
        return this.freeDegree(nodes, adjacencies) > depth;
    }

    private List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.isForbidden(z, x) && !knowledge.isRequired(x, z);
    }

    @Override
    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    @Override
    public int getNumDependenceJudgments() {
        return this.numDependenceJudgement;
    }

    @Override
    public SepsetMap getSepsets() {
        return this.sepset;
    }

    public void setExternalGraph(Graph externalGraph) {
        this.externalGraph = externalGraph;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isAggressivelyPreventCycles() {
        return false;
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        return null;
    }

    @Override
    public Graph search(List<Node> nodes) {
        nodes = new ArrayList<Node>(nodes);
        return null;
    }

    @Override
    public long getElapsedTime() {
        return 0L;
    }

    @Override
    public List<Node> getNodes() {
        return this.test.getVariables();
    }

    @Override
    public List<Triple> getAmbiguousTriples(Node node) {
        return null;
    }

    @Override
    public void setOut(PrintStream out) {
        this.out = out;
    }
}

