/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.math3.util.FastMath;

public class FasFdr
implements IFas {
    private final Matrix cov;
    private final double alpha;
    private final Graph graph;
    private final IndependenceTest test;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private final int numIndependenceTests;
    private final TetradLogger logger = TetradLogger.getInstance();
    private final int numDependenceJudgement;
    private SepsetMap sepset = new SepsetMap();
    private final NumberFormat nf = new DecimalFormat("0.00E0");
    private boolean verbose;
    private final List<Double> pValueList = new ArrayList<Double>();
    private PrintStream out = System.out;

    public FasFdr(IndependenceTest test, int numIndependenceTests, int numDependenceJudgement) {
        this.graph = new EdgeListGraph(test.getVariables());
        this.test = test;
        this.alpha = test.getAlpha();
        this.cov = test.getCov().getMatrix();
        this.numIndependenceTests = numIndependenceTests;
        this.numDependenceJudgement = numDependenceJudgement;
    }

    @Override
    public Graph search() {
        int d;
        this.logger.log("info", "Starting Fast Adjacency Search.");
        this.graph.removeEdges(this.graph.getEdges());
        this.sepset = new SepsetMap();
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        List<Node> nodes = this.graph.getNodes();
        Map<Node, Set<Node>> adjacencies = this.emptyGraph(nodes);
        this.searchICov(nodes, this.test, adjacencies, true);
        this.searchiCovAll(nodes, this.test, adjacencies);
        for (d = 0; d <= _depth; ++d) {
            this.searchAtDepth(nodes, this.test, adjacencies, d);
            if (this.freeDegree(nodes, adjacencies) <= this.depth) break;
        }
        this.pValueList.clear();
        for (d = 0; d <= _depth; ++d) {
            this.test.setAlpha(this.alpha);
            Map<Node, Set<Node>> _adjacencies = this.copy(adjacencies);
            this.searchAtDepth(nodes, this.test, adjacencies, d);
            double cutoff = StatUtils.fdrCutoff(this.test.getAlpha(), this.pValueList, false);
            adjacencies = _adjacencies;
            this.test.setAlpha(cutoff);
            boolean more = this.searchAtDepth(nodes, this.test, adjacencies, d);
            if (!more) break;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node x = nodes.get(i);
                Node y = nodes.get(j);
                if (!adjacencies.get(x).contains(y)) continue;
                this.graph.addUndirectedEdge(x, y);
            }
        }
        this.logger.log("info", "Finishing Fast Adjacency Search.");
        return this.graph;
    }

    private Map<Node, Set<Node>> emptyGraph(List<Node> nodes) {
        HashMap<Node, Set<Node>> adjacencies = new HashMap<Node, Set<Node>>();
        for (Node node : nodes) {
            adjacencies.put(node, new TreeSet());
        }
        return adjacencies;
    }

    private void searchiCovAll(List<Node> nodes, IndependenceTest test, Map<Node, Set<Node>> adjacencies) {
        boolean removed;
        do {
            removed = false;
            for (Node x : nodes) {
                ArrayList adjx = new ArrayList(adjacencies.get(x));
                for (Node y : adjx) {
                    if (!adjacencies.get(x).contains(y)) continue;
                    ArrayList adjy = new ArrayList(adjacencies.get(y));
                    ArrayList<Node> adj = new ArrayList<Node>(adjx);
                    for (Node node : adjy) {
                        if (adj.contains(node)) continue;
                        adj.add(node);
                    }
                    removed = removed || this.searchICov(adj, test, adjacencies, false);
                }
            }
        } while (removed);
    }

    private Map<Node, Set<Node>> copy(Map<Node, Set<Node>> adjacencies) {
        HashMap<Node, Set<Node>> copy = new HashMap<Node, Set<Node>>();
        for (Node node : adjacencies.keySet()) {
            copy.put(node, new HashSet(adjacencies.get(node)));
        }
        return copy;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    private boolean searchICov(List<Node> nodes, IndependenceTest test, Map<Node, Set<Node>> adjacencies, boolean addDependencies) {
        if (nodes.size() < 2) {
            return false;
        }
        boolean removed = false;
        int[] n = new int[nodes.size()];
        List<Node> variables = test.getVariables();
        for (int i = 0; i < nodes.size(); ++i) {
            n[i] = variables.indexOf(nodes.get(i));
        }
        Matrix inv = this.cov.getSelection(n, n).inverse();
        int sampleSize = test.getCov().getSampleSize();
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                ArrayList<Node> theRest;
                boolean independent;
                Node x = nodes.get(i);
                Node y = nodes.get(j);
                double r = -inv.get(i, j) / FastMath.sqrt(inv.get(i, i) * inv.get(j, j));
                double fisherZ = FastMath.sqrt((double)(sampleSize - (nodes.size() - 2)) - 3.0) * 0.5 * (FastMath.log(1.0 + r) - FastMath.log(1.0 - r));
                double pvalue = 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, FastMath.abs(fisherZ)));
                boolean bl = independent = pvalue > test.getAlpha();
                if (addDependencies) {
                    if (independent) {
                        theRest = new ArrayList<Node>();
                        for (Node node : nodes) {
                            if (node == x || node == y) continue;
                            theRest.add(node);
                        }
                        this.getSepsets().set(x, y, theRest);
                        removed = true;
                        continue;
                    }
                    if (this.forbiddenEdge(x, y)) continue;
                    adjacencies.get(x).add(y);
                    adjacencies.get(y).add(x);
                    continue;
                }
                if (!independent || !adjacencies.get(x).contains(y)) continue;
                theRest = new ArrayList();
                for (Node node : nodes) {
                    if (node == x || node == y) continue;
                    theRest.add(node);
                }
                adjacencies.get(x).remove(y);
                adjacencies.get(y).remove(x);
                this.getSepsets().set(x, y, theRest);
                if (this.verbose) {
                    IndependenceResult result = this.test.checkIndependence(x, y, theRest);
                    this.out.println(x + " _||_ " + y + " | the rest p = " + this.nf.format(result.getPValue()));
                }
                removed = true;
            }
        }
        return removed;
    }

    private int freeDegree(List<Node> nodes, Map<Node, Set<Node>> adjacencies) {
        int max = 0;
        for (Node x : nodes) {
            Set<Node> opposites = adjacencies.get(x);
            for (Node y : opposites) {
                HashSet<Node> adjx = new HashSet<Node>(opposites);
                adjx.remove(y);
                if (adjx.size() <= max) continue;
                max = adjx.size();
            }
        }
        return max;
    }

    private boolean forbiddenEdge(Node x, Node y) {
        String name2;
        String name1 = x.getName();
        if (this.knowledge.isForbidden(name1, name2 = y.getName()) && this.knowledge.isForbidden(name2, name1)) {
            this.logger.log("edgeRemoved", "Removed " + Edges.undirectedEdge(x, y) + " because it was forbidden by background knowledge.");
            return true;
        }
        return false;
    }

    private boolean searchAtDepth(List<Node> nodes, IndependenceTest test, Map<Node, Set<Node>> adjacencies, int depth) {
        int count = 0;
        for (Node x : nodes) {
            if (++count % 100 == 0) {
                this.out.println("count " + count + " of " + nodes.size());
            }
            ArrayList adjx = new ArrayList(adjacencies.get(x));
            block3: for (Node y : adjx) {
                int[] choice;
                ArrayList<Node> _adjx = new ArrayList<Node>((Collection)adjacencies.get(x));
                _adjx.remove(y);
                List<Node> ppx = this.possibleParents(x, _adjx, this.knowledge);
                if (ppx.size() < depth) continue;
                ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
                while ((choice = cg.next()) != null) {
                    IndependenceResult result;
                    List<Node> condSet = GraphUtils.asList(choice, ppx);
                    try {
                        result = test.checkIndependence(x, y, condSet);
                        this.pValueList.add(result.getPValue());
                    }
                    catch (Exception e) {
                        result = new IndependenceResult(new IndependenceFact(x, y, condSet), false, Double.NaN);
                    }
                    boolean noEdgeRequired = this.knowledge.noEdgeRequired(x.getName(), y.getName());
                    if (!result.independent() || !noEdgeRequired) continue;
                    adjacencies.get(x).remove(y);
                    adjacencies.get(y).remove(x);
                    this.getSepsets().set(x, y, condSet);
                    if (!this.verbose) continue block3;
                    this.out.println(SearchLogUtils.independenceFact(x, y, condSet) + " p = " + this.nf.format(result.getPValue()));
                    continue block3;
                }
            }
        }
        return this.freeDegree(nodes, adjacencies) > depth;
    }

    private List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.isForbidden(z, x) && !knowledge.isRequired(x, z);
    }

    @Override
    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    @Override
    public int getNumDependenceJudgments() {
        return this.numDependenceJudgement;
    }

    @Override
    public SepsetMap getSepsets() {
        return this.sepset;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isAggressivelyPreventCycles() {
        return false;
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        return null;
    }

    @Override
    public Graph search(List<Node> nodes) {
        nodes = new ArrayList<Node>(nodes);
        return null;
    }

    @Override
    public long getElapsedTime() {
        return 0L;
    }

    @Override
    public List<Node> getNodes() {
        return null;
    }

    @Override
    public List<Triple> getAmbiguousTriples(Node node) {
        return null;
    }

    @Override
    public void setOut(PrintStream out) {
        this.out = out;
    }
}

