/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.ForkJoinPoolInstance;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;

public class FasStableConcurrentFdr
implements IFas {
    private final IndependenceTest test;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private int numIndependenceTests;
    private TetradLogger logger = TetradLogger.getInstance();
    private SepsetMap sepsets = new SepsetMap();
    private Graph externalGraph;
    private final NumberFormat nf = new DecimalFormat("0.00E0");
    private boolean verbose;
    private final ForkJoinPool pool = ForkJoinPoolInstance.getInstance().getPool();
    private PrintStream out = System.out;
    private final int chunk = 100;
    private final boolean recordSepsets = true;

    public FasStableConcurrentFdr(IndependenceTest test) {
        this.test = test;
    }

    public FasStableConcurrentFdr(Graph externalGraph, IndependenceTest test) {
        this.test = test;
        this.externalGraph = externalGraph;
    }

    @Override
    public Graph search() {
        boolean more;
        this.logger.log("info", "Starting Fast Adjacency Search.");
        EdgeListGraph graph = new EdgeListGraph(this.test.getVariables());
        this.sepsets = new SepsetMap();
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        ConcurrentSkipListMap<Node, Set<Node>> adjacencies = new ConcurrentSkipListMap<Node, Set<Node>>();
        List<Node> nodes = graph.getNodes();
        for (Node node : nodes) {
            adjacencies.put(node, new HashSet());
        }
        for (int d = 0; d <= _depth && (more = d == 0 ? this.searchAtDepth0(nodes, this.test, adjacencies) : this.searchAtDepth(nodes, this.test, adjacencies, d)); ++d) {
        }
        if (this.verbose) {
            this.out.println("Finished with search, constructing Graph...");
        }
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node x = nodes.get(i);
                Node y = nodes.get(j);
                if (!((Set)adjacencies.get(x)).contains(y)) continue;
                graph.addUndirectedEdge(x, y);
            }
        }
        if (this.verbose) {
            this.out.println("Finished constructing Graph.");
        }
        if (this.verbose) {
            this.logger.log("info", "Finishing Fast Adjacency Search.");
        }
        return graph;
    }

    @Override
    public Graph search(List<Node> nodes) {
        return null;
    }

    @Override
    public long getElapsedTime() {
        return 0L;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    @Override
    public boolean isAggressivelyPreventCycles() {
        return false;
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        return this.test;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException("Cannot set knowledge to null");
        }
        this.knowledge = knowledge;
    }

    private boolean searchAtDepth0(final List<Node> nodes, final IndependenceTest test, final Map<Node, Set<Node>> adjacencies) {
        if (this.verbose) {
            this.out.println("Searching at depth 0.");
            System.out.println("Searching at depth 0.");
        }
        final List empty = Collections.emptyList();
        final ArrayList<Double> sorted = new ArrayList<Double>();
        class Depth0Task
        extends RecursiveTask<Boolean> {
            private final int chunk;
            private final int from;
            private final int to;
            final /* synthetic */ List val$nodes;
            final /* synthetic */ List val$empty;
            final /* synthetic */ IndependenceTest val$test;
            final /* synthetic */ List val$sorted;

            public Depth0Task(int chunk, int from, int to) {
                this.val$nodes = list;
                this.val$empty = list2;
                this.val$test = independenceTest;
                this.val$sorted = list3;
                this.chunk = chunk;
                this.from = from;
                this.to = to;
            }

            @Override
            protected Boolean compute() {
                if (this.to - this.from <= this.chunk) {
                    for (int i = this.from; i < this.to; ++i) {
                        if (FasStableConcurrentFdr.this.verbose && (i + 1) % 1000 == 0) {
                            System.out.println("i = " + (i + 1));
                        }
                        Node x = (Node)this.val$nodes.get(i);
                        for (int j = 0; j < i; ++j) {
                            Node y = (Node)this.val$nodes.get(j);
                            if (FasStableConcurrentFdr.this.externalGraph != null) {
                                Node x2 = FasStableConcurrentFdr.this.externalGraph.getNode(x.getName());
                                Node y2 = FasStableConcurrentFdr.this.externalGraph.getNode(y.getName());
                                if (!FasStableConcurrentFdr.this.externalGraph.isAdjacentTo(x2, y2)) continue;
                            }
                            IndependenceResult result = new IndependenceResult(new IndependenceFact(x, y, this.val$empty), false, Double.NaN);
                            try {
                                result = this.val$test.checkIndependence(x, y, this.val$empty);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            FasStableConcurrentFdr.this.numIndependenceTests++;
                            double pValue = result.getPValue();
                            this.val$sorted.add(pValue);
                        }
                    }
                } else {
                    int mid = (this.to + this.from) / 2;
                    Depth0Task left = new Depth0Task(this.chunk, this.from, mid);
                    Depth0Task right = new Depth0Task(this.chunk, mid, this.to);
                    left.fork();
                    right.compute();
                    left.join();
                }
                return true;
            }
        }
        this.pool.invoke(new Depth0Task(this.chunk, 0, nodes.size()));
        Collections.sort(sorted);
        final double cutoff = StatUtils.fdrCutoff(test.getAlpha(), sorted, false, true);
        class Depth0Task2
        extends RecursiveTask<Boolean> {
            private final int chunk;
            private final int from;
            private final int to;

            public Depth0Task2(int chunk, int from, int to) {
                this.chunk = chunk;
                this.from = from;
                this.to = to;
            }

            @Override
            protected Boolean compute() {
                if (this.to - this.from <= this.chunk) {
                    for (int i = this.from; i < this.to; ++i) {
                        if (FasStableConcurrentFdr.this.verbose && (i + 1) % 1000 == 0) {
                            System.out.println("i = " + (i + 1));
                        }
                        Node x = (Node)nodes.get(i);
                        for (int j = 0; j < i; ++j) {
                            Node y = (Node)nodes.get(j);
                            if (FasStableConcurrentFdr.this.externalGraph != null) {
                                Node x2 = FasStableConcurrentFdr.this.externalGraph.getNode(x.getName());
                                Node y2 = FasStableConcurrentFdr.this.externalGraph.getNode(y.getName());
                                if (!FasStableConcurrentFdr.this.externalGraph.isAdjacentTo(x2, y2)) continue;
                            }
                            IndependenceResult result = new IndependenceResult(new IndependenceFact(x, y, empty), false, Double.NaN);
                            try {
                                result = test.checkIndependence(x, y, empty);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            FasStableConcurrentFdr.this.numIndependenceTests++;
                            boolean noEdgeRequired = FasStableConcurrentFdr.this.knowledge.noEdgeRequired(x.getName(), y.getName());
                            if (result.getPValue() > cutoff && noEdgeRequired) {
                                FasStableConcurrentFdr.this.getSepsets().set(x, y, empty);
                                continue;
                            }
                            if (FasStableConcurrentFdr.this.forbiddenEdge(x, y)) continue;
                            ((Set)adjacencies.get(x)).add(y);
                            ((Set)adjacencies.get(y)).add(x);
                            if (!FasStableConcurrentFdr.this.verbose) continue;
                            TetradLogger.getInstance().log("dependencies", SearchLogUtils.independenceFact(x, y, empty) + " p = " + FasStableConcurrentFdr.this.nf.format(result.getPValue()));
                        }
                    }
                } else {
                    int mid = (this.to + this.from) / 2;
                    Depth0Task left = new Depth0Task(this.chunk, this.from, mid);
                    Depth0Task right = new Depth0Task(this.chunk, mid, this.to);
                    left.fork();
                    right.compute();
                    left.join();
                }
                return true;
            }
        }
        this.pool.invoke(new Depth0Task2(this.chunk, 0, nodes.size()));
        return this.freeDegree(nodes, adjacencies) > 0;
    }

    private boolean forbiddenEdge(Node x, Node y) {
        String name2;
        String name1 = x.getName();
        if (this.knowledge.isForbidden(name1, name2 = y.getName()) && this.knowledge.isForbidden(name2, name1)) {
            if (this.verbose) {
                this.logger.log("edgeRemoved", "Removed " + Edges.undirectedEdge(x, y) + " because it was forbidden by background knowledge.");
            }
            return true;
        }
        return false;
    }

    private int freeDegree(List<Node> nodes, Map<Node, Set<Node>> adjacencies) {
        int max = 0;
        for (Node x : nodes) {
            Set<Node> opposites = adjacencies.get(x);
            for (Node y : opposites) {
                HashSet<Node> adjx = new HashSet<Node>(opposites);
                adjx.remove(y);
                if (adjx.size() <= max) continue;
                max = adjx.size();
            }
        }
        return max;
    }

    private boolean searchAtDepth(final List<Node> nodes, final IndependenceTest test, final Map<Node, Set<Node>> adjacencies, final int depth) {
        if (this.verbose) {
            this.out.println("Searching at depth " + depth);
            System.out.println("Searching at depth " + depth);
        }
        final HashMap adjacenciesCopy = new HashMap();
        for (Node node : adjacencies.keySet()) {
            adjacenciesCopy.put(node, new HashSet(adjacencies.get(node)));
        }
        final ArrayList<Double> sorted = new ArrayList<Double>();
        class DepthTask
        extends RecursiveTask<Boolean> {
            private final int chunk;
            private final int from;
            private final int to;
            final /* synthetic */ List val$nodes;
            final /* synthetic */ Map val$adjacenciesCopy;
            final /* synthetic */ Map val$adjacencies;
            final /* synthetic */ int val$depth;
            final /* synthetic */ IndependenceTest val$test;
            final /* synthetic */ List val$sorted;

            public DepthTask(int chunk, int from, int to) {
                this.val$nodes = list;
                this.val$adjacenciesCopy = map;
                this.val$adjacencies = map2;
                this.val$depth = n;
                this.val$test = independenceTest;
                this.val$sorted = list2;
                this.chunk = chunk;
                this.from = from;
                this.to = to;
            }

            @Override
            protected Boolean compute() {
                if (this.to - this.from <= this.chunk) {
                    for (int i = this.from; i < this.to; ++i) {
                        if (FasStableConcurrentFdr.this.verbose && (i + 1) % 1000 == 0) {
                            System.out.println("i = " + (i + 1));
                        }
                        Node x = (Node)this.val$nodes.get(i);
                        ArrayList adjx = new ArrayList((Collection)this.val$adjacenciesCopy.get(x));
                        block3: for (Node y : adjx) {
                            int[] choice;
                            if (!FasStableConcurrentFdr.this.existsShortPath(x, y, this.val$adjacencies)) continue;
                            ArrayList _adjx = new ArrayList(adjx);
                            _adjx.remove(y);
                            List ppx = FasStableConcurrentFdr.this.possibleParents(x, _adjx, FasStableConcurrentFdr.this.knowledge);
                            if (ppx.size() < this.val$depth) continue;
                            ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), this.val$depth);
                            while ((choice = cg.next()) != null) {
                                IndependenceResult result;
                                List<Node> condSet = GraphUtils.asList(choice, ppx);
                                try {
                                    FasStableConcurrentFdr.this.numIndependenceTests++;
                                    result = this.val$test.checkIndependence(x, y, condSet);
                                }
                                catch (Exception e) {
                                    result = new IndependenceResult(new IndependenceFact(x, y, condSet), true, Double.NaN);
                                }
                                boolean noEdgeRequired = FasStableConcurrentFdr.this.knowledge.noEdgeRequired(x.getName(), y.getName());
                                if (!result.independent() || !noEdgeRequired) continue;
                                this.val$sorted.add(result.getPValue());
                                continue block3;
                            }
                        }
                    }
                } else {
                    int mid = (this.to + this.from) / 2;
                    DepthTask left = new DepthTask(this.chunk, this.from, mid);
                    DepthTask right = new DepthTask(this.chunk, mid, this.to);
                    left.fork();
                    right.compute();
                    left.join();
                }
                return true;
            }
        }
        this.pool.invoke(new DepthTask(this.chunk, 0, nodes.size()));
        Collections.sort(sorted);
        final double cutoff = StatUtils.fdrCutoff(test.getAlpha(), sorted, false, true);
        System.out.println();
        class DepthTask2
        extends RecursiveTask<Boolean> {
            private final int chunk;
            private final int from;
            private final int to;

            public DepthTask2(int chunk, int from, int to) {
                this.chunk = chunk;
                this.from = from;
                this.to = to;
            }

            @Override
            protected Boolean compute() {
                if (this.to - this.from <= this.chunk) {
                    for (int i = this.from; i < this.to; ++i) {
                        if (FasStableConcurrentFdr.this.verbose && (i + 1) % 1000 == 0) {
                            System.out.println("i = " + (i + 1));
                        }
                        Node x = (Node)nodes.get(i);
                        ArrayList adjx = new ArrayList((Collection)adjacenciesCopy.get(x));
                        block3: for (Node y : adjx) {
                            int[] choice;
                            ArrayList _adjx = new ArrayList(adjx);
                            _adjx.remove(y);
                            List ppx = FasStableConcurrentFdr.this.possibleParents(x, _adjx, FasStableConcurrentFdr.this.knowledge);
                            if (ppx.size() < depth) continue;
                            ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
                            while ((choice = cg.next()) != null) {
                                List<Node> condSet = GraphUtils.asList(choice, ppx);
                                try {
                                    FasStableConcurrentFdr.this.numIndependenceTests++;
                                    IndependenceResult result = test.checkIndependence(x, y, condSet);
                                    if (!(result.getPValue() > cutoff)) continue;
                                    ((Set)adjacencies.get(x)).remove(y);
                                    ((Set)adjacencies.get(y)).remove(x);
                                    FasStableConcurrentFdr.this.getSepsets().set(x, y, condSet);
                                    continue block3;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                } else {
                    int mid = (this.to + this.from) / 2;
                    DepthTask left = new DepthTask(this.chunk, this.from, mid);
                    DepthTask right = new DepthTask(this.chunk, mid, this.to);
                    left.fork();
                    right.compute();
                    left.join();
                }
                return true;
            }
        }
        this.pool.invoke(new DepthTask2(this.chunk, 0, nodes.size()));
        if (this.verbose) {
            System.out.println("Done with depth");
        }
        return this.freeDegree(nodes, adjacencies) > depth;
    }

    private List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.isForbidden(z, x) && !knowledge.isRequired(x, z);
    }

    @Override
    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    @Override
    public List<Node> getNodes() {
        return null;
    }

    @Override
    public List<Triple> getAmbiguousTriples(Node node) {
        return null;
    }

    @Override
    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public void setExternalGraph(Graph externalGraph) {
        this.externalGraph = externalGraph;
    }

    public TetradLogger getLogger() {
        return this.logger;
    }

    public void setLogger(TetradLogger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public int getNumDependenceJudgments() {
        return 0;
    }

    @Override
    public void setOut(PrintStream out) {
        if (out == null) {
            throw new NullPointerException();
        }
        this.out = out;
    }

    public PrintStream getOut() {
        return this.out;
    }

    private boolean existsShortPath(Node x, Node z, Map<Node, Set<Node>> adjacencies) {
        LinkedList<Node> Q = new LinkedList<Node>();
        HashSet<Node> V = new HashSet<Node>();
        Q.offer(x);
        V.add(x);
        Node e = null;
        int distance = 0;
        while (!Q.isEmpty()) {
            Node t = (Node)Q.remove();
            if (e == t) {
                e = null;
                if (++distance > 3) {
                    return false;
                }
            }
            for (Node c : adjacencies.get(t)) {
                if (c == null) continue;
                if (t != x && t != z && c == z) {
                    return true;
                }
                if (V.contains(c)) continue;
                V.add(c);
                Q.offer(c);
                if (e != null) continue;
                e = c;
            }
        }
        return false;
    }
}

